/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-12-27 07:37:32 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=587 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=5318 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=989 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_campaign_emails` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` bigint(20) unsigned DEFAULT NULL,
  `email_type` varchar(50) DEFAULT 'campaign',
  `subscriber_id` bigint(20) unsigned DEFAULT NULL,
  `email_subject_id` bigint(20) unsigned DEFAULT NULL,
  `email_address` varchar(192) NOT NULL,
  `email_subject` varchar(192) DEFAULT NULL,
  `email_body` longtext DEFAULT NULL,
  `email_headers` text DEFAULT NULL,
  `is_open` tinyint(1) NOT NULL DEFAULT 0,
  `is_parsed` tinyint(1) NOT NULL DEFAULT 0,
  `click_counter` int(11) DEFAULT NULL,
  `status` varchar(50) NOT NULL DEFAULT 'draft',
  `note` text DEFAULT NULL,
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `email_hash` varchar(192) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp_fc_cam__cid_idx` (`campaign_id`),
  KEY `wp_fc_cam__sid_idx` (`subscriber_id`),
  KEY `wp_fc_cam__et_idx` (`email_type`),
  KEY `wp_fc_cam__estidx` (`status`),
  KEY `wp_fc_cam__emtidx` (`email_hash`),
  KEY `wp_fc_cam__scheduled_at` (`scheduled_at`),
  KEY `wp_fc_cam__updated_at` (`updated_at`),
  KEY `wp_fc_cam_sc_at_status` (`scheduled_at`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_campaign_url_metrics` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) unsigned DEFAULT NULL,
  `campaign_id` bigint(20) unsigned DEFAULT NULL,
  `subscriber_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(50) DEFAULT 'click',
  `ip_address` varchar(30) DEFAULT NULL,
  `country` varchar(40) DEFAULT NULL,
  `city` varchar(40) DEFAULT NULL,
  `counter` int(10) unsigned NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url_id` (`url_id`),
  KEY `campaign_id` (`campaign_id`),
  KEY `subscriber_id` (`subscriber_id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_campaigns` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(50) NOT NULL DEFAULT 'campaign',
  `title` varchar(192) NOT NULL,
  `available_urls` text DEFAULT NULL,
  `slug` varchar(192) NOT NULL,
  `status` varchar(50) NOT NULL,
  `template_id` bigint(20) unsigned DEFAULT NULL,
  `email_subject` varchar(192) DEFAULT NULL,
  `email_pre_header` varchar(192) DEFAULT NULL,
  `email_body` longtext NOT NULL,
  `recipients_count` int(11) NOT NULL DEFAULT 0,
  `delay` int(11) DEFAULT 0,
  `utm_status` tinyint(1) DEFAULT 0,
  `utm_source` varchar(192) DEFAULT NULL,
  `utm_medium` varchar(192) DEFAULT NULL,
  `utm_campaign` varchar(192) DEFAULT NULL,
  `utm_term` varchar(192) DEFAULT NULL,
  `utm_content` varchar(192) DEFAULT NULL,
  `design_template` varchar(192) DEFAULT NULL,
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `settings` longtext DEFAULT NULL,
  `created_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_funnel_metrics` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `funnel_id` bigint(20) unsigned DEFAULT NULL,
  `sequence_id` bigint(20) unsigned DEFAULT NULL,
  `subscriber_id` bigint(20) unsigned DEFAULT NULL,
  `benchmark_value` bigint(20) unsigned DEFAULT 0,
  `benchmark_currency` varchar(10) DEFAULT 'USD',
  `status` varchar(50) DEFAULT 'completed',
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp_fc_fmx__m_idx` (`funnel_id`),
  KEY `wp_fc_fmx__ms__idx` (`subscriber_id`),
  KEY `sequence_id` (`sequence_id`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_funnel_sequences` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `funnel_id` bigint(20) unsigned DEFAULT NULL,
  `parent_id` bigint(20) unsigned DEFAULT 0,
  `action_name` varchar(192) DEFAULT NULL,
  `condition_type` varchar(192) DEFAULT NULL,
  `type` varchar(50) DEFAULT 'sequence',
  `title` varchar(192) DEFAULT NULL,
  `description` varchar(192) DEFAULT NULL,
  `status` varchar(50) DEFAULT 'draft',
  `conditions` text DEFAULT NULL,
  `settings` text DEFAULT NULL,
  `note` text DEFAULT NULL,
  `delay` int(10) unsigned DEFAULT NULL,
  `c_delay` int(10) unsigned DEFAULT NULL,
  `sequence` int(10) unsigned DEFAULT NULL,
  `created_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp_fc_fq__fs_idx` (`status`),
  KEY `wp_fc_fq__fid_idx` (`funnel_id`),
  KEY `c_delay` (`c_delay`),
  KEY `sequence` (`sequence`),
  KEY `action_name` (`action_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_funnel_subscribers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `funnel_id` bigint(20) unsigned DEFAULT NULL,
  `starting_sequence_id` bigint(20) unsigned DEFAULT NULL,
  `next_sequence` bigint(20) unsigned DEFAULT NULL,
  `subscriber_id` bigint(20) unsigned DEFAULT NULL,
  `last_sequence_id` bigint(20) unsigned DEFAULT NULL,
  `next_sequence_id` bigint(20) unsigned DEFAULT NULL,
  `last_sequence_status` varchar(50) DEFAULT 'pending',
  `status` varchar(50) DEFAULT 'active',
  `type` varchar(50) DEFAULT 'funnel',
  `last_executed_time` timestamp NULL DEFAULT NULL,
  `next_execution_time` timestamp NULL DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `source_trigger_name` varchar(192) DEFAULT NULL,
  `source_ref_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp_fc_fsx__fidx` (`funnel_id`),
  KEY `wp_fc_fsx__fsq_idx` (`subscriber_id`),
  KEY `status` (`status`),
  KEY `type` (`type`),
  KEY `next_execution_time` (`next_execution_time`),
  KEY `next_sequence` (`next_sequence`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_funnels` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL DEFAULT 'funnel',
  `title` varchar(192) NOT NULL,
  `trigger_name` varchar(150) DEFAULT NULL,
  `status` varchar(50) DEFAULT 'draft',
  `conditions` text DEFAULT NULL,
  `settings` text DEFAULT NULL,
  `created_by` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp_fc_fn__f_idx` (`status`),
  KEY `wp_fc_fn__ft_idx` (`trigger_name`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_lists` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(192) NOT NULL,
  `slug` varchar(192) NOT NULL,
  `description` tinytext DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `object_type` varchar(50) NOT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `key` varchar(192) NOT NULL,
  `value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp_fc_mt__mt_idx` (`object_type`),
  KEY `wp_fc_mt__mto_id_idx` (`object_id`),
  KEY `wp_fc_mt__mto_id_key` (`key`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_sequence_tracker` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` bigint(20) unsigned DEFAULT NULL,
  `last_sequence_id` bigint(20) unsigned DEFAULT NULL,
  `subscriber_id` bigint(20) unsigned DEFAULT NULL,
  `next_sequence_id` bigint(20) unsigned DEFAULT NULL,
  `status` varchar(50) DEFAULT 'active',
  `type` varchar(50) DEFAULT 'sequence_tracker',
  `last_executed_time` timestamp NULL DEFAULT NULL,
  `next_execution_time` timestamp NULL DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp_fc_index__esequence_idx` (`campaign_id`),
  KEY `wp_fc_index__esequence_subscriber_idx` (`subscriber_id`),
  KEY `status` (`status`),
  KEY `type` (`type`),
  KEY `last_sequence_id` (`last_sequence_id`),
  KEY `next_execution_time` (`next_execution_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_subscriber_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` bigint(20) unsigned NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `object_type` varchar(50) DEFAULT 'option',
  `key` varchar(192) NOT NULL,
  `value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp_fc_index__s_meta_id_idx` (`subscriber_id`),
  KEY `wp_fc_index__s_ot_idx` (`object_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_subscriber_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `created_by` bigint(20) unsigned DEFAULT NULL,
  `status` varchar(50) DEFAULT 'open',
  `type` varchar(50) DEFAULT 'note',
  `is_private` tinyint(4) DEFAULT 1,
  `title` varchar(192) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp_fc_sn__s_id_idx` (`subscriber_id`),
  KEY `wp_fc_sn__s_idx` (`status`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_subscriber_pivot` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` bigint(20) unsigned NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `object_type` varchar(50) NOT NULL,
  `status` varchar(50) DEFAULT NULL,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp_fc_srp__sp_id_idx` (`subscriber_id`),
  KEY `wp_fc_srp__sp_o_id_idx` (`object_id`),
  KEY `wp_fc_srp__sp_t_id_idx` (`object_type`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_subscribers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `hash` varchar(90) DEFAULT NULL,
  `contact_owner` bigint(20) unsigned DEFAULT NULL,
  `company_id` bigint(20) unsigned DEFAULT NULL,
  `prefix` varchar(192) DEFAULT NULL,
  `first_name` varchar(192) DEFAULT NULL,
  `last_name` varchar(192) DEFAULT NULL,
  `email` varchar(190) NOT NULL,
  `timezone` varchar(192) DEFAULT NULL,
  `address_line_1` varchar(192) DEFAULT NULL,
  `address_line_2` varchar(192) DEFAULT NULL,
  `postal_code` varchar(192) DEFAULT NULL,
  `city` varchar(192) DEFAULT NULL,
  `state` varchar(192) DEFAULT NULL,
  `country` varchar(192) DEFAULT NULL,
  `ip` varchar(40) DEFAULT NULL,
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(10,8) DEFAULT NULL,
  `total_points` int(10) unsigned NOT NULL DEFAULT 0,
  `life_time_value` int(10) unsigned NOT NULL DEFAULT 0,
  `phone` varchar(50) DEFAULT NULL,
  `status` varchar(50) NOT NULL DEFAULT 'subscribed',
  `contact_type` varchar(50) DEFAULT 'lead',
  `source` varchar(50) DEFAULT NULL,
  `avatar` varchar(192) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `last_activity` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `wp_fc_index__subscriber_user_id_idx` (`user_id`),
  KEY `wp_fc_index__subscriber_status_idx` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(192) NOT NULL,
  `slug` varchar(192) NOT NULL,
  `description` tinytext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_term_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned DEFAULT NULL,
  `object_type` varchar(192) NOT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `settings` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp_fc_tmr__tm_idx` (`term_id`),
  KEY `wp_fc_tmr__tm_id_type` (`object_type`),
  KEY `wp_fc_tmr__tm_id_idx` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_terms` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `taxonomy_name` varchar(50) NOT NULL,
  `slug` varchar(100) NOT NULL,
  `title` text DEFAULT NULL,
  `position` decimal(10,2) NOT NULL DEFAULT 1.00,
  `description` longtext DEFAULT NULL,
  `settings` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp_fc_tms__tm_idx` (`taxonomy_name`),
  KEY `wp_fc_tms__tm_id_slug` (`slug`),
  KEY `wp_fc_tms__tm_id_pid` (`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fc_url_stores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` text NOT NULL,
  `short` varchar(50) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `short` (`short`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_ff_scheduled_actions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(255) DEFAULT NULL,
  `form_id` bigint(20) unsigned DEFAULT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `feed_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(255) DEFAULT 'submission_action',
  `status` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `note` tinytext DEFAULT NULL,
  `retry_count` int(10) unsigned DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fluentform_entry_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) unsigned DEFAULT NULL,
  `submission_id` bigint(20) unsigned DEFAULT NULL,
  `field_name` varchar(255) DEFAULT NULL,
  `sub_field_name` varchar(255) DEFAULT NULL,
  `field_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fluentform_form_analytics` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `source_url` text NOT NULL,
  `platform` char(30) DEFAULT NULL,
  `browser` char(30) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `ip` char(15) DEFAULT NULL,
  `count` int(11) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fluentform_form_meta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) unsigned DEFAULT NULL,
  `meta_key` varchar(255) NOT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fluentform_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `status` varchar(45) DEFAULT 'Draft',
  `appearance_settings` text DEFAULT NULL,
  `form_fields` longtext DEFAULT NULL,
  `has_payment` tinyint(1) NOT NULL DEFAULT 0,
  `type` varchar(45) DEFAULT NULL,
  `conditions` text DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fluentform_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_source_id` int(10) unsigned DEFAULT NULL,
  `source_type` varchar(255) DEFAULT NULL,
  `source_id` int(10) unsigned DEFAULT NULL,
  `component` varchar(255) DEFAULT NULL,
  `status` char(30) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `description` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fluentform_submission_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `response_id` bigint(20) unsigned DEFAULT NULL,
  `form_id` int(10) unsigned DEFAULT NULL,
  `meta_key` varchar(45) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  `status` varchar(45) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(45) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_fluentform_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) unsigned DEFAULT NULL,
  `serial_number` int(10) unsigned DEFAULT NULL,
  `response` longtext DEFAULT NULL,
  `source_url` varchar(255) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` varchar(45) DEFAULT 'unread' COMMENT 'possible values: read, unread, trashed',
  `is_favourite` tinyint(1) NOT NULL DEFAULT 0,
  `browser` varchar(45) DEFAULT NULL,
  `device` varchar(45) DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  `city` varchar(45) DEFAULT NULL,
  `country` varchar(45) DEFAULT NULL,
  `payment_status` varchar(45) DEFAULT NULL,
  `payment_method` varchar(45) DEFAULT NULL,
  `payment_type` varchar(45) DEFAULT NULL,
  `currency` varchar(45) DEFAULT NULL,
  `payment_total` float DEFAULT NULL,
  `total_paid` float DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_jet_cct_customers_comments` (
  `_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `cct_status` text DEFAULT NULL,
  `cct_author_id` bigint(20) DEFAULT NULL,
  `cct_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `cct_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `name` text DEFAULT NULL,
  `comment_text` text DEFAULT NULL,
  `profile_pic` bigint(20) DEFAULT NULL,
  `scoring` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_jet_cct_team_members` (
  `_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `cct_status` text DEFAULT NULL,
  `name` text DEFAULT NULL,
  `profile_pic` bigint(20) DEFAULT NULL,
  `scoring` bigint(20) DEFAULT NULL,
  `cct_author_id` bigint(20) DEFAULT NULL,
  `cct_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `cct_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `the_profession` text DEFAULT NULL,
  PRIMARY KEY (`_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_jet_post_types` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text DEFAULT NULL,
  `status` text DEFAULT NULL,
  `labels` longtext DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `meta_fields` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_jet_smart_filters_indexer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `item_id` int(10) unsigned DEFAULT NULL,
  `item_query` varchar(50) DEFAULT NULL,
  `item_key` varchar(50) DEFAULT NULL,
  `item_value` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_jet_taxonomies` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text DEFAULT NULL,
  `object_type` text DEFAULT NULL,
  `status` text DEFAULT NULL,
  `labels` longtext DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `meta_fields` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=17160 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=42025 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=4901 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=204 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext DEFAULT NULL,
  `permalink_hash` varchar(40) DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) NOT NULL,
  `object_sub_type` varchar(32) DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `breadcrumb_title` text DEFAULT NULL,
  `post_status` varchar(20) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext DEFAULT NULL,
  `primary_focus_keyword` varchar(191) DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text DEFAULT NULL,
  `twitter_image` longtext DEFAULT NULL,
  `twitter_description` longtext DEFAULT NULL,
  `twitter_image_id` varchar(191) DEFAULT NULL,
  `twitter_image_source` text DEFAULT NULL,
  `open_graph_title` text DEFAULT NULL,
  `open_graph_description` longtext DEFAULT NULL,
  `open_graph_image` longtext DEFAULT NULL,
  `open_graph_image_id` varchar(191) DEFAULT NULL,
  `open_graph_image_source` text DEFAULT NULL,
  `open_graph_image_meta` mediumtext DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  `schema_page_type` varchar(64) DEFAULT NULL,
  `schema_article_type` varchar(64) DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT 1,
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=467 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("266", "action_scheduler/migration_hook", "failed", "2023-10-13 16:02:40", "2023-10-13 16:02:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1697212960;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1697212960;}", "2", "1", "2023-10-13 16:02:40", "2023-10-13 19:32:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("306", "rocket_preload_job_check_finished", "failed", "2023-11-04 06:25:33", "2023-11-04 06:25:33", "[1699079073]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1699079133;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1699079133;}", "1", "1", "2025-04-21 09:47:22", "2025-04-21 13:17:22", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("308", "action_scheduler/migration_hook", "complete", "2025-04-21 09:48:21", "2025-04-21 13:18:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745228901;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745228901;}", "2", "1", "2025-04-21 09:48:21", "2025-04-21 13:18:21", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("575", "fluentcrm_scheduled_every_minute_tasks", "complete", "2025-04-28 16:02:29", "2025-04-28 19:32:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745856149;s:18:\"\0*\0first_timestamp\";i:1745228840;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745856149;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "3", "1", "2025-04-29 12:05:21", "2025-04-29 15:35:21", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("576", "fluent_crm_ascheduler_runs_daily", "complete", "2025-04-29 16:01:29", "2025-04-29 19:31:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745942489;s:18:\"\0*\0first_timestamp\";i:1745193600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745942489;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-04-29 16:25:15", "2025-04-29 19:55:15", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("577", "fluentcrm_scheduled_every_minute_tasks", "complete", "2025-04-29 12:06:21", "2025-04-29 15:36:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745928381;s:18:\"\0*\0first_timestamp\";i:1745228840;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745928381;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "3", "1", "2025-04-29 12:47:50", "2025-04-29 16:17:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("578", "fluentcrm_scheduled_every_minute_tasks", "complete", "2025-04-29 12:48:50", "2025-04-29 16:18:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745930930;s:18:\"\0*\0first_timestamp\";i:1745228840;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745930930;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "3", "1", "2025-04-29 16:25:15", "2025-04-29 19:55:15", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("579", "fluentcrm_scheduled_every_minute_tasks", "complete", "2025-04-29 16:26:15", "2025-04-29 19:56:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745943975;s:18:\"\0*\0first_timestamp\";i:1745228840;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745943975;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "3", "1", "2025-04-29 16:26:26", "2025-04-29 19:56:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("581", "fluentcrm_scheduled_every_minute_tasks", "complete", "2025-04-29 16:27:26", "2025-04-29 19:57:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745944046;s:18:\"\0*\0first_timestamp\";i:1745228840;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745944046;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "3", "1", "2025-04-29 16:27:29", "2025-04-29 19:57:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("582", "fluentcrm_scheduled_every_minute_tasks", "complete", "2025-04-29 16:28:29", "2025-04-29 19:58:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745944109;s:18:\"\0*\0first_timestamp\";i:1745228840;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745944109;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "3", "1", "2025-04-29 16:28:30", "2025-04-29 19:58:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("583", "action_scheduler/migration_hook", "complete", "2025-04-29 16:29:29", "2025-04-29 19:59:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745944169;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745944169;}", "2", "1", "2025-04-29 16:30:14", "2025-04-29 20:00:14", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("585", "action_scheduler/migration_hook", "failed", "2025-04-29 16:31:15", "2025-04-29 20:01:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745944275;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745944275;}", "2", "1", "2025-04-29 16:32:13", "2025-04-29 20:02:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("586", "action_scheduler/migration_hook", "pending", "2025-04-29 16:48:52", "2025-04-29 20:18:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745945332;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745945332;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "rocket-preload");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "fluent-crm");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("28", "266", "action created", "2023-10-13 16:01:40", "2023-10-13 16:01:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("51", "266", "action started via WP Cron", "2023-10-13 16:02:40", "2023-10-13 16:02:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("52", "266", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-10-13 16:02:40", "2023-10-13 16:02:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("148", "306", "action created", "2023-11-04 06:24:33", "2023-11-04 06:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("150", "308", "action created", "2025-04-21 09:47:21", "2025-04-21 13:17:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("151", "306", "action started via Async Request", "2025-04-21 09:47:22", "2025-04-21 13:17:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("152", "306", "action failed via Async Request: Scheduled action for rocket_preload_job_check_finished will not be executed as no callbacks are registered.", "2025-04-21 09:47:22", "2025-04-21 13:17:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("156", "308", "action started via WP Cron", "2025-04-21 09:48:21", "2025-04-21 13:18:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("157", "308", "action complete via WP Cron", "2025-04-21 09:48:21", "2025-04-21 13:18:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("953", "575", "action created", "2025-04-28 16:01:29", "2025-04-28 19:31:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("956", "576", "action created", "2025-04-28 16:01:29", "2025-04-28 19:31:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("957", "575", "action started via WP Cron", "2025-04-29 12:05:21", "2025-04-29 15:35:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("958", "575", "action complete via WP Cron", "2025-04-29 12:05:21", "2025-04-29 15:35:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("959", "577", "action created", "2025-04-29 12:05:21", "2025-04-29 15:35:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("960", "577", "action started via WP Cron", "2025-04-29 12:47:50", "2025-04-29 16:17:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("961", "577", "action complete via WP Cron", "2025-04-29 12:47:50", "2025-04-29 16:17:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("962", "578", "action created", "2025-04-29 12:47:50", "2025-04-29 16:17:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("963", "578", "action started via WP Cron", "2025-04-29 16:25:15", "2025-04-29 19:55:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("964", "578", "action complete via WP Cron", "2025-04-29 16:25:15", "2025-04-29 19:55:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("965", "579", "action created", "2025-04-29 16:25:15", "2025-04-29 19:55:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("966", "576", "action started via WP Cron", "2025-04-29 16:25:15", "2025-04-29 19:55:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("967", "576", "action complete via WP Cron", "2025-04-29 16:25:15", "2025-04-29 19:55:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("969", "579", "action started via Async Request", "2025-04-29 16:26:26", "2025-04-29 19:56:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("970", "579", "action complete via Async Request", "2025-04-29 16:26:26", "2025-04-29 19:56:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("971", "581", "action created", "2025-04-29 16:26:26", "2025-04-29 19:56:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("972", "581", "action started via WP Cron", "2025-04-29 16:27:29", "2025-04-29 19:57:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("973", "581", "action complete via WP Cron", "2025-04-29 16:27:29", "2025-04-29 19:57:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("974", "582", "action created", "2025-04-29 16:27:29", "2025-04-29 19:57:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("975", "583", "action created", "2025-04-29 16:28:29", "2025-04-29 19:58:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("976", "582", "action started via Async Request", "2025-04-29 16:28:30", "2025-04-29 19:58:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("977", "582", "action complete via Async Request", "2025-04-29 16:28:30", "2025-04-29 19:58:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("983", "583", "action started via WP Cron", "2025-04-29 16:30:14", "2025-04-29 20:00:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("984", "583", "action complete via WP Cron", "2025-04-29 16:30:14", "2025-04-29 20:00:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("985", "585", "action created", "2025-04-29 16:30:15", "2025-04-29 20:00:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("986", "585", "action started via WP Cron", "2025-04-29 16:32:13", "2025-04-29 20:02:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("987", "585", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-04-29 16:32:13", "2025-04-29 20:02:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("988", "586", "action created", "2025-04-29 16:47:52", "2025-04-29 20:17:52");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("3", "513", "ghg ghh", "designer3@abzarwp.com", "", "104.28.243.197", "2023-11-09 08:54:46", "2023-11-09 05:24:46", "عالی", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "513", "designer", "designer@abzarwp.com", "", "78.39.83.10", "2023-11-21 09:57:24", "2023-11-21 06:27:24", "عالی", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36", "comment", "0", "4");
INSERT INTO `wp_comments` VALUES("5", "4754", "MARI", "mari.razzi2024@gmail.com", "", "89.45.48.71", "2025-08-09 07:06:10", "2025-08-09 03:36:10", "بسیار عالی و مفید بود ممنون", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "4754", "۱۰ ویژگی بهترین CRM : کلید افزایش فروش کسب و کار شما-CRM تابان", "", "https://tabancrm.ir/best-crm/", "94.101.182.7", "2025-08-13 07:00:56", "2025-08-13 03:30:56", "[&#8230;] هنوز از مزایای CRM &nbsp;اطلاعات کافی ندارید ، حتما مقاله ی ( CRM &nbsp;چیست ) را مطالعه [&#8230;]", "0", "0", "The Incutio XML-RPC PHP Library -- WordPress/6.8.2", "pingback", "0", "0");
INSERT INTO `wp_comments` VALUES("7", "4806", "MARI", "mari.razzi2024@gmail.com", "", "89.45.48.72", "2025-08-18 12:33:59", "2025-08-18 09:03:59", "مطالب مفیدی بود ممنون", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("8", "4806", "بازاریابی دیجیتال+بازاریابی هوشمند|CRMتابان", "", "https://tabancrm.ir/digital-marketing/", "94.101.182.7", "2025-08-23 06:26:18", "2025-08-23 02:56:18", "[&#8230;] بازاریابان حرفه ای و مدیران موفق در این عصر دیجیتال ، بازاریابی دیجیتال به همراه یک نرم [&#8230;]", "0", "0", "The Incutio XML-RPC PHP Library -- WordPress/6.8.2", "pingback", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "4754", "انواع CRM", "", "https://tabancrm.ir/kinds-crm/", "94.101.182.7", "2025-08-27 11:00:21", "2025-08-27 07:30:21", "[&#8230;] CRMچیست؟ &nbsp;&nbsp;&nbsp;&nbsp; [&#8230;]", "0", "0", "The Incutio XML-RPC PHP Library -- WordPress/6.8.2", "pingback", "0", "0");
INSERT INTO `wp_comments` VALUES("10", "4782", "انواع CRM", "", "https://tabancrm.ir/kinds-crm/", "94.101.182.7", "2025-08-27 11:02:31", "2025-08-27 07:32:31", "[&#8230;] ۱۰ ویژگی بهترین CRM ها [&#8230;]", "0", "0", "The Incutio XML-RPC PHP Library -- WordPress/6.8.2", "pingback", "0", "0");
INSERT INTO `wp_comments` VALUES("11", "60", "uujl", "uujl@uujl.xyz", "https://uujl.xyz", "14.199.128.233", "2025-12-14 11:40:01", "2025-12-14 08:10:01", "Great article! Finding a legit platform is key, and easy registration is a huge plus. I noticed <a href=\'https://uujl.xyz\' rel=\"nofollow ugc\">uujl slot download</a> offers quick access &amp; local payment options – that’s a game changer for PH players! Definitely worth checking out for a smooth experience.", "0", "0", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("12", "64", "369jl", "369jl@369jl.click", "https://369jl.click", "14.199.128.233", "2025-12-16 08:36:05", "2025-12-16 05:06:05", "That’s a solid point about value betting – crucial for long-term success! Seeing platforms like <a href=\'https://369jl.click\' rel=\"nofollow ugc\">369jl vip</a> innovate with diverse games &amp; easy access via app/web is great for PH players. Good analysis!", "0", "0", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("13", "4890", "jljl99applogin", "admin@jljl99applogin.info", "https://jljl99applogin.info", "156.245.246.155", "2025-12-24 13:13:02", "2025-12-24 09:43:02", "JLJL99AppLogin - Anything that makes logging in easier is a win in my book. Seriously, who has time to remember a million passwords? This app gets me straight to the games I want. Login faster: <a href=\'https://jljl99applogin.info\' rel=\"nofollow ugc\">jljl99applogin</a>", "0", "0", "Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("3", "20231206_d8b3d8a7db8cd8aad8a2d985d8a7d8", "e512e32b0f772ce63160_20251227073724", "21", "2025-12-27 07:37:32", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-27 07:37:24\";s:7:\"Version\";s:7:\"1.5.7.1\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:7:\"10.6.18\";s:10:\"VersionPHP\";s:6:\"8.1.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:3;s:4:\"Name\";s:39:\"20231206_d8b3d8a7db8cd8aad8a2d985d8a7d8\";s:4:\"Hash\";s:35:\"e512e32b0f772ce63160_20251227073724\";s:8:\"NameHash\";s:75:\"20231206_d8b3d8a7db8cd8aad8a2d985d8a7d8_e512e32b0f772ce63160_20251227073724\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20231206_d8b3d8a7db8cd8aad8a2d985d8a7d8_e512e32b0f772ce63160_20251227073724_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.0\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20231206_d8b3d8a7db8cd8aad8a2d985d8a7d8_e512e32b0f772ce63160_20251227073724_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:24:\"/home/tabanc/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3134;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:14767;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-27 07:37:24\";s:7:\"Version\";s:7:\"1.5.7.1\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:7:\"10.6.18\";s:10:\"VersionPHP\";s:6:\"8.1.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20231206_d8b3d8a7db8cd8aad8a2d985d8a7d8\";s:4:\"Hash\";s:35:\"e512e32b0f772ce63160_20251227073724\";s:8:\"NameHash\";s:75:\"20231206_d8b3d8a7db8cd8aad8a2d985d8a7d8_e512e32b0f772ce63160_20251227073724\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20231206_d8b3d8a7db8cd8aad8a2d985d8a7d8_e512e32b0f772ce63160_20251227073724_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:38:\"/home/tabanc/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"20231206_d8b3d8a7db8cd8aad8a2d985d8a7d8_e512e32b0f772ce63160_20251227073724_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:145:\"/home/tabanc/public_html/wp-content/backups-dup-lite/tmp/20231206_d8b3d8a7db8cd8aad8a2d985d8a7d8_e512e32b0f772ce63160_20251227073724_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:33:\"/home/tabanc/public_html/wp-admin\";i:1;s:36:\"/home/tabanc/public_html/wp-includes\";i:2;s:45:\"/home/tabanc/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:24:\"/home/tabanc/public_html\";i:1;s:24:\"/home/tabanc/public_html\";i:2;s:35:\"/home/tabanc/public_html/wp-content\";i:3;s:43:\"/home/tabanc/public_html/wp-content/uploads\";i:4;s:43:\"/home/tabanc/public_html/wp-content/plugins\";i:5;s:46:\"/home/tabanc/public_html/wp-content/mu-plugins\";i:6;s:42:\"/home/tabanc/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:56:\"/home/tabanc/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_e_events */
INSERT INTO `wp_e_events` VALUES("1", "{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2023-10-09T18:17:04.680-04:30\"}", "2023-10-09 18:17:04");
INSERT INTO `wp_e_events` VALUES("2", "{\"event\":\"close modal\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\"}\",\"ts\":\"2023-10-09T18:18:38.716-04:30\"}", "2023-10-09 18:18:38");

/* INSERT TABLE DATA: wp_e_submissions */
INSERT INTO `wp_e_submissions` VALUES("4", "submission", "d68b06b7-a762-4ad2-9cbc-b8c43403de6b", "5", "4208", "http://tabancrm.ir/services/%da%af%d8%b2%d8%a7%d8%b1%d8%b4%da%af%db%8c%d8%b1%db%8c-%d9%88-%d8%aa%d8%ad%d9%84%db%8c%d9%84-%d8%af%d8%a7%d8%af%d9%87/", "گزارش‌گیری و تحلیل داده", "61c7d10", "فرم پاپ اپ درخواست مشاوره", "0", "4", "5.160.49.74", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"4208\"}", "2025-04-29 17:17:06", "2025-04-29 17:17:06", "2025-04-29 20:47:06", "2025-04-29 20:47:06");
INSERT INTO `wp_e_submissions` VALUES("5", "submission", "683d8af4-38bd-443c-8775-a8f3ce41e097", "10", "1229", "https://tabancrm.ir/services/%da%af%d8%b2%d8%a7%d8%b1%d8%b4%da%af%db%8c%d8%b1%db%8c-%d9%88-%d8%aa%d8%ad%d9%84%db%8c%d9%84-%d8%af%d8%a7%d8%af%d9%87/", "گزارش‌گیری و تحلیل داده - CRM تابان", "2e3e3d2", "فرم جدید", "0", "0", "46.143.82.73", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0", "1", "1", "new", "0", "{\"edit_post_id\":\"1229\"}", "2025-08-11 13:39:36", "2025-08-11 13:39:36", "2025-08-11 17:09:36", "2025-08-11 17:09:36");

/* INSERT TABLE DATA: wp_e_submissions_actions_log */
INSERT INTO `wp_e_submissions_actions_log` VALUES("4", "4", "email", "آدرس ایمیل", "failed", "ارسال شما به دلیل یک خطای سرور انجام نشد.", "2025-04-29 17:17:06", "2025-04-29 17:17:06", "2025-04-29 20:47:06", "2025-04-29 20:47:06");
INSERT INTO `wp_e_submissions_actions_log` VALUES("5", "5", "email", "آدرس ایمیل", "success", NULL, "2025-08-11 13:39:36", "2025-08-11 13:39:36", "2025-08-11 17:09:36", "2025-08-11 17:09:36");

/* INSERT TABLE DATA: wp_e_submissions_values */
INSERT INTO `wp_e_submissions_values` VALUES("4", "4", "name", "dfdfdf");
INSERT INTO `wp_e_submissions_values` VALUES("5", "4", "email", "sdsdd@dsds.com");
INSERT INTO `wp_e_submissions_values` VALUES("6", "4", "field_9dfe3a1", "dfdf");
INSERT INTO `wp_e_submissions_values` VALUES("7", "4", "phone", "21321321321");
INSERT INTO `wp_e_submissions_values` VALUES("8", "4", "message", "dfdf");
INSERT INTO `wp_e_submissions_values` VALUES("9", "4", "field_eb51bf8", "");
INSERT INTO `wp_e_submissions_values` VALUES("10", "5", "email", "maryamrazzaghi2008@gmail.com");

/* INSERT TABLE DATA: wp_fc_campaigns */
INSERT INTO `wp_fc_campaigns` VALUES("1", NULL, "campaign", "فروش بهار", NULL, "%d9%81%d8%b1%d9%88%d8%b4-%d8%a8%d9%87%d8%a7%d8%b1", "draft", "0", "", "", "<!-- wp:paragraph -->\n<p>سلام</p>\n<!-- /wp:paragraph -->", "0", "0", "0", NULL, NULL, NULL, NULL, NULL, "simple", NULL, "a:7:{s:15:\"mailer_settings\";a:5:{s:9:\"from_name\";s:0:\"\";s:10:\"from_email\";s:0:\"\";s:13:\"reply_to_name\";s:0:\"\";s:14:\"reply_to_email\";s:0:\"\";s:9:\"is_custom\";s:2:\"no\";}s:11:\"subscribers\";a:1:{i:0;a:2:{s:4:\"list\";s:3:\"all\";s:3:\"tag\";s:3:\"all\";}}s:19:\"excludedSubscribers\";a:1:{i:0;a:2:{s:4:\"list\";s:0:\"\";s:3:\"tag\";s:0:\"\";}}s:14:\"sending_filter\";s:8:\"list_tag\";s:15:\"dynamic_segment\";a:2:{s:2:\"id\";s:0:\"\";s:4:\"slug\";s:0:\"\";}s:15:\"template_config\";a:15:{s:13:\"content_width\";s:3:\"700\";s:15:\"content_padding\";s:2:\"20\";s:20:\"headings_font_family\";s:141:\"-apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, Helvetica, Arial, sans-serif, \'Apple Color Emoji\', \'Segoe UI Emoji\', \'Segoe UI Symbol\'\";s:10:\"text_color\";s:7:\"#202020\";s:10:\"link_color\";s:0:\"\";s:13:\"body_bg_color\";s:7:\"#FAFAFA\";s:16:\"content_bg_color\";s:7:\"#FFFFFF\";s:17:\"footer_text_color\";s:7:\"#202020\";s:19:\"content_font_family\";s:141:\"-apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, Helvetica, Arial, sans-serif, \'Apple Color Emoji\', \'Segoe UI Emoji\', \'Segoe UI Symbol\'\";s:15:\"paragraph_color\";s:0:\"\";s:19:\"paragraph_font_size\";s:0:\"\";s:21:\"paragraph_font_family\";s:0:\"\";s:21:\"paragraph_line_height\";s:0:\"\";s:14:\"headings_color\";s:7:\"#202020\";s:14:\"disable_footer\";s:2:\"no\";}s:12:\"sending_type\";s:7:\"instant\";}", "4", "2025-04-21 13:25:11", "2025-04-21 13:25:48");

/* INSERT TABLE DATA: wp_fc_lists */
INSERT INTO `wp_fc_lists` VALUES("1", "مشتری", "public", NULL, "0", "2025-04-21 13:19:16", "2025-04-21 13:19:16");

/* INSERT TABLE DATA: wp_fc_meta */
INSERT INTO `wp_fc_meta` VALUES("1", "option", NULL, "fluentcrm_is_sending_emails_last_called", "1745944110", "2025-04-21 13:17:22", "2025-04-29 19:58:30");
INSERT INTO `wp_fc_meta` VALUES("2", "option", NULL, "fluentcrm_setup_wizard_ran", "yes", "2025-04-21 13:17:41", "2025-04-21 13:17:41");
INSERT INTO `wp_fc_meta` VALUES("3", "option", NULL, "_fluentcrm_share_essential", "yes", "2025-04-21 13:20:40", "2025-04-21 13:20:40");
INSERT INTO `wp_fc_meta` VALUES("4", "FluentCrm\\App\\Models\\Campaign", "1", "_next_config_step", "1", "2025-04-21 13:25:48", "2025-04-21 13:25:48");

/* INSERT TABLE DATA: wp_fc_subscriber_pivot */
INSERT INTO `wp_fc_subscriber_pivot` VALUES("1", "1", "1", "FluentCrm\\App\\Models\\Lists", NULL, "1", "2025-04-21 13:24:01", "2025-04-21 13:24:01");
INSERT INTO `wp_fc_subscriber_pivot` VALUES("2", "1", "1", "FluentCrm\\App\\Models\\Tag", NULL, "1", "2025-04-21 13:24:01", "2025-04-21 13:24:01");

/* INSERT TABLE DATA: wp_fc_subscribers */
INSERT INTO `wp_fc_subscribers` VALUES("1", NULL, "013d664e4e40772c94235841b43c2dfa", NULL, NULL, "Mr", "mohamad", "mohamadi", "sasa@asas.com", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "0", NULL, "pending", "lead", NULL, NULL, NULL, "2025-04-21 13:24:01", NULL, "2025-04-21 13:24:01");

/* INSERT TABLE DATA: wp_fc_tags */
INSERT INTO `wp_fc_tags` VALUES("1", "تگ", "tag", NULL, "2025-04-21 13:20:03", "2025-04-21 13:20:03");
INSERT INTO `wp_fc_tags` VALUES("2", "نام", "%d9%86%d8%a7%d9%85", NULL, "2025-04-21 13:26:46", "2025-04-21 13:26:46");

/* INSERT TABLE DATA: wp_fluentform_form_meta */
INSERT INTO `wp_fluentform_form_meta` VALUES("1", "1", "template_name", "basic_contact_form");
INSERT INTO `wp_fluentform_form_meta` VALUES("2", "1", "formSettings", "{\"confirmation\":{\"redirectTo\":\"samePage\",\"messageToShow\":\"Thank you for your message. We will get in touch with you shortly\",\"customPage\":null,\"samePageFormBehavior\":\"hide_form\",\"customUrl\":null},\"restrictions\":{\"limitNumberOfEntries\":{\"enabled\":false,\"numberOfEntries\":null,\"period\":\"total\",\"limitReachedMsg\":\"Maximum number of entries exceeded.\"},\"scheduleForm\":{\"enabled\":false,\"start\":null,\"end\":null,\"selectedDays\":[\"Monday\",\"Tuesday\",\"Wednesday\",\"Thursday\",\"Friday\",\"Saturday\",\"Sunday\"],\"pendingMsg\":\"Form submission is not started yet.\",\"expiredMsg\":\"Form submission is now closed.\"},\"requireLogin\":{\"enabled\":false,\"requireLoginMsg\":\"You must be logged in to submit the form.\"},\"denyEmptySubmission\":{\"enabled\":false,\"message\":\"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say.\"}},\"layout\":{\"labelPlacement\":\"top\",\"helpMessagePlacement\":\"with_label\",\"errorMessagePlacement\":\"inline\",\"cssClassName\":\"\",\"asteriskPlacement\":\"asterisk-right\"},\"delete_entry_on_submission\":\"no\",\"appendSurveyResult\":{\"enabled\":false,\"showLabel\":false,\"showCount\":false}}");
INSERT INTO `wp_fluentform_form_meta` VALUES("3", "1", "advancedValidationSettings", "{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":\"\",\"operator\":\"=\",\"value\":\"\"}],\"error_message\":\"\",\"validation_type\":\"fail_on_condition_met\"}");
INSERT INTO `wp_fluentform_form_meta` VALUES("4", "1", "double_optin_settings", "{\"status\":\"no\",\"confirmation_message\":\"Please check your email inbox to confirm this submission\",\"email_body_type\":\"global\",\"email_subject\":\"Please confirm your form submission\",\"email_body\":\"<h2>Please Confirm Your Submission</h2><p>&nbsp;</p><p style=\"text-align: center;\"><a style=\"color: #ffffff; background-color: #454545; font-size: 16px; border-radius: 5px; text-decoration: none; font-weight: normal; font-style: normal; padding: 0.8rem 1rem; border-color: #0072ff;\" href=\"#confirmation_url#\">Confirm Submission</a></p><p>&nbsp;</p><p>If you received this email by mistake, simply delete it. Your form submission won\'t proceed if you don\'t click the confirmation link above.</p>\",\"email_field\":\"\",\"skip_if_logged_in\":\"yes\",\"skip_if_fc_subscribed\":\"no\"}");
INSERT INTO `wp_fluentform_form_meta` VALUES("5", "2", "template_name", "inline_subscription");
INSERT INTO `wp_fluentform_form_meta` VALUES("6", "2", "formSettings", "{\"confirmation\":{\"redirectTo\":\"samePage\",\"messageToShow\":\"Thank you for your message. We will get in touch with you shortly\",\"customPage\":null,\"samePageFormBehavior\":\"hide_form\",\"customUrl\":null},\"restrictions\":{\"limitNumberOfEntries\":{\"enabled\":false,\"numberOfEntries\":null,\"period\":\"total\",\"limitReachedMsg\":\"Maximum number of entries exceeded.\"},\"scheduleForm\":{\"enabled\":false,\"start\":null,\"end\":null,\"pendingMsg\":\"Form submission is not started yet.\",\"expiredMsg\":\"Form submission is now closed.\"},\"requireLogin\":{\"enabled\":false,\"requireLoginMsg\":\"You must be logged in to submit the form.\"},\"denyEmptySubmission\":{\"enabled\":false,\"message\":\"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say.\"}},\"layout\":{\"labelPlacement\":\"top\",\"helpMessagePlacement\":\"with_label\",\"errorMessagePlacement\":\"inline\",\"asteriskPlacement\":\"asterisk-right\"}}");
INSERT INTO `wp_fluentform_form_meta` VALUES("7", "2", "notifications", "{\"name\":\"Admin Notification Email\",\"sendTo\":{\"type\":\"email\",\"email\":\"{wp.admin_email}\",\"field\":\"email\",\"routing\":[{\"email\":null,\"field\":null,\"operator\":\"=\",\"value\":null}]},\"fromName\":\"\",\"fromEmail\":\"\",\"replyTo\":\"\",\"bcc\":\"\",\"subject\":\"[{inputs.names}] New Form Submission\",\"message\":\"<p>{all_data}<\\/p> <p>This form submitted at: {embed_post.permalink}<\\/p>\",\"conditionals\":{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":null,\"operator\":\"=\",\"value\":null}]},\"enabled\":false,\"email_template\":\"\"}");
INSERT INTO `wp_fluentform_form_meta` VALUES("8", "2", "step_data_persistency_status", "no");
INSERT INTO `wp_fluentform_form_meta` VALUES("9", "2", "_primary_email_field", "email");
INSERT INTO `wp_fluentform_form_meta` VALUES("10", "3", "formSettings", "{\"confirmation\":{\"redirectTo\":\"samePage\",\"messageToShow\":\"Please check your inbox to confirm your subscription\",\"customPage\":null,\"samePageFormBehavior\":\"hide_form\",\"customUrl\":null},\"restrictions\":{\"limitNumberOfEntries\":{\"enabled\":false,\"numberOfEntries\":null,\"period\":\"total\",\"limitReachedMsg\":\"Maximum number of entries exceeded.\"},\"scheduleForm\":{\"enabled\":false,\"start\":null,\"end\":null,\"selectedDays\":null,\"pendingMsg\":\"Form submission is not started yet.\",\"expiredMsg\":\"Form submission is now closed.\"},\"requireLogin\":{\"enabled\":false,\"requireLoginMsg\":\"You must be logged in to submit the form.\"},\"denyEmptySubmission\":{\"enabled\":false,\"message\":\"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say.\"}},\"layout\":{\"labelPlacement\":\"top\",\"asteriskPlacement\":\"asterisk-right\",\"helpMessagePlacement\":\"with_label\",\"errorMessagePlacement\":\"inline\",\"cssClassName\":\"\"},\"delete_entry_on_submission\":\"no\"}");
INSERT INTO `wp_fluentform_form_meta` VALUES("11", "3", "fluentcrm_feeds", "{\"name\":\"FluentCRM Integration Feed\",\"first_name\":\"{inputs.names.first_name}\",\"last_name\":\"{inputs.names.last_name}\",\"email\":\"email\",\"other_fields\":[{\"item_value\":\"\",\"label\":\"\"}],\"list_id\":\"1\",\"tag_ids\":[\"2\"],\"skip_if_exists\":false,\"double_opt_in\":\"true\",\"conditionals\":{\"conditions\":[],\"status\":false,\"type\":\"all\"},\"enabled\":true,\"status\":true}");

/* INSERT TABLE DATA: wp_fluentform_forms */
INSERT INTO `wp_fluentform_forms` VALUES("1", "Contact Form Demo", "published", NULL, "{\"fields\":[{\"index\":0,\"element\":\"input_name\",\"attributes\":{\"name\":\"names\",\"data-type\":\"name-element\"},\"settings\":{\"container_class\":\"\",\"admin_field_label\":\"Name\",\"conditional_logics\":[]},\"fields\":{\"first_name\":{\"element\":\"input_text\",\"attributes\":{\"type\":\"text\",\"name\":\"first_name\",\"value\":\"\",\"id\":\"\",\"class\":\"\",\"placeholder\":\"First Name\"},\"settings\":{\"container_class\":\"\",\"label\":\"First Name\",\"help_message\":\"\",\"visible\":true,\"validation_rules\":{\"required\":{\"value\":false,\"message\":\"This field is required\"}},\"conditional_logics\":[]},\"editor_options\":{\"template\":\"inputText\"}},\"middle_name\":{\"element\":\"input_text\",\"attributes\":{\"type\":\"text\",\"name\":\"middle_name\",\"value\":\"\",\"id\":\"\",\"class\":\"\",\"placeholder\":\"\",\"required\":false},\"settings\":{\"container_class\":\"\",\"label\":\"Middle Name\",\"help_message\":\"\",\"error_message\":\"\",\"visible\":false,\"validation_rules\":{\"required\":{\"value\":false,\"message\":\"This field is required\"}},\"conditional_logics\":[]},\"editor_options\":{\"template\":\"inputText\"}},\"last_name\":{\"element\":\"input_text\",\"attributes\":{\"type\":\"text\",\"name\":\"last_name\",\"value\":\"\",\"id\":\"\",\"class\":\"\",\"placeholder\":\"Last Name\",\"required\":false},\"settings\":{\"container_class\":\"\",\"label\":\"Last Name\",\"help_message\":\"\",\"error_message\":\"\",\"visible\":true,\"validation_rules\":{\"required\":{\"value\":false,\"message\":\"This field is required\"}},\"conditional_logics\":[]},\"editor_options\":{\"template\":\"inputText\"}}},\"editor_options\":{\"title\":\"Name Fields\",\"element\":\"name-fields\",\"icon_class\":\"ff-edit-name\",\"template\":\"nameFields\"},\"uniqElKey\":\"el_1570866006692\"},{\"index\":1,\"element\":\"input_email\",\"attributes\":{\"type\":\"email\",\"name\":\"email\",\"value\":\"\",\"id\":\"\",\"class\":\"\",\"placeholder\":\"Email Address\"},\"settings\":{\"container_class\":\"\",\"label\":\"Email\",\"label_placement\":\"\",\"help_message\":\"\",\"admin_field_label\":\"\",\"validation_rules\":{\"required\":{\"value\":true,\"message\":\"This field is required\"},\"email\":{\"value\":true,\"message\":\"This field must contain a valid email\"}},\"conditional_logics\":[]},\"editor_options\":{\"title\":\"Email Address\",\"icon_class\":\"ff-edit-email\",\"template\":\"inputText\"},\"uniqElKey\":\"el_1570866012914\"},{\"index\":2,\"element\":\"input_text\",\"attributes\":{\"type\":\"text\",\"name\":\"subject\",\"value\":\"\",\"class\":\"\",\"placeholder\":\"Subject\"},\"settings\":{\"container_class\":\"\",\"label\":\"Subject\",\"label_placement\":\"\",\"admin_field_label\":\"Subject\",\"help_message\":\"\",\"validation_rules\":{\"required\":{\"value\":false,\"message\":\"This field is required\"}},\"conditional_logics\":{\"type\":\"any\",\"status\":false,\"conditions\":[{\"field\":\"\",\"value\":\"\",\"operator\":\"\"}]}},\"editor_options\":{\"title\":\"Simple Text\",\"icon_class\":\"ff-edit-text\",\"template\":\"inputText\"},\"uniqElKey\":\"el_1570878958648\"},{\"index\":3,\"element\":\"textarea\",\"attributes\":{\"name\":\"message\",\"value\":\"\",\"id\":\"\",\"class\":\"\",\"placeholder\":\"Your Message\",\"rows\":4,\"cols\":2},\"settings\":{\"container_class\":\"\",\"label\":\"Your Message\",\"admin_field_label\":\"\",\"label_placement\":\"\",\"help_message\":\"\",\"validation_rules\":{\"required\":{\"value\":true,\"message\":\"This field is required\"}},\"conditional_logics\":{\"type\":\"any\",\"status\":false,\"conditions\":[{\"field\":\"\",\"value\":\"\",\"operator\":\"\"}]}},\"editor_options\":{\"title\":\"Text Area\",\"icon_class\":\"ff-edit-textarea\",\"template\":\"inputTextarea\"},\"uniqElKey\":\"el_1570879001207\"}],\"submitButton\":{\"uniqElKey\":\"el_1524065200616\",\"element\":\"button\",\"attributes\":{\"type\":\"submit\",\"class\":\"\"},\"settings\":{\"align\":\"left\",\"button_style\":\"default\",\"container_class\":\"\",\"help_message\":\"\",\"background_color\":\"#1a7efb\",\"button_size\":\"md\",\"color\":\"#ffffff\",\"button_ui\":{\"type\":\"default\",\"text\":\"Submit Form\",\"img_url\":\"\"}},\"editor_options\":{\"title\":\"Submit Button\"}}}", "0", "", NULL, "4", "2025-04-21 13:20:38", "2025-04-21 13:20:38");
INSERT INTO `wp_fluentform_forms` VALUES("2", "Subscription Form", "published", NULL, "{\"fields\":[{\"index\":1,\"element\":\"container\",\"attributes\":[],\"settings\":{\"container_class\":\"\",\"conditional_logics\":{\"type\":\"any\",\"status\":false,\"conditions\":[{\"field\":\"\",\"value\":\"\",\"operator\":\"\"}]}},\"columns\":[{\"fields\":[{\"index\":1,\"element\":\"input_email\",\"attributes\":{\"type\":\"email\",\"name\":\"email\",\"value\":\"\",\"id\":\"\",\"class\":\"\",\"placeholder\":\"Your Email Address\"},\"settings\":{\"container_class\":\"\",\"label\":\"\",\"label_placement\":\"\",\"help_message\":\"\",\"admin_field_label\":\"Email\",\"validation_rules\":{\"required\":{\"value\":true,\"message\":\"This field is required\"},\"email\":{\"value\":true,\"message\":\"This field must contain a valid email\"}},\"conditional_logics\":[],\"is_unique\":\"no\",\"unique_validation_message\":\"Email address need to be unique.\"},\"editor_options\":{\"title\":\"Email Address\",\"icon_class\":\"ff-edit-email\",\"template\":\"inputText\"},\"uniqElKey\":\"el_16231279686950.8779857923682932\"}]},{\"fields\":[{\"index\":15,\"element\":\"custom_submit_button\",\"attributes\":{\"class\":\"\",\"type\":\"submit\"},\"settings\":{\"button_style\":\"\",\"button_size\":\"md\",\"align\":\"left\",\"container_class\":\"\",\"current_state\":\"normal_styles\",\"background_color\":\"\",\"color\":\"\",\"hover_styles\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#1a7efb\",\"color\":\"#1a7efb\",\"borderRadius\":\"\",\"minWidth\":\"100%\"},\"normal_styles\":{\"backgroundColor\":\"#1a7efb\",\"borderColor\":\"#1a7efb\",\"color\":\"#ffffff\",\"borderRadius\":\"\",\"minWidth\":\"100%\"},\"button_ui\":{\"text\":\"Subscribe\",\"type\":\"default\",\"img_url\":\"\"},\"conditional_logics\":{\"type\":\"any\",\"status\":false,\"conditions\":[{\"field\":\"\",\"value\":\"\",\"operator\":\"\"}]}},\"editor_options\":{\"title\":\"Custom Submit Button\",\"icon_class\":\"dashicons dashicons-arrow-right-alt\",\"template\":\"customButton\"},\"uniqElKey\":\"el_16231279798380.5947400167493171\"}]}],\"editor_options\":{\"title\":\"Two Column Container\",\"icon_class\":\"ff-edit-column-2\"},\"uniqElKey\":\"el_16231279284710.40955091024524304\"}],\"submitButton\":{\"uniqElKey\":\"el_1524065200616\",\"element\":\"button\",\"attributes\":{\"type\":\"submit\",\"class\":\"\"},\"settings\":{\"align\":\"left\",\"button_style\":\"default\",\"container_class\":\"\",\"help_message\":\"\",\"background_color\":\"#1a7efb\",\"button_size\":\"md\",\"color\":\"#ffffff\",\"button_ui\":{\"type\":\"default\",\"text\":\"Subscribe\",\"img_url\":\"\"}},\"editor_options\":{\"title\":\"Submit Button\"}}}", "0", "form", NULL, "4", "2025-04-21 13:20:38", "2025-04-21 13:20:38");
INSERT INTO `wp_fluentform_forms` VALUES("3", "اطلاعات مشتری", "published", NULL, "{\"fields\":[{\"index\":0,\"element\":\"input_name\",\"attributes\":{\"name\":\"names\",\"data-type\":\"name-element\"},\"settings\":{\"container_class\":\"\",\"admin_field_label\":\"Name\",\"conditional_logics\":{\"type\":\"any\",\"status\":false,\"conditions\":[{\"field\":\"\",\"value\":\"\",\"operator\":\"\"}]},\"label_placement\":\"\"},\"fields\":{\"first_name\":{\"element\":\"input_text\",\"attributes\":{\"type\":\"text\",\"name\":\"first_name\",\"value\":\"\",\"id\":\"\",\"class\":\"\",\"placeholder\":\"First Name\"},\"settings\":{\"container_class\":\"\",\"label\":\"First Name\",\"help_message\":\"\",\"visible\":true,\"validation_rules\":{\"required\":{\"value\":false,\"message\":\"This field is required\"}},\"conditional_logics\":[]},\"editor_options\":{\"template\":\"inputText\"}},\"middle_name\":{\"element\":\"input_text\",\"attributes\":{\"type\":\"text\",\"name\":\"middle_name\",\"value\":\"\",\"id\":\"\",\"class\":\"\",\"placeholder\":\"\",\"required\":false},\"settings\":{\"container_class\":\"\",\"label\":\"Middle Name\",\"help_message\":\"\",\"error_message\":\"\",\"visible\":false,\"validation_rules\":{\"required\":{\"value\":false,\"message\":\"This field is required\"}},\"conditional_logics\":[]},\"editor_options\":{\"template\":\"inputText\"}},\"last_name\":{\"element\":\"input_text\",\"attributes\":{\"type\":\"text\",\"name\":\"last_name\",\"value\":\"\",\"id\":\"\",\"class\":\"\",\"placeholder\":\"Last Name\",\"required\":false},\"settings\":{\"container_class\":\"\",\"label\":\"Last Name\",\"help_message\":\"\",\"error_message\":\"\",\"visible\":true,\"validation_rules\":{\"required\":{\"value\":false,\"message\":\"This field is required\"}},\"conditional_logics\":[]},\"editor_options\":{\"template\":\"inputText\"}}},\"editor_options\":{\"title\":\"Name Fields\",\"element\":\"name-fields\",\"icon_class\":\"ff-edit-name\",\"template\":\"nameFields\"},\"uniqElKey\":\"el_1570866006692\"},{\"index\":1,\"element\":\"input_email\",\"attributes\":{\"type\":\"email\",\"name\":\"email\",\"value\":\"\",\"id\":\"\",\"class\":\"\",\"placeholder\":\"Email Address\"},\"settings\":{\"container_class\":\"\",\"label\":\"Email\",\"label_placement\":\"\",\"help_message\":\"\",\"admin_field_label\":\"\",\"validation_rules\":{\"required\":{\"value\":true,\"message\":\"This field is required\"},\"email\":{\"value\":true,\"message\":\"This field must contain a valid email\"}},\"conditional_logics\":{\"type\":\"any\",\"status\":false,\"conditions\":[{\"field\":\"\",\"value\":\"\",\"operator\":\"\"}]},\"is_unique\":\"no\",\"unique_validation_message\":\"Email address need to be unique.\"},\"editor_options\":{\"title\":\"Email Address\",\"icon_class\":\"ff-edit-email\",\"template\":\"inputText\"},\"uniqElKey\":\"el_1570866012914\"}],\"submitButton\":{\"uniqElKey\":\"el_1524065200616\",\"element\":\"button\",\"attributes\":{\"type\":\"submit\",\"class\":\"\"},\"settings\":{\"align\":\"left\",\"button_style\":\"default\",\"container_class\":\"\",\"help_message\":\"\",\"background_color\":\"#409EFF\",\"button_size\":\"md\",\"color\":\"#ffffff\",\"button_ui\":{\"type\":\"default\",\"text\":\"Subscribe\",\"img_url\":\"\"},\"normal_styles\":{\"backgroundColor\":\"#409EFF\",\"borderColor\":\"#409EFF\",\"color\":\"#ffffff\",\"borderRadius\":\"\",\"minWidth\":\"\"},\"hover_styles\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#409EFF\",\"color\":\"#409EFF\",\"borderRadius\":\"\",\"minWidth\":\"\"},\"current_state\":\"normal_styles\"},\"editor_options\":{\"title\":\"Submit Button\"}}}", "0", "form", NULL, "4", "2025-04-21 13:26:54", "2025-04-21 13:26:54");

/* INSERT TABLE DATA: wp_jet_cct_customers_comments */
INSERT INTO `wp_jet_cct_customers_comments` VALUES("1", "publish", "4", "2023-10-26 21:07:36", "2023-10-26 21:08:19", "مونا لطفی", "لورم ایپسوم متن ساختــگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیــک است، چاپگرها و متون بلکه روزنامه و مجله است.", "1284", "5");
INSERT INTO `wp_jet_cct_customers_comments` VALUES("2", "publish", "4", "2023-10-26 21:09:03", "2023-10-26 21:09:03", "سمانه محمودی", "لورم ایپسوم متن ساختــگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیــک است، چاپگرها و متون بلکه روزنامه و مجله است.", "1285", "3");
INSERT INTO `wp_jet_cct_customers_comments` VALUES("3", "publish", "4", "2023-10-26 21:09:44", "2023-10-26 21:09:44", "کوروش محمودی", "لورم ایپسوم متن ساختــگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیــک است، چاپگرها و متون بلکه روزنامه و مجله است.", "1283", "4");

/* INSERT TABLE DATA: wp_jet_cct_team_members */
INSERT INTO `wp_jet_cct_team_members` VALUES("1", "publish", "ایمان افضلی", "4375", "4", "4", "2023-10-27 17:30:52", "2023-12-05 16:09:31", "برنامه نویس بک اند");
INSERT INTO `wp_jet_cct_team_members` VALUES("2", "publish", "سهیل رسولی", "4367", "3", "4", "2023-10-27 17:32:09", "2023-12-05 16:09:50", "برنامه نویس فرانت اند");
INSERT INTO `wp_jet_cct_team_members` VALUES("3", "publish", "مهدی نظری", "1376", "5", "4", "2023-10-27 17:32:58", "2023-10-27 17:32:58", "طراح ui/ux");
INSERT INTO `wp_jet_cct_team_members` VALUES("4", "publish", "حامد علیزاده", "1375", "3", "4", "2023-10-27 17:34:06", "2023-10-27 19:07:35", "طراح سایت");

/* INSERT TABLE DATA: wp_jet_post_types */
INSERT INTO `wp_jet_post_types` VALUES("1", "services", "publish", "a:11:{s:4:\"name\";s:10:\"خدمات\";s:13:\"singular_name\";s:10:\"خدمات\";s:7:\"add_new\";s:32:\"افزودن خدمات جدید\";s:12:\"add_new_item\";s:32:\"افزودن خدمات جدید\";s:8:\"new_item\";s:19:\"خدمات جدید\";s:9:\"edit_item\";s:23:\"ویرایش خدمات\";s:9:\"view_item\";s:23:\"مشاهده خدمات\";s:9:\"all_items\";s:17:\"همه خدمات\";s:12:\"search_items\";s:21:\"جستجو خدمات\";s:14:\"featured_image\";s:14:\"Featured Image\";s:18:\"set_featured_image\";s:18:\"Set featured image\";}", "a:22:{s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:9:\"query_var\";b:1;s:7:\"rewrite\";b:1;s:12:\"map_meta_cap\";b:0;s:11:\"has_archive\";b:1;s:12:\"hierarchical\";b:0;s:19:\"exclude_from_search\";b:0;s:10:\"with_front\";b:0;s:14:\"show_edit_link\";b:0;s:16:\"hide_field_names\";b:0;s:12:\"rewrite_slug\";s:8:\"services\";s:15:\"capability_type\";s:4:\"post\";s:13:\"menu_position\";i:59;s:9:\"menu_icon\";s:23:\"dashicons-admin-generic\";s:8:\"supports\";a:5:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";i:3;s:8:\"comments\";i:4;s:7:\"excerpt\";}s:13:\"admin_columns\";a:0:{}s:13:\"admin_filters\";a:0:{}}", "a:0:{}");
INSERT INTO `wp_jet_post_types` VALUES("2", "projects", "publish", "a:9:{s:4:\"name\";s:15:\"پروژه ها\";s:13:\"singular_name\";s:10:\"پروژه\";s:7:\"add_new\";s:32:\"افزودن پروژه جدید\";s:12:\"add_new_item\";s:32:\"افزودن پروژه جدید\";s:8:\"new_item\";s:19:\"پروژه جدید\";s:9:\"edit_item\";s:23:\"ویرایش پروژه\";s:9:\"view_item\";s:23:\"مشاهده پروژه\";s:9:\"all_items\";s:22:\"همه پروژه ها\";s:12:\"search_items\";s:26:\"جستجو پروژه ها\";}", "a:22:{s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:9:\"query_var\";b:1;s:7:\"rewrite\";b:1;s:12:\"map_meta_cap\";b:0;s:11:\"has_archive\";b:1;s:12:\"hierarchical\";b:0;s:19:\"exclude_from_search\";b:0;s:10:\"with_front\";b:0;s:14:\"show_edit_link\";b:0;s:16:\"hide_field_names\";b:0;s:12:\"rewrite_slug\";s:8:\"projects\";s:15:\"capability_type\";s:4:\"post\";s:13:\"menu_position\";i:59;s:9:\"menu_icon\";s:20:\"dashicons-admin-page\";s:8:\"supports\";a:4:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";i:3;s:8:\"comments\";}s:13:\"admin_columns\";a:0:{}s:13:\"admin_filters\";a:0:{}}", "a:7:{i:0;a:9:{s:5:\"title\";s:10:\"گالری\";s:4:\"name\";s:7:\"gallery\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:7:\"gallery\";s:2:\"id\";i:2230;s:8:\"isNested\";b:0;}i:1;a:9:{s:5:\"title\";s:21:\"نام کارفرما\";s:4:\"name\";s:12:\"the-employer\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:7444;s:8:\"isNested\";b:0;}i:2;a:9:{s:5:\"title\";s:19:\"تاریخ شروع\";s:4:\"name\";s:10:\"start-date\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"date\";s:2:\"id\";i:2192;s:8:\"isNested\";b:0;}i:3;a:9:{s:5:\"title\";s:19:\"قیمت پروژه\";s:4:\"name\";s:13:\"project-price\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:6:\"number\";s:2:\"id\";i:3107;s:8:\"isNested\";b:0;}i:4;a:9:{s:5:\"title\";s:26:\"مدت زمان انجام\";s:4:\"name\";s:23:\"duration-of-performance\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:6:\"number\";s:2:\"id\";i:2428;s:8:\"isNested\";b:0;}i:5;a:12:{s:5:\"title\";s:45:\"تکنولوژی های استفاده شده\";s:4:\"name\";s:17:\"technologies-used\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:11:{i:0;a:3:{s:3:\"key\";s:4:\"html\";s:5:\"value\";s:4:\"html\";s:2:\"id\";i:6018;}i:1;a:3:{s:3:\"key\";s:3:\"css\";s:5:\"value\";s:3:\"css\";s:2:\"id\";i:5447;}i:2;a:3:{s:3:\"key\";s:11:\"Java Script\";s:5:\"value\";s:11:\"Java Script\";s:2:\"id\";i:5614;}i:3;a:3:{s:3:\"key\";s:3:\"php\";s:5:\"value\";s:3:\"php\";s:2:\"id\";i:8838;}i:4;a:3:{s:3:\"key\";s:9:\"Bootstrap\";s:5:\"value\";s:9:\"Bootstrap\";s:2:\"id\";i:3363;}i:5;a:3:{s:3:\"key\";s:6:\"Jquery\";s:5:\"value\";s:6:\"Jquery\";s:2:\"id\";i:3098;}i:6;a:3:{s:3:\"key\";s:9:\"Wordpress\";s:5:\"value\";s:9:\"Wordpress\";s:2:\"id\";i:8885;}i:7;a:3:{s:3:\"key\";s:5:\"figma\";s:5:\"value\";s:5:\"figma\";s:2:\"id\";i:4366;}i:8;a:3:{s:3:\"key\";s:9:\"photoshop\";s:5:\"value\";s:9:\"photoshop\";s:2:\"id\";i:1552;}i:9;a:3:{s:3:\"key\";s:7:\"android\";s:5:\"value\";s:7:\"android\";s:2:\"id\";i:2888;}i:10;a:3:{s:3:\"key\";s:3:\"ios\";s:5:\"value\";s:3:\"ios\";s:2:\"id\";i:5584;}}s:15:\"repeater-fields\";a:1:{i:0;a:4:{s:5:\"title\";s:36:\"نام زبان و نرم افزار\";s:4:\"name\";s:21:\"language-and-software\";s:4:\"type\";s:4:\"text\";s:2:\"id\";i:7104;}}s:4:\"type\";s:8:\"repeater\";s:2:\"id\";i:9015;s:8:\"isNested\";b:0;s:11:\"is_multiple\";b:1;s:18:\"repeater_collapsed\";s:0:\"\";s:20:\"repeater_title_field\";s:36:\"نام-زبان-و-نرم-افزار\";}i:6;a:11:{s:5:\"title\";s:18:\"امتیازدهی\";s:4:\"name\";s:7:\"scoring\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:6:\"number\";s:2:\"id\";i:2956;s:8:\"isNested\";b:0;s:9:\"min_value\";s:1:\"1\";s:9:\"max_value\";s:1:\"5\";}}");
INSERT INTO `wp_jet_post_types` VALUES("3", "customers_comments", "content-type", NULL, "a:20:{s:10:\"has_single\";b:0;s:12:\"create_index\";b:0;s:16:\"rest_get_enabled\";b:0;s:16:\"rest_put_enabled\";b:0;s:17:\"rest_post_enabled\";b:0;s:19:\"rest_delete_enabled\";b:0;s:16:\"hide_field_names\";b:0;s:4:\"name\";s:25:\"نظرات مشتریان\";s:4:\"slug\";s:18:\"customers_comments\";s:8:\"position\";i:59;s:4:\"icon\";s:15:\"dashicons-heart\";s:10:\"capability\";s:14:\"manage_options\";s:17:\"related_post_type\";s:0:\"\";s:23:\"related_post_type_title\";s:0:\"\";s:25:\"related_post_type_content\";s:0:\"\";s:15:\"rest_get_access\";s:0:\"\";s:15:\"rest_put_access\";s:10:\"edit_posts\";s:16:\"rest_post_access\";s:10:\"edit_posts\";s:18:\"rest_delete_access\";s:10:\"edit_posts\";s:13:\"admin_columns\";a:10:{s:3:\"_ID\";a:4:{s:7:\"enabled\";b:1;s:11:\"is_sortable\";b:1;s:6:\"is_num\";b:1;s:6:\"prefix\";s:1:\"#\";}s:18:\"cct_single_post_id\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:13:\"cct_author_id\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:11:\"cct_created\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:12:\"cct_modified\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:10:\"cct_status\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:4:\"name\";a:3:{s:7:\"enabled\";b:1;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:12:\"comment_text\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:11:\"profile_pic\";a:3:{s:7:\"enabled\";b:1;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:7:\"scoring\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}}}", "a:4:{i:0;a:9:{s:5:\"title\";s:6:\"نام\";s:4:\"name\";s:4:\"name\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:1624;s:8:\"isNested\";b:0;}i:1;a:9:{s:5:\"title\";s:13:\"متن نظر\";s:4:\"name\";s:12:\"comment_text\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:1250;s:8:\"isNested\";b:0;}i:2;a:9:{s:5:\"title\";s:36:\"تصویر پروفایل کاربر\";s:4:\"name\";s:11:\"profile_pic\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:5:\"media\";s:2:\"id\";i:6473;s:8:\"isNested\";b:0;}i:3;a:11:{s:5:\"title\";s:18:\"امتیازدهی\";s:4:\"name\";s:7:\"scoring\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:6:\"number\";s:2:\"id\";i:5248;s:8:\"isNested\";b:0;s:9:\"min_value\";s:1:\"1\";s:9:\"max_value\";s:1:\"5\";}}");
INSERT INTO `wp_jet_post_types` VALUES("4", "team_members", "content-type", NULL, "a:20:{s:10:\"has_single\";b:0;s:12:\"create_index\";b:0;s:16:\"rest_get_enabled\";b:0;s:16:\"rest_put_enabled\";b:0;s:17:\"rest_post_enabled\";b:0;s:19:\"rest_delete_enabled\";b:0;s:16:\"hide_field_names\";b:0;s:4:\"name\";s:17:\"اعضای تیم\";s:4:\"slug\";s:12:\"team_members\";s:8:\"position\";i:59;s:4:\"icon\";s:26:\"dashicons-universal-access\";s:10:\"capability\";s:14:\"manage_options\";s:17:\"related_post_type\";s:0:\"\";s:23:\"related_post_type_title\";s:0:\"\";s:25:\"related_post_type_content\";s:0:\"\";s:15:\"rest_get_access\";s:0:\"\";s:15:\"rest_put_access\";s:10:\"edit_posts\";s:16:\"rest_post_access\";s:10:\"edit_posts\";s:18:\"rest_delete_access\";s:10:\"edit_posts\";s:13:\"admin_columns\";a:10:{s:3:\"_ID\";a:4:{s:7:\"enabled\";b:1;s:11:\"is_sortable\";b:1;s:6:\"is_num\";b:1;s:6:\"prefix\";s:1:\"#\";}s:18:\"cct_single_post_id\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:13:\"cct_author_id\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:11:\"cct_created\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:12:\"cct_modified\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:10:\"cct_status\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:4:\"name\";a:3:{s:7:\"enabled\";b:1;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:11:\"profile_pic\";a:3:{s:7:\"enabled\";b:1;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:7:\"scoring\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:14:\"the_profession\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}}}", "a:4:{i:0;a:9:{s:5:\"title\";s:7:\"نام \";s:4:\"name\";s:4:\"name\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:6259;s:8:\"isNested\";b:0;}i:1;a:9:{s:5:\"title\";s:25:\"تصویر پروفایل\";s:4:\"name\";s:11:\"profile_pic\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:5:\"media\";s:2:\"id\";i:8019;s:8:\"isNested\";b:0;}i:2;a:11:{s:5:\"title\";s:18:\"امتیازدهی\";s:4:\"name\";s:7:\"scoring\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:6:\"number\";s:2:\"id\";i:3566;s:8:\"isNested\";b:0;s:9:\"min_value\";s:1:\"1\";s:9:\"max_value\";s:1:\"5\";}i:3;a:9:{s:5:\"title\";s:8:\"حرفه\";s:4:\"name\";s:14:\"the_profession\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:5312;s:8:\"isNested\";b:0;}}");

/* INSERT TABLE DATA: wp_jet_taxonomies */
INSERT INTO `wp_jet_taxonomies` VALUES("6", "work_category", "a:1:{i:0;s:8:\"projects\";}", "publish", "a:9:{s:4:\"name\";s:33:\"دسته بندی پروژه ها\";s:13:\"singular_name\";s:28:\"دسته بندی پروژه\";s:9:\"menu_name\";s:28:\"دسته بندی پروژه\";s:9:\"all_items\";s:40:\"همه دسته بندی پروژه ها\";s:9:\"edit_item\";s:41:\"ویرایش دسته بندی پروژه\";s:9:\"view_item\";s:41:\"مشاهده دسته بندی پروژه\";s:11:\"update_item\";s:52:\"به‌روزرسانی دسته بندی پروژه\";s:12:\"add_new_item\";s:50:\"افزودن دسته بندی پروژه جدید\";s:13:\"new_item_name\";s:44:\"نام دسته بندی پروژه جدید\";}", "a:16:{s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:7:\"rewrite\";b:1;s:12:\"hierarchical\";b:0;s:10:\"with_front\";b:0;s:14:\"show_edit_link\";b:0;s:16:\"hide_field_names\";b:0;s:20:\"rewrite_hierarchical\";b:0;s:9:\"query_var\";s:0:\"\";s:12:\"rewrite_slug\";s:13:\"work_category\";s:15:\"capability_type\";s:0:\"\";s:11:\"description\";s:0:\"\";}", "a:0:{}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://tabancrm.ir", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://tabancrm.ir", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "CRM تابان", "on");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "روشن برای رشد، دقیق برای پیگیری", "on");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "fanaei.amin@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:166:{s:11:\"jsf/(.*)/?$\";s:25:\"index.php?jsf=$matches[1]\";s:19:\"(.?.+?)/jsf/(.*)/?$\";s:46:\"index.php?pagename=$matches[1]&jsf=$matches[2]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:23:\"^udb-login-customizer/?\";s:39:\"index.php?pagename=udb-login-customizer\";s:11:\"projects/?$\";s:28:\"index.php?post_type=projects\";s:41:\"projects/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=projects&feed=$matches[1]\";s:36:\"projects/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=projects&feed=$matches[1]\";s:28:\"projects/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=projects&paged=$matches[1]\";s:11:\"services/?$\";s:28:\"index.php?post_type=services\";s:41:\"services/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=services&feed=$matches[1]\";s:36:\"services/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=services&feed=$matches[1]\";s:28:\"services/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=services&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"e-landing-page/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"e-landing-page/([^/]+)/embed/?$\";s:47:\"index.php?e-landing-page=$matches[1]&embed=true\";s:35:\"e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:43:\"e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:50:\"e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:39:\"e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:31:\"e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"e-landing-page/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"work_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?taxonomy=work_category&term=$matches[1]&feed=$matches[2]\";s:49:\"work_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?taxonomy=work_category&term=$matches[1]&feed=$matches[2]\";s:30:\"work_category/([^/]+)/embed/?$\";s:60:\"index.php?taxonomy=work_category&term=$matches[1]&embed=true\";s:42:\"work_category/([^/]+)/page/?([0-9]{1,})/?$\";s:67:\"index.php?taxonomy=work_category&term=$matches[1]&paged=$matches[2]\";s:24:\"work_category/([^/]+)/?$\";s:49:\"index.php?taxonomy=work_category&term=$matches[1]\";s:36:\"projects/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"projects/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"projects/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"projects/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"projects/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"projects/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"projects/([^/]+)/embed/?$\";s:41:\"index.php?projects=$matches[1]&embed=true\";s:29:\"projects/([^/]+)/trackback/?$\";s:35:\"index.php?projects=$matches[1]&tb=1\";s:49:\"projects/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?projects=$matches[1]&feed=$matches[2]\";s:44:\"projects/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?projects=$matches[1]&feed=$matches[2]\";s:37:\"projects/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?projects=$matches[1]&paged=$matches[2]\";s:44:\"projects/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?projects=$matches[1]&cpage=$matches[2]\";s:33:\"projects/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?projects=$matches[1]&page=$matches[2]\";s:25:\"projects/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"projects/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"projects/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"projects/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"projects/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"projects/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"services/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"services/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"services/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"services/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"services/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"services/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"services/([^/]+)/embed/?$\";s:41:\"index.php?services=$matches[1]&embed=true\";s:29:\"services/([^/]+)/trackback/?$\";s:35:\"index.php?services=$matches[1]&tb=1\";s:49:\"services/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?services=$matches[1]&feed=$matches[2]\";s:44:\"services/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?services=$matches[1]&feed=$matches[2]\";s:37:\"services/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?services=$matches[1]&paged=$matches[2]\";s:44:\"services/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?services=$matches[1]&cpage=$matches[2]\";s:33:\"services/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?services=$matches[1]&page=$matches[2]\";s:25:\"services/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"services/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"services/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"services/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"services/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"services/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:23:\"index.php?sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=33&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:16:{i:0;s:35:\"abzarwp-license/abzarwp-license.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:31:\"elementor-pro/elementor-pro.php\";i:4;s:23:\"elementor/elementor.php\";i:5;s:37:\"flexy-breadcrumb/flexy-breadcrumb.php\";i:6;s:53:\"jet-engine-trim-callback/jet-engine-trim-callback.php\";i:7;s:25:\"jet-engine/jet-engine.php\";i:8;s:24:\"jet-plugin-pro/index.php\";i:9;s:39:\"jet-smart-filters/jet-smart-filters.php\";i:10;s:21:\"jet-tabs/jet-tabs.php\";i:11;s:19:\"jetpack/jetpack.php\";i:12;s:49:\"ultimate-dashboard-pro/ultimate-dashboard-pro.php\";i:13;s:41:\"ultimate-dashboard/ultimate-dashboard.php\";i:14;s:24:\"wordpress-seo/wp-seo.php\";i:15;s:29:\"wp-parsidate/wp-parsidate.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "https://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "hello-elementor", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "hello-elementor", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "60717", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:3:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:27:\"wp-optimize/wp-optimize.php\";a:2:{i:0;s:13:\"WPO_Uninstall\";i:1;s:7:\"actions\";}s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "35", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "33", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "4635", "on");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1767611273", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "55853", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:77:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;s:27:\"fluentform_dashboard_access\";b:1;s:24:\"fluentform_forms_manager\";b:1;s:25:\"fluentform_entries_viewer\";b:1;s:25:\"fluentform_manage_entries\";b:1;s:24:\"fluentform_view_payments\";b:1;s:26:\"fluentform_manage_payments\";b:1;s:27:\"fluentform_settings_manager\";b:1;s:22:\"fluentform_full_access\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("102", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("103", "user_count", "3", "off");
INSERT INTO `wp_options` VALUES("104", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("106", "cron", "a:15:{i:1766823143;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1766823250;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1766823258;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1766823260;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766824548;a:1:{s:27:\"wpseo_indexable_index_batch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:15:\"fifteen_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1766846819;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766848822;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766905923;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766905943;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766909652;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766964448;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1766996050;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1767004200;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1767243790;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("123", "theme_mods_twentytwentythree", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1696862746;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("124", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("125", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("155", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("166", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("189", "current_theme", "Hello Elementor", "yes");
INSERT INTO `wp_options` VALUES("190", "theme_mods_hello-elementor", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1752074543;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "on");
INSERT INTO `wp_options` VALUES("191", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("192", "hello_theme_version", "2.9.0", "yes");
INSERT INTO `wp_options` VALUES("199", "elementor_active_kit", "9", "yes");
INSERT INTO `wp_options` VALUES("200", "elementor_font_display", "swap", "yes");
INSERT INTO `wp_options` VALUES("203", "elementor_version", "3.18.1", "yes");
INSERT INTO `wp_options` VALUES("204", "elementor_install_history", "a:5:{s:6:\"3.16.5\";i:1696863030;s:6:\"3.17.2\";i:1699029088;s:6:\"3.17.3\";i:1699679203;s:6:\"3.18.0\";i:1701755707;s:6:\"3.18.1\";i:1701927099;}", "yes");
INSERT INTO `wp_options` VALUES("205", "elementor_events_db_version", "1.0.0", "no");
INSERT INTO `wp_options` VALUES("207", "elementor_onboarded", "1", "yes");
INSERT INTO `wp_options` VALUES("208", "_elementor_installed_time", "1696862919", "yes");
INSERT INTO `wp_options` VALUES("209", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wp_options` VALUES("210", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:79:\"Introducing Elementor 3.33: Variables Manager, Custom CSS, Blend Modes, & more!\";s:7:\"excerpt\";s:340:\"Elementor 3.33 builds on the foundation of Editor V4, continuing our mission to create a faster, more scalable, and more intuitive design experience for Web Creators. With the addition of the Variables Manager, element-level Custom CSS, Background Clipping, and Blend Modes, designers have more creative precision and consistency than ever.\";s:7:\"created\";i:1762944115;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:145:\"https://elementor.com/blog/elementor-333-v4-variables-manager-custom-css/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp_options` VALUES("215", "elementor_pro_version", "3.18.0", "yes");
INSERT INTO `wp_options` VALUES("216", "widget_elementor-library", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("217", "_elementor_pro_installed_time", "1696863030", "yes");
INSERT INTO `wp_options` VALUES("218", "elementor_submissions_db_version", "5", "yes");
INSERT INTO `wp_options` VALUES("219", "elementor_notes_db_version", "5", "yes");
INSERT INTO `wp_options` VALUES("221", "_elementor_pro_api_requests_lock", "a:1:{s:11:\"get_version\";i:1756198341;}", "yes");
INSERT INTO `wp_options` VALUES("224", "jet-license-data", "a:1:{s:12:\"license-list\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("229", "jet_is_modify_tm_license_data", "true", "yes");
INSERT INTO `wp_options` VALUES("240", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("241", "elementor_pro_theme_builder_conditions", "a:4:{s:7:\"archive\";a:5:{i:4040;a:1:{i:0;s:32:\"include/archive/services_archive\";}i:2200;a:1:{i:0;s:24:\"include/archive/category\";}i:748;a:1:{i:0;s:32:\"include/archive/projects_archive\";}i:726;a:1:{i:0;s:29:\"include/archive/work_category\";}i:399;a:1:{i:0;s:28:\"include/archive/post_archive\";}}s:6:\"single\";a:3:{i:1225;a:1:{i:0;s:25:\"include/singular/services\";}i:677;a:1:{i:0;s:25:\"include/singular/projects\";}i:255;a:1:{i:0;s:21:\"include/singular/post\";}}s:6:\"footer\";a:1:{i:635;a:1:{i:0;s:15:\"include/general\";}}s:6:\"header\";a:1:{i:76;a:1:{i:0;s:15:\"include/general\";}}}", "yes");
INSERT INTO `wp_options` VALUES("242", "wp_calendar_block_has_published_posts", "1", "yes");
INSERT INTO `wp_options` VALUES("268", "elementor_custom_icon_sets_config", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("310", "elementor_log", "a:43:{s:32:\"bf61f12f29f5a9b290a7c5b896c9693b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-11-11 08:36:43\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.17.2\";s:2:\"to\";s:6:\"3.17.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-11-11 08:36:43\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.17.2\";s:2:\"to\";s:6:\"3.17.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"46271042bb1a015924c0045f4051ad7d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-11-11 07:44:02\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:80:\"View (cid: &quot;view19347&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-11-11 07:44:02\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1699688642\";s:7:\"message\";s:70:\"View (cid: \"view19347\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"f99eb5ed417492ef28b6b3000203a316\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-11-11 09:34:27\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:61:\"Cannot read properties of undefined (reading &#039;get&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-11-11 09:34:27\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1699695267\";s:7:\"message\";s:51:\"Cannot read properties of undefined (reading \'get\')\";s:3:\"url\";s:82:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.17.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"694959\";}s:7:\"\0*\0file\";s:82:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.17.3\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"694959\";}s:32:\"1a48d9e9962fdab7a00bd435a4e1ad19\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2023-11-11 13:35:50\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:51:\"Trying to access array offset on value of type bool\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2023-11-11 13:35:50\";i:1;s:19:\"2023-12-05 17:58:31\";i:2;s:19:\"2023-12-05 17:58:54\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:51:\"Trying to access array offset on value of type bool\";s:4:\"file\";s:81:\"/home/tabanc/public_html/wp-content/plugins/elementor/includes/managers/image.php\";s:4:\"line\";i:113;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:81:\"/home/tabanc/public_html/wp-content/plugins/elementor/includes/managers/image.php\";s:7:\"\0*\0line\";i:113;}s:32:\"64d2c85b07f94a713a2a97eda8e3fdfa\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-11-11 13:41:37\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view5226&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-11-11 13:41:37\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1699710097\";s:7:\"message\";s:69:\"View (cid: \"view5226\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"318644ad61384ed24630f2949a97f211\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-11-11 13:42:21\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view6534&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2023-11-11 13:42:21\";i:1;s:19:\"2023-11-11 13:42:21\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1699710141\";s:7:\"message\";s:69:\"View (cid: \"view6534\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"576b09f853ce92bc12534580110dac20\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-11-11 13:42:21\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view8474&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2023-11-11 13:42:21\";i:1;s:19:\"2023-11-11 13:42:21\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1699710141\";s:7:\"message\";s:69:\"View (cid: \"view8474\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"0f3d6c80c4c9827dd66ce5e3717b56d2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-12-05 09:25:07\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 09:25:07\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"22bf885fb1dc648de84f596d61c577de\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-12-05 09:25:07\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 09:25:07\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"f6c74a0d31262aa988a4535c6acd0f7c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-12-05 09:25:07\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 09:25:07\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"689ec1cffb051bbbe9d4683bdbec373d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-12-05 09:25:07\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.17.3\";s:2:\"to\";s:6:\"3.18.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 09:25:07\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.17.3\";s:2:\"to\";s:6:\"3.18.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"6fa710efb0968d031ca5a8b3c5d848d4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-12-05 09:25:07\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.17.3\";s:2:\"to\";s:6:\"3.18.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 09:25:07\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.17.3\";s:2:\"to\";s:6:\"3.18.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"c64a57b995da78722bea4371d69538c7\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2023-12-05 09:37:27\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:24:\"Undefined index: options\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:11;s:14:\"\0*\0times_dates\";a:11:{i:0;s:19:\"2023-12-05 09:37:27\";i:1;s:19:\"2023-12-05 10:47:44\";i:2;s:19:\"2023-12-06 14:04:17\";i:3;s:19:\"2023-12-06 14:12:32\";i:4;s:19:\"2023-12-06 14:39:09\";i:5;s:19:\"2023-12-07 08:57:43\";i:6;s:19:\"2023-12-07 09:01:53\";i:7;s:19:\"2023-12-07 09:03:27\";i:8;s:19:\"2023-12-07 09:05:08\";i:9;s:19:\"2023-12-07 09:09:05\";i:10;s:19:\"2023-12-07 09:10:50\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:24:\"Undefined index: options\";s:4:\"file\";s:101:\"/home/tabanc/public_html/wp-content/plugins/elementor-pro/modules/theme-builder/widgets/site-logo.php\";s:4:\"line\";i:192;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:101:\"/home/tabanc/public_html/wp-content/plugins/elementor-pro/modules/theme-builder/widgets/site-logo.php\";s:7:\"\0*\0line\";i:192;}s:32:\"b065150505a32b0845abdc10b4365133\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-05 06:21:54\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view8750&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 06:21:54\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701757314\";s:7:\"message\";s:69:\"View (cid: \"view8750\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"f082290ba23afbd26b2c0102c251108c\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-05 06:21:54\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view8787&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 06:21:54\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701757314\";s:7:\"message\";s:69:\"View (cid: \"view8787\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"c64a85087a50626a2a1b3e455e3272f3\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-05 06:21:54\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view8824&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 06:21:54\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701757314\";s:7:\"message\";s:69:\"View (cid: \"view8824\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"9ec023e7f2186f826203458916729dd7\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-05 06:21:54\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view8861&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 06:21:54\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701757314\";s:7:\"message\";s:69:\"View (cid: \"view8861\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"7a70d209fc7d11efe48dba5d974b9246\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-05 06:21:54\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view8898&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 06:21:54\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701757314\";s:7:\"message\";s:69:\"View (cid: \"view8898\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"506eaa08e33bb43444883fa36e6d4868\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-05 07:41:52\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view6721&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 07:41:52\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701762112\";s:7:\"message\";s:69:\"View (cid: \"view6721\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"dbc14f84e99a230c34aca728d15d96e0\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-05 07:41:52\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view6757&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 07:41:52\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701762112\";s:7:\"message\";s:69:\"View (cid: \"view6757\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"6c4f42988f512d504c3f741f2f37767b\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-05 07:41:52\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view6793&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 07:41:52\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701762112\";s:7:\"message\";s:69:\"View (cid: \"view6793\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"9e04cd91bb38b1e9946e8996feb5afb9\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-05 07:41:52\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view6649&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 07:41:52\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701762112\";s:7:\"message\";s:69:\"View (cid: \"view6649\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"73454f0ffc23d9137f3df2194bf6092e\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-05 07:41:52\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view6685&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 07:41:52\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701762112\";s:7:\"message\";s:69:\"View (cid: \"view6685\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"1878ed1e14fcbea864ad2ac5efae01fb\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-05 07:41:52\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view6829&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 07:41:52\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701762112\";s:7:\"message\";s:69:\"View (cid: \"view6829\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"f3926008caad789235bd907e6c7a4743\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2023-12-05 11:47:46\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:31:\"Undefined index: editor_post_id\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2023-12-05 11:47:46\";i:1;s:19:\"2023-12-05 11:50:05\";i:2;s:19:\"2023-12-07 09:02:43\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:31:\"Undefined index: editor_post_id\";s:4:\"file\";s:110:\"/home/tabanc/public_html/wp-content/plugins/elementor-pro/modules/assets-manager/asset-types/fonts-manager.php\";s:4:\"line\";i:252;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:110:\"/home/tabanc/public_html/wp-content/plugins/elementor-pro/modules/assets-manager/asset-types/fonts-manager.php\";s:7:\"\0*\0line\";i:252;}s:32:\"fdd5cecfc87d5fe235b91d1f8aa3ddc0\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-05 08:21:26\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view3065&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 08:21:26\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701764486\";s:7:\"message\";s:69:\"View (cid: \"view3065\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"ba55a87010dc62ad806fb1b01e7f3d62\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-05 08:21:26\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view3102&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 08:21:26\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701764486\";s:7:\"message\";s:69:\"View (cid: \"view3102\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"7d913791f141a144bff66f8d437a50d7\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-05 08:21:26\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view3176&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 08:21:26\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701764486\";s:7:\"message\";s:69:\"View (cid: \"view3176\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"69871b37b527f72cc5b64c0cbeb92f90\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-05 08:21:26\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view3139&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-05 08:21:26\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701764486\";s:7:\"message\";s:69:\"View (cid: \"view3139\") has already been destroyed and cannot be used.\";s:3:\"url\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}s:7:\"\0*\0file\";s:107:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:9:\"\0*\0column\";s:5:\"19952\";}s:32:\"58fb37337126433428b9342b4ff6938d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-06 09:40:15\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:63:\"Cannot read properties of undefined (reading &#039;value&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:7;s:14:\"\0*\0times_dates\";a:7:{i:0;s:19:\"2023-12-06 09:40:15\";i:1;s:19:\"2025-04-21 09:11:04\";i:2;s:19:\"2025-04-21 11:05:11\";i:3;s:19:\"2025-04-29 17:17:22\";i:4;s:19:\"2025-04-30 06:10:56\";i:5;s:19:\"2025-07-13 07:55:14\";i:6;s:19:\"2025-07-26 08:44:09\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701855615\";s:7:\"message\";s:53:\"Cannot read properties of undefined (reading \'value\')\";s:3:\"url\";s:170:\"http://tabancrm.ir/wp-admin/load-scripts.php?c=1&amp;loadchunk_0=jquery-core,jquery-migrate,utils,wp-polyfill-inert,regenerator-runtime,wp-polyfill,wp-hooks&amp;ver=6.4.1\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"28760\";}s:7:\"\0*\0file\";s:170:\"http://tabancrm.ir/wp-admin/load-scripts.php?c=1&amp;loadchunk_0=jquery-core,jquery-migrate,utils,wp-polyfill-inert,regenerator-runtime,wp-polyfill,wp-hooks&amp;ver=6.4.1\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:5:\"28760\";}s:32:\"5f9b88d09bd213e1bcc8d6a58ff4c11d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-12-07 09:01:39\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-07 09:01:39\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"457b207e42632786de82e7d885381e0f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-12-07 09:01:39\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-07 09:01:39\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"1f9d4ac25f28d5a993906fe295bc9ccd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-12-07 09:01:39\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-07 09:01:39\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"848da4428109abaa19bcd636fe4257f6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-12-07 09:01:39\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.18.0\";s:2:\"to\";s:6:\"3.18.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-07 09:01:39\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.18.0\";s:2:\"to\";s:6:\"3.18.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"11ee74c373d122a0c57aa9e26c8c0f25\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-12-07 09:01:39\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.18.0\";s:2:\"to\";s:6:\"3.18.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-07 09:01:39\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.18.0\";s:2:\"to\";s:6:\"3.18.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"115165f4f4b9531b642c0f7376083100\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-12-07 11:04:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-07 11:04:10\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"b490c46f957be6b729ac2fdbcbcb5e7a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-12-07 11:04:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:56:\"المنتور پرو/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-07 11:04:10\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:56:\"المنتور پرو/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"87a50df43514cbf13f343828ec33226b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-12-07 11:04:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:58:\"المنتور پرو/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-07 11:04:10\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:58:\"المنتور پرو/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"857fd85e5ae3ff05315a4f5477b08db6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-12-07 11:04:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.17.1\";s:2:\"to\";s:6:\"3.18.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-07 11:04:10\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.17.1\";s:2:\"to\";s:6:\"3.18.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"b391ec7644a10b4dcb3dc2c4858dfab0\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-04-21 12:03:59\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:17:\"l[0] is undefined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:8;s:14:\"\0*\0times_dates\";a:8:{i:0;s:19:\"2025-04-21 12:03:59\";i:1;s:19:\"2025-04-21 12:04:16\";i:2;s:19:\"2025-04-21 12:04:53\";i:3;s:19:\"2025-04-21 12:05:04\";i:4;s:19:\"2025-04-21 12:23:23\";i:5;s:19:\"2025-04-21 12:33:18\";i:6;s:19:\"2025-04-21 12:34:45\";i:7;s:19:\"2025-04-21 12:35:47\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1745237039\";s:7:\"message\";s:17:\"l[0] is undefined\";s:3:\"url\";s:81:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/js/admin.min.js?ver=3.18.1\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:5:\"47920\";}s:7:\"\0*\0file\";s:81:\"http://tabancrm.ir/wp-content/plugins/elementor/assets/js/admin.min.js?ver=3.18.1\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:5:\"47920\";}s:32:\"77ebb8a4099da27c004c61ea0ecaf8e0\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-07-17 10:21:50\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:62:\"Cannot read properties of undefined (reading &#039;view&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-07-17 10:21:50\";i:1;s:19:\"2025-07-17 10:21:53\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1752747710\";s:7:\"message\";s:52:\"Cannot read properties of undefined (reading \'view\')\";s:3:\"url\";s:83:\"https://tabancrm.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.18.1\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"957709\";}s:7:\"\0*\0file\";s:83:\"https://tabancrm.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.18.1\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"957709\";}s:32:\"7eba2ec85cd008299e3ea5c46e82492f\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-07-17 10:53:55\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:67:\"Cannot read properties of undefined (reading &#039;localized&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-07-17 10:53:55\";i:1;s:19:\"2025-07-17 10:53:56\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1752749635\";s:7:\"message\";s:57:\"Cannot read properties of undefined (reading \'localized\')\";s:3:\"url\";s:83:\"https://tabancrm.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.18.1\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"806906\";}s:7:\"\0*\0file\";s:83:\"https://tabancrm.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.18.1\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"806906\";}s:32:\"02e08dcc4b7d7756d623c31e522e77b9\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-11-24 02:22:59\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:75:\"trim(): Passing null to parameter #1 ($string) of type string is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-24 02:22:59\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:75:\"trim(): Passing null to parameter #1 ($string) of type string is deprecated\";s:4:\"file\";s:87:\"/home/tabanc/public_html/wp-content/plugins/elementor-pro/modules/custom-css/module.php\";s:4:\"line\";i:96;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:87:\"/home/tabanc/public_html/wp-content/plugins/elementor-pro/modules/custom-css/module.php\";s:7:\"\0*\0line\";i:96;}}", "off");
INSERT INTO `wp_options` VALUES("315", "elementor_library_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("346", "elementor_clear_cache", "", "yes");
INSERT INTO `wp_options` VALUES("347", "elementor_reset_api_data", "", "yes");
INSERT INTO `wp_options` VALUES("349", "elementor_enable_inspector", "", "yes");
INSERT INTO `wp_options` VALUES("350", "elementor_replace_url", "", "yes");
INSERT INTO `wp_options` VALUES("351", "elementor_rollback", "", "yes");
INSERT INTO `wp_options` VALUES("352", "elementor_rollback_pro_separator", "", "yes");
INSERT INTO `wp_options` VALUES("353", "elementor_rollback_pro", "", "yes");
INSERT INTO `wp_options` VALUES("354", "elementor_beta", "no", "yes");
INSERT INTO `wp_options` VALUES("355", "elementor_maintenance_mode_mode", "", "yes");
INSERT INTO `wp_options` VALUES("356", "elementor_maintenance_mode_exclude_mode", "logged_in", "yes");
INSERT INTO `wp_options` VALUES("357", "elementor_maintenance_mode_exclude_roles", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("358", "elementor_maintenance_mode_template_id", "", "yes");
INSERT INTO `wp_options` VALUES("376", "_elementor_settings_update_time", "1698597890", "yes");
INSERT INTO `wp_options` VALUES("377", "elementor_cpt_support", "a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}", "yes");
INSERT INTO `wp_options` VALUES("378", "elementor_disable_color_schemes", "", "yes");
INSERT INTO `wp_options` VALUES("379", "elementor_disable_typography_schemes", "", "yes");
INSERT INTO `wp_options` VALUES("380", "elementor_google_maps_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("381", "elementor_pro_recaptcha_site_key", "", "yes");
INSERT INTO `wp_options` VALUES("382", "elementor_pro_recaptcha_secret_key", "", "yes");
INSERT INTO `wp_options` VALUES("383", "elementor_pro_recaptcha_v3_site_key", "", "yes");
INSERT INTO `wp_options` VALUES("384", "elementor_pro_recaptcha_v3_secret_key", "", "yes");
INSERT INTO `wp_options` VALUES("385", "elementor_pro_recaptcha_v3_threshold", "0.5", "yes");
INSERT INTO `wp_options` VALUES("386", "elementor_pro_facebook_app_id", "", "yes");
INSERT INTO `wp_options` VALUES("387", "elementor_pro_mailchimp_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("388", "elementor_validate_api_data", "", "yes");
INSERT INTO `wp_options` VALUES("389", "elementor_pro_drip_api_token", "", "yes");
INSERT INTO `wp_options` VALUES("390", "elementor_pro_activecampaign_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("391", "elementor_pro_activecampaign_api_url", "", "yes");
INSERT INTO `wp_options` VALUES("392", "elementor_pro_getresponse_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("393", "elementor_pro_convertkit_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("394", "elementor_pro_mailerlite_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("395", "elementor_typekit-kit-id", "", "yes");
INSERT INTO `wp_options` VALUES("397", "elementor_pro_stripe_test_secret_key", "", "yes");
INSERT INTO `wp_options` VALUES("398", "elementor_validate_stripe_api_test_secret_key_button", "", "yes");
INSERT INTO `wp_options` VALUES("399", "elementor_pro_stripe_live_secret_key", "", "yes");
INSERT INTO `wp_options` VALUES("400", "elementor_validate_stripe_api_live_secret_key_button", "", "yes");
INSERT INTO `wp_options` VALUES("401", "elementor_stripe_legal_disclaimer", "", "yes");
INSERT INTO `wp_options` VALUES("402", "elementor_css_print_method", "external", "yes");
INSERT INTO `wp_options` VALUES("403", "elementor_editor_break_lines", "", "yes");
INSERT INTO `wp_options` VALUES("404", "elementor_unfiltered_files_upload", "1", "yes");
INSERT INTO `wp_options` VALUES("405", "elementor_google_font", "1", "yes");
INSERT INTO `wp_options` VALUES("406", "elementor_load_fa4_shim", "", "yes");
INSERT INTO `wp_options` VALUES("407", "elementor_meta_generator_tag", "", "yes");
INSERT INTO `wp_options` VALUES("408", "elementor_experiment-e_font_icon_svg", "default", "yes");
INSERT INTO `wp_options` VALUES("409", "elementor_experiment-container", "default", "yes");
INSERT INTO `wp_options` VALUES("410", "elementor_experiment-container_grid", "default", "yes");
INSERT INTO `wp_options` VALUES("411", "elementor_experiment-editor_v2", "default", "yes");
INSERT INTO `wp_options` VALUES("412", "elementor_experiment-landing-pages", "default", "yes");
INSERT INTO `wp_options` VALUES("413", "elementor_experiment-nested-elements", "default", "yes");
INSERT INTO `wp_options` VALUES("414", "elementor_experiment-e_lazyload", "default", "yes");
INSERT INTO `wp_options` VALUES("415", "elementor_experiment-e_global_styleguide", "default", "yes");
INSERT INTO `wp_options` VALUES("416", "elementor_experiment-mega-menu", "default", "yes");
INSERT INTO `wp_options` VALUES("417", "elementor_experiment-loop", "default", "yes");
INSERT INTO `wp_options` VALUES("418", "elementor_experiment-taxonomy-filter", "default", "yes");
INSERT INTO `wp_options` VALUES("419", "elementor_experiment-e_dom_optimization", "default", "yes");
INSERT INTO `wp_options` VALUES("420", "elementor_experiment-e_optimized_assets_loading", "default", "yes");
INSERT INTO `wp_options` VALUES("421", "elementor_experiment-e_optimized_css_loading", "default", "yes");
INSERT INTO `wp_options` VALUES("422", "elementor_experiment-additional_custom_breakpoints", "inactive", "yes");
INSERT INTO `wp_options` VALUES("423", "elementor_experiment-e_swiper_latest", "default", "yes");
INSERT INTO `wp_options` VALUES("424", "elementor_experiment-theme_builder_v2", "default", "yes");
INSERT INTO `wp_options` VALUES("425", "elementor_experiment-hello-theme-header-footer", "default", "yes");
INSERT INTO `wp_options` VALUES("426", "elementor_experiment-page-transitions", "default", "yes");
INSERT INTO `wp_options` VALUES("427", "elementor_experiment-notes", "default", "yes");
INSERT INTO `wp_options` VALUES("428", "elementor_experiment-form-submissions", "default", "yes");
INSERT INTO `wp_options` VALUES("429", "elementor_experiment-e_scroll_snap", "default", "yes");
INSERT INTO `wp_options` VALUES("479", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:21:\"fanaei.amin@gmail.com\";s:7:\"version\";s:3:\"6.9\";s:9:\"timestamp\";i:1764805017;}", "off");
INSERT INTO `wp_options` VALUES("498", "action_scheduler_hybrid_store_demarkation", "256", "yes");
INSERT INTO `wp_options` VALUES("499", "schema-ActionScheduler_StoreSchema", "7.0.1745228840", "yes");
INSERT INTO `wp_options` VALUES("500", "schema-ActionScheduler_LoggerSchema", "3.0.1697212836", "yes");
INSERT INTO `wp_options` VALUES("504", "action_scheduler_lock_async-request-runner", "1745945295", "yes");
INSERT INTO `wp_options` VALUES("830", "wpp_settings", "a:14:{s:12:\"persian_date\";s:6:\"enable\";s:10:\"conv_title\";s:7:\"disable\";s:13:\"conv_contents\";s:7:\"disable\";s:12:\"conv_excerpt\";s:7:\"disable\";s:13:\"conv_comments\";s:7:\"disable\";s:18:\"conv_comment_count\";s:7:\"disable\";s:10:\"conv_dates\";s:7:\"disable\";s:9:\"conv_cats\";s:7:\"disable\";s:11:\"conv_arabic\";s:7:\"disable\";s:15:\"conv_permalinks\";s:7:\"disable\";s:11:\"news_source\";s:5:\"parsi\";s:12:\"enable_fonts\";s:6:\"enable\";s:8:\"dev_mode\";s:6:\"enable\";s:12:\"submenu_move\";s:6:\"enable\";}", "yes");
INSERT INTO `wp_options` VALUES("831", "widget_parsidate_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("832", "widget_parsidate_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("853", "fbc_settings_options", "a:13:{s:21:\"breadcrumb_front_text\";s:17:\"صفحه اصلی\";s:20:\"breadcrumb_front_url\";s:18:\"http://tabancrm.ir\";s:20:\"breadcrumb_home_icon\";s:0:\"\";s:20:\"breadcrumb_separator\";s:1:\"/\";s:22:\"breadcrumb_limit_style\";s:4:\"word\";s:21:\"breadcrumb_text_limit\";s:1:\"4\";s:19:\"breadcrumb_end_text\";s:3:\"...\";s:14:\"post_hierarchy\";s:13:\"post-category\";s:21:\"breadcrumb_text_color\";s:7:\"#27272a\";s:21:\"breadcrumb_link_color\";s:7:\"#013087\";s:25:\"breadcrumb_separate_color\";s:7:\"#cccccc\";s:27:\"breadcrumb_background_color\";s:19:\"rgba(237,239,240,0)\";s:20:\"breadcrumb_font_size\";s:2:\"14\";}", "yes");
INSERT INTO `wp_options` VALUES("2145", "jet_engine_modules", "a:2:{i:0;s:14:\"gallery-slider\";i:1;s:20:\"custom-content-types\";}", "yes");
INSERT INTO `wp_options` VALUES("2387", "jet_engine_meta_boxes", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4811", "elementor_font_awesome_pro_kit_id", "", "yes");
INSERT INTO `wp_options` VALUES("5334", "jet_smart_filters_version", "3.2.0", "no");
INSERT INTO `wp_options` VALUES("6242", "elementor_pro_install_history", "a:4:{s:6:\"3.15.1\";i:1699098649;s:6:\"3.17.1\";i:1701934449;s:6:\"3.17.2\";i:1699098650;s:6:\"3.18.1\";i:1701934450;}", "yes");
INSERT INTO `wp_options` VALUES("6310", "elementor_fonts_manager_font_types", "a:1:{s:14:\"YekanBakhFaNum\";s:6:\"custom\";}", "yes");
INSERT INTO `wp_options` VALUES("6311", "elementor_fonts_manager_fonts", "a:1:{s:14:\"YekanBakhFaNum\";a:2:{s:9:\"font_face\";s:1868:\"@font-face {\n	font-family: \'YekanBakhFaNum\';\n	font-style: normal;\n	font-weight: 400;\n	font-display: auto;\n	src: url(\'http://tabancrm.ir/wp-content/uploads/2023/10/YekanBakhFaNum-Light.woff2\') format(\'woff2\'),\n		url(\'http://tabancrm.ir/wp-content/uploads/2023/10/YekanBakhFaNum-Light.woff\') format(\'woff\');\n}\n@font-face {\n	font-family: \'YekanBakhFaNum\';\n	font-style: normal;\n	font-weight: 500;\n	font-display: auto;\n	src: url(\'http://tabancrm.ir/wp-content/uploads/2023/10/YekanBakhFaNum-Regular.woff2\') format(\'woff2\'),\n		url(\'http://tabancrm.ir/wp-content/uploads/2023/10/YekanBakhFaNum-Regular.woff\') format(\'woff\');\n}\n@font-face {\n	font-family: \'YekanBakhFaNum\';\n	font-style: normal;\n	font-weight: 600;\n	font-display: auto;\n	src: url(\'http://tabancrm.ir/wp-content/uploads/2023/10/YekanBakhFaNum-Bold.woff2\') format(\'woff2\'),\n		url(\'http://tabancrm.ir/wp-content/uploads/2023/10/YekanBakhFaNum-Bold.woff\') format(\'woff\');\n}\n@font-face {\n	font-family: \'YekanBakhFaNum\';\n	font-style: normal;\n	font-weight: 700;\n	font-display: auto;\n	src: url(\'http://tabancrm.ir/wp-content/uploads/2023/10/YekanBakhFaNum-ExtraBold.woff2\') format(\'woff2\'),\n		url(\'http://tabancrm.ir/wp-content/uploads/2023/10/YekanBakhFaNum-ExtraBold.woff\') format(\'woff\');\n}\n@font-face {\n	font-family: \'YekanBakhFaNum\';\n	font-style: normal;\n	font-weight: 800;\n	font-display: auto;\n	src: url(\'http://tabancrm.ir/wp-content/uploads/2023/10/YekanBakhFaNum-Black.woff2\') format(\'woff2\'),\n		url(\'http://tabancrm.ir/wp-content/uploads/2023/10/YekanBakhFaNum-Black.woff\') format(\'woff\');\n}\n@font-face {\n	font-family: \'YekanBakhFaNum\';\n	font-style: normal;\n	font-weight: 900;\n	font-display: auto;\n	src: url(\'http://tabancrm.ir/wp-content/uploads/2023/10/YekanBakhFaNum-ExtraBlack.woff2\') format(\'woff2\'),\n		url(\'http://tabancrm.ir/wp-content/uploads/2023/10/YekanBakhFaNum-ExtraBlack.woff\') format(\'woff\');\n}\n\";s:7:\"post_id\";i:1297;}}", "yes");
INSERT INTO `wp_options` VALUES("6468", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("6469", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("7074", "jet-tabs-db-version", "2.1.21", "yes");
INSERT INTO `wp_options` VALUES("7177", "new_admin_email", "fanaei.amin@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7188", "duplicator_version_plugin", "1.5.7.1", "yes");
INSERT INTO `wp_options` VALUES("7191", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `wp_options` VALUES("7192", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `wp_options` VALUES("7193", "duplicator_settings", "a:20:{s:7:\"version\";s:7:\"1.5.7.1\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:3;s:14:\"usage_tracking\";b:0;i:0;b:0;}", "yes");
INSERT INTO `wp_options` VALUES("7196", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-27 07:37:24\";s:7:\"Version\";s:7:\"1.5.7.1\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:7:\"10.6.18\";s:10:\"VersionPHP\";s:6:\"8.1.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20231206_d8b3d8a7db8cd8aad8a2d985d8a7d8\";s:4:\"Hash\";s:35:\"e512e32b0f772ce63160_20251227073724\";s:8:\"NameHash\";s:75:\"20231206_d8b3d8a7db8cd8aad8a2d985d8a7d8_e512e32b0f772ce63160_20251227073724\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20231206_d8b3d8a7db8cd8aad8a2d985d8a7d8_e512e32b0f772ce63160_20251227073724_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:24:\"/home/tabanc/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3134;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:14767;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-27 07:37:24\";s:7:\"Version\";s:7:\"1.5.7.1\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:7:\"10.6.18\";s:10:\"VersionPHP\";s:6:\"8.1.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20231206_d8b3d8a7db8cd8aad8a2d985d8a7d8\";s:4:\"Hash\";s:35:\"e512e32b0f772ce63160_20251227073724\";s:8:\"NameHash\";s:75:\"20231206_d8b3d8a7db8cd8aad8a2d985d8a7d8_e512e32b0f772ce63160_20251227073724\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:38:\"/home/tabanc/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:33:\"/home/tabanc/public_html/wp-admin\";i:1;s:36:\"/home/tabanc/public_html/wp-includes\";i:2;s:45:\"/home/tabanc/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:24:\"/home/tabanc/public_html\";i:1;s:24:\"/home/tabanc/public_html\";i:2;s:35:\"/home/tabanc/public_html/wp-content\";i:3;s:43:\"/home/tabanc/public_html/wp-content/uploads\";i:4;s:43:\"/home/tabanc/public_html/wp-content/plugins\";i:5;s:46:\"/home/tabanc/public_html/wp-content/mu-plugins\";i:6;s:42:\"/home/tabanc/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:56:\"/home/tabanc/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "yes");
INSERT INTO `wp_options` VALUES("7294", "elementor_pro_remote_info_api_data_3.18.0", "a:2:{s:7:\"timeout\";i:1756254145;s:5:\"value\";s:246210:\"{\"stable_version\":\"3.31.2\",\"last_updated\":\"2025-08-10 09:31:59\",\"sections\":\"a:2:{s:11:\\\"description\\\";s:161:\\\"Elementor Pro adds new features to the Elementor Page Builder plugin. Control your conversions, your user engagement, your entire website, from one page builder.\\\";s:9:\\\"changelog\\\";s:229935:\\\"<h2>Elementor Pro - by Elementor.com<\\/h2>\\n<h4>3.31.2 - 2025-08-10<\\/h4>\\n<ul>\\n<li>Tweak: Improved release version functionality<\\/li>\\n<\\/ul>\\n<h4>3.31.0 - 2025-08-05<\\/h4>\\n<ul>\\n<li>New: Introducing Attributes - add custom HTML attributes to elements for advanced control - Editor V4<\\/li>\\n<li>Tweak: Optimized Custom Code styles by removing redundant RTL file<\\/li>\\n<li>Tweak: Improved performance by loading ribbon styles only when used in Call to Action and Price Table widgets<\\/li>\\n<li>Tweak: Improved semantic markup structure for header and footer documents<\\/li>\\n<li>Tweak: Reorganized design controls in Animated Headline widget<\\/li>\\n<li>Tweak: Reorganized design controls in Blockquote widget<\\/li>\\n<li>Tweak: Reorganized design controls in Countdown widget<\\/li>\\n<li>Tweak: Replaced SASS mixins and functions with native CSS logical properties<\\/li>\\n<li>Fix: Empty headers are rendered in Table of Contents widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28167\\\">#28167<\\/a>)<\\/li>\\n<li>Fix: <code>TypeError<\\/code> bug in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.30.1 - 2025-07-22<\\/h4>\\n<ul>\\n<li>Security Fix: Improved content sanitization in multiple widgets<\\/li>\\n<li>Fix: UI issue in Hotspot widget when Optimized Markup experiment is enabled<\\/li>\\n<li>Fix: Taxonomy filter not working in the Editor when Optimized Markup experiment is enabled<\\/li>\\n<\\/ul>\\n<h4>3.30.0 - 2025-07-01<\\/h4>\\n<ul>\\n<li>New: Introduced Full Website Templates in the Cloud - export, manage, and reuse full site kits across all your websites from one place<\\/li>\\n<li>Tweak: Activated &quot;Optimized Markup&quot; feature on new sites<\\/li>\\n<li>Tweak: Activated &quot;Menu&quot; feature on new sites<\\/li>\\n<li>Tweak: Improved error handling for Theme Builder display conditions<\\/li>\\n<li>Tweak: Added styling controls to Post Excerpt widget<\\/li>\\n<li>Tweak: Improved accessibility with <code>role<\\/code> and <code>aria-label<\\/code> attributes Post Navigation widget<\\/li>\\n<li>Tweak: Added <code>aria-label<\\/code> in Form widget<\\/li>\\n<li>Tweak: Added <code>aria-label<\\/code> in Login widget<\\/li>\\n<li>Tweak: Arranged content as lists in Portfolio and Posts widgets<\\/li>\\n<li>Tweak: Added Box Shadow and Text Shadow controls in Countdown widget<\\/li>\\n<li>Tweak: Moved image resolution control to content tab in Price List widget<\\/li>\\n<li>Tweak: Renamed and reorganized style sections in Price List widget<\\/li>\\n<li>Tweak: Added conditional logic to controls in Price Table widget<\\/li>\\n<li>Tweak: Grouped layout controls under list section in Price List widget<\\/li>\\n<li>Tweak: Updated minimum required WordPress version to 6.6<\\/li>\\n<li>Fix: Inline font icons support doesn\'t work in Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24367\\\">#24367<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18343\\\">#18343<\\/a>)<\\/li>\\n<li>Fix: Page Title condition doesn\'t work on child pages in Widget Display Conditions<\\/li>\\n<li>Fix: Editor users with &quot;Access to edit content only&quot; are able to delete elements<\\/li>\\n<li>Fix: Links are not crawlable in Video Playlist widget<\\/li>\\n<li>Fix: Uses hardcoded admin fonts in Video Playlist widget<\\/li>\\n<li>Fix: Editor freezes when the Form widget is used with a high PHP upload size limit<\\/li>\\n<li>Fix: Errors occur when Debug mode is enabled in Slides widget<\\/li>\\n<li>Fix: Plugin dependency not enforced in Elementor Pro<\\/li>\\n<li>Fix: Console shows deprecation warning in Global Widgets<\\/li>\\n<\\/ul>\\n<h4>3.29.2 - 2025-06-04<\\/h4>\\n<ul>\\n<li>Tweak: Added selectors to Menu widget for compatibility with Optimized Markup experiment<\\/li>\\n<\\/ul>\\n<h4>3.29.1 - 2025-05-28<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Animated Headline widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Price Table widget<\\/li>\\n<\\/ul>\\n<h4>3.29.0 - 2025-05-19<\\/h4>\\n<ul>\\n<li>New: Introduced Cloud Templates - save, manage, and reuse your templates across all your sites from a single cloud library<\\/li>\\n<li>Tweak: Improved accessibility with <code>role<\\/code> attributes in Share Buttons widget<\\/li>\\n<li>Tweak: Improved accessibility by grouping content with <code>role=region<\\/code> in the Video Playlist widget<\\/li>\\n<li>Fix: Focus color is not applied correctly for accessibility in WordPress Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24239\\\">#24239<\\/a>)<\\/li>\\n<li>Fix: Common scripts loaded late when using the Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.28.4 - 2025-05-05<\\/h4>\\n<ul>\\n<li>Fix: Empty results appeared on the frontend when using the Taxonomy Filter with the \'Avoid Duplicates\' option in Loop Grid widget<\\/li>\\n<li>Fix: Errors occur when Debug mode is enabled and the Optimized Markup experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.28.3 - 2025-04-16<\\/h4>\\n<ul>\\n<li>Tweak: Improved sidebar navigation flow on the Elementor Home screen<\\/li>\\n<\\/ul>\\n<h4>3.28.2 - 2025-03-30<\\/h4>\\n<ul>\\n<li>Fix: Default Elementor animation shown for logged-out users when using an &quot;External URL&quot; source in Lottie widget<\\/li>\\n<\\/ul>\\n<h4>3.28.1 - 2025-03-23<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Animated Headline and Form widgets<\\/li>\\n<\\/ul>\\n<h4>3.28.0 - 2025-03-17<\\/h4>\\n<ul>\\n<li>Tweak: Ensured File Upload field styles are overridden by global styles in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11651\\\">#11651<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17223\\\">#17223<\\/a>)<\\/li>\\n<li>Tweak: Updated Scroll Snap description to clarify incompatibility with animations and motion effects<\\/li>\\n<li>Tweak: Prevented special characters from being encoded in the email subject field in Form widget<\\/li>\\n<li>Tweak: Loaded module styles within the module instead of registering them in <code>plugin.php<\\/code><\\/li>\\n<li>Tweak: Updated minimum required WordPress version to 6.5<\\/li>\\n<li>Tweak: Improved keyboard accessibility for menus in Editor Top Bar<\\/li>\\n<li>Tweak: Made the edit button accessible in the Template widget<\\/li>\\n<li>Tweak: Optimized Form widget performance by caching field assets <code>using get_style_depends()<\\/code> and <code>get_script_depends()<\\/code> methods<\\/li>\\n<li>Tweak: Added Text Shadow control in Testimonial Carousel, Call to Action and Animated Headline widgets<\\/li>\\n<li>Fix: Button icon alignment breaks when Inline Font Icons feature is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16077\\\">#16077<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16511\\\">#16511<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17692\\\">#17692<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17922\\\">#17922<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19253\\\">#19253<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19370\\\">#19370<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21236\\\">#21236<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21844\\\">#21844<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28080\\\">#28080<\\/a>)<\\/li>\\n<li>Fix: Dropdown caret color did not follow menu item color when Inline Font Icons feature is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17500\\\">#17500<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18466\\\">#18466<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21664\\\">#21664<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24929\\\">#24929<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28064\\\">#28064<\\/a>)<\\/li>\\n<li>Fix: Page doesn\'t scroll up when a coupon error notice appears in Checkout widget<\\/li>\\n<\\/ul>\\n<h4>3.27.7 - 2025-03-13<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Lottie widget<\\/li>\\n<\\/ul>\\n<h4>3.27.6 - 2025-03-10<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Template Condition<\\/li>\\n<\\/ul>\\n<h4>3.27.5 - 2025-03-03<\\/h4>\\n<ul>\\n<li>Fix: The <code>wp_trigger_error<\\/code> function causes the site to crash instead of triggering a warning when used with ACF text<\\/li>\\n<\\/ul>\\n<h4>3.27.4 - 2025-02-16<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Screenshots module<\\/li>\\n<li>Security Fix: Improved code security enforcement in Query control<\\/li>\\n<li>Fix: ACF <code>true_false<\\/code> field causing a fatal error when used as a dynamic tag with third-party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/30170\\\">#30170<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.27.3 - 2025-02-06<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Stripe Button widget<\\/li>\\n<\\/ul>\\n<h4>3.27.2 - 2025-02-03<\\/h4>\\n<ul>\\n<li>Fix: Value type configuration issue causing errors when using ACF<\\/li>\\n<li>Fix: Hide content on responsive breakpoint option is not working on WordPress Menu widget when Optimized Markup experiment is activated<\\/li>\\n<\\/ul>\\n<h4>3.27.1 - 2025-01-27<\\/h4>\\n<ul>\\n<li>Tweak: Increased the number of items allowed in Dynamic Tags options in Display Conditions for Elements<\\/li>\\n<li>Security Fix: Improved code security enforcement in Global widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Lottie widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Admin settings<\\/li>\\n<li>Fix: Accessible navigation in popups caused unintended scrolling of the page when triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29175\\\">#29175<\\/a>)<\\/li>\\n<li>Fix: Empty custom fields are missing in the Dynamic Tags options in Display Conditions for Elements<\\/li>\\n<\\/ul>\\n<h4>3.27.0 - 2025-01-20<\\/h4>\\n<ul>\\n<li>Tweak: Removed the <code>elementor-widget-container<\\/code> div from the Menu, Loop, Table of Contents, Form, and Hotspot widgets as part of the Optimized Markup experiment to improve HTML structure<\\/li>\\n<li>Tweak: Reduced DOM size by optimizing the submit button markup in Search widget<\\/li>\\n<li>Tweak: Moved style loading to the head instead of the footer to improve CLS<\\/li>\\n<li>Tweak: Enabled conditional loading of Swiper.js based on widget dependencies to reduce unnecessary assets and improve page load times<\\/li>\\n<li>Tweak: Standardized navigation elements like arrows and bullets across all carousel and slider widgets for improved accessibility<\\/li>\\n<li>Tweak: Improved accessibility when the submit button has only an icon and no text in Search widget<\\/li>\\n<li>Tweak: Removed <code>load_plugin_textdomain()<\\/code> function from Elementor Pro<\\/li>\\n<\\/ul>\\n<h4>3.26.3 - 2025-01-07<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Search widget<\\/li>\\n<li>Fix: Height issues cause slideshow thumbnails to display incorrectly in Media Carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29663\\\">#29663<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.26.2 - 2024-12-22<\\/h4>\\n<ul>\\n<li>Fix: Menu items are not clickable in various scenarios in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29191\\\">#29191<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.26.1 - 2024-12-17<\\/h4>\\n<ul>\\n<li>Fix: Restore deprecated <code>Plugin::enqueue_styles()<\\/code> function to avoid errors with 3rd party plugins<\\/li>\\n<\\/ul>\\n<h4>3.26.0 - 2024-12-16<\\/h4>\\n<ul>\\n<li>New: Introducing dynamic content support for Off-canvas in Loop Grid widget templates - enabling seamless display of additional content dynamically (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29049\\\">#29049<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28935\\\">#28935<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7106\\\">#7106<\\/a>)<\\/li>\\n<li>New: AdBlock Detection trigger for Popups - display targeted popups for visitors using ad blockers<\\/li>\\n<li>New: Added Reload Page link action for Dynamic Tags<\\/li>\\n<li>Tweak: Added &quot;Space Between Dots&quot; control to Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2526\\\">#2526<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3277\\\">#3277<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21697\\\">#21697<\\/a>)<\\/li>\\n<li>Tweak: Replaced hidden <code>elementor-screen-only<\\/code> div with <code>aria-label<\\/code> attributes<\\/li>\\n<li>Tweak: Removed <code>elementor-widget-container<\\/code> div from Elementor widgets as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Optimize popup styling by loading it only when necessary<\\/li>\\n<li>Tweak: Updated Gap between slides control to support only PX units in Carousel widget<\\/li>\\n<li>Tweak: Removed the dependency between the Tabs handler and the Menu handler<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> in Carousel widgets<\\/li>\\n<li>Tweak: Added <code>aria-roledescription=carousel<\\/code> to carousel wrapper<\\/li>\\n<li>Tweak: Added <code>aria-roledescription=slide<\\/code> to slide wrapper<\\/li>\\n<li>Tweak: Optimized carousel widgets markup as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n<li>Tweak: Facebook widgets are no longer supported on mobile due to Facebook functionality changes<\\/li>\\n<li>Fix: Motion Effects sticky feature is not working when Scroll Snap is enabled<\\/li>\\n<li>Fix: Custom Image Resolution option is not working in Gallery widget<\\/li>\\n<li>Fix: \'Reading Settings\' unexpectedly reduces the number of posts displayed when using the Archive with Pagination setting<\\/li>\\n<li>Fix: Step Form does not scroll to the top when the first field is not an input field in Form widget<\\/li>\\n<li>Fix: Display Condition feature is available without an active Elementor license in Floating Elements<\\/li>\\n<li>Fix: Background options of Flip Box in Loop Grid widget are not working when images are added using ACF Dynamic Tags<\\/li>\\n<li>Fix: Dropdown icon in the Select field of the Form widget is cut off when the Inline Font Icons feature is activated<\\/li>\\n<li>Fix: Incompatibility between Form widget and WPML when using Nested Elements<\\/li>\\n<li>Fix: Performance issues when changing the title name in the Menu widget<\\/li>\\n<li>Fix: Warnings appear when Element Caching is set to Inactive in Carousel widgets<\\/li>\\n<li>Fix: Swiper styling missing from Lightbox inside Gallery widgets<\\/li>\\n<\\/ul>\\n<h4>3.25.5 - 2024-12-10<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Form widget<\\/li>\\n<li>Fix: Accessible navigation in popups caused unintended scrolling of the page when triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29175\\\">#29175<\\/a>)<\\/li>\\n<li>Fix: Popup overlay shown for non-logged users even when disabled<\\/li>\\n<\\/ul>\\n<h4>3.25.4 - 2024-11-20<\\/h4>\\n<ul>\\n<li>Tweak: Improved Global Widget loading method to enhance performance<\\/li>\\n<\\/ul>\\n<h4>3.25.3 - 2024-11-13<\\/h4>\\n<ul>\\n<li>Fix: Nested Elements are activated even when the Container experiment is inactive<\\/li>\\n<\\/ul>\\n<h4>3.25.2 - 2024-11-03<\\/h4>\\n<ul>\\n<li>Fix: Styling issues affecting popup layout when using a Dynamic Tag to open the popup<\\/li>\\n<li>Fix: Image captions are not displaying for non-logged-in users in Media Carousel widget<\\/li>\\n<li>Fix: Custom Add to Cart widget with Quantity enabled causes critical error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29159\\\">#29159<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.25.1 - 2024-10-31<\\/h4>\\n<ul>\\n<li>Fix: Multiple Custom Add to Cart widgets on the same page are adding the same product<\\/li>\\n<\\/ul>\\n<h4>3.25.0 - 2024-10-28<\\/h4>\\n<ul>\\n<li>Tweak: Added pagination functionality to the Live Results in Search widget<\\/li>\\n<li>Tweak: Added Anchor Offset control to allow precise positioning when scrolling to anchor links on the page<\\/li>\\n<li>Tweak: Load motion effects styles only when they are in use<\\/li>\\n<li>Tweak: Load sticky styles only when they are in use<\\/li>\\n<li>Tweak: Load popup styles only when they are in use<\\/li>\\n<li>Tweak: Load theme builder styles only when they are in use<\\/li>\\n<li>Tweak: Load transition styles for Call to Action and Gallery widgets only when they are in use<\\/li>\\n<li>Tweak: Load styles for Form widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for WooCommerce widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Theme Elements widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Carousel widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Pricing widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Floating Elements separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Link in Bio widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load minified CSS in the Loop Builder\'s Call to Action button in the Editor<\\/li>\\n<li>Tweak: Removed &quot;Payments&quot; module styles<\\/li>\\n<li>Tweak: Removed <code>elementor-button-wrapper<\\/code> div from Payapl widget as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Removed <code>elementor-button-wrapper<\\/code> div from Stripe widget as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Merged &quot;Form Submissions&quot; feature into the version and moved it to the Advanced tab<\\/li>\\n<li>Tweak: Merged &quot;Display Conditions&quot; into the version<\\/li>\\n<li>Fix: Missing translation string for the empty message in the Table of Contents widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27580\\\">#27580<\\/a>)<\\/li>\\n<li>Fix: Local Storage and Session Storage were being used even when popups were not in use (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7151\\\">#7151<\\/a>)<\\/li>\\n<li>Fix: Masonry layout is not working when pagination is set to &quot;Load More&quot; or &quot;Infinite Scroll&quot; in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23684\\\">#23684<\\/a>)<\\/li>\\n<li>Fix: Extra gap between widgets on the frontend when using Off-canvas widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27706\\\">#27706<\\/a>)<\\/li>\\n<li>Fix: Pagination and custom queries did not work when the Posts Widget was saved as a Global Widget or used via shortcode<\\/li>\\n<li>Fix: Lightbox videos are missing controls and displayed at the wrong size in Media Carousel widget<\\/li>\\n<li>Fix: Pagination options with Individual Pagination not working as expected in Posts and Loop Grid widgets<\\/li>\\n<li>Fix: Justified or Masonry layouts for the Pro Gallery would not display images on the frontend when inserted via nested tabs<\\/li>\\n<li>Fix: Error issue in the Loop Grid widget when used in theme parts with the Taxonomy Filter<\\/li>\\n<li>Fix: Removed the focus ring after clicking to open the Off Canvas inside the Editor<\\/li>\\n<li>Fix: Background gradient colors from the dynamic color tag values are not rendering on the frontend<\\/li>\\n<li>Fix: Excessive database requests generated by the Loop Grid widget<\\/li>\\n<li>Fix: Colors from Dynamic Tags were not rendered on the frontend<\\/li>\\n<li>Fix: Display issue in the Menu widget caused by the \'Native Intersection Observer API<\\/li>\\n<li>Fix: Dropdown area not working in certain scenarios in Menu widget<\\/li>\\n<li>Fix: Content Width control inside the Mega Menu is displaying an empty value<\\/li>\\n<\\/ul>\\n<h4>3.24.4 - 2024-10-09<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Media Carousel widget<\\/li>\\n<\\/ul>\\n<h4>3.24.3 - 2024-10-01<\\/h4>\\n<ul>\\n<li>Fix: Floating Elements template not loading when Single Page template is set with All Singular condition<\\/li>\\n<li>Fix: Form field styles not loading properly in various scenarios<\\/li>\\n<\\/ul>\\n<h4>3.24.2 - 2024-09-18<\\/h4>\\n<ul>\\n<li>Fix: Icons not displaying when Inline SVG Icons experiment is active in Link In Bio widgets and Floating Elements<\\/li>\\n<\\/ul>\\n<h4>3.24.1 - 2024-09-12<\\/h4>\\n<ul>\\n<li>Fix: Widget styles not loading correctly on front causing alignment inconsistencies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28676\\\">#28676<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.24.0 - 2024-09-10<\\/h4>\\n<ul>\\n<li>New: Introducing support for Variable Fonts - allowing for more dynamic and flexible text styling (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6703\\\">#6703<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11333\\\">#11333<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19277\\\">#19277<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25485\\\">#25485<\\/a>)<\\/li>\\n<li>Tweak: Added \'Structure\' indication for widgets with Display Conditions applied (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28027\\\">#28027<\\/a>)<\\/li>\\n<li>Tweak: Added a new option for setting the live search results width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28280\\\">#28280<\\/a>)<\\/li>\\n<li>Tweak: Improved Honeypot field functionality in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28480\\\">#28480<\\/a>)<\\/li>\\n<li>Tweak: Added options to \'Copy\', \'Paste\', and \'Clear\' Display Conditions in Context Menu<\\/li>\\n<li>Tweak: Improved performance of the Menu widget when using Dynamic Tags in the URL field<\\/li>\\n<li>Tweak: Improved performance when using Dynamic Tags in Nested Elements<\\/li>\\n<li>Tweak: Added the option for users to disable Akismet for specific Elementor forms<\\/li>\\n<li>Tweak: Adjusted URL structure when presenting the Search Archive page in Search widget<\\/li>\\n<li>Tweak: Added the \'Create Template\' button in Search widget<\\/li>\\n<li>Tweak: Added an option to enable the \'Loader\' animation while live results are loading in Search widget<\\/li>\\n<li>Tweak: Load share buttons compatibility styles only when they are in use<\\/li>\\n<li>Tweak: Load dialog styles only when they are in use<\\/li>\\n<li>Tweak: Load global widget styles only during Editor preview<\\/li>\\n<li>Tweak: Conditionally load widget styles only when the widgets are used<\\/li>\\n<li>Tweak: Load styles for CTA hover animations only when they are in use<\\/li>\\n<li>Tweak: Load notes styles only when the WordPress Toolbar is displayed<\\/li>\\n<li>Tweak: Split <code>animations.min.css<\\/code> into multiple CSS files and load them conditionally<\\/li>\\n<li>Tweak: Promoted Display Conditions feature to Stable status<\\/li>\\n<li>Tweak: Merged Taxonomy Filter feature into the version<\\/li>\\n<li>Tweak: Merged Search feature into the version<\\/li>\\n<li>Tweak: Added a note to \'Current Query\' explaining the impact of WordPress settings on pagination within Archives<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> for the Off-Canvas widget<\\/li>\\n<li>Fix: Manual Selection option is not excluding sticky posts in Posts and Loop Grid widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18689\\\">#18689<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23331\\\">#23331<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28179\\\">#28179<\\/a>)<\\/li>\\n<li>Fix: Template ID does not change according to the imported Loop Item (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21404\\\">#21404<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22202\\\">#22202<\\/a>)<\\/li>\\n<li>Fix: \'Editing Mode\' for the Off-canvas was not functioning correctly in certain scenarios<\\/li>\\n<li>Fix: Added definition to <code>clear_custom_image_sizes<\\/code> hook to prevent edge case issues<\\/li>\\n<li>Fix: Flickering issue with search result buttons when closing results using the keyboard escape key in Search widget<\\/li>\\n<li>Fix: Theme Style settings for buttons were overriding the text styling in Search widget<\\/li>\\n<li>Fix: Nesting menu inside another menu causes functionality issues in Menu widget<\\/li>\\n<li>Fix: Error when using array as custom fields value in Dynamic Tags<\\/li>\\n<\\/ul>\\n<h4>3.23.3 - 2024-08-05<\\/h4>\\n<ul>\\n<li>Fix: Dropdown area not working in certain scenarios in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28194\\\">#28194<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.23.2 - 2024-07-29<\\/h4>\\n<ul>\\n<li>Fix: Horizontal scroll bar appearing on the page when using Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28087\\\">#28087<\\/a>)<\\/li>\\n<li>Fix: Dropdown area disappearing in certain scenarios in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.23.1 - 2024-07-23<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in link URL<\\/li>\\n<\\/ul>\\n<h4>3.23.0 - 2024-07-15<\\/h4>\\n<ul>\\n<li>New: Search Widget with Live Results - Display live search results as visitors type into the search box, enhancing user experience and engagement (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27664\\\">#27664<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24931\\\">#24931<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21459\\\">#21459<\\/a>)<\\/li>\\n<li>Tweak: Renamed <code>width<\\/code> to <code>Min width<\\/code> and added <code>Max width<\\/code> control to Hotspot tooltips (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18930\\\">#18930<\\/a>)<\\/li>\\n<li>Tweak: Applied a logical DOM order to the Mega Menu widget to improve accessibility<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> for WordPress Menu widget<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> for Menu widget<\\/li>\\n<li>Tweak: Added a bottom option to the Image Position control in Call to Action widget<\\/li>\\n<li>Fix: Missing version string in included CSS query string when Improved CSS Loading is enabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21879\\\">#21879<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23821\\\">#23821<\\/a>)<\\/li>\\n<li>Fix: Form submission icon message does not display correctly when Inline Font Icons feature is activated<\\/li>\\n<li>Fix: Save and Close button position issues in the conditions screen in Theme Builder.<\\/li>\\n<li>Fix: Focus appears on the first element when using the mouse to open Off-Canvas <\\/li>\\n<li>Fix: Links to Elementor Settings are broken in various locations<\\/li>\\n<li>Fix: Conditions field not showing all relevant conditions in Theme Builder<\\/li>\\n<li>Fix: Off-Canvas flickering in sticky containers with exit animations triggered by sticky effects<\\/li>\\n<\\/ul>\\n<h4>3.22.1 - 2024-06-24<\\/h4>\\n<ul>\\n<li>Fix: Styling of Global widgets not loading when Element Caching experiment is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27704\\\">#27704<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.22.0 - 2024-06-16<\\/h4>\\n<ul>\\n<li>New: Introducing Off-Canvas widget - create engaging and creative layers triggered by a link (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6225\\\">#6225<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21769\\\">#21769<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25770\\\">#25770<\\/a>)<\\/li>\\n<li>Tweak: Added option to remove \'User IP\' and \'User Agent\' from the form submissions metadata (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14285\\\">#14285<\\/a>)<\\/li>\\n<li>Tweak: Replaced <code>waypoints.js<\\/code> library with the native Intersection Observer API<\\/li>\\n<li>Tweak: Extended Alignment and Position capabilities in Form widget<\\/li>\\n<li>Tweak: Moved icon View control to style tab in Flip Box widget<\\/li>\\n<li>Tweak: Moved icon View control to style tab in Call to Action widget<\\/li>\\n<li>Tweak: Optimized Form widget to eliminate unnecessary markup when the button icon is empty<\\/li>\\n<li>Tweak: Optimized Posts widget to eliminate unnecessary markup when Load More button text is empty<\\/li>\\n<li>Tweak: Remove <code>placeholder<\\/code> arguments from URL controls<\\/li>\\n<li>Tweak: Implemented CSS logical properties to Icon Position in Form, Posts and Menu Cart widgets<\\/li>\\n<li>Tweak: Activated Display Conditions feature for existing sites<\\/li>\\n<li>Tweak: Activated Taxonomy Filter feature for existing sites<\\/li>\\n<li>Tweak: Added functionality to delay the running of the ready triggers on inner elements<\\/li>\\n<li>Fix: Icons are now part of the link in the Menu Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24298\\\">#24298<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25112\\\">#25112<\\/a>)<\\/li>\\n<li>Fix: <code>all: unset<\\/code> assigned to buttons cause focus issues (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24322\\\">#24322<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25448\\\">#25448<\\/a>)<\\/li>\\n<li>Fix: Menu cart SVG icon disappears on front when Optimized Control Loading experiment is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27342\\\">#27342<\\/a>)<\\/li>\\n<li>Fix: Elementor Pro auto-updates are not working on multisite networks (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12615\\\">#12615<\\/a>)<\\/li>\\n<li>Fix: PHP error appears in the editor when using Loop Grid in an archive template<\\/li>\\n<li>Fix: UI glitch on Icon Position control in Paypal and Stripe Buttons widgets<\\/li>\\n<li>Fix: Icon Position control RTL issue in Hotspot widget<\\/li>\\n<li>Fix: Manual Selection &quot;Include By&quot; Query doesn\'t work with product categories<\\/li>\\n<\\/ul>\\n<h4>3.21.3 - 2024-05-20<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Loop Grid widget<\\/li>\\n<li>Fix: License expired affects the Display Conditions functionality in the front end<\\/li>\\n<\\/ul>\\n<h4>3.21.2 - 2024-04-30<\\/h4>\\n<ul>\\n<li>Fix: Special characters are not displayed correctly when using the Excerpt widget in Loop template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25860\\\">#25860<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.21.1 - 2024-04-24<\\/h4>\\n<ul>\\n<li>Fix: Excerpt Length setting doesn\'t function correctly for languages with non-English characters in Post Excerpt widget<\\/li>\\n<\\/ul>\\n<h4>3.21.0 - 2024-04-15<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Taxonomy Query - Enabling the display of post and product categories and tags within Loop Grid and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21372\\\">#21372<\\/a>)<\\/li>\\n<li>Tweak: Optimized Hotspot widget to prevent rendering when no image is provided<\\/li>\\n<li>Tweak: Optimized Blockquote widget to eliminate unnecessary markup when devoid of content<\\/li>\\n<li>Tweak: Optimized Template widget to eliminate unnecessary markup when no template is selected<\\/li>\\n<li>Tweak: Optimized Code Highlight widget to eliminate unnecessary markup when there is no content<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Elementor<\\/li>\\n<li>Tweak: Implemented accessibility improvements in Portfolio widget<\\/li>\\n<li>Tweak: Implemented accessibility improvements of Author Avatar image alt text in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25440\\\">#25440<\\/a>)<\\/li>\\n<li>Tweak: Notes feature merged to version<\\/li>\\n<li>Tweak: Implemented accessibility improvements of Profile Picture alt text in Author widget<\\/li>\\n<li>Fix: Display issue on hover state in WooCommerce Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.20.3 - 2024-04-10<\\/h4>\\n<ul>\\n<li>Fix: Compatibility issue between the My Account widget and other third-party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20986\\\">#20986<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.20.2 - 2024-03-26<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Media Carousel widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Form widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Post Navigation widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Gallery widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Video Playlist widget<\\/li>\\n<\\/ul>\\n<h4>3.20.1 - 2024-03-20<\\/h4>\\n<ul>\\n<li>Fix: Strengthened code integrity in deprecated Woo Single Element widget<\\/li>\\n<li>Fix: PHP error notice appears when using Loop Grid with the Taxonomy Filter widgets<\\/li>\\n<\\/ul>\\n<h4>3.20.0 - 2024-03-11<\\/h4>\\n<ul>\\n<li>Tweak: Implemented OR logic in the Display Conditions feature<\\/li>\\n<li>Tweak: Added X and Threads social networks to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25299\\\">#25299<\\/a>)<\\/li>\\n<li>Tweak: Added Archive Title dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image Title dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image Alt dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image Caption dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Author Bio dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Author Email dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Author Website dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Page Title rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Post Title rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Comments Number rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Archive Author rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added support for WordPress Custom Fields in Display Conditions feature<\\/li>\\n<li>Tweak: Implemented accessibility improvements in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23875\\\">#23875<\\/a>)<\\/li>\\n<li>Tweak: Implemented accessibility improvements in Login widget<\\/li>\\n<li>Tweak: Added additional style controls in the Table of Contents widget<\\/li>\\n<li>Tweak: Added Transition Duration option in Blockquote widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21295\\\">#21295<\\/a>)<\\/li>\\n<li>Tweak: Added Transition Duration to button in Flip Box widget<\\/li>\\n<li>Tweak: Added Transition Duration to button in Author Box widget<\\/li>\\n<li>Tweak: Added Transition Duration to List in Table of Contents widget<\\/li>\\n<li>Tweak: Added Transition Duration to button in Login widget<\\/li>\\n<li>Tweak: Added Transition Duration in Post Navigation widget<\\/li>\\n<li>Tweak: Added Transition Duration Show More in Video Playlist widget<\\/li>\\n<li>Tweak: Added Transition Duration to button in Form widget<\\/li>\\n<li>Tweak: Removed separator-none argument from all Editor controls<\\/li>\\n<li>Tweak: Add <code>&lt;time&gt;<\\/code> wrapper for Date and Time items in Post Info widget<\\/li>\\n<li>Tweak: Page Transitions feature merged to version<\\/li>\\n<li>Tweak: Scroll Snap feature merged to version<\\/li>\\n<li>Tweak: Promoted Display Conditions feature to Beta status and activated for new sites<\\/li>\\n<li>Tweak: Promoted Taxonomy Filter feature to beta status and activated for new sites<\\/li>\\n<li>Fix: Page Transitions feature and Load Font Awesome 4 Support cause a console error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18885\\\">#18885<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19334\\\">#19334<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21082\\\">#21082<\\/a>)<\\/li>\\n<li>Fix: Added better output escaping in Taxonomy Filter widget<\\/li>\\n<\\/ul>\\n<h4>3.19.3 - 2024-02-26<\\/h4>\\n<ul>\\n<li>Tweak: Improved Loop CSS loading structure in Loop Grid item<\\/li>\\n<li>Security Fix: Addressed security weaknesses in Dynamic Tags<\\/li>\\n<\\/ul>\\n<h4>3.19.2 - 2024-02-07<\\/h4>\\n<ul>\\n<li>Fix: Export data inconsistencies when using form actions in Form widget<\\/li>\\n<\\/ul>\\n<h4>3.19.1 - 2024-02-05<\\/h4>\\n<ul>\\n<li>Fix: Enqueuing non-existing Loop Template CSS file in Loop Item template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24959\\\">#24959<\\/a>)<\\/li>\\n<li>Fix: Improved code security enforcement in Countdown widget<\\/li>\\n<\\/ul>\\n<h4>3.19.0 - 2024-01-29<\\/h4>\\n<ul>\\n<li>New: Introducing Display Conditions for Elements - allowing users to customize content visibility based on specified criteria (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4246\\\">#4246<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21152\\\">#21152<\\/a>)<\\/li>\\n<li>New: Implemented Akismet Integration for enhanced spam protection and security in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11401\\\">#11401<\\/a>)<\\/li>\\n<li>New: Introducing Permissions functionality to Element Manager - providing users with enhanced control over access and management capabilities<\\/li>\\n<li>Tweak: Added styling option for dropdown indicator in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21907\\\">#21907<\\/a>)<\\/li>\\n<li>Tweak: Added additional size units and custom units in all elements<\\/li>\\n<li>Tweak: Implemented CSS logical properties in WordPress Menu widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Reviews widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Countdown widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Elementor Editor<\\/li>\\n<li>Tweak: Updated <code>jquery.smartmenus.js<\\/code> version from 1.1.1 to 1.2.0<\\/li>\\n<li>Fix: Dynamic Background Image does not load on the first Loop Item in a Loop Grid (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21489\\\">#21489<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22368\\\">#22368<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23085\\\">#23085<\\/a>)<\\/li>\\n<li>Fix: History panel deprecation notices in console log<\\/li>\\n<li>Fix: Second Pro rollback installed the latest version instead of the specifically selected older version<\\/li>\\n<li>Fix: Incorrect position of the dropdown content when applying entrance animation in Menu Widget<\\/li>\\n<li>Fix: UX issues when using in-place editing in Menu widget<\\/li>\\n<li>Fix: Pagination with page reload is not working when used with the Taxonomy filter and Loop Grid widget in Archive template<\\/li>\\n<\\/ul>\\n<h4>3.18.2 - 2023-12-20<\\/h4>\\n<ul>\\n<li>Fix: Modified controls sanitization to enforce better security policies in Price List widget<\\/li>\\n<li>Fix: Error messages related to loop filter appear on front when using PHP 8.X and <code>WP_DEBUG<\\/code> is true<\\/li>\\n<\\/ul>\\n<h4>3.18.1 - 2023-12-06<\\/h4>\\n<ul>\\n<li>Fix: No results appeared when reloading the page with deep link and de-selecting terms in Taxonomy Filter widget<\\/li>\\n<li>Fix: No results appeared when filtering the Uncategorized category in Filter Taxonomy widget<\\/li>\\n<li>Fix: Notes still available when the Notes feature is deactivated<\\/li>\\n<\\/ul>\\n<h4>3.18.0 - 2023-12-04<\\/h4>\\n<ul>\\n<li>Tweak: Added the ability to upload files as attachments to emails in the File Upload field in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4868\\\">#4868<\\/a>)<\\/li>\\n<li>Tweak: Introduced the capability to design and edit the empty state in the Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24261\\\">#24261<\\/a>)<\\/li>\\n<li>Tweak: Implemented the option to close the menu content area with a click anywhere on the screen in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22686\\\">#22686<\\/a>)<\\/li>\\n<li>Tweak: Improve scrolling behavior inside the content area when there is not enough space in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22712\\\">#22712<\\/a>)<\\/li>\\n<li>Tweak: Expanded breakpoint options in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22488\\\">#22488<\\/a>)<\\/li>\\n<li>Tweak: Added Logical Combination control in Taxonomy Filter widget<\\/li>\\n<li>Tweak: Added additional units to Horizontal and Vertical padding for Dropdown in WordPress Menu widget<\\/li>\\n<li>Tweak: Hide navigation arrows when there is only one slide in Loop Carousel and Carousel widgets<\\/li>\\n<li>Tweak: Added various HTML Tag controls in Video Playlist widget<\\/li>\\n<li>Tweak: Added responsive control to navigation size in Slides, Reviews, Media Carousel and Testimonial Carousel widgets<\\/li>\\n<li>Tweak: Added semantic <code>&lt;search&gt;<\\/code> wrapper in Search Form widget<\\/li>\\n<li>Tweak: Added semantic <code>&lt;search&gt;<\\/code> wrapper in Taxonomy Filter widget<\\/li>\\n<li>Tweak: Added Multiple Selection control in Taxonomy Filter widget<\\/li>\\n<li>Fix: Deprecated notice when using ${var} in strings instead of {$var} with PHP 8.2 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23927\\\">#23927<\\/a>)<\\/li>\\n<li>Fix: Dropdown indicator position issue in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23947\\\">#23947<\\/a>)<\\/li>\\n<li>Fix: Dynamic Tags are not available when choosing \'self-hosted\' source in Video widget<\\/li>\\n<li>Fix: Telephone field placeholder is aligned to the left in RTL websites in Form widget<\\/li>\\n<\\/ul>\\n<h4>3.17.1 - 2023-11-01<\\/h4>\\n<ul>\\n<li>Fix: Modified controls sanitization to enforce better security policies in Code Highlight, Form, Lottie, Price List, and Video Playlist widgets<\\/li>\\n<\\/ul>\\n<h4>3.17.0 - 2023-10-25<\\/h4>\\n<ul>\\n<li>Tweak: Added AJAX pagination option or seamless page navigation between content in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1284\\\">#1284<\\/a>)<\\/li>\\n<li>Tweak: Introduced Individual Pagination option when multiple Post widgets are on the same page, providing enhanced control over pagination<\\/li>\\n<li>Tweak: Introduced Individual Pagination option when multiple Loop Grid widgets are on the same page, providing enhanced control over pagination<\\/li>\\n<li>Tweak: Added a None option to the breakpoint options in Menu widget<\\/li>\\n<li>Tweak: Added a horizontal scrolling option in Menu widget<\\/li>\\n<li>Tweak: Upgraded minimum required PHP version to 7.3<\\/li>\\n<li>Tweak: Improved accessibility when minimize button is disabled in Table of Content widget<\\/li>\\n<li>Fix: Table of Content widget without icons displays <code>undefined<\\/code> error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17523\\\">#17523<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17768\\\">#17768<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18463\\\">#18463<\\/a>)<\\/li>\\n<li>Fix: Hover behavior issues on menu items in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23430\\\">#23430<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22431\\\">#22431<\\/a>)<\\/li>\\n<li>Fix: Links inside Loop Carousel are not working on initial load in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23705\\\">#23705<\\/a>)<\\/li>\\n<li>Fix: Popups accessible navigation adds outlines to the wrong first focusable element<\\/li>\\n<li>Fix: Dropdown area aligned to the left side of the screen if contains Tabs widget in Menu widget<\\/li>\\n<li>Fix: Content horizontal position not aligning correctly when used with carousel widgets in Menu widget<\\/li>\\n<li>Fix: Accessibility errors in PageSpeed Insights in Table of Contents widget<\\/li>\\n<\\/ul>\\n<h4>3.16.2 - 2023-09-20<\\/h4>\\n<ul>\\n<li>Fix: Fit to Content dropdown position calculation is incorrect in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23808\\\">#23808<\\/a>)<\\/li>\\n<li>Fix: Reverted hide navigation arrows when there is only one slide in the Loop or Nested carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23804\\\">#23804<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.16.1 - 2023-09-14<\\/h4>\\n<ul>\\n<li>Fix: Dynamic tag for ACF image field is not working as expected (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23757\\\">#23757<\\/a>)<\\/li>\\n<li>Fix: Sticky functionality affects padding values in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23758\\\">#23758<\\/a>)<\\/li>\\n<li>Fix: HTML list issues for padding and margin in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.16.0 - 2023-09-12<\\/h4>\\n<ul>\\n<li>Tweak: Implemented accessibility improvements in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23607\\\">#23607<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22554\\\">#22554<\\/a>)<\\/li>\\n<li>Fix: \'Fallback: Recent Posts\' option malfunctions in the Query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21436\\\">#21436<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23259\\\">#23259<\\/a>)<\\/li>\\n<li>Tweak: Hide navigation arrows when there is only one slide in the Loop or Nested carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22056\\\">#22056<\\/a>)<\\/li>\\n<li>Tweak: Used appropriate image <code>alt<\\/code> in Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17680\\\">#17680<\\/a>)<\\/li>\\n<li>Tweak: Optimized Scroll Snap functionality when using Container widget<\\/li>\\n<li>Tweak: Enhanced Elementor Role Manager functionality when using Containers<\\/li>\\n<li>Tweak: Added Notes feature to the Editor Top Bar<\\/li>\\n<li>Tweak: Replace CSS <code>float<\\/code> with other layouts in the Editor<\\/li>\\n<li>Tweak: Upgraded HTML Structure for the Menu widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Carousel and Menu widgets<\\/li>\\n<li>Tweak: Added keyboard accessibility to a link in Posts widget<\\/li>\\n<li>Tweak: Loop Builder feature merged to version<\\/li>\\n<li>Fix: Addressed inconsistency in hover effect durations between icon, dropdown indicator colors, and text colors in the Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22376\\\">#22376<\\/a>)<\\/li>\\n<li>Fix: Slides break if the parent container is set to HTML A tag in Loop Carousel and Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22678\\\">#22678<\\/a>)<\\/li>\\n<li>Fix: The icon size setting is not affecting uploaded SVG icons in the Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22372\\\">#22372<\\/a>)<\\/li>\\n<li>Fix: Taxonomy filter does not work with slug in foreign characters (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23315\\\">#23315<\\/a>)<\\/li>\\n<li>Fix: Improved code security enforcement in Dynamic Tags<\\/li>\\n<li>Fix: Sticky container incorrectly adjusts its width when transitioning from a smaller breakpoint to a larger one within the Editor<\\/li>\\n<\\/ul>\\n<h4>3.15.1 - 2023-08-09<\\/h4>\\n<ul>\\n<li>Fix: Improved code security enforcement in Table of Contents widget<\\/li>\\n<\\/ul>\\n<h4>3.15.0 - 2023-07-31<\\/h4>\\n<ul>\\n<li>New: Introducing Taxonomy Filter widget - Empower visitors to seamlessly filter listings in Loop Grids based on taxonomies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3140\\\">#3140<\\/a>)<\\/li>\\n<li>Tweak: Added an &quot;Offset Sides&quot; functionality in Carousel and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21114\\\">#21114<\\/a>)<\\/li>\\n<li>Tweak: Modified the size of the Publish button in the Editor Top Bar feature (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22472\\\">#22472<\\/a>)<\\/li>\\n<li>Tweak: Improved Ajax permissions functionality for better security enforcement<\\/li>\\n<li>Tweak: Added option for pagination custom position in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added option for navigation custom position in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added additional styling options for navigation in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added labels to shortcode column in WordPress admin<\\/li>\\n<li>Tweak: Unified the appearance of <code>stretch<\\/code> and <code>center<\\/code> buttons in Menu widget<\\/li>\\n<li>Tweak: Unified the appearance of <code>stretch<\\/code> and <code>center<\\/code> buttons in My Account widget<\\/li>\\n<li>Tweak: Improved panel UI in Video Playlist widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Elementor Editor<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Price List widget<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Slides widget<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Flip Box widget<\\/li>\\n<li>Tweak: Added &quot;Description HTML Tag&quot; in Call To Action widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Share Buttons widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Form widget<\\/li>\\n<li>Fix: WooCommerce Status page failed to recognize Elementor WooCommerce widgets<\\/li>\\n<li>Fix: Pagination does not work inside single templates when using Posts and Loop Grid widgets<\\/li>\\n<li>Fix: Incorrect saving of WooCommerce page settings in Elementor site settings under certain scenarios<\\/li>\\n<\\/ul>\\n<h4>3.14.1 - 2023-06-26<\\/h4>\\n<ul>\\n<li>Tweak: Improved navigation on touch devices in Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22827\\\">#22827<\\/a>)<\\/li>\\n<li>Fix: Missing navigation arrows on lightbox in Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22870\\\">#22870<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.14.0 - 2023-06-19<\\/h4>\\n<ul>\\n<li>New: Introducing Carousel widget - Infinite design possibilities, and nesting capabilities (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2587\\\">#2587<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/219\\\">#219<\\/a>)<\\/li>\\n<li>Tweak: Added Static Item Position functionality to Alternate template in Loop Grid widget<\\/li>\\n<li>Tweak: Added visual indication of Page Parts<\\/li>\\n<li>Tweak: Added dividers option between menu items in Menu widget<\\/li>\\n<li>Tweak: Changed the HTML structure of Pagination and Navigation in Loop Carousel and Nested Carousel widgets<\\/li>\\n<li>Tweak: Added shop page in WooCommerce Pages section in Site Settings<\\/li>\\n<li>Tweak: Added Text Shadow, Box Shadow and Padding control to button in Call to Action widget<\\/li>\\n<li>Tweak: Added Lazy Load support for images in Video Playlist widget<\\/li>\\n<li>Tweak: Added <code>alt<\\/code> attribute to images in Video Playlist widget<\\/li>\\n<li>Tweak: Replaced select control with choose control for Flip Direction control in Flip Box widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Use <code>media_types<\\/code> array in Media controls<\\/li>\\n<li>Fix: Lightbox is still enabled after disabling it in the Site Settings in Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11193\\\">#11193<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19871\\\">#19871<\\/a>)<\\/li>\\n<li>Fix: Responsive settings for templates don\'t work as expected when Additional Custom Breakpoints feature is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16819\\\">#16819<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19394\\\">#19394<\\/a>)<\\/li>\\n<li>Fix: Inner containers are not presented as expected in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21813\\\">#21813<\\/a>)<\\/li>\\n<li>Fix: Popup width does not support percentages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22413\\\">#22413<\\/a>)<\\/li>\\n<li>Fix: PHP 8.x throws errors when using WooCommerce Ajax response (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22199\\\">#22199<\\/a>)<\\/li>\\n<li>Fix: Mini cart template appears as empty in various scenarios in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22789\\\">#22789<\\/a>)<\\/li>\\n<li>Fix: Order by Price doesn\'t work for the Latest products or Manual Selection in Products widget<\\/li>\\n<li>Fix: Dropdown indicator icon is not vertically aligned to the text when using icon in Menu Widget<\\/li>\\n<li>Fix: Mixed content warning in the console for Video Playlist widget<\\/li>\\n<li>Fix: Preview settings are not presented as expected after first save in Loop Template<\\/li>\\n<li>Fix: Not-crawlable link error in Video Playlist widget<\\/li>\\n<li>Fix: Lightbox is still enabled after disabling it in the Site Settings in Logo widget<\\/li>\\n<li>Fix: Focus state issue on page load when using Table of Content widget<\\/li>\\n<\\/ul>\\n<h4>3.13.2 - 2023-05-22<\\/h4>\\n<ul>\\n<li>Fix: Hover settings not working as expected on Touch-Enabled devices in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22258\\\">#22258<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.13.1 - 2023-05-11<\\/h4>\\n<ul>\\n<li>Security Fix: Addressed security weaknesses in access management related functions<\\/li>\\n<li>Fix: Excerpt content pulled from post content is showing with HTML tags in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22367\\\">#22367<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.13.0 - 2023-05-08<\\/h4>\\n<ul>\\n<li>Tweak: Provided an option to assign excerpt automatically from post content in Post Excerpt dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20256\\\">#20256<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21715\\\">#21715<\\/a>)<\\/li>\\n<li>Tweak: Added Display Conditions functionality in Editor Top bar (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21675\\\">#21675<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22050\\\">#22050<\\/a>)<\\/li>\\n<li>Tweak: Removed <code>elementor_page_id<\\/code> from request URLs in the WC AJAX calls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18675\\\">#18675<\\/a>)<\\/li>\\n<li>Tweak: Added icons to menu items in Mega Menu widget (<a href=\\\"https:\\/\\/github.com\\/orgs\\/elementor\\/discussions\\/21602\\\">#21602<\\/a>)<\\/li>\\n<li>Tweak: Added keyboard accessibility to Toggle Button in WordPress Menu widget (<a href=\\\"https:\\/\\/github.com\\/orgs\\/elementor\\/discussions\\/2348\\\">#2348<\\/a>)<\\/li>\\n<li>Tweak: Added \'Active item state\' to top-level menu items for anchor links in the Menu widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Loop Carousel widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Slides widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Media, Testimonial and Reviews Carousel widgets<\\/li>\\n<li>Tweak: Added keyboard accessibility to Table of Content widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to Search Form widget<\\/li>\\n<li>Tweak: Added accessibility to images in Slides widget<\\/li>\\n<li>Tweak: Added accessibility to images in Call To Action widget<\\/li>\\n<li>Tweak: Added accessibility to images in Media Carousel widget<\\/li>\\n<li>Tweak: Added accessibility to images in Gallery widget<\\/li>\\n<li>Tweak: Added Lazy Load support for avatar image in Post Info widget<\\/li>\\n<li>Tweak: Added Lazy Load support to various Elementor Editor and Admin images<\\/li>\\n<li>Tweak: Added Lazy Load support for author image in Author Box widget<\\/li>\\n<li>Tweak: Added Lazy Load support for images in Price List widget<\\/li>\\n<li>Fix: Content width is affected by the widget\'s width when Content Width is set to Fit to Content in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21842\\\">#21842<\\/a>)<\\/li>\\n<li>Fix: Empty value on Rows field causes an error in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21451\\\">#21451<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.12.2 - 2023-04-09<\\/h4>\\n<ul>\\n<li>Fix: Mini cart template appears as empty in various WordPress themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21836\\\">#21836<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.12.1 - 2023-04-02<\\/h4>\\n<ul>\\n<li>Fix: Default background colors are presented as transparent in Popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21824\\\">#21824<\\/a>)<\\/li>\\n<li>Fix: Reverted the tweak of Form Submissions feature merged to the version (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21821\\\">#21821<\\/a>)<\\/li>\\n<li>Fix: Dropdown area is not closing when hovering outside of the content area in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.12.0 - 2023-03-29<\\/h4>\\n<ul>\\n<li>New: Introducing the Mega Menu with the new Menu widget - empowers you to achieve a much higher level of menu design, customization, and creativity<\\/li>\\n<li>New: Diversify your design with a Loop Alternate template - apply another template within your Loop Grid for design creativity<\\/li>\\n<li>New: Kickstart your workflow with predesigned Loop container-based templates<\\/li>\\n<li>Tweak: Added custom icon controls to various locations in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13678\\\">#13678<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17941\\\">#17941<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19295\\\">#19295<\\/a>)<\\/li>\\n<li>Tweak: Added a spacing control between navigation and slides in the Loop Carousel<\\/li>\\n<li>Tweak: Added responsive control to the \'Gap between slides\' control in the Loop Carousel<\\/li>\\n<li>Tweak: Added Custom CSS section in Loop Item template<\\/li>\\n<li>Tweak: Added an Article class metadata in Loop Item template<\\/li>\\n<li>Tweak: Added Lazy Load support for background images in CTA widget when using the Lazy Load Background Images experiment<\\/li>\\n<li>Tweak: Added Lazy Load support for background images in Flipbox widget when using the Lazy Load Background Images experiment<\\/li>\\n<li>Tweak: Added additional size units and custom units in all elements<\\/li>\\n<li>Tweak: Changed Nav Menu widget name to WordPress Menu widget<\\/li>\\n<li>Tweak: Added &quot;Form Validation&quot; control to Form widget<\\/li>\\n<li>Tweak: Updated custom messages in the Form widget<\\/li>\\n<li>Tweak: Improved accessibility in various elements in Gallery widget<\\/li>\\n<li>Tweak: Form Submissions feature merged to version<\\/li>\\n<li>Tweak: Loop feature promoted to Stable status<\\/li>\\n<li>Tweak: Page Transitions feature promoted to Stable status<\\/li>\\n<li>Tweak: Improved accessibility in filter bar in Gallery widget<\\/li>\\n<li>Tweak: Remove unused <code>aspect-ratio-*<\\/code> CSS classes<\\/li>\\n<li>Fix: Not all active breakpoints appear under &quot;Advanced Rules&quot; in popup publish settings (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17020\\\">#17020<\\/a>)<\\/li>\\n<li>Fix: Dynamic background image and video is not working with ACF in Loop Grid widget<\\/li>\\n<\\/ul>\\n<h4>3.11.7 - 2023-03-22<\\/h4>\\n<ul>\\n<li>Tweak: Improved code security enforcement in WooCommerce components<\\/li>\\n<\\/ul>\\n<h4>3.11.6 - 2023-03-14<\\/h4>\\n<ul>\\n<li>Tweak: Improved code security enforcement in Author Box and Countdown widgets<\\/li>\\n<\\/ul>\\n<h4>3.11.5 - 2023-03-12<\\/h4>\\n<ul>\\n<li>Fix: Hamburger Menu Toggle not showing if breakpoint is set to Tablet Extra in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21003\\\">#21003<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.11.4 - 2023-03-07<\\/h4>\\n<ul>\\n<li>Tweak: Prevented SVG file upload for better security enforcement in Forms widget<\\/li>\\n<\\/ul>\\n<h4>3.11.3 - 2023-02-26<\\/h4>\\n<ul>\\n<li>Fix: Error message appears when submitting a form placed below Loop Grid and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21432\\\">#21432<\\/a>)<\\/li>\\n<li>Fix: PHP 8.x compatibility issues in various places<\\/li>\\n<\\/ul>\\n<h4>3.11.2 - 2023-02-22<\\/h4>\\n<ul>\\n<li>Fix: Save &amp; Back handle becomes inaccessible in various scenarios cases in Loop Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21316\\\">#21316<\\/a>)<\\/li>\\n<li>Fix: Can\'t edit page when using \'Content Tabs\' and \'Section\' options in Video Playlist widget<\\/li>\\n<\\/ul>\\n<h4>3.11.1 - 2023-02-15<\\/h4>\\n<ul>\\n<li>Fix: Featured Image dynamic tag is not working in Background images (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21313\\\">#21313<\\/a>)<\\/li>\\n<li>Fix: Time zone is not correct in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17485\\\">#17485<\\/a>)<\\/li>\\n<li>Fix: File upload field is not working in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21341\\\">#21341<\\/a>)<\\/li>\\n<li>Fix: Post Image Attachments dynamic tag is not working in various widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21314\\\">#21314<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.11.0 - 2023-02-13<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Carousel widget - Create powerful &amp; repeating loop templates and populate each one with dynamic content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/219\\\">#219<\\/a>)<\\/li>\\n<li>New: Added Date and Time Range option to Advanced Rules in Popup<\\/li>\\n<li>Tweak: Improved accessibility when opening and closing a popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9788\\\">#9788<\\/a>)<\\/li>\\n<li>Tweak: Improved accessibility of full-screen mode in Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19907\\\">#19907<\\/a>)<\\/li>\\n<li>Tweak: Added keyboard accessibility support to Flip Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5861\\\">#5861<\\/a>)<\\/li>\\n<li>Tweak: Add <code>aria-label<\\/code> to read more link in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13784\\\">#13784<\\/a>)<\\/li>\\n<li>Tweak: Use <code>aspect-ratio<\\/code> property instead of CSS trick in Media Carousel widget<\\/li>\\n<li>Tweak: Updated translation string in Stripe widget<\\/li>\\n<li>Fix: Masonry and Columns controls are not working as expected with responsive in Posts and Loop Grid widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20670\\\">#20670<\\/a>)<\\/li>\\n<li>Fix: Invalid attributes names in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17400\\\">#17400<\\/a>)<\\/li>\\n<li>Fix: Post Image Attachments dynamic tag is not working as expected in various widgets<\\/li>\\n<li>Fix: Form fields order is not presented correctly when exported to CSV in Form Submissions<\\/li>\\n<li>Fix: Dynamic background image and video are not working with ACF in Loop Grid widget<\\/li>\\n<\\/ul>\\n<h4>3.10.3 - 2023-01-29<\\/h4>\\n<ul>\\n<li>Tweak: Added introduction video to loop item information modal in Theme Builder<\\/li>\\n<li>Fix: PHP 8.x throws errors and notices in some cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21087\\\">#21087<\\/a>)<\\/li>\\n<li>Fix: Infinite Scroll and Load on click pagination are not working as expected in Archive template<\\/li>\\n<li>Fix: Show row even when values do not exist in Form Submissions<\\/li>\\n<\\/ul>\\n<h4>3.10.2 - 2023-01-17<\\/h4>\\n<ul>\\n<li>Fix: Updated compatibility tag for Elementor v3.10<\\/li>\\n<\\/ul>\\n<h4>3.10.1 - 2023-01-09<\\/h4>\\n<p>Fix: Preview Could not be loaded error message appears on pages containing the Loop Grid in a header or footer templates<\\/p>\\n<h4>3.10.0 - 2023-01-09<\\/h4>\\n<ul>\\n<li>New: Added new dynamic tag for due date in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7737\\\">#7737<\\/a>)<\\/li>\\n<li>Tweak: Added <code>modified<\\/code> and <code>comment_count<\\/code> to Order By in posts query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11159\\\">#11159<\\/a>)<\\/li>\\n<li>Tweak: Replaced <code>footer<\\/code> tag in Blockquote and Comments widgets for better semantics<\\/li>\\n<li>Fix: Compatibility issue in Imagify Media Library filters due to <code>_elementor_is_screenshot<\\/code> meta filter (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19988\\\">#19988<\\/a>)<\\/li>\\n<li>Fix: Hotspot Widget label icon height issues when Inline Font Icons experiment is active<\\/li>\\n<li>Fix: Editing glitch when using two loop grid widgets on the same page with the same loop item template<\\/li>\\n<li>Fix: Equal height is not working when using sections in Loop Grid widget<\\/li>\\n<li>Fix: Large amount of menu items are not appearing correctly on a mobile device in Nav Menu widget<\\/li>\\n<li>Fix: Featured Image does not change dynamically when using infinite\\/click pagination in Loop Grid widget<\\/li>\\n<li>Fix: Removed action call of non-existent <code>display_empty_cart_template()<\\/code> method in Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.9.2 - 2022-12-21<\\/h4>\\n<ul>\\n<li>Fix: JS events do not trigger in Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20708\\\">#20708<\\/a>)<\\/li>\\n<li>Fix: PHP Errors appear when not using the toggle menu in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18636\\\">#18636<\\/a>)<\\/li>\\n<li>Fix: Popups\' backgrounds disappear when using Lazy Load Background Images experiment<\\/li>\\n<\\/ul>\\n<h4>3.9.1 - 2022-12-14<\\/h4>\\n<ul>\\n<li>Fix: WooCommerce Product Gallery dynamic tag is not working in Basic Gallery, Gallery and Image Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20678\\\">#20678<\\/a>)<\\/li>\\n<li>Fix: Hide Empty option is not working in Menu Cart widget<\\/li>\\n<li>Fix: The Stripe Button widget doesn\'t work in Templates<\\/li>\\n<\\/ul>\\n<h4>3.9.0 - 2022-12-06<\\/h4>\\n<ul>\\n<li>New: Added support for WooCommerce to Loop Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20020\\\">#20020<\\/a>)<\\/li>\\n<li>Tweak: Added more options to \'Show up to X times\' advanced rule in Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8187\\\">#8187<\\/a>)<\\/li>\\n<li>Tweak: Allow saving and reloading a page while editing in-place loop item template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19882\\\">#19882<\\/a>)<\\/li>\\n<li>Tweak: Added <code>$location param<\\/code> to <code>elementor\\/theme\\/get_location_templates\\/template_id<\\/code> hook (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18453\\\">#18453<\\/a>)<\\/li>\\n<li>Tweak: Removed redundant labels from group controls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11666\\\">#11666<\\/a>)<\\/li>\\n<li>Tweak: Added support to use sections and columns as the layout structure of a Loop item template<\\/li>\\n<li>Tweak: Disabled movement when a repeater item is in focus in edit mode<\\/li>\\n<li>Tweak: Upgrade the autoprefixer package to better minify CSS files<\\/li>\\n<li>Tweak: Removed duplicate SQL queries on every page for better performance<\\/li>\\n<li>Tweak: Improved License validation mechanism to avoid limitations<\\/li>\\n<li>Tweak: Added more units options to Border Width control in various elements<\\/li>\\n<li>Tweak: Added <code>em<\\/code> units to Border Radius control in various elements<\\/li>\\n<li>Tweak: Added \'Equal height\' functionality to Loop Grid widget<\\/li>\\n<li>Fix: Issue with Related Products widget and WooCommerce Pixel Manager plugin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16934\\\">#16934<\\/a>)<\\/li>\\n<li>Fix: My Account widget gets hidden when using a single page template with post content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19627\\\">#19627<\\/a>)<\\/li>\\n<li>Fix: Cart is not updated when cache enabled in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19312\\\">#19312<\\/a>)<\\/li>\\n<li>Fix: Entrance animations are not working as expected with Infinite Loop and Load on CLick pagination in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20293\\\">#20293<\\/a>)<\\/li>\\n<li>Fix: Loading page issues in Form Submissions screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19973\\\">#19973<\\/a>)<\\/li>\\n<li>Fix: Recently Edited date and time not working as expected in Elementor Overview plugin in WordPress dashboard (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17966\\\">#17966<\\/a>)<\\/li>\\n<li>Fix: Recurring license mismatch error message when using translators plugins<\\/li>\\n<li>Fix: Submenu items triggers page transition instead of opening in Nav Menu widget<\\/li>\\n<li>Fix: Query values of Posts widget are not imported correctly when importing a Kit<\\/li>\\n<li>Fix: Loop items are exceeding the widget boundaries in Loop Grid widget<\\/li>\\n<li>Fix: Order by option is not working as expected when choosing Upsells, Cross-Sells and Related Products query in Products widget<\\/li>\\n<li>Fix: Various widgets disappear in certain scenarios when choosing direction Row or Column in Container<\\/li>\\n<\\/ul>\\n<h4>3.8.2 - 2022-11-20<\\/h4>\\n<ul>\\n<li>Fix: Z-index issues when applying sticky to Container<\\/li>\\n<li>Fix: Error message appears on front with Editor and Shop Manager roles when using the Loop Builder widget<\\/li>\\n<\\/ul>\\n<h4>3.8.1 - 2022-11-06<\\/h4>\\n<ul>\\n<li>Fix: Sticky inner section is not staying in the column when applying sticky option in Sections (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20203\\\">#20203<\\/a>)<\\/li>\\n<li>Fix: Post Title widget located in a loop item template disappears when enabling the hide title option inside page settings (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20207\\\">#20207<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20255\\\">#20255<\\/a>)<\\/li>\\n<li>Fix: ACF Dynamic data not rendering correctly in various scenarios (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20235\\\">#20235<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20258\\\">#20258<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20277\\\">#20277<\\/a>)<\\/li>\\n<li>Fix: Z-index issues when applying sticky to Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20227\\\">#20227<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.8.0 - 2022-10-30<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Builder as a beta status experiment - Create powerful &amp; repeating loop templates and populate each one with dynamic content and design flexibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4440\\\">#4440<\\/a>)<\\/li>\\n<li>Tweak: Add <code>wp_body_open()<\\/code> to header in Header template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11562\\\">#11562<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15828\\\">#15828<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13089\\\">#13089<\\/a>)<\\/li>\\n<li>Tweak: Added support border-radius option to the Code Highlight widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14316\\\">#14316<\\/a>)<\\/li>\\n<li>Tweak: Import\\/Export CLI and UI mechanisms were merged into a unified service<\\/li>\\n<li>Tweak: User with no permission to Notes cannot be mentioned in a note<\\/li>\\n<li>Tweak: User with no permission to view a post cannot be mentioned in a note<\\/li>\\n<li>Tweak: Notes was added to the right click context-menu<\\/li>\\n<li>Tweak: Notes panel can be resizable<\\/li>\\n<li>Tweak: Notes panel can be dragged outside of the canvas in responsive mode in the editor<\\/li>\\n<li>Tweak: Updated form validation messages translation strings in Form widget<\\/li>\\n<li>Tweak: Updated translators comments<\\/li>\\n<li>Tweak: Theme Builder logo and Title should be clickable<\\/li>\\n<li>Tweak: Reduced API requests and DB calls on non-write setup<\\/li>\\n<li>Tweak: Added media queries to the Table of Contents widget<\\/li>\\n<li>Fix: Sticky option is not working as expected in various scenarios in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18357\\\">#18357<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19540\\\">#19540<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19618\\\">#19618<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19777\\\">#19777<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19827\\\">#19827<\\/a>)<\\/li>\\n<li>Fix: Mixed Content errors on HTTPS in Video Playlist Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18895\\\">#18895<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18945\\\">#18945<\\/a>)<\\/li>\\n<li>Fix: Note\'s timestamp is being updated according to the last activity in Notes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19123\\\">#19123<\\/a>)<\\/li>\\n<li>Fix: Accessibility attribute <code>role=navigation<\\/code> is redundant in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17582\\\">#17582<\\/a>)<\\/li>\\n<li>Fix: Accessibility attribute <code>role=navigation<\\/code> is redundant in pagination in Posts widget<\\/li>\\n<li>Fix: Share buttons is accessible with keyboard but not clickable<\\/li>\\n<li>Fix: Sub-items icons style is missing in preview with Inline Font Icons experiment in Nav Menu widget<\\/li>\\n<li>Fix: Quotes are appearing as HTML when editing a note in Notes<\\/li>\\n<li>Fix: Label\'s Icon height increases when Inline Font Icons experiment is active in Hotspot Widget<\\/li>\\n<li>Fix: Sub conditions of templates are not overridden when importing a Kit<\\/li>\\n<li>Fix: X\\/Y Anchor Point controls were not visible for Scale and Rotate effects<\\/li>\\n<li>Fix: PHP warning notice appears in some situations when using motion effects<\\/li>\\n<\\/ul>\\n<h4>3.7.7 - 2022-09-20<\\/h4>\\n<ul>\\n<li>Fix: Default Flex Grow affects the layout when the container is set to direction Column in various widgets<\\/li>\\n<\\/ul>\\n<h4>3.7.6 - 2022-09-14<\\/h4>\\n<ul>\\n<li>Fix: Submissions menu item appears at the bottom of Elementor section in WordPress dashboard<\\/li>\\n<\\/ul>\\n<h4>3.7.5 - 2022-08-31<\\/h4>\\n<ul>\\n<li>Fix: Error message appears on front if WooCommerce is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19553\\\">#19553<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.7.4 - 2022-08-29<\\/h4>\\n<ul>\\n<li>Tweak: PHP 5.6 Is deprecated<\\/li>\\n<li>Fix: Triangle icon is not being displayed in the Select field when Inline Font Icons Experiment is active in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18598\\\">#18598<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19495\\\">#19495<\\/a>)<\\/li>\\n<li>Fix: The page jumps or flickers to the video playlist on page reload in Video Playlist Widget<\\/li>\\n<\\/ul>\\n<h4>3.7.3 - 2022-07-31<\\/h4>\\n<ul>\\n<li>Tweak: Improved license mechanism for correct validation<\\/li>\\n<li>Fix: Sticky option causes unexpected results when using the Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18357\\\">#18357<\\/a>)<\\/li>\\n<li>Fix: Price list, Portfolio, Flip Box and Gallery widgets disappear when the direction is set to column in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18880\\\">#18880<\\/a>)<\\/li>\\n<li>Fix: Quotes character is showing up as <code>&amp;quot;<\\/code> when editing a note in Notes<\\/li>\\n<\\/ul>\\n<h4>3.7.2 - 2022-06-15<\\/h4>\\n<ul>\\n<li>Tweak: Applied optimized file handling in various modules<\\/li>\\n<li>Fix: Related posts query options are missing in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18633\\\">#18633<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18641\\\">#18641<\\/a>)<\\/li>\\n<li>Fix: Menu Cart Icon is not being displayed on all browsers when Inline Font Icons Experiment is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17705\\\">#17705<\\/a>)<\\/li>\\n<li>Fix: Gallery widget is not working as expected in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18408\\\">#18408<\\/a>)<\\/li>\\n<li>Fix: Flip box is not visible when the direction is set to Row in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18413\\\">#18413<\\/a>)<\\/li>\\n<li>Fix: Portfolio widget is not visible when dragged into &quot;Row&quot; direction Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17653\\\">#17653<\\/a>)<\\/li>\\n<li>Fix: Menu cart is open automatically in Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18629\\\">#18629<\\/a>)<\\/li>\\n<li>Fix: PHP error is being shown the license is expired in License screen<\\/li>\\n<\\/ul>\\n<h4>3.7.1 - 2022-05-16<\\/h4>\\n<ul>\\n<li>Fix: Notes icon appears as an empty square in admin top bar for users with permissions lower than Editor<\\/li>\\n<li>Fix: Notes experiment causes a PHP fatal error on some cases<\\/li>\\n<li>Fix: UI glitches in Notes feature<\\/li>\\n<\\/ul>\\n<h4>3.7.0 - 2022-05-10<\\/h4>\\n<ul>\\n<li>New: Introducing Notes - Work collaboratively directly within Elementor<\\/li>\\n<li>New: Stripe Button widget - Collect Stripe payments directly from your site (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14748\\\">#14748<\\/a>)<\\/li>\\n<li>New: Meet WooCommerce Add to Cart dynamic tag - add products to cart from every widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10607\\\">#10607<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11801\\\">#11801<\\/a>)<\\/li>\\n<li>New: Added WooCommerce Product Content dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16367\\\">#16367<\\/a>)<\\/li>\\n<li>Tweak: Added Related, Upsells and Cross-Sells query sources to Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8071\\\">#8071<\\/a>)<\\/li>\\n<li>Tweak: Added custom icon control to Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18007\\\">#18007<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14357\\\">#14357<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13151\\\">#13151<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11361\\\">#11361<\\/a>)<\\/li>\\n<li>Tweak: Added an option to minimize on Desktop device in Table of Contents widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9933\\\">#9933<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10729\\\">#10729<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10314\\\">#10314<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6327\\\">#6327<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6691\\\">#6691<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11774\\\">#11774<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9051\\\">#9051<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6327\\\">#6327<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5760\\\">#5760<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9774\\\">#9774<\\/a>)<\\/li>\\n<li>Tweak: Added align button to bottom option in various Product widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10263\\\">#10263<\\/a>)<\\/li>\\n<li>Tweak: Added align button to bottom control in Posts and Archive Posts widgets<\\/li>\\n<li>Tweak: Added the ability to hide and show the coupon section in WooCommerce Cart widget<\\/li>\\n<li>Tweak: Added the ability to hide and show the coupon section in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added alignment option to various buttons in WooCommerce Cart widget<\\/li>\\n<li>Tweak: Added alignment option to various buttons in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added percentage unit to padding control in Additional Information customize section in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added quick link to create new theme parts directly from the Finder<\\/li>\\n<li>Tweak: Added the option to add a custom template to Dashboard screen in My Account widget<\\/li>\\n<li>Tweak: Added spacing control to view cart button in various product widgets<\\/li>\\n<li>Tweak: Added the option to add a custom template to empty cart state in Cart widget<\\/li>\\n<li>Tweak: Adjusted the layout of the Payment Methods screen in the My Account widget<\\/li>\\n<li>Tweak: Added lazy load option to Media Carousel, Reviews and Testimonial Carousel widgets<\\/li>\\n<li>Tweak: Added Site Identity quick link to Logo widget<\\/li>\\n<li>Tweak: Added Site Identity quick link to Site Title widget<\\/li>\\n<li>Tweak: Created an attribute that allows disabling page transition for specific links<\\/li>\\n<li>Tweak: Added dynamic tag controls to Gallery widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Countdown widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Portfolio widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Price Table widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Login widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Blockquote widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Facebook Comments widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Post Navigation widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Search Form widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Author Box widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Post info widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Archive Posts widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Product Meta widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Archive Products widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Sitemap widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Reviews widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Code Highlight widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to PayPal Button widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added missing PHP documentation to hooks<\\/li>\\n<li>Fix: Scrolling glitches on mobile devices when Sticky Effect is enabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17767\\\">#17767<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18330\\\">#18330<\\/a>)<\\/li>\\n<li>Fix: Only 1st honypot field is validated when using multiple honeypot fields in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18136\\\">#18136<\\/a>)<\\/li>\\n<li>Fix: Checkout button background color is not working as expected in Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18289\\\">#18289<\\/a>)<\\/li>\\n<li>Fix: Button labels are not accessible for screen readers in Share buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8615\\\">#8615<\\/a>)<\\/li>\\n<li>Fix: Downloads titles controls are not working in responsive in WooCommerce Purchase Summary widget<\\/li>\\n<li>Fix: Excerpt length is not working as expected in Posts and Archive Posts widgets<\\/li>\\n<li>Fix: Titles &amp; Totals weight is not working in WooCommerce Checkout widget<\\/li>\\n<li>Fix: Product image is not appearing on Single Product Page on template load<\\/li>\\n<li>Fix: Additional Information title not editable in some scenarios in WooCommerce Checkout widget<\\/li>\\n<li>Fix: Cart is not updating automatically on mobile in Cart widget<\\/li>\\n<li>Fix: UI Glitch in Masonry control in Portfolio widget<\\/li>\\n<li>Fix: Custom breakpoints experiment didn\'t work on Single post and page templates<\\/li>\\n<li>Fix: Testimonial carousel &amp; Reviews widgets disregards the <code>alt<\\/code> attribute<\\/li>\\n<li>Fix: Playlist widget deeplink didn\'t send user directly to the widget in the page<\\/li>\\n<li>Fix: Masonry option causes the images to disappear in the Editor in Posts widget<\\/li>\\n<li>Fix: Scrollbar appears after clicking on the dropdown toggle in Nav Menu widget<\\/li>\\n<li>Fix: Custom icons disappear on frontend if the pack name contains numbers<\\/li>\\n<li>Fix: Custom Font disappears if the name contains only numbers<\\/li>\\n<li>Fix: <code>end-section()<\\/code> is missing from Progress Tracker and Facebook Embed widgets<\\/li>\\n<li>Tweak: Added a filter for conditions cache query in Theme Builder<\\/li>\\n<li>Fix: Customizations lost on Ajax refresh in WooCommerce Cart widget<\\/li>\\n<li>Fix: Hello theme Header and Footer experiment is not working when WooCommerce plugin is active<\\/li>\\n<li>Fix: Color controls are not working as expected in Checkout widget<\\/li>\\n<li>Fix: Color controls are not working as expected in My Account widget<\\/li>\\n<li>Fix: Empty state widget preview in the editor is disappearing in various widgets<\\/li>\\n<li>Fix: Cart is not updating automatically on mobile in WooCommerce Cart widget<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-7-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.6.5 - 2022-04-12<\\/h4>\\n<ul>\\n<li>Fix: Compatibility issues for several widgets in iOS 14 and macOS 13 devices (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18090\\\">#18090<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15910\\\">#15910<\\/a>)<\\/li>\\n<li>Fix: Button Alignment doesn\'t work in Custom Add To Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17810\\\">#17810<\\/a>)<\\/li>\\n<li>Fix: PHP warning is thrown in some cases in PayPal button widget<\\/li>\\n<li>Fix: PHP 8.1 throws errors and notices in some cases<\\/li>\\n<li>Fix: PHP notice was thrown when Kit Import process initiated without display conditions<\\/li>\\n<li>Fix: Create Account button always opens on the Sign Up screen even if the user has an account in Onboarding process<\\/li>\\n<\\/ul>\\n<h4>3.6.4 - 2022-03-15<\\/h4>\\n<ul>\\n<li>Tweak: Kit import dynamic reference support for templates and dynamic tags<\\/li>\\n<li>Tweak: Updated tested up to version tag to <code>3.6.0<\\/code><\\/li>\\n<li>Fix: Sticky caused scrolling issues after clicking an element that expands the page height (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17821\\\">#17821<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17839\\\">#17839<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18069\\\">#18069<\\/a>)<\\/li>\\n<li>Fix: When saving Global widget JS error is being thrown and editor fails to load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17954\\\">#17954<\\/a>)<\\/li>\\n<li>Fix: Motion effects are missing from Background section under Style tab in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18063\\\">#18063<\\/a>)<\\/li>\\n<li>Fix: Imported Kit doesn\'t appear in the theme builder after successful import in some cases<\\/li>\\n<li>Fix: Added future Pro support to fix the Cart icon that shifted aside in Menu cart widget<\\/li>\\n<\\/ul>\\n<h4>3.6.3 - 2022-02-28<\\/h4>\\n<ul>\\n<li>Fix: Custom Code display conditions modal is not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17865\\\">#17865<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17942\\\">#17942<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17994\\\">#17994<\\/a>)<\\/li>\\n<li>Fix: Share buttons are not accessible for keyboard navigation (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8615\\\">#8615<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.6.2 - 2022-02-14<\\/h4>\\n<ul>\\n<li>Fix: Auto updates mechanism is not working as expected (this version might be also installed automatically)<\\/li>\\n<\\/ul>\\n<h4>3.6.1 - 2022-02-09<\\/h4>\\n<ul>\\n<li>Tweak: Allow connecting via generic source for future feature support<\\/li>\\n<li>Fix: Custom Code doesn\'t work when WooCommerce is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17675\\\">#17675<\\/a>)<\\/li>\\n<li>Fix: Content animation didn\'t work when Improved asset loading experiment is active Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17055\\\">#17055<\\/a>)<\\/li>\\n<li>Fix: PHP warning appears some times when trying to force-check for available updates<\\/li>\\n<li>Fix: Page transitions are being triggered when not needed<\\/li>\\n<li>Fix: Text alignment on Tablet responsive device affects base device in Testimonial Carousel widget<\\/li>\\n<li>Fix: Harden Submissions feature to prevent potential security issues<\\/li>\\n<li>Fix: Page Transitions Icon option Preloader doesn\'t work on frontend<\\/li>\\n<\\/ul>\\n<h4>3.6.0 - 2022-01-31<\\/h4>\\n<ul>\\n<li>New: WooCommerce Purchase Summary widget - Fully customize the content and style of your order summary page (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5756\\\">#5756<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15862\\\">#15862<\\/a>)<\\/li>\\n<li>New: WooCommerce Notices styling on Site Settings - Customize the appearance of WooCommerce notices (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14570\\\">#14570<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15896\\\">#15896<\\/a>)<\\/li>\\n<li>New: WooCommerce Notices widget - Set the position of WooCommerce notices on your shop pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8124\\\">#8124<\\/a>)<\\/li>\\n<li>Experiment: Page Transitions - Customize the page loading experience, and increase brand recognition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10576\\\">#10576<\\/a>)<\\/li>\\n<li>Tweak: Added WooCommerce &amp; Theme Elements widgets to Improved CSS Loading experiment to save up 126KB per page load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17412\\\">#17412<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17337\\\">#17337<\\/a>)<\\/li>\\n<li>Tweak: Added new layout options in WooCommerce Add To Cart and WooCommerce Custom Add To Cart widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5437\\\">#5437<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10617\\\">#10617<\\/a>)<\\/li>\\n<li>Tweak: Added Stroke functionality for typography control in various widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11158\\\">#11158<\\/a>)<\\/li>\\n<li>Tweak: Removed <code>elementor-section-wrap<\\/code> by adding it to the Optimized DOM Output experiment (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16950\\\">#16950<\\/a>)<\\/li>\\n<li>Tweak: Added style controls for variations in WooCommerce Menu Cart widget<\\/li>\\n<li>Tweak: Added color control to navigation dots in Media Carousel, Reviews, and Slides widgets<\\/li>\\n<li>Tweak: Disabled Vimeo autoplay on edit mode when getting video data in Video Playlist widget<\\/li>\\n<li>Tweak: Added notice about Facebook\'s new EU consent policy in Facebook Button, Facebook Comments, Facebook Embed, and Facebook Page widgets<\\/li>\\n<li>Tweak: Refactor string translation calls to use native WP translation methods<\\/li>\\n<li>Tweak: Convert <code>home_url<\\/code> license API call to <code>get_site_url<\\/code> for better compatibility<\\/li>\\n<li>Tweak: Promoted Default to New Theme Builder and Scroll Snap experiments to Stable status in Experiments screen<\\/li>\\n<li>Tweak: Scroll Snap experiment set to active by default for all websites in Experiments screen<\\/li>\\n<li>Tweak: Scrolling Effects in Header and Section backgrounds are not working as expected when effects are relative to the entire page<\\/li>\\n<li>Tweak: Added &quot;Auto Updates&quot; capability to Pro versions<\\/li>\\n<li>Tweak: Removed sequenced animation hover effect option from Classic skin in Call to Action widget<\\/li>\\n<li>Tweak: Added &quot;Excerpt Length&quot; control in Post Excerpt widget<\\/li>\\n<li>Tweak: Deleted deprecated methods from Query Control module<\\/li>\\n<li>Tweak: Adjusted Inline-CSS Experiment to work with Additional Custom Breakpoints experiment<\\/li>\\n<li>Fix: Automatically open cart functionality didn\'t work in product page in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5921\\\">#5921<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16276\\\">#16276<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16879\\\">#16879<\\/a>)<\\/li>\\n<li>Fix: Buttons are not visible when there are too many products in the cart in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16221\\\">#16221<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17283\\\">#17283<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16333\\\">#16333<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13005\\\">#13005<\\/a>)<\\/li>\\n<li>Fix: Mini cart modal z-index is too low in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16333\\\">#16333<\\/a>)<\\/li>\\n<li>Fix: Side cart buttons are not visible at first glance on mobile in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16221\\\">#16221<\\/a>)<\\/li>\\n<li>Fix: Read More field recognizes inline HTML elements as plain text in Posts and Archive Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16985\\\">#16985<\\/a>)<\\/li>\\n<li>Fix: Load More functionality caused JS error console in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17036\\\">#17036<\\/a>)<\\/li>\\n<li>Fix: Autoplay is not working as expected when the lazy load is active in Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15304\\\">#15304<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16274\\\">#16274<\\/a>)<\\/li>\\n<li>Fix: Right navigation area wasn\'t 100% clickable in Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14252\\\">#14252<\\/a>)<\\/li>\\n<li>Fix: Posts duplicate when there are two Posts widgets inside a page using pagination functionality (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17056\\\">#17056<\\/a>)<\\/li>\\n<li>Fix: Global widget changes are not reflected on frontend (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16820\\\">#16820<\\/a>)<\\/li>\\n<li>Fix: JS Error console message when using the Load More functionality and Post Per Page option in Posts widget<\\/li>\\n<li>Fix: Heading styling is not being loaded when Inline CSS experiment is active in Post and Page Title widgets<\\/li>\\n<li>Fix: Sticky offset not working as expected when changing device mode on the browser<\\/li>\\n<li>Fix: Scroll Snap functionality wasn\'t applied on Templates and Archives<\\/li>\\n<li>Fix: Toggle icon color didn\'t work on hover state when Inline Font Icons experiment is activated in Nav Menu widget<\\/li>\\n<li>Fix: Variations style controls are not working as expected in WooCommerce Add to Cart widget<\\/li>\\n<li>Fix: Display conditions module is not working as expected when using the new Theme Builder UI<\\/li>\\n<li>Fix: Edit header handles <code>z-index<\\/code> issues in Header document<\\/li>\\n<li>Fix: Panel icons UI glitch in Call To Action widget<\\/li>\\n<li>Fix: WordPress 5.9 <code>WP_User_query<\\/code> <code>who<\\/code> argument deprecation adjustments<\\/li>\\n<\\/ul>\\n<h4>3.5.2 - 2021-11-28<\\/h4>\\n<ul>\\n<li>Tweak: Adjusted license mechanism to support trial period<\\/li>\\n<li>Fix: Updates made to Global Widgets do not reflect accordingly to linked widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16815\\\">#16815<\\/a>)<\\/li>\\n<li>Fix: Hamburger toggle button doesn\'t change to \\u201cclose\\u201d when menu is collapsed in Nav Menu widget when Inline Font Awesome experiment is active<\\/li>\\n<li>Fix: Global Widget cannot be unlinked<\\/li>\\n<\\/ul>\\n<h4>3.5.1 - 2021-11-10<\\/h4>\\n<ul>\\n<li>Fix: Inline HTML elements appear as plain text in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16816\\\">#16816<\\/a>)<\\/li>\\n<li>Fix: Dropdown items inherited values from Main Menu space between control in Nav Menu widget (<a href=\\\"(https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16815)\\\">#16815<\\/a><\\/li>\\n<li>Fix: Order Summary titles style controls not applying on various devices in Cart widget<\\/li>\\n<li>Fix: Panel &quot;Need Help&quot; link is not correct in WooCommerce section in Site Settings<\\/li>\\n<\\/ul>\\n<h4>3.5.0 - 2021-11-01<\\/h4>\\n<ul>\\n<li>New: WooCommerce Checkout widget - Fully customize the content and style of your checkout page (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15282\\\">#15282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15990\\\">#15990<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13218\\\">#13218<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: WooCommerce Cart widget - Style your cart page the way you want with design flexibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15282\\\">#15282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13218\\\">#13218<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: WooCommerce My Account widget - Create a custom design for your my account pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: Progress Tracker widget - Motivate your customers to keep reading your site content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16576\\\">#16576<\\/a>)<\\/li>\\n<li>New: Meet WooCommerce Site Settings - Set your store pages within Elementor<\\/li>\\n<li>Experiment: Scroll Snap - Set the scene of every scroll (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10752\\\">#10752<\\/a>)<\\/li>\\n<li>Tweak: Changed infrastructure to prevent rendering bugs in Global Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16354\\\">#16354<\\/a>)<\\/li>\\n<li>Tweak: Added the option to open submission in a new tab in Form Submissions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14967\\\">#14967<\\/a>)<\\/li>\\n<li>Tweak: Added various responsive controls in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1851\\\">#1851<\\/a>)<\\/li>\\n<li>Tweak: Split Title and Price styling controls in Price List widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7688\\\">#7688<\\/a>)<\\/li>\\n<li>Tweak: Added various responsive capabilities to controls in Posts Archive widget<\\/li>\\n<li>Tweak: Adjusted Motion Effects module to support future feature<\\/li>\\n<li>Tweak: Changed admin notice content when Pro installed without Core installed<\\/li>\\n<li>Tweak: Cleanup in <code>wp_options<\\/code> table<\\/li>\\n<li>Tweak: Changed Connect logic in Elementor top bar to simplify the connect process<\\/li>\\n<li>Tweak: Marked new Theme Builder as an Experiment and set to default for new sites<\\/li>\\n<li>Tweak: Enforced better security policies in various widgets and modules<\\/li>\\n<li>Tweak: Added load more button functionality to the Posts Archive widget<\\/li>\\n<li>Tweak: Renamed Elementor\'s responsive SCSS variables<\\/li>\\n<li>Tweak: Added dividers to horizontal layout in Nav Menu widget<\\/li>\\n<li>Tweak: Removed Google+ social network from Share Buttons widget<\\/li>\\n<li>Tweak: Convert usage of old Responsive class to use the new Breakpoints Manager<\\/li>\\n<li>Fix: jQuery in Heading doesn\'t work for not logged in users in Custom Code (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14515\\\">#14515<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14266\\\">#14266<\\/a>)<\\/li>\\n<li>Fix: Menu animation causing page horizontal scroll in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15184\\\">#15184<\\/a>)<\\/li>\\n<li>Fix: Wrong function call in Table of Content &amp; Post Excerpt widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16547\\\">#16547<\\/a>)<\\/li>\\n<li>Fix: Slides to Scroll control can\'t be set to Default if Widescreen mode has a value in Testimonial Carousel widget<\\/li>\\n<li>Fix: Sticky offset not working properly when changing device mode<\\/li>\\n<li>Fix: UTF character issues when exporting CSV file in Form Submissions<\\/li>\\n<li>Fix: Load More functionality doesn\'t work when the Posts widget placed inside an Archive template<\\/li>\\n<li>Fix: UI glitches and editing issues in Video Playlist widget<\\/li>\\n<\\/ul>\\n<h4>3.4.2 - 2021-10-12<\\/h4>\\n<ul>\\n<li>Fix: Icons color style conflicts when Font-Awesome Inline experiment is active in Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16435\\\">#16435<\\/a>)<\\/li>\\n<li>Fix: Mini Cart hides page content when closed in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16305\\\">#16305<\\/a>)<\\/li>\\n<li>Fix: UI glitches in the Editor edit mode when inserting Post Content widget and Font-Awesome Inline experiment is active in Single Post template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16358\\\">#16358<\\/a>)<\\/li>\\n<li>Fix: Slides per view controls disappeared from multiple breakpoints in Testimonial Carousel<\\/li>\\n<li>Fix: Product variations UI glitch in Menu Cart widget<\\/li>\\n<li>Fix: Buttons UI glitch on Safari browser in Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.4.1 - 2021-09-01<\\/h4>\\n<ul>\\n<li>Fix: Sticky functionality is not working if the Additional Custom Breakpoints experiment is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16186\\\">#16186<\\/a>)<\\/li>\\n<li>Fix: Slideshow skin UI glitch in Media Carousel widget<\\/li>\\n<li>Fix: Product price typography weight control is not working as expected in Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.4.0 - 2021-09-01<\\/h4>\\n<ul>\\n<li>Tweak: Added new Mini Cart layout type in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11312\\\">#11312<\\/a>)<\\/li>\\n<li>Tweak: Added styling options for Cart, Products, and Cart buttons in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14952\\\">#14952<\\/a>)<\\/li>\\n<li>Tweak: Added the ability to open cart automatically when an item is added in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14119\\\">#14119<\\/a>)<\\/li>\\n<li>Tweak: Added the ability to remove an item from cart without reloading the page with an AJAX request (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9531\\\">#9531<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10875\\\">#10875<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11309\\\">#11309<\\/a>)<\\/li>\\n<li>Tweak: Added Load More AJAX functionality to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1284\\\">#1284<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14557\\\">#14557<\\/a>)<\\/li>\\n<li>Tweak: Added Vimeo support to the Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15319\\\">#15319<\\/a>)<\\/li>\\n<li>Tweak: Improved asset loading performance by serving lighter JS files (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8572\\\">#8572<\\/a>)<\\/li>\\n<li>Tweak: Added query string to the URL only after the first video is played in Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15348\\\">#15348<\\/a>)<\\/li>\\n<li>Tweak: Added various layout options with more responsive controls and cart structure options in Menu Cart widget<\\/li>\\n<li>Tweak: Added the option to open the menu cart by click or hover in Menu Cart widget<\\/li>\\n<li>Tweak: Added the ability to choose a specific product to draw data from in WooCommerce Dynamic tags<\\/li>\\n<li>Tweak: Removed auto-scroll to the widget location when arriving from external URL in Video Playlist widget<\\/li>\\n<li>Tweak: Removed the Video Playlist widget from the Experiments list<\\/li>\\n<li>Tweak: Added descriptive error messages for MailChimp action after submit and on form submit in Forms widget<\\/li>\\n<li>Tweak: Added tooltip trigger None and Hover for link in Hotspot widget<\\/li>\\n<li>Tweak: Added responsive controls to Offset and Effects Offset in Sticky options<\\/li>\\n<li>Tweak: Added responsive control to Alignment in Testimonial Carousel widget<\\/li>\\n<li>Tweak: Adjusted Motion Effects module to support future feature<\\/li>\\n<li>Tweak: Added future compatibility to support better loading of <code>eicons<\\/code> font<\\/li>\\n<li>Tweak: Changed Rename Part title and button color in Theme Builder<\\/li>\\n<li>Fix: Products don\'t appear on the cart while editing in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15451\\\">#15451<\\/a>)<\\/li>\\n<li>Fix: Videos always start muted in the Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15292\\\">#15292<\\/a>)<\\/li>\\n<li>Fix: Unnecessary spacing if submenu indicator is set to None in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15365\\\">#15365<\\/a>)<\\/li>\\n<li>Fix: MailChimp double opt-in feature doesn\'t work in Forms widget<\\/li>\\n<li>Fix: Fetching MailChimp groups field blocks the loading of the rest of the fields in the Form widget<\\/li>\\n<li>Fix: Missing field IDs causes forms not to be sent in Forms widget<\\/li>\\n<li>Fix: Full Content Skin is not working properly when inserted twice on the same page in Posts widget<\\/li>\\n<li>Fix: Avoid Duplicates option doesn\'t exclude manual selections in Posts widget<\\/li>\\n<li>Fix: Submenu indicator alignment issue in Nav menu widget<\\/li>\\n<li>Fix: Query control deprecated message appears when debug mode is defined<\\/li>\\n<li>Fix: Tweet Button icon incorrect color and size when the icon is rendered as SVG in Blockquote widget<\\/li>\\n<li>Fix: Video icon size is not changing on Active state in Video Playlist widget<\\/li>\\n<li>Fix: Header icon color is not working in Table Of Content widget<\\/li>\\n<li>Fix: Icons style glitches when Font Awesome Inline experiment is active in Video Playlist widget<\\/li>\\n<li>Fix: Bullet markers are not visible on preview mode when Font Awesome Inline experiment is active in Table of Content widget<\\/li>\\n<li>Fix: UI Glitch when Font-Awesome Inline experiment is active in Price Table widget<\\/li>\\n<li>Fix: Submenu Indicator appears larger when Font Awesome Inline experiment is active in Nav Menu widget<\\/li>\\n<li>Fix: Part name is deleted when clicking on the &quot;Change&quot; Button without changing the name in Theme Builder<\\/li>\\n<li>Fix: Redundant pagination queries in the Editor<\\/li>\\n<li>Deprecated: Remove all usages of <code>ElementorUtils::get_create_new_post_url()<\\/code><\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-4-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.3.8 - 2021-08-23<\\/h4>\\n<ul>\\n<li>Fix: Products grid width issue when adjusting columns and rows in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16001\\\">#16001<\\/a>)<\\/li>\\n<li>Fix: Font Awesome Inline experiment causes icons glitch in Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16045\\\">#16045<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA v3 <code>z-index<\\/code> is lower than the Section\'s background color<\\/li>\\n<li>Fix: Style missing when Font Awesome inline experiment is active in Post Info widget<\\/li>\\n<li>Fix: Font Awesome icons were not loaded in Post Info widget<\\/li>\\n<li>Fix: Zero character can\'t be used as a placeholder in Number field in Form widget<\\/li>\\n<li>Fix: Carousels are not working properly in the Editor when Additional Custom Breakpoints experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.3.7 - 2021-08-15<\\/h4>\\n<ul>\\n<li>Tweak: Added support for Additional Custom Breakpoints in Nav Menu widget<\\/li>\\n<li>Tweak: Added support for Additional Custom breakpoints in Motion Effects<\\/li>\\n<li>Fix: Columns didn\'t respond to changes in Gallery widget if Additional Custom Breakpoints Experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.3.6 - 2021-08-10<\\/h4>\\n<ul>\\n<li>Tweak: Added support for future feature in Nav Menu widget<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Related widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Upsells widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Categories widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.3.5 - 2021-08-01<\\/h4>\\n<ul>\\n<li>Fix: Responsive layout glitches in Products and Products Archive widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15773\\\">#15773<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA V3 integration conflict with required fields validation in Forms widget<\\/li>\\n<\\/ul>\\n<h4>3.3.4 - 2021-07-21<\\/h4>\\n<ul>\\n<li>Fix: Grid layout glitch in WooCommerce Products Archive widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15718\\\">#15718<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.3.3 - 2021-07-20<\\/h4>\\n<ul>\\n<li>Tweak: Added a descriptive message in Collect Submissions action after submit<\\/li>\\n<li>Tweak: Added future compatibility for Additional Custom Breakpoints for Pro widgets<\\/li>\\n<li>Fix: Some widget style breaks when Improved CSS Loading Experiment is active in certain cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15632\\\">#15632<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15683\\\">#15683<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15660\\\">#15660<\\/a>)<\\/li>\\n<li>Fix: Translation update keep appearing as available after install (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14297\\\">#14297<\\/a>)<\\/li>\\n<li>Fix: Wrong default icon color when using Font Awesome icons as inline SVG in Call to Action widget<\\/li>\\n<\\/ul>\\n<h4>3.3.2 - 2021-07-13<\\/h4>\\n<ul>\\n<li>Tweak: Updated plugin description<\\/li>\\n<li>Fix: MailChimp tags in form widget replaced existing tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11111\\\">#11111<\\/a>)<\\/li>\\n<li>Fix: Clicking videos from the items list in edit mode doesn\\u2019t initiate videos properly<\\/li>\\n<li>Fix: User unauthorized message when activated but not connected in Kit Library<\\/li>\\n<li>Fix: Carousel widgets did not support additional custom breakpoint responsive values<\\/li>\\n<li>Fix: Tab border is overridden by the Section background color in Video Playlist widget<\\/li>\\n<li>Fix: Widgets style breaks when Improved CSS Load experiment is active in a Single Page template and Post Content widget<\\/li>\\n<\\/ul>\\n<h4>3.3.1 - 2021-06-20<\\/h4>\\n<ul>\\n<li>Tweak: Added support for more Theme Builder display conditions in Export \\/ Import experiment<\\/li>\\n<li>Tweak: Adjusted License page heading structure for future feature<\\/li>\\n<li>Tweak: Adjusted Font Awesome icon for allowing support for future feature<\\/li>\\n<li>Fix: <code>frontend.min.js<\\/code> file size increased in Elementor Pro 3.3.0 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15278\\\">#15278<\\/a>)<\\/li>\\n<li>Fix: Prevent conditions from being reset when object cache is enabled in site (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13299\\\">#13299<\\/a>)<\\/li>\\n<li>Fix: Custom Code publish modal responsiveness issues (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14519\\\">#14519<\\/a>)<\\/li>\\n<li>Fix: Populating fields with options programmatically doesn\'t appear in Submissions screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10671\\\">#10671<\\/a>)<\\/li>\\n<li>Fix: Large images are not shown on the Image Carousel widget when set via Toolset dynamic tag<\\/li>\\n<li>Fix: Enable inline editing to the inner content tabs in Video Playlist widget<\\/li>\\n<li>Fix: Clicking on the video list doesn\'t play videos properly in Video Playlist widget<\\/li>\\n<li>Fix: Hide Play Icon control when Image overlay is toggled off in Video Playlist widget<\\/li>\\n<li>Fix: Removed extra space below the player when viewing from mobile view in Video Playlist widget<\\/li>\\n<li>Fix: Import button is not working properly in Theme Builder interface<\\/li>\\n<li>Fix: Preview Dynamic Content as control is not updating preview and throws an error in Popup Builder<\\/li>\\n<\\/ul>\\n<h4>3.3.0 - 2021-06-08<\\/h4>\\n<ul>\\n<li>New: Video Playlist widget - Add Engaging Video Content to Your Website (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11859\\\">#11859<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7803\\\">#7803<\\/a>)<\\/li>\\n<li>New: Hotspot widget - Create Interactive Images With Contextually Relevant Information (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7282\\\">#7282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2768\\\">#2768<\\/a>)<\\/li>\\n<li>Tweak: Accessibility improvements for sub-menus in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13859\\\">#13859<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13810\\\">#13810<\\/a>)<\\/li>\\n<li>Tweak: MailChimp action after submit can now add new tags to existing subscribers in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11111\\\">#11111<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/forms\\/record\\/actions_before<\\/code> to filter the record before it sent to Actions After Submit in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14261\\\">#14261<\\/a>)<\\/li>\\n<li>Tweak: Yoast SEO breadcrumbs widget can be used in Elementor without the need of enabling them in Yoast setting<\\/li>\\n<li>Tweak: Added future support for widgets CSS conditional loading (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10329\\\">#10329<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14229\\\">#14229<\\/a>)<\\/li>\\n<li>Tweak: Added future support for Sticky JS library conditional loading<\\/li>\\n<li>Tweak: Added future support for Import \\/ Export experiment<\\/li>\\n<li>Tweak: Preparations and fixes for Import Export Experiment in Pro version<\\/li>\\n<li>Tweak: Added gradient button capabilities to Login widget buttons<\\/li>\\n<li>Tweak: Added gradient button capabilities to Slides widget button<\\/li>\\n<li>Tweak: Added gradient button capabilities to Price Table widget button<\\/li>\\n<li>Tweak: Added gradient button capabilities to Flip Box widget button<\\/li>\\n<li>Tweak: Added Code Highlight widget Developers Documentation<\\/li>\\n<li>Tweak: Adjusted Submissions page for future updates<\\/li>\\n<li>Tweak: Added <code>em<\\/code> and <code>%<\\/code> units for padding control in Carousel widgets<\\/li>\\n<li>Tweak: Shorten currency name to currency symbol in PayPal button widget<\\/li>\\n<li>Fix: Custom Fonts URLs should be replaced when replace URL is triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7376\\\">#7376<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10382\\\">#10382<\\/a>)<\\/li>\\n<li>Fix: The currency symbol size changed in the Price Table widget if enabling sale (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13519\\\">#13519<\\/a>)<\\/li>\\n<li>Fix: Nav Menu widget is not loading Font Awesome submenu icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9907\\\">#9907<\\/a>)<\\/li>\\n<li>Fix: Hamburger toggle is not working in Nav menu widget<\\/li>\\n<li>Fix: Activation bug for IDN domains<\\/li>\\n<li>Fix: Conditions modal responsive glitches in Custom Code<\\/li>\\n<li>Fix: Duplicated strings in Custom Code module<\\/li>\\n<li>Fix: Enable resize option for code input field in Custom Code<\\/li>\\n<li>Fix: \\u201cSave &amp; Close \\u201cbutton in Custom Code\'s Conditions modal was not visible on small screen sizes<\\/li>\\n<li>Fix: Removing a column from a section in the navigator resulted in an empty section<\\/li>\\n<li>Fix: Recommend option is cut If the layout is not &quot;Standard&quot; in the Facebook Button widget<\\/li>\\n<li>Fix: Video item does not play without adding an image in Media Carousel widget<\\/li>\\n<li>Fix: <code>search-plus<\\/code> icon missing from panel in Media Carousel widget<\\/li>\\n<li>Fix: UI hover state glitch in Media Carousel widget<\\/li>\\n<li>Fix: PHP notice was thrown when trying to import a kit without overrideConditions parameter in Kit Import flow<\\/li>\\n<li>Fix: Templates conditions not imported if there are no conflicts in Import Export Experiment<\\/li>\\n<li>Fix: Non english values are not encoded properly on Submissions export<\\/li>\\n<li>Fix: Theme Builder import is not working properly<\\/li>\\n<li>Fix: UI glitch when no global widgets were found in Editor Panel<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-3-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.2.2 - 2021-05-05<\\/h4>\\n<ul>\\n<li>Tweak: Added support for Expert tier templates in Templates Library<\\/li>\\n<li>Tweak: Updated compatibility tag to support Elementor v3.2.x<\\/li>\\n<li>Tweak: Added compatibility for future Library improvements<\\/li>\\n<li>Fix: Toolset image dynamic field is not working with Gallery widget<\\/li>\\n<\\/ul>\\n<h4>3.2.1 - 2021-03-21<\\/h4>\\n<ul>\\n<li>Tweak: Added strings context in PayPal button and Price Table widgets<\\/li>\\n<li>Tweak: Added support for future Import \\/ Export Kit feature<\\/li>\\n<li>Fix: Submissions with over than 191 characters weren\'t indexed properly<\\/li>\\n<\\/ul>\\n<h4>3.2.0 - 2021-03-14<\\/h4>\\n<ul>\\n<li>New: PayPal Button widget - Collect PayPal payments directly from your site<\\/li>\\n<li>Experiment: Submissions - Save all of your form submissions in one place (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1686\\\">#1686<\\/a>)<\\/li>\\n<li>Tweak: Added Stay In Column option to Inner Section element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7956\\\">#7956<\\/a>)<\\/li>\\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget<\\/li>\\n<li>Tweak: Changed descriptive text in Create Custom Code screen<\\/li>\\n<li>Tweak: Added support for dynamic capabilities in Code Highlight widget<\\/li>\\n<li>Tweak: Added support for future load on demand for <code>share-link<\\/code> library<\\/li>\\n<li>Tweak: Added support for future load on demand for <code>dialog<\\/code> library in Popup<\\/li>\\n<li>Tweak: Allow overwriting the assets URL when using a mirror domain<\\/li>\\n<li>Fix: Animation was triggered multiple times when accessing the viewport in certain cases in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13951\\\">#13951<\\/a>)<\\/li>\\n<li>Fix: Location is not being updated after a Custom Code snippet is published (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13971\\\">#13971<\\/a>)<\\/li>\\n<li>Fix: Custom Fonts CSS files were not updated after regenerating CSS files<\\/li>\\n<li>Fix: Conditions modal is not responsive in Custom Code<\\/li>\\n<li>Fix: Empty order buttons are displayed in Custom Fonts screen<\\/li>\\n<li>Fix: Typo in \'Reply To\' Email action after submit placeholder in Forms widget<\\/li>\\n<li>Fix: Unnecessary Save Draft button in Custom Code<\\/li>\\n<li>Fix: RTL glitches in Custom Code<\\/li>\\n<li>Fix: Sanitized options in the editor to enforce better security policies<\\/li>\\n<li>Deprecated: See all deprecations to this version in our (<a href=\\\"https:\\/\\/developers.elementor.com\\/v3-2-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.1.1 - 2021-02-23<\\/h4>\\n<ul>\\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget<\\/li>\\n<li>Fix: Popup event handler is undefined (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11475]\\\">#11475<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10690\\\">#10690<\\/a>)<\\/li>\\n<li>Fix: Conditions modal is not responsive in Custom Code<\\/li>\\n<li>Fix: RTL glitches in Code Highlight widget<\\/li>\\n<li>Fix: Minor UI glitches in Code Highlight widget<\\/li>\\n<li>Fix: Users can\'t get Pro Developer Edition version updates<\\/li>\\n<\\/ul>\\n<h4>3.1.0 - 2021-02-13<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Code - Add custom code snippets to your site, including <code>head<\\/code>, <code>body<\\/code> start and <code>body<\\/code> end<\\/li>\\n<li>New: Meet Code Highlight widget - showcase any syntax with highlighted UI (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5815\\\">#5815<\\/a>)<\\/li>\\n<li>Experiment: Improved Pro widgets performance by loading JS and Swiper assets conditionally in frontend (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8572\\\">#8572<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/experiment-optimized-asset-loading\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added Compatibility Tag support in Elementor Pro (<a href=\\\"https:\\/\\/developers.elementor.com\\/compatibility-tag\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Rotating Text animation in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4625\\\">#4625<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added an option to set Selected color for Typing effect in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5403\\\">#5403<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7826\\\">#7826<\\/a>)<\\/li>\\n<li>Tweak: Added animation Loop option for Animated Headline (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9749\\\">#9749<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2457\\\">#2457<\\/a>)<\\/li>\\n<li>Tweak: Added timing options for Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4392\\\">#4392<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4242\\\">#4242<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added Word Wrap control to Code Highlight widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13577\\\">#13577<\\/a>)<\\/li>\\n<li>Tweak: Upgraded Font Awesome Pro library to v5.15.1<\\/li>\\n<li>Tweak: Improved method of loading field mapping repeater in Form widget (<a href=\\\"https:\\/\\/developers.elementor.com\\/how-to-add-a-repeater-control-to-elementor-add-on\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added &quot;Show on Browsers&quot; Popup Advanced Rule<\\/li>\\n<li>Tweak: Added real-time JS handling to prevent redundant renders in Slides widget and all Carousel widgets<\\/li>\\n<li>Tweak: Import scroll utility from core and remove it from Pro<\\/li>\\n<li>Tweak: Added alignment options for Post Excerpt widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9757\\\">#9757<\\/a>)<\\/li>\\n<li>Tweak: Changed alignment control to work with selectors in Share Buttons<\\/li>\\n<li>Tweak: Upgraded to Webpack 5, Grunt-Webpack 4 and TerserPlugin instead of UglifyJsPlugin<\\/li>\\n<li>Fix: Steps Divider is not vertically aligned in Multi Step Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12569\\\">#12569<\\/a>)<\\/li>\\n<li>Fix: Slides are playing in an infinite loop mode even when the option is disabled in Slides Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6726\\\">#6726<\\/a>)<\\/li>\\n<li>Fix: Redundant spacing is added to Share Buttons widget<\\/li>\\n<li>Fix: Step buttons text is not updated without a page reload in Forms widget<\\/li>\\n<li>Fix: Overflow issue in certain animations in Animated Headline widget<\\/li>\\n<li>Fix: When dragging a new Testimonial Carousel there is a console error thrown<\\/li>\\n<li>Fix: Step Buttons are cut in mobile view in Multi Step Form<\\/li>\\n<li>Fix: Submit and Step buttons size differences when using Twenty Twenty theme<\\/li>\\n<li>Fix: Duplicate button Text Color control in Slides widget<\\/li>\\n<li>Fix: JS error is thrown when editing and saving global widgets<\\/li>\\n<li>Fix: <code>get_version<\\/code> API function may fail with Redis \\/ DB cache<\\/li>\\n<li>Fix: Multiple license check requests are created in certain cases<\\/li>\\n<li>Deprecated: Deprecate methods prefixed with an underscore and replace them with unprefixed methods<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-1-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.0.10 - 2021-01-20<\\/h4>\\n<ul>\\n<li>Tweak: Added Editing Handles string translation compatibility with Elementor v3.1.0<\\/li>\\n<\\/ul>\\n<h4>3.0.9 - 2020-12-29<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility to support Elementor 3.1.0<\\/li>\\n<li>Fix: Wrong phrasing of Import template success message in Theme Builder<\\/li>\\n<li>Fix: Border color glitch in Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.8 - 2020-11-26<\\/h4>\\n<ul>\\n<li>Fix: Navigation arrows UI glitch in Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13172\\\">#13172<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.0.7 - 2020-11-25<\\/h4>\\n<ul>\\n<li>Fix: Console Error when dragging  Testimonials Carousel widget<\\/li>\\n<li>Fix: Arrows of Testimonial and Reviews Carousel widgets navigate to the wrong direction in RTL websites<\\/li>\\n<li>Fix: Removed the conditional loading of Webpack<\\/li>\\n<li>Fix: Fatal error is thrown after deleting an associated custom taxonomy when Posts widget with Cards skin has a badge<\\/li>\\n<li>Fix: Upload JSON files only when the user allowed to prevent security issues<\\/li>\\n<li>Fix: Gallery not displayed in Theme Builder templates preview<\\/li>\\n<\\/ul>\\n<h4>3.0.6 - 2020-11-04<\\/h4>\\n<ul>\\n<li>Tweak: Updated the embedded post in Facebook Embed widget<\\/li>\\n<li>Fix: Minor UI glitches in Theme Builder\'s conditions screen footer<\\/li>\\n<li>Fix: Template type changes into Single Page after conditions change in Theme Builder<\\/li>\\n<li>Fix: Redundant Custom Caption option in Site Logo widget<\\/li>\\n<li>Fix: Removed unused code in Drip integration<\\/li>\\n<li>Fix: Removed Weibo and WeChat social networks due to website and links inactivity from Share Buttons widget<\\/li>\\n<li>Fix: Removed redundant code from Portfolio and Post Navigation widgets<\\/li>\\n<\\/ul>\\n<h4>3.0.5 - 2020-09-23<\\/h4>\\n<ul>\\n<li>Fix: If the default page layout is set to &quot;Canvas&quot; Headers and Footers cannot be edited<\\/li>\\n<li>Fix: Product Image Dynamic Tag throws an error when no image is set<\\/li>\\n<li>Fix: Missing Single document placeholder in Theme Builder<\\/li>\\n<li>Fix: Document editing handles inherit the <code>font-family<\\/code> from 3rd party source<\\/li>\\n<li>Fix: Can\'t add linebreaks to Textarea input when used as Multi Step Form<\\/li>\\n<li>Fix: Incorrect width in Facebook Page widget<\\/li>\\n<li>Fix: Added compatibility to allow the use of \'get_create_url\' in Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.4 - 2020-09-09<\\/h4>\\n<ul>\\n<li>Fix: Autogenerated screenshots appear in WP Media Library modal (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12304\\\">#12304<\\/a>)<\\/li>\\n<li>Fix: Make sure Elementor Posts widget Pagination doesn\'t interfere with 3rd party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12127\\\">#12127<\\/a>)<\\/li>\\n<li>Fix: Shrinking conditions indicator in Theme Builder<\\/li>\\n<li>Fix: Column can\'t be dragged and dropped if it populates a Global widget<\\/li>\\n<li>Fix: Styles are missing from Single templates in some edge cases<\\/li>\\n<\\/ul>\\n<h4>3.0.3 - 2020-09-02<\\/h4>\\n<ul>\\n<li>Fix: Pagination doesn\'t work in WordPress 5.5 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12127\\\">#12127<\\/a>)<\\/li>\\n<li>Fix: Change delete template action to &quot;Move to Trash&quot; in the new Theme Builder view<\\/li>\\n<\\/ul>\\n<h4>3.0.2 - 2020-08-31<\\/h4>\\n<ul>\\n<li>Tweak: Replaced WordPress &quot;Learn More&quot; links with dynamic links for better control over time (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12312\\\">#12312<\\/a>)<\\/li>\\n<li>Tweak: UI tweaks to the Conditions screen In the new Theme Builder<\\/li>\\n<li>Fix: Motion Effects not working when assigned to a column and throws JS error when DOM optimization is disabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12299\\\">#12299<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12275\\\">#12275<\\/a>)<\\/li>\\n<li>Fix: Multiple Galleries display all the images in the Lightbox slideshow (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11809\\\">#11809<\\/a>)<\\/li>\\n<li>Fix: Old Theme Builder is being opened when accessing through the Finder<\\/li>\\n<li>Fix: Mixed templates import glitch in Theme Builder<\\/li>\\n<li>Fix: Card icon sizes in Theme Builder<\\/li>\\n<li>Fix: Preview button leads to <code>render_mode<\\/code> instead of preview when importing a template from the new Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.1 - 2020-08-26<\\/h4>\\n<ul>\\n<li>Tweak: Keep previous Theme Builder when accessing from the WP Dashboard for legacy support<\\/li>\\n<li>Tweak: Updated video tutorials in Theme Builder<\\/li>\\n<li>Tweak: Don\'t show auto-screenshots in the Media Library (Props <a href=\\\"https:\\/\\/github.com\\/black-eye\\\">@black-eye<\\/a>)<\\/li>\\n<li>Fix: Repeater items throws <code>childView<\\/code> is undefined message in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12239\\\">#12239<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12221\\\">#12221<\\/a>)<\\/li>\\n<li>Fix: Misspelling of the word &quot;occurred&quot; in Form widget default error message (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12137\\\">#12137<\\/a>)<\\/li>\\n<li>Fix: Facebook comments not showing up (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12157\\\">#12157<\\/a>)<\\/li>\\n<li>Fix: Check for conflicts in Theme Builder doesn\'t work properly<\\/li>\\n<li>Fix: Minor UI fixes in Theme Builder<\\/li>\\n<li>Fix: Dark mode glitches in Theme Builder<\\/li>\\n<li>Fix: Global Site Part toaster appears when you publish a Popup<\\/li>\\n<li>Fix: Site Parts aren\'t in the correct order in Theme Builder<\\/li>\\n<li>Fix: Date field caused forms to get corrupted in Forms widget<\\/li>\\n<li>Fix: Theme Builder application page is forbidden<\\/li>\\n<\\/ul>\\n<h4>3.0.0 - 2020-08-23<\\/h4>\\n<ul>\\n<li>New: Introducing the new and improved Theme Builder<\\/li>\\n<li>Tweak: Removed <code>.elementor-inner<\\/code> and <code>.elementor-column-wrap<\\/code> from DOM output to improve performance (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7351\\\">#7351<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7817\\\">#7817<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/dom-improvements-ahead-html-wrappers-removal-from-v3-0\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added contextual anchors ID support to Table of Contents widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10052\\\">#10052<\\/a>)<\\/li>\\n<li>Tweak: Added WeChat and Weibo social networks to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11554\\\">#11554<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities for Redirect after Login\\/Logout in Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11343\\\">#11343<\\/a>)<\\/li>\\n<li>Tweak: Added Blend Mode and CSS Filters controls to adjust the Background Overlay in Flipbox widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11653\\\">#11653<\\/a>)<\\/li>\\n<li>Tweak: Added responsive capabilities to Toggle Button styling in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8269\\\">#8269<\\/a>)<\\/li>\\n<li>Tweak: Added responsive Text Alignment control in Call to Action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11968\\\">#11968<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic content to Ribbon element in Call to Action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10364\\\">#10364<\\/a>)<\\/li>\\n<li>Tweak: Converted uses of Color and Typography Schemes to Global Colors and Fonts<\\/li>\\n<li>Tweak: Separated Title and Description control fields labels in Call to Action widget<\\/li>\\n<li>Tweak: Removed unnecessary style in WC Product with variations<\\/li>\\n<li>Tweak: Converted Portfolio, Posts and Share Buttons widgets to use CSS Variable-based Elementor Grid (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-dropping-support-ie\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added Date Modified option to Posts widget metadata<\\/li>\\n<li>Fix: PHP 7.4 compatibility to Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11355\\\">#11355<\\/a>)<\\/li>\\n<li>Fix: Divider alignment issue in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11628\\\">#11628<\\/a>)<\\/li>\\n<li>Fix: Color doesn\\u2019t change in Products Archive Description widget<\\/li>\\n<li>Fix: WC Product variations layout breaks when using Variation Swatches plugin<\\/li>\\n<li>Fix: WC Product variations layout issue<\\/li>\\n<li>Fix: WC Product variations mobile zoom-in glitch<\\/li>\\n<li>Fix: Can\'t edit a Popup after accessing Theme Style<\\/li>\\n<li>Fix: Twitter icon missing in Blockquote widget<\\/li>\\n<li>Fix: Removed redundant default text color from Share Buttons minimal skin<\\/li>\\n<li>Fix: UI glitch in Display Conditions modal<\\/li>\\n<li>Fix: Insert template button UI glitch in Templates Library<\\/li>\\n<li>Fix: Added sanitization to post titles in WordPress dashboard for better security<\\/li>\\n<li>Fix: Show when arriving from search engines rule doesn\'t work in Popup<\\/li>\\n<li>Fix: Child categories are shown with a different parent category in Query control<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-0-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>2.10.3 - 2020-06-29<\\/h4>\\n<ul>\\n<li>Fix: Form not being submitted when using &quot;Progress Bar&quot; and &quot;None&quot; view types in Multi Step Form (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11596\\\">#11596<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11610\\\">#11610<\\/a>)<\\/li>\\n<li>Fix: Missing &quot;for&quot; attribute in Password field label in Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8646\\\">#8646<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.10.2 - 2020-06-16<\\/h4>\\n<ul>\\n<li>Fix: Run step events only when in Multi Step Form mode (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11644\\\">#11644<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.10.1 - 2020-06-16<\\/h4>\\n<ul>\\n<li>Tweak: Improved License validation mechanism to avoid limitations<\\/li>\\n<li>Tweak: Changed control labels and ordering in Price Table, Lottie and Form widgets<\\/li>\\n<li>Fix: Popup close button vertical position glitch (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10921\\\">#10921<\\/a>)<\\/li>\\n<li>Fix: Radio field placement glitch when in Multi Step mode in Form widget<\\/li>\\n<li>Fix: Clicking <code>Enter<\\/code> key submits the form in Multi Step Form<\\/li>\\n<li>Fix: Hardened sanitization in Custom Attributes to avoid security issues<\\/li>\\n<\\/ul>\\n<h4>2.10.0 - 2020-06-07<\\/h4>\\n<ul>\\n<li>New: Introducing Multi-Step Forms - Breakdown long forms into simple steps (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5975\\\">#5975<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3911\\\">#3911<\\/a>)<\\/li>\\n<li>New: Introducing Lottie widget - easily add Lottie animations to your site, no coding needed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11026\\\">#11026<\\/a>)<\\/li>\\n<li>Tweak: Added spacing option to Posts widget pagination (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5682\\\">#5682<\\/a>)<\\/li>\\n<li>Tweak: Changed texts and logic for administrator plugin renewal notices<\\/li>\\n<li>Tweak: Added new Scroll Util for improved scrolling handling<\\/li>\\n<li>Tweak: Improved Motion Effects animation performance<\\/li>\\n<\\/ul>\\n<h4>2.9.5 - 2020-05-24<\\/h4>\\n<ul>\\n<li>Fix: Added sanitization to Custom Attributes control to avoid security issue<\\/li>\\n<\\/ul>\\n<h4>2.9.4 - 2020-05-07<\\/h4>\\n<ul>\\n<li>Fix: Hardened user role that is allowed to upload icon sets and unzip only allowed files in Custom Icons to prevent security vulnerability<\\/li>\\n<\\/ul>\\n<h4>2.9.3 - 2020-04-19<\\/h4>\\n<ul>\\n<li>Fix: Form shortcode IDs are not wrapped in double-quotes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11023\\\">#11023<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10932\\\">#10932<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10967\\\">#10967<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11000\\\">#11000<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11049\\\">#11049<\\/a>)<\\/li>\\n<li>Fix: Escaped Form records metadata to prevent security vulnerability<\\/li>\\n<li>Fix: Closing &quot;Save Changes&quot; document confirmation modal causes Panel infinite loading<\\/li>\\n<li>Fix: Ken Burns effect not working when there is only one slide in Slides widget<\\/li>\\n<li>Fix: Document handles UI glitch<\\/li>\\n<\\/ul>\\n<h4>2.9.2 - 2020-03-25<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility with WordPress v5.4 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10745\\\">#10745<\\/a>)<\\/li>\\n<li>Fix: Image ratio number is displayed under the Archive Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10874\\\">#10874<\\/a>)<\\/li>\\n<li>Fix: Theme Style Link color setting overrides the Table of Content list style<\\/li>\\n<li>Fix: PHP notice when using dynamic user info <code>id<\\/code><\\/li>\\n<li>Fix: Navigation arrows direction is crossed on first drag in Slides Widget<\\/li>\\n<li>Fix: &quot;No headings were found on this page&quot; message was not displayed in the frontend in Table of Contents widget<\\/li>\\n<li>Fix: Container includes Popup tags by default in Table of Contents widget<\\/li>\\n<li>Fix: Twitter icon display issue when Font Awesome 4 support is disabled in Blockquote widget<\\/li>\\n<li>Fix: ACF Dynamic tag not working in Form widget Redirect action<\\/li>\\n<\\/ul>\\n<h4>2.9.1 - 2020-03-16<\\/h4>\\n<ul>\\n<li>Fix: Can\'t access Elementor Editor when there is Page Title widget in the page<\\/li>\\n<li>Fix: Applying styling to Post Content widget affects the Page and Post editing handles<\\/li>\\n<\\/ul>\\n<h4>2.9.0 - 2020-03-15<\\/h4>\\n<ul>\\n<li>New: Introducing Full Site Editing: Design header, footer, and content all in one place! (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4985\\\">#4985<\\/a>)<\\/li>\\n<li>New: Added Global Custom CSS for Your Entire Site in Theme Style (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3345\\\">#3345<\\/a>)<\\/li>\\n<li>New: Added Dynamic Colors tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6485\\\">#6485<\\/a>)<\\/li>\\n<li>Tweak: Added option to set the Site Part HTML Wrapper Tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9293\\\">#9293<\\/a>)<\\/li>\\n<li>Tweak: Added Link Attributes support to Pro widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5716\\\">#5716<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3642\\\">#3642<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9225\\\">#9225<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9079\\\">#9079<\\/a>)<\\/li>\\n<li>Tweak: Added Theme Style support in Theme Builder parts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10564\\\">#10564<\\/a>)<\\/li>\\n<li>Tweak: Avoid creating empty Custom Font<\\/li>\\n<li>Tweak: Added <code>aria-expanded<\\/code> attribute to Menu Cart widget<\\/li>\\n<li>Tweak: Moved Link Actions module to Core plugin<\\/li>\\n<li>Tweak: Changed the name of \\u201cTypeKit Web Fonts by Adobe\\u201d to \\u201cAdobe Fonts\\u201d<\\/li>\\n<li>Tweak: Removed redundant display conditions from Blockquote, Flipbox, Price Table, and Search Form widgets<\\/li>\\n<li>Tweak: Pro widgets are not draggable unless Elementor license has been activated<\\/li>\\n<li>Tweak: Remove redundant <code>label_block<\\/code> parameters from several controls<\\/li>\\n<li>Tweak: Converted controls selectors to CSS variables in Gallery widget<\\/li>\\n<li>Tweak: Replaced Stumbleupon with Mix in Reviews widget recommended icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10099\\\">#10099<\\/a>)<\\/li>\\n<li>Tweak: Added Mix to the Share Buttons network list (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10099\\\">#10099<\\/a>)<\\/li>\\n<li>Tweak: Added &quot;Open in new tab&quot; option to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7924\\\">#7924<\\/a>)<\\/li>\\n<li>Tweak: Upgraded Font Awesome Pro library to v5.12.0<\\/li>\\n<li>Tweak: Added new Lightbox compatibility for Gallery and Media Carousel widgets<\\/li>\\n<li>Tweak: Expose external API for Swiper instances<\\/li>\\n<li>Tweak: Added compatibility to JS API in Theme Builder, Popups, Form widget and Global widget<\\/li>\\n<li>Tweak: Replaced nerd icons with new Elementor emojis<\\/li>\\n<li>Tweak: Added specific <code>color<\\/code> attribute to header title in Table of Contents widget<\\/li>\\n<li>Fix: Line break issues in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10585\\\">#10585<\\/a>)<\\/li>\\n<li>Fix: Theme Style Link color overrides the Table of Content list style<\\/li>\\n<li>Fix: Active state glitches when using Table of contents widget with Sticky mode<\\/li>\\n<li>Fix: &quot;Graphic Element&quot; section appears as empty in case of unmarked Graphic Element in Call to Action widget<\\/li>\\n<li>Fix: Page Title widget render glitches in the Editor<\\/li>\\n<li>Fix: Image ratio parameter visible in some edge cases in Posts widget<\\/li>\\n<li>Fix: Image missing when sharing to Pinterest using Share Buttons widget<\\/li>\\n<li>Fix: Theme Style Link color setting override the list style in Table of Contents widget<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v2-9-0-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>2.8.5 - 2020-03-08<\\/h4>\\n<ul>\\n<li>Tweak: Added new Swiper parameter to all Pro carousels to allow 3rd party integration<\\/li>\\n<li>Fix: Missing closing bracket in Animated Headline widget<\\/li>\\n<li>Fix: Share buttons widgets show Font Awesome 4 icons on first drag in Editor<\\/li>\\n<\\/ul>\\n<h4>2.8.4 - 2020-02-16<\\/h4>\\n<ul>\\n<li>Tweak: Added Lightbox Title &amp; Description support to Gallery widget<\\/li>\\n<li>Tweak: Added RTL support for Slides widget<\\/li>\\n<li>Tweak: Display Lightbox images in Full size in Gallery widget<\\/li>\\n<li>Fix: Template with Slides widget not working properly when placed inside Tabs, Accordion and Toggle widget<\\/li>\\n<li>Fix: Dropdown menu lost styling after Elementor Pro v2.8 upgrade in Nav Menu widget<\\/li>\\n<li>Fix: Indent doesn\'t work on RTL websites in Table of Contents widget<\\/li>\\n<li>Fix: Query Control throws <code>Undefined index: q<\\/code> error<\\/li>\\n<li>Fix: Typography control not affecting dropdown menu in Nav Menu widget<\\/li>\\n<li>Fix: Discord forms integration fails to send submissions in some server configurations<\\/li>\\n<li>Fix: Rotating headlines don\'t align center in Animated Headline widget<\\/li>\\n<li>Fix: Custom secondary color displayed when not needed in Share buttons widget<\\/li>\\n<li>Fix: Motion Effects of certain objects are not functioning properly on Safari browser<\\/li>\\n<li>Fix: Missing eye icon in Single template footer preview button<\\/li>\\n<\\/ul>\\n<h4>2.8.3 - 2020-01-01<\\/h4>\\n<ul>\\n<li>Tweak: Updated Table of Contents widget panel location<\\/li>\\n<li>Fix: ACF URL Dynamic field throws <code>undefined index<\\/code> PHP notice (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9929\\\">#9929<\\/a>)<\\/li>\\n<li>Fix: Gallery lightbox pagination shows images from all tabs<\\/li>\\n<li>Fix: &quot;Reply To&quot; option not working in Form widget &quot;Email 2&quot; Action<\\/li>\\n<li>Fix: ACF Dynamic tag not working in Form widget Redirect action<\\/li>\\n<li>Fix: Underline option not working in Table of Contents widget Normal state<\\/li>\\n<li>Fix: Query Control <code>Undefined index: autocomplete<\\/code> notice in some cases<\\/li>\\n<li>Fix: Missing display condition to Read More Spacing control in Posts widget<\\/li>\\n<\\/ul>\\n<h4>2.8.2 - 2019-12-19<\\/h4>\\n<ul>\\n<li>Tweak: Improved scroll-spy and collapsing functionality in Table of Contents widget<\\/li>\\n<li>Fix: &quot;No products were found&quot; message not being displayed in an empty Products Archive<\\/li>\\n<li>Fix: Redundant <code>&lt;br&gt;<\\/code> tags in Single theme template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9927\\\">#9927<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9928\\\">#9928<\\/a>)<\\/li>\\n<li>Fix: Draft Popup shows up in Dynamic tag dropdown<\\/li>\\n<\\/ul>\\n<h4>2.8.1 - 2019-12-18<\\/h4>\\n<ul>\\n<li>Fix: Share Buttons widget not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9920\\\">#9920<\\/a>)<\\/li>\\n<li>Fix: Redundant <code>&lt;p&gt;<\\/code> tags added to Single Template posts<\\/li>\\n<\\/ul>\\n<h4>2.8.0 - 2019-12-18<\\/h4>\\n<ul>\\n<li>New: Table of Contents Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5171\\\">#5171<\\/a>)<\\/li>\\n<li>New: Added Font Awesome Pro Duotone font family support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9578\\\">#9578<\\/a>)<\\/li>\\n<li>Tweak: Added Lazy Load option to Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9763\\\">#9763<\\/a>)<\\/li>\\n<li>Tweak: Added Random order option to Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9269\\\">#9269<\\/a>)<\\/li>\\n<li>Tweak: Updated Font Awesome Pro to v5.11.2 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9578\\\">#9578<\\/a>)<\\/li>\\n<li>Tweak: Added preselect support for multiple default select values in Forms Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9324\\\">#9324<\\/a>)<\\/li>\\n<li>Tweak: Avoid duplicate queries for Custom Icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9579\\\">#9579<\\/a>)<\\/li>\\n<li>Tweak: Major performance improvements to Gallery widget<\\/li>\\n<li>Tweak: Avoid non-existing images in Gallery widget<\\/li>\\n<li>Tweak: Added <code>tabindex<\\/code>, <code>aria-expanded<\\/code>, <code>aria-hidden<\\/code> and <code>role=\\\"navigation\\\"<\\/code> accessibility attributes to Nav Menu widget<\\/li>\\n<li>Tweak: Changed button HTML tag from <code>button<\\/code> to <code>span<\\/code> in Call to Action and Flip Box widgets for better W3C compliance and accessibility<\\/li>\\n<li>Tweak: Removed Google+ from default networks in Share Buttons widget<\\/li>\\n<li>Tweak: Added compatibility for Library Connect<\\/li>\\n<li>Tweak: Added i18n to Toolset date dynamic tag<\\/li>\\n<li>Tweak: Added external link support to Gallery widget<\\/li>\\n<li>Tweak: Changed the link external attributes implementation to use <code>add_link_attributes()<\\/code> in Gallery widget<\\/li>\\n<li>Tweak: Updated references to the new Schemes system location<\\/li>\\n<li>Tweak: Avoid running Gallery handler when the gallery is empty<\\/li>\\n<li>Tweak: UI Tweaks in Editor Panel<\\/li>\\n<li>Tweak: Added responsive capabilities to Pointer Width control in Nav Menu widget<\\/li>\\n<li>Tweak: Added mobile support for responsive controls in Nav Menu widget<\\/li>\\n<li>Tweak: Refactor <code>register_controls()<\\/code> method in Posts widget skin trait<\\/li>\\n<li>Fix: ACF URL &quot;undefined Index&quot; notice (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7646\\\">#7646<\\/a>)<\\/li>\\n<li>Fix: WooCommerce Mini-Cart widget causes fatal error in edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9304\\\">#9304<\\/a>)<\\/li>\\n<li>Fix: <code>PHP Notice: Undefined index<\\/code> display for Author query (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9864\\\">#9864<\\/a>)<\\/li>\\n<li>Fix: Added compatibility for Button widget placed inside Swiper carousel (<a href=\\\"https:\\/\\/wordpress.org\\/support\\/topic\\/broken-buttons-since-elementor-2-8\\/\\\">Topic<\\/a>)<\\/li>\\n<li>Fix: Avoid empty spaces in Post info widget<\\/li>\\n<li>Tweak: Always show &quot;Custom label&quot; control in Login widget<\\/li>\\n<li>Fix: Nav Menu item typography selector in Nav Menu widget<\\/li>\\n<li>Fix: Facebook Like Button widget causes flickering<\\/li>\\n<li>Fix: WooCommerce mini-cart behaviour when using <code>plain<\\/code> permalinks format<\\/li>\\n<li>Fix: Avoid running Popup triggers when set without conditions<\\/li>\\n<li>Fix: Removed &quot;Date&quot; query from Products widget<\\/li>\\n<li>Fix: Slides widget when used as a Shortcode and is hidden<\\/li>\\n<li>Fix: Custom URL being accessed on swipe in Media Carousel<\\/li>\\n<li>Fix: Media Carousel widget Cube effect glitch<\\/li>\\n<li>Fix: Lightbox shows images from multiple Gallery widgets in the same page<\\/li>\\n<li>Fix: Image <code>alt<\\/code> Text not displayed on overlay in Gallery widget<\\/li>\\n<li>Fix: Gallery widget not visible in Posts widget Full Content skin<\\/li>\\n<li>Fix: WooCommerce mini-cart remove unnecessary hooks registration when WooCommerce integration set to <code>Disable<\\/code><\\/li>\\n<li>Fix: Slides widget button wrapping breaks in mobile view<\\/li>\\n<li>Fix: Dynamic capabilities with the Reviews widget<\\/li>\\n<li>Fix: Disabling autoplay doesn\'t work in Slides widget<\\/li>\\n<li>Fix: Posts widget Full Content skin not working on Single template<\\/li>\\n<li>Fix: Autocomplete not working for &quot;By Author&quot; condition in Display Conditions screen<\\/li>\\n<li>Fix: Posts widget alignment issue<\\/li>\\n<li>Fix: Product Variations Clear button not working in edge cases<\\/li>\\n<li>Fix: Styling issues in Form widget submit button<\\/li>\\n<\\/ul>\\n<h4>2.7.3 - 2019-10-28<\\/h4>\\n<ul>\\n<li>Tweak: Added RTL support to Galleries widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9213\\\">#9213<\\/a>)<\\/li>\\n<li>Tweak: Added Custom Icons compatibility for WordPress 5.3<\\/li>\\n<li>Fix: Missing template function declaration causes fatal error in WC mini-cart widget<\\/li>\\n<li>Fix: Pause on hover doesn\'t work in Carousel widgets<\\/li>\\n<li>Fix: Link-actions conflict with <code>?action=<\\/code> parameter in the URL<\\/li>\\n<li>Fix: Lightbox navigation not working in Gallery widget Single mode<\\/li>\\n<li>Fix: Ken burns effect not working on the 1st slide if Infinite Loop option is turned off in Carousel widgets<\\/li>\\n<li>Fix: Popup Advanced Rules detects internal links as external if current URL starts with <code>www<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.7.2 - 2019-10-06<\\/h4>\\n<ul>\\n<li>Fix: Slide Overlay not working when applying Ken burns effect in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9209\\\">#9209<\\/a>)<\\/li>\\n<li>Fix: Content width glitch in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Horizontal Alignment not working when applying custom style per slide in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Missing semicolon in Custom Fonts <code>font-display<\\/code> CSS<\\/li>\\n<\\/ul>\\n<h4>2.7.1 - 2019-09-26<\\/h4>\\n<ul>\\n<li>Fix: Background Overlay layer is over the slide content in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Duplicate images under &quot;All&quot; filter in Multiple Gallery<\\/li>\\n<\\/ul>\\n<h4>2.7.0 - 2019-09-24<\\/h4>\\n<ul>\\n<li>New: Enhanced Galleries widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1898\\\">#1898<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3103\\\">#3103<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4279\\\">#4279<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7631\\\">#7631<\\/a>)<\\/li>\\n<li>New: Dynamic Number (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5952\\\">#5952<\\/a>)<\\/li>\\n<li>New: Full content skin for Posts and Archive-posts widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4617\\\">#4617<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic number capability to Price List, Price Table, Counter, Star Rating, Progress Bar widgets<\\/li>\\n<li>Tweak: Added tags support to forms Mailchimp action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5418\\\">#5418<\\/a>)<\\/li>\\n<li>Tweak: User Profile Picture Dynamic Tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7947\\\">#7947<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8740\\\">#8740<\\/a>)<\\/li>\\n<li>Tweak: Added <code>font-display<\\/code> support to custom fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5993\\\">#5993<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-pro-2-7-custom-fonts-font-display-support\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added Text Shadow control to Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8800\\\">#8800<\\/a>)<\\/li>\\n<li>Tweak: Added Re-subscribe support to MailerLite (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8799\\\">#8799<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Facebook Embed widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9030\\\">#9030<\\/a>)<\\/li>\\n<li>Tweak: Use <code>swiper.js<\\/code> instead of <code>slick.js<\\/code> in Slides widget (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-2-7-moving-sliders-from-slick-to-swiper\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/search_form\\/before_input<\\/code> action hook to Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5598\\\">#5598<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/search_form\\/after_input<\\/code> action hook to Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5598\\\">#5598<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic support for Custom field key (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7789\\\">#7789<\\/a>)<\\/li>\\n<li>Tweak: Increased expired license notice bar frequency<\\/li>\\n<li>Tweak: Changed the icon name of Slides widget<\\/li>\\n<li>Tweak: Added designated Finder\'s Icons for Custom icons &amp; Custom fonts<\\/li>\\n<li>Tweak: Use Ken Burns Effect as an external module<\\/li>\\n<li>Tweak: Remove Fontello conflicting CSS on import to Custom Icons sets<\\/li>\\n<li>Tweak: Editor Panel UI tweaks<\\/li>\\n<li>Tweak: Added DOM events on Popup show\\/hide (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-pro-2-7-popup-events\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added option to change the variations field width in Add to Cart widget<\\/li>\\n<li>Tweak: Use select control instead of select2 in Menu Cart widget<\\/li>\\n<li>Tweak: Added conditions to the tabs instead of to each control in Share Buttons widget<\\/li>\\n<li>Tweak: Added Typography controls to HTML field in Forms widget<\\/li>\\n<li>Tweak: Allow edit selected Font file in Custom Font<\\/li>\\n<li>Tweak: Changed reCAPTCHA v3 error message<\\/li>\\n<li>Tweak: Remove the &quot;Save as Global&quot; option on Global widget context menu<\\/li>\\n<li>Fix: Corrected selector for <code>removeControlSpinner()<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8790\\\">#8790<\\/a>)<\\/li>\\n<li>Fix: Slides widget navigation icons misplacement (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8533\\\">#8533<\\/a>)<\\/li>\\n<li>Fix: Horizontal Scrollbar when Slider widget is set to Full Width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8527\\\">#8527<\\/a>)<\\/li>\\n<li>Fix: Inconsistent behavior when &quot;Infinite Loop&quot; enabled with &quot;Autoplay&quot; in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6726\\\">#6726<\\/a>)<\\/li>\\n<li>Fix: Ken Burns effect on Chrome transition glitches (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1671\\\">#1671<\\/a>)<\\/li>\\n<li>Fix: Nothing found message shows up inside the columns set in Posts Archive widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7347\\\">#7347<\\/a>)<\\/li>\\n<li>Fix: Responsive UI glitch in Popup Conditions modal tabs<\\/li>\\n<li>Fix: Removed unnecessary divider in Call to Action widget<\\/li>\\n<li>Fix: Custom Add To Cart * button style (size, position and background color) when <code>quantity<\\/code> is enabled.<\\/li>\\n<li>Fix: Add support for Document\\/PageBase in Theme Builder (Core &gt;=2.7.0)<\\/li>\\n<li>Fix: Ampersand character breaks email link in Share Buttons widget<\\/li>\\n<li>Fix: Correct custom font attachment <code>mime-type<\\/code> to show uploaded Custom Fonts<\\/li>\\n<li>Fix: Mini-Cart not refreshing in Menu Cart widget<\\/li>\\n<li>Fix: Cart drawer not working when WC Subscriptions plugin is activated<\\/li>\\n<li>Fix:  Querying CPT with custom taxonomies does not show the taxonomies before saving<\\/li>\\n<li>Fix: Double rendering on change caused console error in Theme Builder\'s conditions screen<\\/li>\\n<li>Fix: Translations and Strings in Share Buttons widget<\\/li>\\n<li>Fix: Avoid using offset if the source is Manual selection in Query Control<\\/li>\\n<li>Fix: Form being submitted although reCAPTCHA v3 validation failed in Forms widget<\\/li>\\n<\\/ul>\\n<h4>2.6.5 - 2019-08-26<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.7<\\/li>\\n<li>Fix: Button style not working when <code>quantity<\\/code> is enabled in Custom Add To Cart widget<\\/li>\\n<li>Fix: Updated minified JS file fixed WhatsApp base URL in Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>2.6.4 - 2019-08-21<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.7<\\/li>\\n<li>Fix: Changed WhatsApp base URL in Share Buttons widget for cross-device compatibility<\\/li>\\n<li>Fix: Random slides order after several clicks on pagination in Testimonial Carousel widget<\\/li>\\n<\\/ul>\\n<h4>2.6.3 - 2019-08-18<\\/h4>\\n<ul>\\n<li>Fix: Core version rollback to <code>&gt;2.6.0<\\/code> causes a fatal error<\\/li>\\n<li>Fix: Duplicate images when slideshow skin is selected in Media Carousel lightbox<\\/li>\\n<li>Fix: Default bottom margin added to reCAPTCHA V3 badge<\\/li>\\n<li>Fix: Input glitch in reCAPTCHA V3 threshold settings<\\/li>\\n<\\/ul>\\n<h4>2.6.2 - 2019-07-30<\\/h4>\\n<ul>\\n<li>Tweak: Better accessibility support in Search Form widget<\\/li>\\n<li>Fix: UI glitched in Popup publish screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8616\\\">#8616<\\/a>)<\\/li>\\n<li>Fix: &quot;Child of Term&quot; and &quot;Any child of term&quot; conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8695\\\">#8695<\\/a>)<\\/li>\\n<li>Fix: Restored <code>library_widget_templates<\\/code> action hook for 3rd party compatibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8687\\\">#8687<\\/a>)<\\/li>\\n<li>Fix: Twitter Icon missing in Blockquote widget<\\/li>\\n<li>Fix: Form reCAPTCHA v3 badge position not working<\\/li>\\n<li>Fix: Renewal notice bar appears in wrong situations<\\/li>\\n<li>Fix: Draft Icon Set loads empty Icon Library<\\/li>\\n<\\/ul>\\n<h4>2.6.1 - 2019-07-24<\\/h4>\\n<ul>\\n<li>Fix: Query Control autocomplete not retrieving results (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8672\\\">#8672<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8661\\\">#8661<\\/a>)<\\/li>\\n<li>Fix: Price Table features section not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8660\\\">#8660<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.6.0 - 2019-07-23<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Icon sets - including Fontello, IcoMoon and Fontastic support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/110\\\">#110<\\/a>)<\\/li>\\n<li>New: Added Font Awesome 5 Pro integration including 5,300+ icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4430\\\">#4430<\\/a>)<\\/li>\\n<li>New: Added reCAPTCHA v3 integration to Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8213\\\">#8213<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6039\\\">#6039<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7165\\\">#7165<\\/a>)<\\/li>\\n<li>Tweak: Added Exit Animation for Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7063\\\">#7063<\\/a>)<\\/li>\\n<li>Tweak: Added ACF Dynamic tag support for archive pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5147\\\">#5147<\\/a>)<\\/li>\\n<li>Tweak: Added Navigator Indicators for Custom CSS &amp; Motion Effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2180\\\">#2180<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities for Form Redirect action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7552\\\">#7552<\\/a>)<\\/li>\\n<li>Tweak: Added Logged In Message styling options for Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7928\\\">#7928<\\/a>)<\\/li>\\n<li>Tweak: Added <code>none<\\/code> breakpoint option to Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7916\\\">#7916<\\/a>)<\\/li>\\n<li>Tweak: Added option to place Post Terms dynamic tag without links (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8366\\\">#8366<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor\\/query\\/query_results<\\/code> hook to Query Control to allow full control over results (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7912\\\">#7912<\\/a>)<\\/li>\\n<li>Tweak: Allow choosing Heading HTML tag in Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8090\\\">#8090<\\/a>)<\\/li>\\n<li>Tweak: Show popup on dynamic click even when <code>Avoid Multiple Popups<\\/code> option is selected (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8189\\\">#8189<\\/a>)<\\/li>\\n<li>Tweak: Added condition option to all of archive child pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8256\\\">#8256<\\/a>)<\\/li>\\n<li>Tweak: Added <code>Effects Relative To<\\/code> control to Scrolling Effects<\\/li>\\n<li>Tweak: Allow shortcodes in HTML Form field<\\/li>\\n<li>Tweak: Removed donReach integration from Share Buttons widget due to service inconsistent stability<\\/li>\\n<li>Tweak: Changed MailChimp <code>List<\\/code> label to <code>Audience<\\/code><\\/li>\\n<li>Tweak: Improved Entrance and Exit animation behavior in Popup<\\/li>\\n<li>Tweak: Added <code>Deprecated Notice<\\/code> control to <code>Archive Products<\\/code> and <code>Woo Products<\\/code> widgets<\\/li>\\n<li>Tweak: Added default dynamic title for archives in Theme Builder<\\/li>\\n<li>Tweak: Added condition to show <code>Centered Slides<\\/code> control in Media Carousel widget<\\/li>\\n<li>Tweak: Added notice bar in the Editor when the license is expired or not activated<\\/li>\\n<li>Tweak: Replaced <code>select<\\/code> control with <code>choose<\\/code> control in Price List widget<\\/li>\\n<li>Tweak: Removed Font Awesome 4 dependencies from the Editor<\\/li>\\n<li>Tweak: Minor styling tweaks in the Popup publish modal<\\/li>\\n<li>Tweak: Hide ordering form in Products widget on front page<\\/li>\\n<li>Tweak: Removed page title markup when \'Hide Title\' is active<\\/li>\\n<li>Tweak: Added style controls for HTML field in Form widget<\\/li>\\n<li>Fix: Form widget Date picker makes the Popup builder disappear (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7240\\\">#7240<\\/a>)<\\/li>\\n<li>Fix: Sticky element stop point stops working on viewport resize (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7884\\\">#7884<\\/a>)<\\/li>\\n<li>Fix: Copy-Paste style not pasting the Pointer option in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8497\\\">#8497<\\/a>)<\\/li>\\n<li>Fix: Missing Print icon in Share Buttons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8506\\\">#8506<\\/a>)<\\/li>\\n<li>Fix: UI style glitch in Blockquote widget when viewing from iPad<\\/li>\\n<li>Deprecated: <code>DB::save_editor()<\\/code> - Remove usage of this method (<a href=\\\"https:\\/\\/developers.elementor.com\\/v2-6-0-planned-deprecations\\/\\\">Deprecation Post<\\/a>)<\\/li>\\n<li>Deprecated: <code>DB::get_plain_editor()<\\/code> - Remove usage of this method (<a href=\\\"https:\\/\\/developers.elementor.com\\/v2-6-0-planned-deprecations\\/\\\">Deprecation Post<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.14 - 2019-07-14<\\/h4>\\n<ul>\\n<li>Fix: Better WC Related Product grid support to various themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8555\\\">#8555<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.13 - 2019-07-11<\\/h4>\\n<ul>\\n<li>Fix: Better WC grid support to various themes<\\/li>\\n<\\/ul>\\n<h4>2.5.12 - 2019-07-10<\\/h4>\\n<ul>\\n<li>Fix: Grid for WooCommerce Archive Product widget<\\/li>\\n<li>Fix: Remove redundant <code>whitespace<\\/code> CSS property causes style glitch in iPad<\\/li>\\n<li>Tweak: Added more compatibility for Elementor v2.6<\\/li>\\n<\\/ul>\\n<h4>2.5.11 - 2019-07-02<\\/h4>\\n<ul>\\n<li>Fix: Close icon missing from Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8460\\\">#8460<\\/a>)<\\/li>\\n<li>Fix: Elementor Pro v2.5.10 shows PHP notice regarding notice bar (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8461\\\">#8461<\\/a>)<\\/li>\\n<li>Fix: Fatal error when deleting used Pods fields (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8396\\\">#8396<\\/a>)<\\/li>\\n<li>Fix: Missing dropdown icon in conditions screen<\\/li>\\n<\\/ul>\\n<h4>2.5.10 - 2019-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.6<\\/li>\\n<li>Tweak: Error caused by empty Rows &amp; Columns values in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8261\\\">#8261<\\/a>)<\\/li>\\n<li>Fix: Do not unset <code>product<\\/code> CPT if it\'s not from WooCommerce (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8160\\\">#8160<\\/a>)<\\/li>\\n<li>Fix: Column Spacing not working in WooCommerce Archive Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8285\\\">#8285<\\/a>)<\\/li>\\n<li>Fix: Title styling not working in Products Categories widget<\\/li>\\n<li>Fix: Empty value in Dynamic Pods Gallery dropdown using Safari browser<\\/li>\\n<li>Fix: WooCommerce archives included in &quot;All Archives&quot; condition<\\/li>\\n<\\/ul>\\n<h4>2.5.9 - 2019-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Removed <code>auto-confirm<\\/code> control from MailPoet to support new version of MailPoet<\\/li>\\n<li>Fix: Multiple Custom Fonts not rendered in the editor<\\/li>\\n<li>Fix: Products <code>sale<\\/code> query - handle exclude by manual selection.<\\/li>\\n<li>Fix: Product Categories grid row &amp; column style<\\/li>\\n<li>Fix: Form integration AJAX cache override<\\/li>\\n<li>Fix: Removed redundant CSS on Canvas &amp; Header-Footer page templates<\\/li>\\n<\\/ul>\\n<h4>2.5.8 - 2019-05-06<\\/h4>\\n<ul>\\n<li>Fix: Popup entrance animation not working in frontend<\\/li>\\n<li>Fix: Popup Exit Intent trigger activated multiple times<\\/li>\\n<\\/ul>\\n<h4>2.5.7 - 2019-05-05<\\/h4>\\n<ul>\\n<li>Fix: Embedded video keeps playing after a Popup is closed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7875\\\">#7875<\\/a>)<\\/li>\\n<li>Fix: Maximum call stack size exceeded error in Safari (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7824\\\">#7824<\\/a>)<\\/li>\\n<li>Fix: Entrance animations not appearing on Popup reopen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7395\\\">#7395<\\/a>)<\\/li>\\n<li>Fix: WC variations select style glitch in several themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8008\\\">#8008<\\/a>)<\\/li>\\n<li>Fix: Theme Builder taxonomy conditions not retrieving proper results in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.5.6 - 2019-04-29<\\/h4>\\n<ul>\\n<li>Tweak: Removed <code>Shortcode<\\/code> dynamic from Image, Gallery and Media control<\\/li>\\n<li>Fix: Popup not inheriting entrance animation in responsive mode (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7809\\\">#7809<\\/a>)<\\/li>\\n<li>Fix: Terms autocomplete retrieves wrong results in Query Control<\\/li>\\n<li>Fix: Query Control Related by author glitches in edge cases<\\/li>\\n<li>Fix: Query Control using terms for Products widget<\\/li>\\n<li>Fix: Posts cards style glitch in small screens<\\/li>\\n<li>Fix: Display conditions delete icon missing in small screens<\\/li>\\n<li>Fix: Avoid rendering Menu Cart widget in WordPress native editor<\\/li>\\n<\\/ul>\\n<h4>2.5.5 - 2019-04-08<\\/h4>\\n<ul>\\n<li>Tweak: Allow text selection inside a Popup<\\/li>\\n<li>Fix: Added backwards compatibility for <code>tax_query<\\/code> in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7751\\\">#7751<\\/a>)<\\/li>\\n<li>Fix: Missing arguments for <code>widget_title<\\/code> filter (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7745\\\">#7745<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.4 - 2019-04-03<\\/h4>\\n<ul>\\n<li>Fix: Move Query from using <code>term_id<\\/code> to <code>term_taxonomy_id<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7653\\\">#7653<\\/a>)<\\/li>\\n<li>Fix: Offset manipulation hook removal in Query control<\\/li>\\n<li>Fix: Missing form field <code>ID<\\/code> in some edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7711\\\">#7711<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7660\\\">#7660<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.3 - 2019-03-31<\\/h4>\\n<ul>\\n<li>Tweak: Updated Google Calendar dynamic tag URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7673\\\">#7673<\\/a>)<\\/li>\\n<li>Fix: Missing form field names (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7651\\\">#7651<\\/a>)<\\/li>\\n<li>Fix: PHP 5.4 backward compatibility in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7633\\\">#7633<\\/a>)<\\/li>\\n<li>Fix: <code>products_deprecated<\\/code> Query Control module compatibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7654\\\">#7654<\\/a>)<\\/li>\\n<li>Fix: Changed query method from <code>term_id<\\/code> to <code>term_taxonomy_id<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7653\\\">#7653<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.2 - 2019-03-27<\\/h4>\\n<ul>\\n<li>Fix: Overwrite parent widget type in Global Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7632\\\">#7632<\\/a>)<\\/li>\\n<li>Fix: Avoid Duplicates option not working in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7635\\\">#7635<\\/a>)<\\/li>\\n<li>Fix: Manual Selection option not working in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7634\\\">#7634<\\/a>)<\\/li>\\n<li>Fix: Incorrect condition caused handlers issues inside popup<\\/li>\\n<\\/ul>\\n<h4>2.5.1 - 2019-03-26<\\/h4>\\n<ul>\\n<li>Fix: Query Control invalid call to deprecated action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7619\\\">#7619<\\/a>)<\\/li>\\n<li>Tweak: Renamed action hook from <code>elementor_pro\\/{$widget_name}\\/query\\/{$query_id}<\\/code> to <code>elementor\\/query\\/{$query_id}<\\/code><\\/li>\\n<li>Tweak: Renamed filter hook from <code>elementor_pro\\/query_control\\/get_query_args\\/current_query<\\/code> to <code>elementor\\/query\\/get_query_args\\/current_query<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.5.0 - 2019-03-26<\\/h4>\\n<ul>\\n<li>New: Introducing Motion Effects including Scrolling &amp; Mouse effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/72\\\">#72<\\/a>)<\\/li>\\n<li>New: Introducing Related Posts for Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7306\\\">#7306<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7490\\\">#7490<\\/a>)<\\/li>\\n<li>New: Introducing Date query for Query Control<\\/li>\\n<li>New: Introducing Sticky Posts support for Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2501\\\">#2501<\\/a>)<\\/li>\\n<li>Tweak: Added option to open a Popup by a custom selector (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6871\\\">#6871<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6876\\\">#6876<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7258\\\">#7258<\\/a>)<\\/li>\\n<li>Tweak: Option to count when Popup is closed in &quot;Show up to X times&quot; Advanced Rule<\\/li>\\n<li>Tweak: Added full border radius control options inside Popup<\\/li>\\n<li>Tweak: Changed exit intent icon in Popups<\\/li>\\n<li>Tweak: Show only one popup in its own preview<\\/li>\\n<li>Tweak: Added responsive support to Popup entrance animation control<\\/li>\\n<li>Tweak: Conditions - Singular <code>All Pages<\\/code> string changed to <code>Pages<\\/code><\\/li>\\n<li>Tweak: Added form field shortcode support for Drip tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7000\\\">#7000<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities to Price List widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7258\\\">#7258<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Custom Attributes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6779\\\">#6779<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities to Flip Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6986\\\">#6986<\\/a>)<\\/li>\\n<li>Tweak: Decrease <code>z-index<\\/code> for Nav Menu (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6869\\\">#6869<\\/a>)<\\/li>\\n<li>Tweak: Changed &quot;Scrolling Effects&quot; section label to &quot;Motion Effects&quot;<\\/li>\\n<li>Tweak: Use filter <code>get_meta_viewport<\\/code> for header templates (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7043\\\">#7043<\\/a>)<\\/li>\\n<li>Tweak: use filterable <code>Util::get_public_post_types()<\\/code> in Theme Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7172\\\">#7172<\\/a>)<\\/li>\\n<li>Tweak: Added Cloudflare rocket-loader support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7443\\\">#7443<\\/a>)<\\/li>\\n<li>Tweak: Added responsive support to WC Products Columns &amp; Rows Gap controls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6913\\\">#6913<\\/a>)<\\/li>\\n<li>Tweak: WC Menu cart &quot;View Cart&quot; &amp; &quot;Checkout&quot; buttons styling<\\/li>\\n<li>Fix: Custom ID reset to default when dragging repeater<\\/li>\\n<li>Fix: Conflict between archive-products widget and WC customizer<\\/li>\\n<li>Fix: Add to Cart widget <code>spacing<\\/code> and <code>space-between<\\/code><\\/li>\\n<li>Fix: Library view when creating a new Header or Footer<\\/li>\\n<li>Fix: Post types labels missing on Add New Template modal<\\/li>\\n<\\/ul>\\n<h4>2.4.8 - 2019-03-11<\\/h4>\\n<ul>\\n<li>Fix: Missing query section in Products widget<\\/li>\\n<li>Fix: Missing Taxonomy controls in Products widget in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.4.7 - 2019-03-06<\\/h4>\\n<ul>\\n<li>Fix: Compatibility Global Widget with Elementor v2.5.0+<\\/li>\\n<\\/ul>\\n<h4>2.4.6 - 2019-03-04<\\/h4>\\n<ul>\\n<li>Fix: Pods gallery dynamic when empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7127\\\">#7127<\\/a>)<\\/li>\\n<li>Fix: Duplicate call for conditions screen issue<\\/li>\\n<li>Fix: Compatibility with Elementor v2.5.0<\\/li>\\n<\\/ul>\\n<h4>2.4.5 - 2019-02-18<\\/h4>\\n<ul>\\n<li>Fix: Image size issue in Testimonial Carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7058\\\">#7058<\\/a>)<\\/li>\\n<li>Fix: MailChimp groups not saved in a form integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7083\\\">#7083<\\/a>)<\\/li>\\n<li>Fix: Show popup preview only on it\'s own preview<\\/li>\\n<li>Fix: Elementor dashboard templates URL corrupted links in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.4.4 - 2019-02-11<\\/h4>\\n<ul>\\n<li>Tweak: Added ACF Date Time Picker field support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6690\\\">#6690<\\/a>)<\\/li>\\n<li>Tweak: Changed the term of <code>All Posts<\\/code> condition to <code>Posts<\\/code><\\/li>\\n<li>Fix: Added <code>&lt;IfModule&gt;<\\/code> to avoid 500 error when <code>mod-headers<\\/code> is missing (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7034\\\">#7034<\\/a>)<\\/li>\\n<li>Fix: Include post CSS deletion in Global Widget update (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6856\\\">#6856<\\/a>)<\\/li>\\n<li>Fix: <code>Textarea<\\/code> default value in Forms Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6934\\\">#6934<\\/a>)<\\/li>\\n<li>Fix: MailPoet latest version caused fatal error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6996\\\">#6996<\\/a>)<\\/li>\\n<li>Fix: Fatal Error caused by calling MailPoet deleted method<\\/li>\\n<li>Notice: MailPoet <code>Auto Confirm<\\/code> option will now default to &quot;On&quot;<\\/li>\\n<\\/ul>\\n<h4>2.4.3 - 2019-01-30<\\/h4>\\n<ul>\\n<li>Fix: Custom Add to Cart widget responsive alignment settings<\\/li>\\n<li>Fix: Links in Post Info widget<\\/li>\\n<li>Fix: WooCommerce <code>View Cart<\\/code> string translate<\\/li>\\n<li>Fix: Wrapper classes for header\\/footer templates (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6884\\\">#6884<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.4.2 - 2019-01-25<\\/h4>\\n<ul>\\n<li>Tweak: Added pixel units to Close Button position control in Popups<\\/li>\\n<li>Fix: Exclude error in WC Products widget<\\/li>\\n<\\/ul>\\n<h4>2.4.1 - 2019-01-24<\\/h4>\\n<ul>\\n<li>Tweak: Added CSS classes control to Popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6826\\\">#6826<\\/a>)<\\/li>\\n<li>Tweak: Added responsive image size to Testimonial Carousel widget<\\/li>\\n<li>Fix: PHP warning when Toolset Date dynamic is empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6842\\\">#6842<\\/a>)<\\/li>\\n<li>Fix: Support of exclude-ids in WC Products widget<\\/li>\\n<li>Fix: Popup close button not clickable<\\/li>\\n<li>Fix: Alignment justify issue of Add to Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6749\\\">#6749<\\/a>)<\\/li>\\n<li>Fix: Bad anchors breaks the page JS<\\/li>\\n<li>Fix: Popup overlay shown when turned off<\\/li>\\n<\\/ul>\\n<h4>2.4.0 - 2019-01-21<\\/h4>\\n<ul>\\n<li>New: Introducing Popup Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/628\\\">#628<\\/a>)<\\/li>\\n<li>New: Added <code>Popup<\\/code> Dynamic Tag<\\/li>\\n<li>New: Added <code>Popup<\\/code> forms action after submit<\\/li>\\n<li>New: Added User Info dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6322\\\">#6322<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for &quot;Nothing Found&quot; message<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/theme_builder\\/archive\\/escape_nothing_found_message<\\/code> Filter to avoid HTML escaping in &quot;Nothing Found&quot; message (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6053\\\">#6053<\\/a>)<\\/li>\\n<li>Tweak: Added <code>add_doc_to_location<\\/code> method to Allow insertion of a document to a location<\\/li>\\n<li>Fix: <code>z-index<\\/code> issue with CTA widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6486\\\">#6486<\\/a>)<\\/li>\\n<li>Fix: Hide the Post Content widget and show it only in a Single document<\\/li>\\n<li>Fix: <code>selector<\\/code> replacement in Custom CSS<\\/li>\\n<li>Fix: Apply <code>the_content<\\/code> on the real content only<\\/li>\\n<li>Fix: CSS for WC products selector (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6559\\\">#6559<\\/a>)<\\/li>\\n<li>Fix: Odnoklassniki share URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6638\\\">#6638<\\/a>)<\\/li>\\n<li>Fix: Custom link new tab in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5766\\\">#5766<\\/a>)<\\/li>\\n<li>Fix: <code>nofollow<\\/code> link in Flip Box &amp; CTA widgets<\\/li>\\n<li>Fix: Post Terms in Post Info widget<\\/li>\\n<li>Fix: Added screen reader to some icons &amp; buttons for better accessibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5386\\\">#5386<\\/a>)<\\/li>\\n<li>Fix: Accessibility labels in Reviews widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6630\\\">#6630<\\/a>)<\\/li>\\n<li>Fix: Link to cart page not working when WooCommerce Subscriptions is active<\\/li>\\n<li>Fix: MailChimp Selected list not showing on reloading in Form widget<\\/li>\\n<li>Fix: Sub-menu arrow position in Nav Menu widget<\\/li>\\n<li>Fix: Conflict with WP Security Audit Log plugin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6648\\\">#6648<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.3.1 - 2018-12-19<\\/h4>\\n<ul>\\n<li>Fix: Template widget search functionality (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6473\\\">#6473<\\/a>)<\\/li>\\n<li>Fix: Apply <code>the_content<\\/code> filter to post content in theme builder<\\/li>\\n<\\/ul>\\n<h4>2.3.0 - 2018-12-17<\\/h4>\\n<ul>\\n<li>New: Introducing Discord Integration for Forms (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4218\\\">#4218<\\/a>)<\\/li>\\n<li>New: Introducing Slack Integration for Forms<\\/li>\\n<li>New: Introducing MailerLite Integration for Forms (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4462\\\">#4462<\\/a>)<\\/li>\\n<li>New: Activate Elementor Pro plugin by connecting to Elementor account<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/utils\\/get_public_post_types<\\/code> filter hook (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5900\\\">#5900<\\/a>)<\\/li>\\n<li>Tweak: Added <code>loop_start<\\/code> &amp; <code>the_content<\\/code> hooks for Post Content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6173\\\">#6173<\\/a>)<\\/li>\\n<li>Tweak: Removed Custom Attributes from Page Settings<\\/li>\\n<li>Tweak: Always add the Custom CSS control to the Advanced tab<\\/li>\\n<li>Fix: In sub Term condition false positive in edge cases<\\/li>\\n<li>Fix: ToolSet Dynamic Image fallback<\\/li>\\n<li>Fix: Style glitch with the dropdown color in Nav Menu widget<\\/li>\\n<li>Fix: Style glitch in the Conditions screen in Safari browser<\\/li>\\n<li>Fix: Ribbon in the CTA widget obscures drop down menu (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6080\\\">#6080<\\/a>)<\\/li>\\n<li>Fix: The color of label won\'t change color in Widget login<\\/li>\\n<\\/ul>\\n<h4>2.2.5 - 2018-12-11<\\/h4>\\n<ul>\\n<li>New: Add Style Tab &amp; Custom CSS for Header &amp; Footer Templates.<\\/li>\\n<li>Tweak: Added a better identifier for subpages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6362\\\">#6362<\\/a>)<\\/li>\\n<li>Tweak: Removed Custom Attributes from page settings<\\/li>\\n<li>Fix: Yahoo event URL date issue (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6354\\\">#6354<\\/a>)<\\/li>\\n<li>Fix: Allow timezone settings in Google event URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6354\\\">#6354<\\/a>)<\\/li>\\n<li>Fix: Avoid <code>z-index<\\/code> changes by <code>nanocss<\\/code> in build process<\\/li>\\n<li>Fix: Added missing WC upsells products CSS<\\/li>\\n<li>Fix: Nav Menu dropdown losing color on hover<\\/li>\\n<li>Fix: WC Product Add-ons CSS compatibility<\\/li>\\n<\\/ul>\\n<h4>2.2.4 - 2018-12-04<\\/h4>\\n<ul>\\n<li>Fix: Global widget not saving changes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6340\\\">#6340<\\/a>)<\\/li>\\n<li>Fix: Dynamic tags support in Blockquote widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6334\\\">#6334<\\/a>)<\\/li>\\n<li>Fix: Forms Redirect URL action when using form field values with spaces<\\/li>\\n<\\/ul>\\n<h4>2.2.3 - 2018-11-29<\\/h4>\\n<ul>\\n<li>Fix: Missing &quot;Edit Template&quot; in Template widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6271\\\">#6271<\\/a>)<\\/li>\\n<li>Fix: Follow menu anchors with UTF8 characters in Nav Menu<\\/li>\\n<li>Fix: Show only supported templates in Template widget<\\/li>\\n<li>Fix: Revert conflicting fix for a default order for WC archive<\\/li>\\n<\\/ul>\\n<h4>2.2.2 - 2018-11-28<\\/h4>\\n<ul>\\n<li>Fix: Lightbox dynamic tag crashes the editor<\\/li>\\n<\\/ul>\\n<h4>2.2.1 - 2018-11-28<\\/h4>\\n<ul>\\n<li>New: Added <code>ACF File<\\/code> Dynamic tag to support text controls.<\\/li>\\n<li>Tweak: Added option to hide item count bubble when cart is empty in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6223\\\">#6223<\\/a>)<\\/li>\\n<li>Tweak: Added Actions group for Lightbox and Contact URL tags<\\/li>\\n<li>Tweak: Added filter <code>elementor_pro\\/dynamic_tags\\/shortcode\\/should_escape<\\/code> to avoid escaping in Shortcode dynamic tag<\\/li>\\n<li>Tweak: MailPoet3 integration allow Subscriber to to subscribe to multiple lists<\\/li>\\n<li>Tweak: Added front-end max file size validation for upload fields<\\/li>\\n<li>Tweak: Added <code>by-author<\\/code> per Post-Type condition for theme builder<\\/li>\\n<li>Fix: Template widget panel not showing the selected template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6271\\\">#6271<\\/a>)<\\/li>\\n<li>Fix: Conflict between ACF with Safari browser on Select option in Dynamic tag<\\/li>\\n<li>Fix: Add post classes only for the Single template<\\/li>\\n<li>Fix: Set document type as not editable for unsupported document like Global widget<\\/li>\\n<li>Fix: Avoid duplicate query for current WC product query<\\/li>\\n<li>Fix: Product Archive showing oldest products instead of latest<\\/li>\\n<li>Fix: CSS reset in Posts widget using cards skin<\\/li>\\n<\\/ul>\\n<h4>2.2.0 - 2018-11-19<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Attributes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/290\\\">#290<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3990\\\">#3990<\\/a>)<\\/li>\\n<li>New: Added evergreen option for Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4459\\\">#4459<\\/a>)<\\/li>\\n<li>New: Added expire actions option for Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5242\\\">#5242<\\/a>)<\\/li>\\n<li>New: Introducing Reviews widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3854\\\">#3854<\\/a>)<\\/li>\\n<li>New: Introducing Sitemap widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5594\\\">#5594<\\/a>)<\\/li>\\n<li>New: Added Request Parameter dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4934\\\">#4934<\\/a>)<\\/li>\\n<li>New: Added Shortcode dynamic tag<\\/li>\\n<li>New: Added Image and Video Lightbox dynamic tag<\\/li>\\n<li>New: Added Contact URL dynamic tag<\\/li>\\n<li>New: Added Featured Image Data dynamic tag<\\/li>\\n<li>New: Added default value to each field in the Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4268\\\">#4268<\\/a>)<\\/li>\\n<li>New: Added &quot;Any Child Of&quot; condition to template conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5321\\\">#5321<\\/a>)<\\/li>\\n<li>New: Added &quot;In Child&quot; condition to template conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5587\\\">#5587<\\/a>)<\\/li>\\n<li>Tweak: Added Form Redirect URL with form values (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2564\\\">#2564<\\/a>)<\\/li>\\n<li>Tweak: Added default post classes to template wrapper (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5959\\\">#5959<\\/a>)<\\/li>\\n<li>Tweak: Better labels for terms in Query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6092\\\">#6092<\\/a>)<\\/li>\\n<li>Tweak: Renamed &quot;Child Of&quot; templates condition to &quot;Direct Child Of&quot;<\\/li>\\n<li>Tweak: Added <code>elementor\\/theme\\/get_location_templates\\/condition_sub_id<\\/code> filter hook to allow template condition translations<\\/li>\\n<li>Tweak: Load the Template Library widget via Ajax for better performance<\\/li>\\n<li>Tweak: Added 404 page title for Page Title dynamic tag<\\/li>\\n<li>Fix: Menu Cart Toggle has # URL link (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6141\\\">#6141<\\/a>)<\\/li>\\n<li>Fix: Alignment issue in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5790\\\">#5790<\\/a>)<\\/li>\\n<li>Fix: Avoid potential security risk in forms<\\/li>\\n<li>Fix: Template By Author condition conflicts with 404 page<\\/li>\\n<li>Fix: Restored WC Product Content widget in Single Product template<\\/li>\\n<li>Fix: Theme Builder Preview URLs for date archives and 404 pages<\\/li>\\n<li>Fix: Highlight active menu anchor items only when scrolled into view<\\/li>\\n<li>Fix: Carousel Pagination Progress style to support new Swiper version<\\/li>\\n<\\/ul>\\n<h4>2.1.13 - 2018-11-12<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for new brand Finder in v2.3.0<\\/li>\\n<li>Fix: Settings conflict when there are multiple carousels in the page<\\/li>\\n<\\/ul>\\n<h4>2.1.12 - 2018-11-05<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.3<\\/li>\\n<li>Tweak: Better performance for Template Library widget<\\/li>\\n<li>Fix: Fatal error if a taxonomy used in a dynamic field is removed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6029\\\">#6029<\\/a>)<\\/li>\\n<li>Fix: Date Time dynamic tag now respect site language (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6001\\\">#6001<\\/a>)<\\/li>\\n<li>Fix: Custom CSS printed twice in the front-end<\\/li>\\n<li>Fix: ACF Image field PHP warning (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6051\\\">#6051<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.1.11 - 2018-10-22<\\/h4>\\n<ul>\\n<li>New: Added ACF local fields compatibility<\\/li>\\n<li>Tweak: Re-brand TypeKit by Adobe Fonts integration<\\/li>\\n<li>Fix: Exclude <code>is_embed<\\/code> from Singular condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5915\\\">#5915<\\/a>)<\\/li>\\n<li>Fix: Avoid conflict with Ad Blockers and Share Buttons<\\/li>\\n<li>Fix: Current date time dynamic tag now shows local time<\\/li>\\n<li>Fix: Avoid conflict with 3rd party plugins that filter the permalink<\\/li>\\n<li>Fix: Avoid PHP warning when no groups are selected for MailChimp integration<\\/li>\\n<li>Fix: Avoid PHP warning if checkbox field is empty for ACF<\\/li>\\n<li>Fix: Respect password protected for a WC single product template<\\/li>\\n<li>Fix: Respect <code>order<\\/code> settings for WC archive also without pagination<\\/li>\\n<\\/ul>\\n<h4>2.1.10 - 2018-10-09<\\/h4>\\n<ul>\\n<li>Tweak: Added responsive alignment control for Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5821\\\">#5821<\\/a>)<\\/li>\\n<li>Tweak: Added link control to Animated Headline widget<\\/li>\\n<li>Fix: Mobile nav menu jump on RTL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5711\\\">#5711<\\/a>)<\\/li>\\n<li>Fix: Responsive alignment control in Add to Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5830\\\">#5830<\\/a>)<\\/li>\\n<li>Fix: Added IE compatibility for Animated Headline widget<\\/li>\\n<li>Fix: Post Content widget is now shown only on <code>Single<\\/code> templates<\\/li>\\n<li>Fix: Query Control Pagination with offset<\\/li>\\n<\\/ul>\\n<h4>2.1.9 - 2018-09-17<\\/h4>\\n<ul>\\n<li>Tweak: Added Centered Slides option for Slideshow carousel<\\/li>\\n<li>Fix: Allow only public CPT for Manual Selection in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5091\\\">#5091<\\/a>)<\\/li>\\n<li>Fix: ACF Gallery option support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5344\\\">#5344<\\/a>)<\\/li>\\n<li>Fix: Page scrolling on resize when sticky is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5740\\\">#5740<\\/a>)<\\/li>\\n<li>Fix: Edit custom name for Global Widget in the Navigator (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5689\\\">#5689<\\/a>)<\\/li>\\n<li>Fix: Coverflow transition effect in Carousel<\\/li>\\n<li>Fix: Weird mobile behavior with Cube effect in Carousel<\\/li>\\n<li>Fix: Show the first thumbnail in the Slideshow carousel correctly<\\/li>\\n<\\/ul>\\n<h4>2.1.8 - 2018-09-12<\\/h4>\\n<ul>\\n<li>Tweak: Added styling options for WC Additional Information widget<\\/li>\\n<li>Tweak: Added styling options for \'View Cart\' link in Products widget<\\/li>\\n<li>Fix: 3rd party plugin support for WC single product template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5338\\\">#5338<\\/a>)<\\/li>\\n<li>Fix: Layout of Related Product widget with WC native style<\\/li>\\n<\\/ul>\\n<h4>2.1.7 - 2018-09-03<\\/h4>\\n<ul>\\n<li>New: WC Archive Description widget<\\/li>\\n<li>Tweak: Added blend mode to Slides widget background overlay (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5555\\\">#5555<\\/a>)<\\/li>\\n<li>Tweak: Added \'Current Subcategories\' option to Product Categories widget<\\/li>\\n<li>Fix: Added default vertical alignment in Author Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5589\\\">#5589<\\/a>)<\\/li>\\n<li>Tweak: Added more blend mode options for CTA widget<\\/li>\\n<li>Tweak: Improved plugin updater method based on WordPress version<\\/li>\\n<li>Fix: Improved IE compatibility for Posts and Portfolio widgets<\\/li>\\n<li>Fix: Added default gap for products pagination<\\/li>\\n<li>Fix: Post thumbnail flickering in Safari browser<\\/li>\\n<li>Fix: Close mobile nav menu on click only in full-width mode<\\/li>\\n<li>Fix: Added trailing slash to pagination links in Posts widget<\\/li>\\n<\\/ul>\\n<h4>2.1.6 - 2018-08-28<\\/h4>\\n<ul>\\n<li>New: WC Product Category Image widget and Dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5117\\\">#5117<\\/a>)<\\/li>\\n<li>Tweak: Allow HTML in Excerpt widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5491\\\">#5491<\\/a>)<\\/li>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.2<\\/li>\\n<li>Tweak: Deprecated Follow option in the Facebook Button widget<\\/li>\\n<li>Fix: Posts widget grid in Safari &amp; IE11 (Depended on Elementor v2.2)<\\/li>\\n<li>Fix: Posts widget CSS when using cards skin in masonry mode<\\/li>\\n<li>Fix: ACF Image &amp; ACF URL option support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5344\\\">#5344<\\/a>)<\\/li>\\n<li>Fix: WC product gallery links in RTL<\\/li>\\n<li>Fix: Dynamic tags in Call To Action widget<\\/li>\\n<\\/ul>\\n<h4>2.1.5 - 2018-08-21<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.2<\\/li>\\n<li>Fix: Posts Widget layout theme compatibility<\\/li>\\n<li>Fix: Added compatibility for WooCommerce native style<\\/li>\\n<\\/ul>\\n<h4>2.1.4 - 2018-08-19<\\/h4>\\n<ul>\\n<li>Fix: Layout issue compatibility with themes caused by v2.1 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5442\\\">#5442<\\/a>)<\\/li>\\n<li>Fix: Dynamic setting in Pricing Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5460\\\">#5460<\\/a>)<\\/li>\\n<li>Fix: Hide Target URL control if is not necessary in Blockquote widget<\\/li>\\n<li>Fix: Selector specificity for WooCommerce Products widget<\\/li>\\n<li>Fix: WooCommerce conflicts in the editor in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.1.3 - 2018-08-15<\\/h4>\\n<ul>\\n<li>Fix: Thumbnails in the Posts widget jumping (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5350\\\">#5350<\\/a>)<\\/li>\\n<li>Fix: Responsive grid in the Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5375\\\">#5375<\\/a>)<\\/li>\\n<li>Fix: Added missing <code>setup_postdata<\\/code> for Product Data Tabs widget<\\/li>\\n<li>Fix: Rollback to older version of Flip Box widget to resolve 3D depth issue (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5399\\\">#5399<\\/a>)<\\/li>\\n<li>Fix: Allowed types in the Upload File field are now case-insensitive (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5254\\\">#5254<\\/a>)<\\/li>\\n<li>Fix: Carousel behavior when using a single slide<\\/li>\\n<\\/ul>\\n<h4>2.1.2 - 2018-08-12<\\/h4>\\n<ul>\\n<li>Fix: Error when ACF Pro is not installed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5367\\\">#5367<\\/a>)<\\/li>\\n<li>Fix: Edge cases in Inspector where document is a boolean<\\/li>\\n<li>Fix: Edge cases for incorrect file fields in PODS<\\/li>\\n<\\/ul>\\n<h4>2.1.1 - 2018-08-09<\\/h4>\\n<ul>\\n<li>Fix: Highlighted text in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5345\\\">#5345<\\/a>)<\\/li>\\n<li>Fix: Flip Box effect issues<\\/li>\\n<li>Fix: ACF Options page fields support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5329\\\">#5329<\\/a>)<\\/li>\\n<li>Fix: Import Pro templates in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.1.0 - 2018-08-07<\\/h4>\\n<ul>\\n<li>New: Introducing WooCommerce Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1690\\\">#1690<\\/a>)<\\/li>\\n<li>New: Introducing 12 new dynamic tags &amp; widgets for WooCommerce: Gallery, Image, Price, Rating, Description, Breadcrumbs, Data Tabs, Stock, Related, Upsell, Title &amp; Archive<\\/li>\\n<li>New: Introducing Cart Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4220\\\">#4220<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4600\\\">#4600<\\/a>)<\\/li>\\n<li>New: Added integration with Toolset (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2949\\\">#2949<\\/a>)<\\/li>\\n<li>New: Added integration with Pods (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4129\\\">#4129<\\/a>)<\\/li>\\n<li>New: Added stick to bottom in scrolling effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4799\\\">#4799<\\/a>)<\\/li>\\n<li>New: Added Scrolling Effect to Widgets under advanced tab<\\/li>\\n<li>New: Introducing Internal URL Dynamic Tag<\\/li>\\n<li>Tweak: Added a Last Updated Date in the Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4597\\\">#4597<\\/a>)<\\/li>\\n<li>Tweak: Added Redirect after Logout option for Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4447\\\">#4447<\\/a>)<\\/li>\\n<li>Tweak: Avoid repeating posts when using more than one in the Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1878\\\">#1878<\\/a>)<\\/li>\\n<li>Tweak: Add Custom Query hook for Query control (<a href=\\\"https:\\/\\/developers.elementor.com\\/custom-query-filter\\/\\\">More Info<\\/a>) (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1748\\\">#1748<\\/a>)<\\/li>\\n<li>Tweak: Added form-message style (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1180\\\">#1180<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag for button on the Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4242\\\">#4242<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag for Call to action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4767\\\">#4767<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic Tags support for Google Map field (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4602\\\">#4602<\\/a>)<\\/li>\\n<li>Tweak: Added an support for <code>label|value<\\/code> in options field (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4594\\\">#4594<\\/a>)<\\/li>\\n<li>Tweak: Added <code>by-author<\\/code> condition for theme builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4681\\\">#4681<\\/a>)<\\/li>\\n<li>Tweak: Added Activate\\/Deactivate license key via WP-CLI command (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4149\\\">#4149<\\/a>)<\\/li>\\n<li>Tweak: Added <code>is_scroll<\\/code> trigger to scrolling effect (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4340\\\">#4340<\\/a>)<\\/li>\\n<li>Tweak: Added In Same Term support for Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4177\\\">#4177<\\/a>)<\\/li>\\n<li>Tweak: Added responsive control for Slides To Scroll control in all carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3697\\\">#3697<\\/a>)<\\/li>\\n<li>Tweak: Added style options for Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1335\\\">#1335<\\/a>)<\\/li>\\n<li>Tweak: Added button CSS ID for Forms widget<\\/li>\\n<li>Tweak: Added pixel units to Post-Info divider height control<\\/li>\\n<li>Tweak: Rewrite sticky library to handle with stretch section, auto scroller &amp; more bugs<\\/li>\\n<li>Tweak: Re-organize the panel categories per document type<\\/li>\\n<li>Tweak: Added ACF support for <code>options-page<\\/code> fields<\\/li>\\n<li>Tweak: Added dynamic tag for Animated headlines<\\/li>\\n<li>Tweak: Added dynamic tag for BlockQuote widget<\\/li>\\n<li>Fix: Elementor Full Width template in GeneratePress theme (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4817\\\">#4817<\\/a>)<\\/li>\\n<li>Fix: Checkbox fields can accidentally be set to required (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4324\\\">#4324<\\/a>)<\\/li>\\n<li>Fix: Initial slide in Carousel widget<\\/li>\\n<li>Fix: Stay on current slide while editing in Carousel widget<\\/li>\\n<li>Fix: Default slides per device in Carousel widget<\\/li>\\n<li>Deprecated: Woo Products, Woo Elements &amp; Single elements widgets<\\/li>\\n<\\/ul>\\n<h4>2.0.18 - 2018-07-27<\\/h4>\\n<ul>\\n<li>Fix: Global widget error on saving page<\\/li>\\n<\\/ul>\\n<h4>2.0.17 - 2018-07-26<\\/h4>\\n<ul>\\n<li>Fix: Sub menu indicator direction in Nav Menu widget<\\/li>\\n<li>Fix: Change the title and icon for Global Widget when is moving<\\/li>\\n<li>Fix: CSS wrapper selector for Page Document<\\/li>\\n<\\/ul>\\n<h4>2.0.16 - 2018-07-16<\\/h4>\\n<ul>\\n<li>Tweak: CSS Filter Control module is now included in Elementor<\\/li>\\n<li>Fix: Border gap in Portfolio widget when item gap set as <code>0<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5077\\\">#5077<\\/a>)<\\/li>\\n<li>Fix: Restore current query after get Global Widget data<\\/li>\\n<li>Fix: Add action item in History on unlink Global widget<\\/li>\\n<\\/ul>\\n<h4>2.0.15 - 2018-07-10<\\/h4>\\n<ul>\\n<li>Fix: Dropdown menu items collapsing when activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4996\\\">#4996<\\/a>)<\\/li>\\n<li>Fix: GMT offset in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4997\\\">#4997<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.0.14 - 2018-07-08<\\/h4>\\n<ul>\\n<li>Tweak: Added set method to form record for developers (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4983\\\">#4983<\\/a>)<\\/li>\\n<li>Fix: Autoplay option for Carousels<\\/li>\\n<li>Fix: Close mobile menu on item click in the Nav Menu widget<\\/li>\\n<\\/ul>\\n<h4>2.0.13 - 2018-07-03<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for Elementor v2.1<\\/li>\\n<\\/ul>\\n<h4>2.0.12 - 2018-07-02<\\/h4>\\n<ul>\\n<li>Fix: Global widget PHP notices<\\/li>\\n<li>Fix: Slides widget active slide lost focus when clicking Editor tabs<\\/li>\\n<li>Fix: Form select field send all selected values on multiple selection<\\/li>\\n<li>Fix: Validate time field only if it\'s not empty<\\/li>\\n<li>Fix: ConvertKit API not saving name field<\\/li>\\n<\\/ul>\\n<h4>2.0.11 - 2018-06-12<\\/h4>\\n<ul>\\n<li>Fix: Theme Builder <code>author<\\/code> archive condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4593\\\">#4593<\\/a>)<\\/li>\\n<li>Fix: Respect password protected posts in Post Content widget<\\/li>\\n<li>Fix: Custom Fonts redirect to post edit screen in edge cases.<\\/li>\\n<\\/ul>\\n<h4>2.0.10 - 2018-06-05<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>elementor\\/theme\\/get_location_templates\\/template_id<\\/code> filter hook for multi-language plugins<\\/li>\\n<li>Fix: Dynamic Post Terms missing taxonomies if the taxonomy is registered to more then one post types (#4386)<\\/li>\\n<li>Fix: Fields shortcode missing after removing a field in Form widget<\\/li>\\n<li>Deprecated: <code>get_theme_templates_by_location<\\/code> is replaced by <code>get_location_templates<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.0.9 - 2018-05-28<\\/h4>\\n<ul>\\n<li>Fix: Compatibility for PHP version 5.4<\\/li>\\n<\\/ul>\\n<h4>2.0.8 - 2018-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Added Active state for Nav Menu dropdown<\\/li>\\n<li>Tweak: Added style for &quot;Nothing Found&quot; Message for Archive Posts widget<\\/li>\\n<li>Tweak: Removed caption control in Site Logo widget<\\/li>\\n<li>Tweak: Added option to position currency symbol before\\/after In Price Table widget<\\/li>\\n<li>Fix: Query control manual selection does not show more than 10 items (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4479\\\">#4479<\\/a>)<\\/li>\\n<li>Fix: Styling glitch with terms list in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4342\\\">#4342<\\/a>)<\\/li>\\n<li>Fix: Sub terms missing in Query control in edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4527\\\">#4527<\\/a>)<\\/li>\\n<li>Fix: Avoid rendering a template if it\'s not published<\\/li>\\n<li>Fix: 404 Page style not working<\\/li>\\n<li>Fix: Price Table button with hover animation not working in editor<\\/li>\\n<li>Fix: Styling conflict in Call to Action widget<\\/li>\\n<li>Fix: Global Widget tab translation<\\/li>\\n<li>Fix: Adding parent wrapper class to Site Title widget<\\/li>\\n<\\/ul>\\n<h4>2.0.7 - 2018-05-16<\\/h4>\\n<ul>\\n<li>Fix: Content not found on section when single is set to &quot;All Singular&quot;<\\/li>\\n<li>Fix: Open 404 template library for 404 page<\\/li>\\n<li>Tweak: Added CSS prefix for dev files<\\/li>\\n<li>Tweak: Removed product post type from display conditions<\\/li>\\n<\\/ul>\\n<h4>2.0.6 - 2018-05-15<\\/h4>\\n<ul>\\n<li>Tweak: Set type on create new single template<\\/li>\\n<li>Tweak: Always show the conditions dialog in the Draft status<\\/li>\\n<li>Tweak: Added document type <code>widget<\\/code><\\/li>\\n<li>Tweak: Added Post Custom Field tag to URL category<\\/li>\\n<li>Fix: When ACF Field Groups are Empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4428\\\">#4428<\\/a>)<\\/li>\\n<li>Fix: Links inside carousel in edge cases<\\/li>\\n<li>Fix: Responsive issue in My Templates area<\\/li>\\n<li>Fix: Image alignment for post content with text alignment<\\/li>\\n<li>Fix: Post Content widget when preview post is missing<\\/li>\\n<li>Fix: Global Widget tab translation<\\/li>\\n<li>Fix: Style settings for Post \\/ Archive Title widgets<\\/li>\\n<\\/ul>\\n<h4>2.0.5 - 2018-05-08<\\/h4>\\n<ul>\\n<li>Fix: Creating a CPT with name like document-type breaks the editor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4203\\\">#4203<\\/a>)<\\/li>\\n<li>Fix: Added support for new version of reCAPTCHA<\\/li>\\n<li>Fix: Added fallback for controls after <code>post_status<\\/code><\\/li>\\n<li>Fix: Required field in forms widget<\\/li>\\n<li>Fix: Media Carousel in the Coverflow skin<\\/li>\\n<li>Fix: 404 Page show wrong template in edge cases<\\/li>\\n<li>Fix: Save the default menu in the Nav Menu widget<\\/li>\\n<\\/ul>\\n<h4>2.0.4 - 2018-05-02<\\/h4>\\n<ul>\\n<li>Tweak: Added parent\'s class for extended widgets<\\/li>\\n<li>Tweak: Set entire-site as default to avoid conflict with save without conditions<\\/li>\\n<li>Tweak: Initialize global model when it\'s needed<\\/li>\\n<li>Tweak: Removed some duplicate strings<\\/li>\\n<li>Tweak: Query control now includes empty terms<\\/li>\\n<li>Tweak: Design polish for conditions dialog<\\/li>\\n<li>Tweak: Decreasing <code>minimumInputLength<\\/code> to 1 of select2<\\/li>\\n<li>Fix: Editor not loading for single templates in edge cases<\\/li>\\n<li>Fix: Select2 in Safari takes it\'s time to get the original select width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4310\\\">#4310<\\/a>)<\\/li>\\n<li>Fix: Slides per view not working for some effects<\\/li>\\n<li>Fix: New slides not showing in the editor<\\/li>\\n<li>Fix: Editor for section without a defined location, defaults to content area<\\/li>\\n<\\/ul>\\n<h4>2.0.3 - 2018-04-24<\\/h4>\\n<ul>\\n<li>Tweak: Optimize CSS for Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4214\\\">#4214<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4216\\\">#4216<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4225\\\">#4225<\\/a>)<\\/li>\\n<li>Fix: Double render on frontend view in core locations<\\/li>\\n<li>Fix: Masonry not working in edge cases<\\/li>\\n<li>Fix: Added default setting for Author Info tag<\\/li>\\n<\\/ul>\\n<h4>2.0.2 - 2018-04-18<\\/h4>\\n<ul>\\n<li>Fix: Regenerate conditions to include all templates<\\/li>\\n<\\/ul>\\n<h4>2.0.1 - 2018-04-17<\\/h4>\\n<ul>\\n<li>Tweak: Added div wrapper for Nothing Found massage (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4136\\\">#4136<\\/a>)<\\/li>\\n<li>Tweak: Show empty categories in Query Control &amp; Display Conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4127\\\">#4127<\\/a>)<\\/li>\\n<li>Tweak: Added Divider control for Post Info widget<\\/li>\\n<li>Fix: Update admin links in Yoast Breadcrumbs widget<\\/li>\\n<li>Fix: Sticky element conflict with clearfix CSS<\\/li>\\n<li>Fix: Compatibility for PHP version 5.4.32 &amp; 5.5.16 and below<\\/li>\\n<li>Fix: Avoid running <code>wp_head<\\/code> hooks twice<\\/li>\\n<\\/ul>\\n<h4>2.0.0 - 2018-04-16<\\/h4>\\n<ul>\\n<li>New: Introducing Theme Builder - <a href=\\\"https:\\/\\/elementor.com\\/introducing-theme-builder\\/\\\">Release Post<\\/a> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/417\\\">#417<\\/a>)<\\/li>\\n<li>New: Introducing Locations API to inject custom location templates<\\/li>\\n<li>New: Introducing Display Conditions for all dynamic templates<\\/li>\\n<li>New: Introducing Dynamic Tag feature - a new way to add dynamic content to your design<\\/li>\\n<li>New: Introducing Role manager to allow &quot;Content Only mode&quot; (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/483\\\">#483<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/653\\\">#653<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/885\\\">#885<\\/a>)<\\/li>\\n<li>New: Introducing 9 new dynamic widgets: Archive Posts, Archive Title, Post Content, Post Info, Post Title, Post Excerpt, Featured Image, Site Logo &amp; Site Name (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/543\\\">#543<\\/a>)<\\/li>\\n<li>New: Introducing Developers area with guides and API documentation - <a href=\\\"https:\\/\\/elementor.com\\/introducing-elementor-developer-api\\/\\\">Release Post<\\/a> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/451\\\">#451<\\/a>)<\\/li>\\n<li>New: Introducing <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor-hello-theme\\\">Elementor Hello Theme<\\/a> - A demonstration theme for developers<\\/li>\\n<li>New: Added new type of templates: Header, Footer, Single and Archive (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2761\\\">#2761<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2623\\\">#2623<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2109\\\">#2109<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2061\\\">#2061<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2439\\\">#2439<\\/a>)<\\/li>\\n<li>New: Design 404 page with Single template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1558\\\">#1558<\\/a>)<\\/li>\\n<li>New: Design Search Results with Archive template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3196\\\">#3196<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2590\\\">#2590<\\/a>)<\\/li>\\n<li>New: Added Scrolling Effect for sections including <em>Sticky Element<\\/em> per device (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2412\\\">#2412<\\/a>)<\\/li>\\n<li>New: Integration with Custom Fields (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2054\\\">#2054<\\/a>)<\\/li>\\n<li>New: Partial support for Toolset integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2949\\\">#2949<\\/a>)<\\/li>\\n<li>New: Partial support for Pods integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2169\\\">#2169<\\/a>)<\\/li>\\n<li>New: Partial support for ACF integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2041\\\">#2041<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2059\\\">#2059<\\/a>)<\\/li>\\n<li>Tweak: Add custom fields support for ActiveCampaign (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3531\\\">#3531<\\/a>)<\\/li>\\n<li>Tweak: Allow brackets in Forms Tel field<\\/li>\\n<li>Tweak: Added currency format control for Price Table widget<\\/li>\\n<li>Tweak: Reduced API request for some servers<\\/li>\\n<li>Fix: Dropdown <code>border-radius<\\/code> in Nav Menu widget<\\/li>\\n<li>Fix: Price List widget layout breaks in edge cases<\\/li>\\n<li>Note: This version requires Elementor v2.0.6<\\/li>\\n<\\/ul>\\n<h4>1.15.6 - 2018-03-28<\\/h4>\\n<ul>\\n<li>Fix: Removed duplicate Custom CSS section (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3938\\\">#3938<\\/a>)<\\/li>\\n<li>Fix: <code>box-shadow<\\/code> issue with cards skin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3940\\\">#3940<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.15.5 - 2018-03-27<\\/h4>\\n<ul>\\n<li>Fix: Added global widget compatibility for Elementor v2.0<\\/li>\\n<li>Fix: Reduced API request for some servers<\\/li>\\n<\\/ul>\\n<h4>1.15.4 - 2018-03-26<\\/h4>\\n<ul>\\n<li>Tweak: Allow brackets in phone field<\\/li>\\n<li>Tweak: Added compatibility with Yoast 7.0.+<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v2.0<\\/li>\\n<li>Fix: Support for multiple carousel setting in editor<\\/li>\\n<li>Fix: <code>on_export<\\/code> issue in forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3890\\\">#3890<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.15.3 - 2018-03-07<\\/h4>\\n<ul>\\n<li>Tweak: Added unique class to field group div (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3595\\\">#3595<\\/a>)<\\/li>\\n<li>Fix: Screen Options missing when Pro is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3622\\\">#3622<\\/a>)<\\/li>\\n<li>Fix: Allow label styling even when <code>show labels<\\/code> is set hide (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3544\\\">#3544<\\/a>)<\\/li>\\n<li>Fix: Typography control not working in edge cases<\\/li>\\n<li>Fix: Safari compatibility for Search widget<\\/li>\\n<\\/ul>\\n<h4>1.15.2 - 2018-02-27<\\/h4>\\n<ul>\\n<li>Fix: Only add support mine-type if needed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3543\\\">#3543<\\/a>)<\\/li>\\n<li>Fix: Better support for Old Typekit kits<\\/li>\\n<\\/ul>\\n<h4>1.15.1 - 2018-02-21<\\/h4>\\n<ul>\\n<li>Tweak: Custom font title placeholder is not <code>enter font family<\\/code><\\/li>\\n<li>Tweak: Custom font title set as required<\\/li>\\n<li>Fix: Custom font, <code>font-face<\\/code> enqueued only once if used in global (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3513\\\">#3513<\\/a>)<\\/li>\\n<li>Fix: Added workaround for upload validation which relies on a PHP extension (fileinfo) with inconsistent reporting behavior.<\\/li>\\n<\\/ul>\\n<h4>1.15.0 - 2018-02-19<\\/h4>\\n<ul>\\n<li>New: Added custom fonts manager for self hosted fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/852\\\">#852<\\/a>)<\\/li>\\n<li>New: Integration with Adobe TypeKit fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/631\\\">#631<\\/a>)<\\/li>\\n<li>Tweak: Clear menu from Nav Menu widget on template export<\\/li>\\n<li>Tweak: Allow zero for GetResponse integration as <code>day of cycle<\\/code><\\/li>\\n<\\/ul>\\n<h4>1.14.2 - 2018-02-13<\\/h4>\\n<ul>\\n<li>Fix: Global widget content that got affected by previous update<\\/li>\\n<\\/ul>\\n<h4>1.14.1 - 2018-02-13<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>none<\\/code> option to content animation in CTA widget<\\/li>\\n<li>Tweak: Added <code>form_id<\\/code> to ActiveCampaign integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3422\\\">#3422<\\/a>)<\\/li>\\n<li>Fix: Page crashed when Global widget not found.<\\/li>\\n<\\/ul>\\n<h4>1.14.0 - 2018-02-12<\\/h4>\\n<ul>\\n<li>New: Added Call to Action widget<\\/li>\\n<li>Tweak: MailPoet pull field mapping from MailPoet instead of hardcoded<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v2.0<\\/li>\\n<li>Fix: Allow zero (0) to be accepted as a field value<\\/li>\\n<li>Fix: Login form when custom login URL is set<\\/li>\\n<li>Fix: Added Day of cycle control to GetResponse integration<\\/li>\\n<\\/ul>\\n<h4>1.13.2 - 2018-01-23<\\/h4>\\n<ul>\\n<li>Tweak: Added placeholder to Password field<\\/li>\\n<li>Tweak: Removed <code>subscriber_already_exists_message<\\/code> control to prevent potential data leakage<\\/li>\\n<li>Fix: MailPoet Subscriber Already Exists error validation against translated string directly from MailPoet<\\/li>\\n<li>Fix: Changed <code>imagesLoaded()<\\/code> to Vanilla JS to avoid compatibility issues with some themes<\\/li>\\n<li>Fix: Only validate Tel field if not empty<\\/li>\\n<li>Fix: Stop slider while editing<\\/li>\\n<\\/ul>\\n<h4>1.13.1 - 2018-01-16<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility with old PHP versions<\\/li>\\n<\\/ul>\\n<h4>1.13.0 - 2018-01-16<\\/h4>\\n<ul>\\n<li>New: Added File Upload field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1482\\\">#1482<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2974\\\">#2974<\\/a>)<\\/li>\\n<li>New: Added Acceptance field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1693\\\">#1693<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2974\\\">#2974<\\/a>)<\\/li>\\n<li>New: Added Date field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1868\\\">#1868<\\/a>)<\\/li>\\n<li>New: Added Time field for Forms widget<\\/li>\\n<li>New: Added Password field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2164\\\">#2164<\\/a>)<\\/li>\\n<li>New: Added HTML field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1500\\\">#1500<\\/a>)<\\/li>\\n<li>Tweak: Added characters validation for Tel field<\\/li>\\n<li>Tweak: Added min &amp; max validation for Number field<\\/li>\\n<li>Tweak: Added multiple selection for Select field<\\/li>\\n<li>Tweak: Added donReach integration for Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>1.12.3 - 2018-01-09<\\/h4>\\n<ul>\\n<li>Fix: Render element plain content instead of parsed content when not needed in global widget<\\/li>\\n<li>Fix: Apply <code>url-encoding<\\/code> to &quot;Tweet&quot; button text in Blockquote widget to prevent unexpected corruption of the tweet text<\\/li>\\n<li>Fix: Removed My Account link from dashboard widget<\\/li>\\n<\\/ul>\\n<h4>1.12.2 - 2018-01-03<\\/h4>\\n<ul>\\n<li>Tweak: Added animation none for Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2964\\\">#2964<\\/a>)<\\/li>\\n<li>Fix: Active license button style<\\/li>\\n<\\/ul>\\n<h4>1.12.1 - 2018-01-02<\\/h4>\\n<ul>\\n<li>Tweak: Removed theme-element widgets from plain content<\\/li>\\n<li>Tweak: Set all theme-element widgets to extend same widget Base<\\/li>\\n<li>Tweak: Removed credit URL in forms meta data<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.9<\\/li>\\n<li>Fix: Validate Get response Error as real error<\\/li>\\n<li>Fix: Removed responsive height control from Facebook Page widget<\\/li>\\n<\\/ul>\\n<h4>1.12.0 - 2017-12-20<\\/h4>\\n<ul>\\n<li>New: Added Drip integration to Forms<\\/li>\\n<li>New: Added ActiveCampaign integration to Forms<\\/li>\\n<li>New: Added ConverKit integration to Forms<\\/li>\\n<li>New: Added GetResponse integration to Forms<\\/li>\\n<li>New: Added form <code>id<\\/code>, <code>name<\\/code> attributes to handle integration with auto collectors like HubSpot<\\/li>\\n<li>New: Added Global API key for MailChimp to improve the workflow<\\/li>\\n<li>Tweak: Better error handling and message display for Forms<\\/li>\\n<li>Fix: PHP notice Undefined variable <code>$cc_header<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2934\\\">#2934<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.11.0 - 2017-12-11<\\/h4>\\n<ul>\\n<li>New: Added a native Comments widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/543\\\">#543<\\/a>)<\\/li>\\n<li>New: Added an Author Box widget<\\/li>\\n<li>New: Added a Post Navigation widget<\\/li>\\n<li>New: Added a Yoast Breadcrumbs widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2749\\\">#2749<\\/a>)<\\/li>\\n<li>Tweak: Added a close button to search widget under Full Screen skin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2762\\\">#2762<\\/a>)<\\/li>\\n<li>Fix: Allow currency symbol to appear even if price isn\'t numeric<\\/li>\\n<li>Fix: Edge cases when the nav menu is empty in a stretched section<\\/li>\\n<li>Fix: Added fallback when you remove the <code>space-between<\\/code> on Swiper carousel<\\/li>\\n<\\/ul>\\n<h4>1.10.2 - 2017-12-03<\\/h4>\\n<ul>\\n<li>Fix: Missing save widget icon (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2878\\\">#2878<\\/a>)<\\/li>\\n<li>Fix: Global widgets not saving edits (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2874\\\">#2874<\\/a>)<\\/li>\\n<li>Fix: Removed <code>white-space: nowrap;<\\/code> property from vertical menu in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2815\\\">#2815<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.10.1 - 2017-11-30<\\/h4>\\n<ul>\\n<li>Tweak: Added default value for search form<\\/li>\\n<li>Tweak: Order template list A-Z in the library widget<\\/li>\\n<li>Tweak: get_users\\/authors query is now done using AJAX only, for better performance in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2865\\\">#2865<\\/a>)<\\/li>\\n<li>Fix: When adding <code>.00<\\/code> it is not displayed on the front<\\/li>\\n<li>Fix: Make sure space between is numeric for carousel control<\\/li>\\n<li>Fix: Added space for radio &amp; checkbox fields in form widget<\\/li>\\n<\\/ul>\\n<h4>1.10.0 - 2017-11-15<\\/h4>\\n<ul>\\n<li>New: Added native Search form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2576\\\">#2576<\\/a>)<\\/li>\\n<li>Tweak: Added Slides To Scroll &amp; Loop controls to Media Carousel and Testimonials widgets<\\/li>\\n<li>Tweak: Added Inline editing to Blockquote widget<\\/li>\\n<li>Fix: Animated Headline color bug (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2516\\\">#2516<\\/a>)<\\/li>\\n<li>Fix: Animated Headline with Rotating skin<\\/li>\\n<li>Fix: RTL fix for Animated Headline widget in \'typing\' and \'clip\' animations<\\/li>\\n<li>Fix: Empty menu cause jQuery to crash in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2662\\\">#2662<\\/a>)<\\/li>\\n<li>Fix: Custom CSS gone after reloading the editor<\\/li>\\n<\\/ul>\\n<h4>1.9.5 - 2017-10-27<\\/h4>\\n<ul>\\n<li>Fix: Broken Global widget with JS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2639\\\">#2639<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.9.4 - 2017-10-24<\\/h4>\\n<ul>\\n<li>Tweak: Improved UI for notices and license page<\\/li>\\n<li>Fix: Update system conflict with other EDD plugins<\\/li>\\n<li>Fix: WooCommerce frontend hooks on Elementor editor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2577\\\">#2577<\\/a>)<\\/li>\\n<li>Fix: Removed default border left in Nav Menu dropdown CSS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2496\\\">#2496<\\/a>)<\\/li>\\n<li>Fix: Increased submenu max-width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2558\\\">#2558<\\/a>)<\\/li>\\n<li>Fix: Save global templates without their defaults<\\/li>\\n<li>Fix: Horizontal scrolling issue with posts grid<\\/li>\\n<\\/ul>\\n<h4>1.9.3 - 2017-10-03<\\/h4>\\n<ul>\\n<li>Fix: Condition slide style that got affected by previous update<\\/li>\\n<\\/ul>\\n<h4>1.9.2 - 2017-10-02<\\/h4>\\n<ul>\\n<li>New: Added integration with MailPoet 3 for Forms actions<\\/li>\\n<li>Fix: Removed height control from Testimonial carousel in mobile editing mode<\\/li>\\n<li>Fix: Removed bottom padding when there\'s no pagination in Testimonial carousel<\\/li>\\n<li>Fix: Added condition for slides style section in skin bubble mode<\\/li>\\n<li>Fix: Slides per view control for mobile editing in Testimonial carousel<\\/li>\\n<li>Fix: Navigation Arrows icons matched with common Elementor Navigation Arrows<\\/li>\\n<\\/ul>\\n<h4>1.9.1 - 2017-09-28<\\/h4>\\n<ul>\\n<li>Fix: Slides per view for slideshow carousel<\\/li>\\n<li>Fix: Final polish for the new Testimonial Carousel widget<\\/li>\\n<li>Fix: Don\'t play video if slide type is not video<\\/li>\\n<li>Fix: Removed slides style section condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2497\\\">#2497<\\/a>)<\\/li>\\n<li>Fix: Set cursor as pointer for slideshow thumbnails<\\/li>\\n<\\/ul>\\n<h4>1.9.0 - 2017-09-26<\\/h4>\\n<ul>\\n<li>New: Added Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/216\\\">#216<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/347\\\">#347<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2209\\\">#2209<\\/a>)<\\/li>\\n<li>New: Added Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/715\\\">#715<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.8.3 - 2017-09-24<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility for WordPress 4.8.2 &amp; 4.7.6<\\/li>\\n<li>Fix: Remove slashes from Form sent data<\\/li>\\n<\\/ul>\\n<h4>1.8.2 - 2017-09-19<\\/h4>\\n<ul>\\n<li>Tweak: Added target URL for the tweet message in Blockquote widget<\\/li>\\n<li>Tweak: Render the slide height before the slider is finished loading<\\/li>\\n<li>Fix: Space between words for Animated Headline widget<\\/li>\\n<li>Fix: RTL compatibility for Animated Headline widget<\\/li>\\n<li>Fix: Italic font style for Animated Headline widget<\\/li>\\n<li>Fix: Excluded Menu widget from the WP Editor text rendering<\\/li>\\n<\\/ul>\\n<h4>1.8.1 - 2017-09-18<\\/h4>\\n<ul>\\n<li>Fix: WCAG Compatible &quot;required&quot; field attribute for W3C validation (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2391\\\">#2391<\\/a>)<\\/li>\\n<li>Fix: Print the main menu only when is necessary in Menu widget<\\/li>\\n<li>Fix: Use CSS media query instead of JS to hide items in Menu widget to avoid flickering on page load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2381\\\">#2381<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.8.0 - 2017-09-12<\\/h4>\\n<ul>\\n<li>New: Added Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1406\\\">#1406<\\/a>)<\\/li>\\n<li>Fix: Field ID for checkbox control in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2279\\\">#2279<\\/a>)<\\/li>\\n<li>Fix: Style for Blockquote widget included<\\/li>\\n<\\/ul>\\n<h4>1.7.2 - 2017-09-07<\\/h4>\\n<ul>\\n<li>Tweak: Loading Facebook SDK via JS for better compatibility with caching plugins<\\/li>\\n<li>Fix: Responsive Embed Facebook post widget for Safari iOS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2340\\\">#2340<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.7.1 - 2017-09-05<\\/h4>\\n<ul>\\n<li>Fix: Facebook SDK version<\\/li>\\n<\\/ul>\\n<h4>1.7.0 - 2017-09-05<\\/h4>\\n<ul>\\n<li>New: Added Facebook Button widget for Like, Recommend, Share and Follow<\\/li>\\n<li>New: Added Facebook Embed widget for Post, Video and Comment<\\/li>\\n<li>New: Added Facebook Comments widget<\\/li>\\n<li>New: Added Facebook Page widget (Previously known as Like Box)<\\/li>\\n<li>New: Added Blockquote widget with Tweet button<\\/li>\\n<li>Tweak: Added Facebook SDK integration for all Facebook widgets<\\/li>\\n<li>Fix: Animated headline rotating with long words<\\/li>\\n<\\/ul>\\n<h4>1.6.1 - 2017-08-28<\\/h4>\\n<ul>\\n<li>Fix: Animated Headline marker gets in front of neighboring spans even when &quot;Bring to Front&quot; is not set<\\/li>\\n<li>Fix: Stroke animation in Animated Headline for MS Edge browser<\\/li>\\n<li>Fix: Animated headline with more than 1-word per rotation<\\/li>\\n<li>Fix: Animated Headline in two lines<\\/li>\\n<li>Fix: Some errors in Global widget<\\/li>\\n<\\/ul>\\n<h4>1.6.0 - 2017-08-22<\\/h4>\\n<ul>\\n<li>New: Added Animated Headline widget<\\/li>\\n<li>New: Added Hidden field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2038\\\">#2038<\\/a>)<\\/li>\\n<li>Tweak: Added notice to update Elementor to v1.6.5 or higher<\\/li>\\n<li>Fix: CSS Animations names no longer minified, in order to prevent unexpected conflicts<\\/li>\\n<\\/ul>\\n<h4>1.5.9 - 2017-08-16<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.7<\\/li>\\n<li>Fix: Portfolio compatibility for GeneratePress theme<\\/li>\\n<li>Fix: Portfolio filter compatibility for RTL<\\/li>\\n<li>Fix: Pagination apply for all posts widget in the page<\\/li>\\n<li>Fix: Global form widget with MailChimp integration not saving<\\/li>\\n<\\/ul>\\n<h4>1.5.8 - 2017-07-25<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.6<\\/li>\\n<li>Fix: Improved backward compatibility for query control rename<\\/li>\\n<\\/ul>\\n<h4>1.5.7 - 2017-07-24<\\/h4>\\n<ul>\\n<li>Tweak: Moved JS render of reCAPTCHA to a separate file<\\/li>\\n<li>Tweak: Display the label in the reCAPTCHA field for better experience<\\/li>\\n<li>Tweak: Rename <code>panel-posts-control<\\/code> to <code>query-control<\\/code> and added fallback support<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor with history feature<\\/li>\\n<li>Fix: reCAPTCHA preview on the editor<\\/li>\\n<li>Fix: Manual selection (query control) has stopped working after saving (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2000\\\">#2000<\\/a>)<\\/li>\\n<li>Fix: Added condition for icon size control in Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>1.5.6 - 2017-07-12<\\/h4>\\n<ul>\\n<li>Fix: Query Control correction for taxonomies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1963\\\">#1963<\\/a>)<\\/li>\\n<li>Fix: Custom CSS override scheme color in the editor<\\/li>\\n<li>Fix: Added order by Menu Order for Query Control in WC widget<\\/li>\\n<li>Fix: Glitch with Flip Box background overlay<\\/li>\\n<\\/ul>\\n<h4>1.5.5 - 2017-07-03<\\/h4>\\n<ul>\\n<li>Tweak: Moved reCAPTCHA render to handler &amp; load only if a form is exist<\\/li>\\n<li>Fix: MailChimp integration: Default number of items returned by API increased to 999<\\/li>\\n<li>Fix: MailChimp integration: Refresh the groups list if API is changed<\\/li>\\n<li>Fix: Sorted items in filter bar by A-Z<\\/li>\\n<li>Fix: Editor glitch with Elementor v1.5 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1927\\\">#1927<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.5.4 - 2017-06-22<\\/h4>\\n<ul>\\n<li>Tweak: Improved compatibility for Elementor v1.5<\\/li>\\n<li>Fix: URL default for Add To Cart widget<\\/li>\\n<li>Fix: Allowed <code>date<\\/code> and <code>birthday<\\/code> fields as text for MailChimp integration<\\/li>\\n<\\/ul>\\n<h4>1.5.3 - 2017-06-19<\\/h4>\\n<ul>\\n<li>Tweak: Make flip-box height responsive control<\\/li>\\n<li>Fix: Facebook share count now gets retrieved by Elementor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1829\\\">#1829<\\/a>)<\\/li>\\n<li>Fix: Global form widget with MailChimp integration not saving<\\/li>\\n<\\/ul>\\n<h4>1.5.2 - 2017-06-13<\\/h4>\\n<ul>\\n<li>Fix: Custom CSS panel location compatibility for the old versions<\\/li>\\n<\\/ul>\\n<h4>1.5.1 - 2017-06-12<\\/h4>\\n<ul>\\n<li>Fix: MailChimp update existing user registration<\\/li>\\n<li>Fix: Global widget with JS in the editor mode<\\/li>\\n<li>Fix: Label section condition in Login widget<\\/li>\\n<li>Fix: Changes to unlinked global widget do not appear in the editor<\\/li>\\n<\\/ul>\\n<h4>1.5.0 - 2017-05-23<\\/h4>\\n<ul>\\n<li>New: Added Cards, a new skin for Posts widget<\\/li>\\n<li>New: Added Exclude option to post query control group<\\/li>\\n<li>Tweak: Added <code>post_class()<\\/code> for each post in the loop<\\/li>\\n<li>Tweak: Added <code>.elementor-posts-masonry<\\/code> class when Masonry layout is enabled<\\/li>\\n<li>Tweak: Added compatibility for the next release of Elementor v1.5.0<\\/li>\\n<li>Tweak: CSS <code>autoprefixer<\\/code> now supports last 5 versions of browsers<\\/li>\\n<li>Tweak: Added <code>imageLoaded<\\/code> library for Posts &amp; Portfolio widgets<\\/li>\\n<\\/ul>\\n<h4>1.4.4 - 2017-05-18<\\/h4>\\n<ul>\\n<li>Fix: Force Mailchimp API to return all lists and not just 10 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1683\\\">#1683<\\/a>)<\\/li>\\n<li>Fix: Added <code>.elementor-form<\\/code> class to Login form to fix style glitch<\\/li>\\n<\\/ul>\\n<h4>1.4.3 - 2017-05-14<\\/h4>\\n<ul>\\n<li>Tweak: Added Redirect After Login option to Login widget<\\/li>\\n<li>Tweak: Stay in the current page after logout in Login widget<\\/li>\\n<li>Tweak: Preparation for Elementor settings tabs in future version<\\/li>\\n<li>Fix: Pinterest in Share Buttons widget now sharing the URL alone<\\/li>\\n<li>Fix: Bug with <code>active<\\/code> class in portfolio filter item<\\/li>\\n<li>Fix: Higher specific list-style-type <code>none<\\/code> for filter items to override some theme style<\\/li>\\n<\\/ul>\\n<h4>1.4.2 - 2017-05-06<\\/h4>\\n<ul>\\n<li>Fix: Temporary patch for form field shortcode in some servers<\\/li>\\n<\\/ul>\\n<h4>1.4.1 - 2017-05-03<\\/h4>\\n<ul>\\n<li>Fix: Bug with custom success message in form widget<\\/li>\\n<li>Fix: Bug with meta data in email action<\\/li>\\n<\\/ul>\\n<h4>1.4.0 - 2017-05-03<\\/h4>\\n<ul>\\n<li>New: Forms: integration with MailChimp<\\/li>\\n<li>New: Forms: integration with MailPoet<\\/li>\\n<li>New: Forms: Added Email 2 action for email confirmation<\\/li>\\n<li>New: Forms: Added shortcodes for fields<\\/li>\\n<li>New: Forms: Added custom ID for fields<\\/li>\\n<li>New: Forms: Added option to edit email HTML template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1180\\\">#1180<\\/a>)<\\/li>\\n<li>New: Added Login widget<\\/li>\\n<li>Tweak: Move <code>send_html<\\/code> control to <code>email_content_type<\\/code><\\/li>\\n<li>Fix: Email still sent even if validation failed in form widget<\\/li>\\n<\\/ul>\\n<h4>1.3.2 - 2017-05-01<\\/h4>\\n<ul>\\n<li>New: Added action <code>elementor_pro\\/init<\\/code> for better integration with Elementor Pro<\\/li>\\n<li>Fix: Posts without featured image in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1234\\\">#1234<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1382\\\">#1382<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA &amp; Honeypot fields with new method<\\/li>\\n<li>Fix: Added border width control in Share Buttons to avoid a glitch on Chrome browser<\\/li>\\n<li>Fix: Border radius glitch on hover in Share Buttons<\\/li>\\n<\\/ul>\\n<h4>1.3.1 - 2017-04-25<\\/h4>\\n<ul>\\n<li>Fix: Conflict update with revision history module<\\/li>\\n<\\/ul>\\n<h4>1.3.0 - 2017-04-25<\\/h4>\\n<ul>\\n<li>New: Added Share Buttons widget (<a href=\\\"https:\\/\\/wordpress.org\\/support\\/topic\\/social-sharing-buttons-is-it-possible\\/\\\">Topic<\\/a>)<\\/li>\\n<li>New: Added Custom CSS for Page Settings<\\/li>\\n<li>New: Added Masonry layout for Portfolio widget<\\/li>\\n<li>New: Added Cc &amp; Bcc options to email action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1181\\\">#1181<\\/a>)<\\/li>\\n<li>New: Introduced <code>ElementorProModulesFormsClassesAction_Base<\\/code> class for better 3rd party integration for forms<\\/li>\\n<li>Tweak: Debugger module now also shows errors from Pro<\\/li>\\n<li>Tweak: Added options for Elementor Library<\\/li>\\n<li>Tweak: New base posts module for optimized performance<\\/li>\\n<li>Tweak: Adjusting Posts \\/ Portfolio to the new structure<\\/li>\\n<li>Fix: Export for posts \\/ portfolio<\\/li>\\n<li>Fix: Duplicate repeater field with switcher control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1442\\\">#1442<\\/a>)<\\/li>\\n<li>Fix: Post per Page in the query control<\\/li>\\n<li>Fix: Metadata does not come through on form emails (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1566\\\">#1566<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.2.6 - 2017-04-19<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility with WooCommerce 3.0 - Products &amp; Add to Cart widgets<\\/li>\\n<\\/ul>\\n<h4>1.2.5 - 2017-04-18<\\/h4>\\n<ul>\\n<li>Fix: Offset query for posts widgets (Posts, Portfolio and Products)<\\/li>\\n<\\/ul>\\n<h4>1.2.4 - 2017-03-21<\\/h4>\\n<ul>\\n<li>Tweak: Added Indian Rupee sign to Price Table widget<\\/li>\\n<li>Fix: Portfolio grid for IE11<\\/li>\\n<li>Fix: Link target blank in Price List widget<\\/li>\\n<li>Fix: Active item for filter bar in Portfolio widget<\\/li>\\n<\\/ul>\\n<h4>1.2.3 - 2017-03-06<\\/h4>\\n<ul>\\n<li>Tweak: Fully compatible with Elementor v1.3.0<\\/li>\\n<li>Tweak: Added trigger for after form submission in Forms widget<\\/li>\\n<li>Tweak: Changed handle name in reCAPTCHA field to avoid conflict with other contact forms<\\/li>\\n<li>Fix: Portfolio filter syntax in Non-Latin languages<\\/li>\\n<li>Fix: Added <code>no-repeat<\\/code> property for slide with <code>background-size:contain<\\/code><\\/li>\\n<li>Fix: Condition control &amp; Import value in Posts widgets<\\/li>\\n<li>Fix: Offset and Pagination in WordPress (<a href=\\\"https:\\/\\/codex.wordpress.org\\/Making_Custom_Queries_using_Offset_and_Pagination\\\">More Info<\\/a>)<\\/li>\\n<li>Fix: Submit handler bubbling for custom events in Forms widget<\\/li>\\n<\\/ul>\\n<h4>1.2.2 - 2017-02-23<\\/h4>\\n<ul>\\n<li>Tweak: Change name from Side A\\/B to Front and Back in Flip Box widget<\\/li>\\n<li>Fix: Error when saving third party widgets in the global widget<\\/li>\\n<li>Fix: Image position &quot;none&quot; remains visible in editor preview (Posts)<\\/li>\\n<li>Fix: Hide the pagination when there are no links<\\/li>\\n<\\/ul>\\n<h4>1.2.1 - 2017-02-21<\\/h4>\\n<ul>\\n<li>Fix: Firefox Flip Box 3D compatibility<\\/li>\\n<\\/ul>\\n<h4>1.2.0 - 2017-02-21<\\/h4>\\n<ul>\\n<li>New: Added Flip Box widget<\\/li>\\n<li>New: Added Ken Burns effect for slides<\\/li>\\n<li>New: Added Masonry layout for Posts widget<\\/li>\\n<li>New: Added Pagination option for Posts widget<\\/li>\\n<li>Tweak: Added background size contain to slides<\\/li>\\n<li>Tweak: Improve Query control by preload items<\\/li>\\n<li>Fix: Text color for Checkbox and Radio fields<\\/li>\\n<\\/ul>\\n<h4>1.1.2 - 2017-02-05<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>aria-required<\\/code> for better accessibility in forms widget<\\/li>\\n<li>Fix: Conflict Call to <code>undefined<\\/code> method in Posts &amp; Portfolio widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1271\\\">#1271<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1266\\\">#1266<\\/a>)<\\/li>\\n<li>Fix: Submit button HTML after error sending<\\/li>\\n<li>Fix: Success message for <code>skip_email<\\/code> function<\\/li>\\n<li>Notice: Elementor 1.2.0 or later now required<\\/li>\\n<\\/ul>\\n<h4>1.1.1 - 2017-01-24<\\/h4>\\n<ul>\\n<li>Fix: Can\'t save global widgets when <code>WP_DEBUG<\\/code> is <code>true<\\/code><\\/li>\\n<li>Fix: Undefined variable in WC widgets<\\/li>\\n<li>Fix: Removed duplicate strings<\\/li>\\n<\\/ul>\\n<h4>1.1.0 - 2017-01-24<\\/h4>\\n<ul>\\n<li>New: Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/102\\\">#102<\\/a>)<\\/li>\\n<li>New: WooCommerce Add to Cart widget<\\/li>\\n<li>New: WooCommerce Categories widget<\\/li>\\n<li>New: WooCommerce Elements widget<\\/li>\\n<li>New: Honeypot field for Forms widgets<\\/li>\\n<li>Tweak: Added inline options for taxonomies &amp; authors if is less than 15 items<\\/li>\\n<li>Tweak: Added Required Mark for fields in Forms widget<\\/li>\\n<li>Fix: CSS selectors priority in Slides widget<\\/li>\\n<li>Fix: CSS bug in Price List widget<\\/li>\\n<li>Fix: Update all Post CSS files that includes specific Global Widget<\\/li>\\n<\\/ul>\\n<h4>1.0.9 - 2017-01-18<\\/h4>\\n<ul>\\n<li>Fix: Auto complete bug in query controls<\\/li>\\n<li>Fix: Render template with escaping slashes<\\/li>\\n<li>Fix: Reply-to field in Forms widget<\\/li>\\n<\\/ul>\\n<h4>1.0.8 - 2017-01-11<\\/h4>\\n<ul>\\n<li>Tweak: Code adjustments for Elementor API<\\/li>\\n<li>Fix: Removed go pro link from plugins page in admin<\\/li>\\n<\\/ul>\\n<h4>1.0.7 - 2017-01-05<\\/h4>\\n<ul>\\n<li>Tweak: Added filter by featured \\/ sale for WC Products widget<\\/li>\\n<li>Tweak: Added author control in Portfolio widget<\\/li>\\n<li>Tweak: Code adjustments for Elementor API<\\/li>\\n<li>Fix: Added support for empty image ratio<\\/li>\\n<li>Fix: Avoid nesting a sidebar within a template that will appear in the sidebar itself<\\/li>\\n<\\/ul>\\n<h4>1.0.6 - 2017-01-01<\\/h4>\\n<ul>\\n<li>Tweak: Added Auto-updates for local translation files<\\/li>\\n<li>Fix: Custom CSS for Global widgets<\\/li>\\n<li>Fix: Remove <code>nonce<\\/code> field (Fix some cache plugins)<\\/li>\\n<\\/ul>\\n<h4>1.0.5 - 2016-12-27<\\/h4>\\n<ul>\\n<li>Fix: Slide element bug fix - \'Link apply on\' logic<\\/li>\\n<li>Fix: Removed unique wrapper for Custom CSS in order to allow media queries (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1086\\\">#1086<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.0.4 - 2016-12-21<\\/h4>\\n<ul>\\n<li>Tweak: Mobile Editing for fields in the form widget<\\/li>\\n<li>Tweak: Mobile Editing for posts<\\/li>\\n<li>Tweak: Allow send form as HTML<\\/li>\\n<li>Tweak: Improved auto upgrades for Multisite installation<\\/li>\\n<li>Tweak: Improve editor rendering experience for Portfolio widget<\\/li>\\n<li>Fix: Posts widget check if image exist<\\/li>\\n<li>Fix: Changed the clone method for global widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1042\\\">#1042<\\/a>)<\\/li>\\n<li>Fix: Bug slides in RTL (removed direction control)<\\/li>\\n<li>Fix: Slides with no height jumps when changing slides<\\/li>\\n<\\/ul>\\n<h4>1.0.3 - 2016-12-13<\\/h4>\\n<ul>\\n<li>Fix: Added escape placeholder for HTML Entities in form widget<\\/li>\\n<li>Fix: Countdown widget RTL bug<\\/li>\\n<li>Fix: Remove redundant #elementor selector for control style<\\/li>\\n<li>Fix: Added prefixing with \'0\' for one digit number in Countdown widget<\\/li>\\n<\\/ul>\\n<h4>1.0.2 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Fix: Page layout collapses when inserting reCAPTCHA field in Form<\\/li>\\n<\\/ul>\\n<h4>1.0.1 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Fix: WordPress widgets disappear from Editor when Elementor Pro active<\\/li>\\n<\\/ul>\\n<h4>1.0.0 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Initial release<\\/li>\\n<\\/ul>\\\";}\",\"new_version\":\"3.31.2\",\"name\":\"Elementor Pro\",\"slug\":\"elementor-pro\",\"url\":\"https:\\/\\/elementor.com\\/pro\\/changelog\\/\",\"homepage\":\"https:\\/\\/elementor.com\\/pro\\/\",\"requires\":\"5.0\",\"tested\":\"6.8.2\",\"elementor_requires\":\"3.0.1\",\"package\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/package_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiYncyOWdnanRlYnRqdjJpOHF2cWI0NWEyeG40eDk3YmkiLCJ1cmwiOiJodHRwOi8vbXl0ZXN0ZGVzaWduLnh5ei9lbGVtZW50b3IiLCJkb3dubG9hZF9iZXRhIjpmYWxzZSwiZmlsZV9rZXkiOiIxIiwiaWF0IjoxNzU2MTk4MzMxLCJleHAiOjE3NTYyODQ3MzF9.KdYip82vYeAq0OkwdSJ7QSXdHEHyykhpwwJenk9rgFw\\/package_download\",\"download_link\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/package_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiYncyOWdnanRlYnRqdjJpOHF2cWI0NWEyeG40eDk3YmkiLCJ1cmwiOiJodHRwOi8vbXl0ZXN0ZGVzaWduLnh5ei9lbGVtZW50b3IiLCJkb3dubG9hZF9iZXRhIjpmYWxzZSwiZmlsZV9rZXkiOiIxIiwiaWF0IjoxNzU2MTk4MzMxLCJleHAiOjE3NTYyODQ3MzF9.KdYip82vYeAq0OkwdSJ7QSXdHEHyykhpwwJenk9rgFw\\/package_download\",\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-1544x500.png?rev=1475479\",\"1x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-772x250.png?rev=1475479\"},\"icons\":{\"svg\":\"https:\\/\\/storage.googleapis.com\\/web-public-files\\/Web%20Assets\\/icons\\/icon.svg\"},\"canary_deployment\":{\"plugin_info\":{\"new_version\":\"3.7.0\",\"name\":\"Elementor Pro\",\"slug\":\"elementor-pro\",\"url\":\"https:\\/\\/elementor.com\\/pro\\/changelog\\/\",\"homepage\":\"https:\\/\\/elementor.com\\/pro\\/\",\"requires\":\"5.0\",\"tested\":\"6.8.2\",\"elementor_requires\":\"3.0.1\",\"package\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/previous_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiYncyOWdnanRlYnRqdjJpOHF2cWI0NWEyeG40eDk3YmkiLCJ2ZXJzaW9uIjoiMy43LjAiLCJ1cmwiOiJodHRwOi8vbXl0ZXN0ZGVzaWduLnh5ei9lbGVtZW50b3IiLCJpYXQiOjE3NTYxOTgzMzIsImV4cCI6MTc1NjI4NDczMn0.W9ALZCOKUqD9D1bj3puOy2yeNLUEYGWXGTfDTxt_ikM\\/previous_download\",\"download_link\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/previous_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiYncyOWdnanRlYnRqdjJpOHF2cWI0NWEyeG40eDk3YmkiLCJ2ZXJzaW9uIjoiMy43LjAiLCJ1cmwiOiJodHRwOi8vbXl0ZXN0ZGVzaWduLnh5ei9lbGVtZW50b3IiLCJpYXQiOjE3NTYxOTgzMzIsImV4cCI6MTc1NjI4NDczMn0.W9ALZCOKUqD9D1bj3puOy2yeNLUEYGWXGTfDTxt_ikM\\/previous_download\",\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-1544x500.png?rev=1475479\",\"1x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-772x250.png?rev=1475479\"},\"icons\":{\"svg\":\"https:\\/\\/storage.googleapis.com\\/web-public-files\\/Web%20Assets\\/icons\\/icon.svg\"}},\"conditions\":[[{\"type\":\"language\",\"languages\":[\"he_IL\",\"nl_NL\",\"en_GB\",\"en_NZ\",\"en_ZA\",\"en_AU\",\"en_CA\",\"sv_SE\",\"da_DK\",\"fr_FR\",\"nl_NL\",\"nb_NO\",\"de_AT\",\"fi\",\"it_IT\",\"nn_NO\",\"de_CH\",\"en_GB\",\"is_IS\",\"ga\",\"fr_BE\",\"nl_BE\",\"ast\",\"lb_LU\",\"es_ES\",\"pt_PT\",\"mlt\"],\"operator\":\"in\"}]]},\"translations\":[{\"language\":\"fa_IR\",\"updated\":\"2024-04-29 14:12:39+0000\",\"package\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/translation\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiYncyOWdnanRlYnRqdjJpOHF2cWI0NWEyeG40eDk3YmkiLCJ1cmwiOiJodHRwOi8vbXl0ZXN0ZGVzaWduLnh5ei9lbGVtZW50b3IiLCJsYW5ndWFnZSI6ImZhX0lSIiwiaWF0IjoxNzU2MTk4MzMyfQ.vbhehbDhLAxgY7AzvOcS7w3CK1oYHKx5X2fLZKkIiks\\/translation\"}],\"cloud\":false}\";}", "off");
INSERT INTO `wp_options` VALUES("7339", "duplicator_pro_exe_safe_mode", "0", "yes");
INSERT INTO `wp_options` VALUES("7340", "duplicator_activate_plugins_after_installation", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("7343", "wp_check_theme_update_id_QQqoQRICpFXITpotXFtnRQAAWnPRFttI", "NDI1ODE5Ng==", "yes");
INSERT INTO `wp_options` VALUES("7371", "ARIpQPoRnPToqCXTTopIPRApWXotFIIp", "=r=gsnP4SkrJRJcMcjqTYV41fffYS7iTBaecKKcQZ7tecCKgfHfZgcISBhJxyJYYhjEcLUHpwsYYHXwZBuTAfJYuJW7HlLfrbWrO7BMXfchW7fUEbjhtGfVx20dj5pUEbvhtdZhxSwdjNdV1BlOXIShrVKdj868p2YZcfZhrTcMjzYrGaYZcIovAZfr1CCOt3p8GwBacKIdtyBRkbHhWdEhrVKdj86V1BLOXIHhrbKdjEL51bYYACSMpfIOkwY87wZ8kjBujfIOk2YV1sfY7iBagKIOkU6V14B8kjB1WfYuttfQkbSyGNHMjTjRGyOrXlIQhYErtb95STH1jTjRGyCapCSuAfIOtt7QkbWOXdpVrvEOttcOAbZVx7B116chW7IrWbDhtIHhrxYYj5ZLrbqrtCZhrTcMjaYV14BQiiBa7RcMjwY87wZ8kjBujfIOkS6rGbYY7iBMcKcRX7cOtwYYACSMXfYaW7cOAJlhc46vEEYVk5l1WbWOXGfVxbKdjNZU7aYY7iBMcKIOkZ6rGNYYWiB116IdW7fUEbxhtGYOWfcrWllv1bH1tGYCXfIvtt7QkbjOXGYCcKIdtylv1bvhtIDVr4KdjysujNSMGaKMSY6rxzoZpMLU72BUWysMjwsaWPHMGfKMSdYQhYErtb95STDMGaKujagajNWajTdQGygrtncRx6cQXb95STH1jTjRGQxuEQSMj6gaEws1tPSk7KY8pysuETjRGQd1jqOMjCs1tPSe7foL70YV7ysaETjRGyqrxyZ8p2Shtzxh7bwrxCYQ7fcVSTd1jTjRGygrtnL8pfE5STWMGaK1jTSQGyOVpfcRxlo6WfByGIsaWPvMGyKMSCBh70ZQhCIQXb7QhYcrtsByGQvMGaK5GIs1x", "auto");
INSERT INTO `wp_options` VALUES("7400", "_fluentcrm_db_version", "2.9.50", "auto");
INSERT INTO `wp_options` VALUES("7401", "fluentcrm-global-settings", "a:3:{s:8:\"campaign\";a:1:{s:4:\"from\";a:2:{s:4:\"name\";s:0:\"\";s:5:\"email\";s:0:\"\";}}s:5:\"email\";a:1:{s:17:\"emails_per_second\";i:4;}s:17:\"business_settings\";a:2:{s:13:\"business_name\";s:14:\"تابان CRM\";s:4:\"logo\";s:60:\"http://tabancrm.ir/wp-content/uploads/2023/10/taban-logo.png\";}}", "auto");
INSERT INTO `wp_options` VALUES("7405", "_fcrm_last_scheduler", "1745944110", "off");
INSERT INTO `wp_options` VALUES("7406", "fluentcrm_is_sending_emails", "", "auto");
INSERT INTO `wp_options` VALUES("7407", "_fcrm_last_email_process_cleanup", "1745943986", "off");
INSERT INTO `wp_options` VALUES("7408", "_fc_last_sequence_run", "1745944049", "off");
INSERT INTO `wp_options` VALUES("7409", "_fc_last_funnel_processor", "", "off");
INSERT INTO `wp_options` VALUES("7410", "_fc_last_funnel_processor_ran", "1745944110", "off");
INSERT INTO `wp_options` VALUES("7411", "_fcrm_last_five_minutes_run", "1745944049", "off");
INSERT INTO `wp_options` VALUES("7419", "fluentform_entry_details_migrated", "yes", "off");
INSERT INTO `wp_options` VALUES("7420", "fluentform_db_fluentform_logs_added", "1", "off");
INSERT INTO `wp_options` VALUES("7421", "fluentform_scheduled_actions_migrated", "yes", "off");
INSERT INTO `wp_options` VALUES("7422", "_fluentform_global_form_settings", "a:2:{s:6:\"layout\";a:5:{s:14:\"labelPlacement\";s:3:\"top\";s:17:\"asteriskPlacement\";s:14:\"asterisk-right\";s:20:\"helpMessagePlacement\";s:10:\"with_label\";s:21:\"errorMessagePlacement\";s:6:\"inline\";s:12:\"cssClassName\";s:0:\"\";}s:4:\"misc\";a:5:{s:18:\"isIpLogingDisabled\";b:0;s:19:\"isAnalyticsDisabled\";b:1;s:21:\"file_upload_locations\";s:0:\"\";s:20:\"admin_top_nav_status\";s:3:\"yes\";s:23:\"default_admin_date_time\";s:9:\"time_diff\";}}", "off");
INSERT INTO `wp_options` VALUES("7423", "_fluentform_installed_version", "6.0.3", "off");
INSERT INTO `wp_options` VALUES("7424", "fluentform_global_modules_status", "a:9:{s:9:\"mailchimp\";s:2:\"no\";s:14:\"activecampaign\";s:2:\"no\";s:16:\"campaign_monitor\";s:2:\"no\";s:17:\"constatantcontact\";s:2:\"no\";s:11:\"getresponse\";s:2:\"no\";s:8:\"icontact\";s:2:\"no\";s:7:\"webhook\";s:2:\"no\";s:6:\"zapier\";s:2:\"no\";s:5:\"slack\";s:2:\"no\";}", "off");
INSERT INTO `wp_options` VALUES("7425", "widget_fluentform_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("7429", "_fluentcrm_commerce_modules", "a:2:{s:8:\"migrated\";s:2:\"no\";s:7:\"modules\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("7431", "__fluentcrm_campaign_license_lc", "1745229059", "off");
INSERT INTO `wp_options` VALUES("7432", "__fluentcrm_campaign_license", "a:4:{s:6:\"status\";s:7:\"invalid\";s:11:\"license_key\";s:9:\"*********\";s:8:\"price_id\";s:1:\"1\";s:7:\"expires\";N;}", "auto");
INSERT INTO `wp_options` VALUES("8047", "b452185f7f8b216ca40e46f94e8b92c3", "a:2:{s:7:\"timeout\";i:1746027329;s:5:\"value\";O:8:\"stdClass\":12:{s:11:\"new_version\";s:6:\"2.9.50\";s:14:\"stable_version\";s:6:\"2.9.50\";s:4:\"name\";s:37:\"FluentCRM Pro - Email Marketing Addon\";s:4:\"slug\";s:18:\"fluentcampaign-pro\";s:3:\"url\";s:71:\"https://wpmanageninja.com/downloads/fluentcrm-campaign-pro/?changelog=1\";s:12:\"last_updated\";s:19:\"2025-04-17 14:11:10\";s:8:\"homepage\";s:59:\"https://wpmanageninja.com/downloads/fluentcrm-campaign-pro/\";s:7:\"package\";s:170:\"https://wpmanageninja.com/edd-sl/package_download/MTc0NjAxNDcyODoqKioqKioqKio6MzQxMTk3OjdkZWNjNTllYTMwMjBiZGJkMmRhZGI2MzQyNmRiMWIzOmh0dHBzQC8vZGlnaXRhbHJldi5pci90YWJhbjow\";s:13:\"download_link\";s:170:\"https://wpmanageninja.com/edd-sl/package_download/MTc0NjAxNDcyODoqKioqKioqKio6MzQxMTk3OjdkZWNjNTllYTMwMjBiZGJkMmRhZGI2MzQyNmRiMWIzOmh0dHBzQC8vZGlnaXRhbHJldi5pci90YWJhbjow\";s:8:\"sections\";a:2:{s:11:\"description\";s:0:\"\";s:9:\"changelog\";s:23311:\"<p>= 2.9.50 (Date: April 17, 2025) =<br />\nNew: Shortcode support for multiple email campaign archives<br />\nNew: Shortcodes are now searchable<br />\nNew: Voxel Integration ( Product purchase history in contact )<br />\nNew: IPv6 compatibility Added<br />\nImprovement: WordPress version 6.8 compatible<br />\nImprovement: Toggle for column visibility in automation funnels table<br />\nImprovement: Unsaved changes warning in block editor<br />\nImprovement: More translations string added<br />\nImprovement: Search functionality for System Logs<br />\nFixed: Global footer displaying incorrectly in email previews<br />\nFixed: Custom field values couldn\'t be cleared once set<br />\nFixed: Custom email footer settings import issue<br />\nFixed: Encoding issue in Custom Field Text<br />\nFixed: Label search functionality errors<br />\nFixed: Fatal error during funnel import process<br />\nFixed: AB Cart Tag and list not removing after order completion</p>\n<p>= 2.9.48 (Date: March 20, 2025) =<br />\nNew: Re-apply Option for Completed Sequence<br />\nNew: Tags and Lists are now searchable in Dynamic Selection<br />\nNew: Selectable Custom Fields now Editable & Sortable<br />\nNew: Smartcodes for WooCommerce Subscription Triggers<br />\nImprovement: Added Copy email and phone from contact lists<br />\nImprovement: Tags and lists display in ascending order<br />\nImprovement: LearnPress course finished hook Updated<br />\nImprovement: Latest Post Block now displays all custom post types<br />\nimprovement: Added currency to Shipping and Tax Total<br />\nImprovement: Introduced Filter to manage new bounced email<br />\nImprovement: Tags and subscriber lists now sorted in ascending order<br />\nImprovement: Added operator type selection for taxonomy filters in LatestPost Block<br />\nFixed: Padding, Margin, and Line-Height issues inside Column block<br />\nFixed: Dynamic coupon amount issue with existing template<br />\nFixed: Excerpt length of LatestPostBlock issue<br />\nFixed: Update Contact Property Action float subtraction issue<br />\nOther Improvements & Bug Fixes</p>\n<p>= 2.9.45 (Date: February 24, 2025) =<br />\nNew: Subscription Cancelled Trigger (Fluent Forms)<br />\nNew: Subscription Payment Received Trigger (Fluent Forms)<br />\nNew: FluentForm Subscriptions Widget in Contact Profile<br />\nNew: Update Custom Fields Using Bulk Actions<br />\nNew: Filter option for failed emails<br />\nNew: Show non-recurring memberships in MemberPress Widget<br />\nNew: Woo Subscription Cancelled trigger<br />\nNew: Option to sort custom fields<br />\nNew: Wishlist Membership Widget in Contact Profile<br />\nImprovement: The slug retains one character even after the title is cleared<br />\nImprovement: Display which user sent the campaign<br />\nImprovement: All tables with adjustable column widths<br />\nImprovement: Redesigned the Addons section with improved UI/UX<br />\nImprovement: Added tooltip for Skipped AB cart status<br />\nImprovement: Added a button to copy the bounce handler URL<br />\nFixed: Custom numeric field filter issue<br />\nFixed: WooCommerce Coupon Discount amount not working<br />\nOther Improvements & Bug Fixes</p>\n<p>= 2.9.40 (Date: January 22, 2025) =<br />\nNew: Quick Search in Automation Actions, Benchmarks, Goals<br />\nNew: MemberPress Subscriptions Widget<br />\nNew: Export/Import Email Campaign<br />\nNew: Export/Import Email Campaign Contacts<br />\nNew: Brevo (ex Sendinblue) Bounce Handler<br />\nNew: Support for Polish Characters in slug (Tags/Lists)<br />\nImprovement: Contact filtering options: Never Clicked/Opened<br />\nImprovement: Quick preview added in email templates<br />\nImprovement: Post Image Type for Latest Post block<br />\nImprovement: Current date in Update Contact Property action in Automation<br />\nImprovement: WooCommerce Product Image Styling (order_items_table)<br />\nImprovement: Back Button for Campaign Archives<br />\nImprovement: Restart section added in ‘Remove From List’ Trigger<br />\nImprovement: Added \'Check All\' option contact exporter<br />\nImprovement: More Filters in email campaign archive<br />\nImprovement: Added ‘Select All’ tag/list option while importing contacts<br />\nImprovement: UI Improvements (Automation Label Color)<br />\nImprovement: Smoother One-click Unsubscribe<br />\nImprovement: Coupon systems support for multi-vendor/extensions along with woocommerce<br />\nImprovement: Added Gravatar & Fallback Compliance for Contact Avatar<br />\nFixed: Spammed/Complained Status Issue in Bounce Handler<br />\nFixed: Theme colors not displaying in Emails<br />\nFixed: Pagination for recurring campaign emails<br />\nFixed: Sync WooCommerce order (trashed order issue)</p>\n<p>= 2.9.31 (Date: December 27, 2024) =<br />\nNew: Added Email Preview in Campaigns<br />\nImprovement: AB Cart item table responsive<br />\nImprovement: User delete option sync between compliance settings and general settings<br />\nImprovement: Replaced google fonts with Bunny<br />\nFixed: AB Cart Recovered Revenue issue<br />\nFixed: Campaigns revenue report issue<br />\nFixed: Latest Post Block random sort issue<br />\nFixed: Table alignment issue in blocks<br />\nFixed: Number values in the \'Text\' custom field misinterpreted as date issue.<br />\nFixed: Variable button size not working in block editor<br />\nFixed: MailChimp Migration import limitations<br />\nFixed: Theme & default color issue in editor<br />\nOther Improvements & Bug Fixes</p>\n<p>= 2.9.30 (Date: December 09, 2024) =<br />\nNew: Labels in Automations & Campaign<br />\nNew: WordPress date format support in Custom Field<br />\nNew: Test Outgoing Webhook functionality<br />\nImprovement: UI enhancements for Lists & Tags popover<br />\nImprovement: Corrected date handling<br />\nImprovement: Auto-Mapping CSV Fields with Custom Fields<br />\nImprovement: Better SQL Queries<br />\nImprovement: Users now searchable in manager settings<br />\nFixed: Default link color issue while editing the email template<br />\nFixed: Default values not working for Smartcode (manage_subscription_html, unsubscribe_html)<br />\nFixed: Ordering in Dashboard Chart<br />\nFixed: Campaign Revenue Report issues<br />\nFixed: URL decode issue in A/B Testing for Campaigns<br />\nFixed: Some Deprecation Warnings<br />\nOther Improvements & Bug Fixes</p>\n<p>= 2.9.25 (Date: October 16, 2024) =<br />\n- New: Export/Import Recurring Campaign<br />\n- New: Smart Code support in Custom Email Address field<br />\n- New: Customer Profile button for EDD<br />\n- New: Added internal description to the funnels page<br />\n- Improvement: Product Image  & Currency Added in Ab Cart Details/Email<br />\n- Improvement: Multiline Custom Field<br />\n- Improvement: UX in Latest Post Block<br />\n- Improvement: Added tax row in Abandoned Cart<br />\n- Improvement: Abandoned Cart Details Mobile Responsiveness<br />\n- Improvement: Sorting Option in Purchase History in Contact for Woo/EDD<br />\n- Improvement: Changing product now possible from block sidebar<br />\n- Fixed: URL encoding Issue<br />\n- Fixed: Automation Wait Delay Issue<br />\n- Fixed: Dashboard Chat Dates Order<br />\n- Fixed: Email Editor LetterCase<br />\n- Fixed: Company Custom Field CSV Import Issue<br />\n- Fixed: Company Custom Field Issue while creating<br />\n- Fixed: Smart Code wp.url Issue<br />\n- Fixed: Ab Cart Smart Code Issue<br />\n- Fixed: MemberPress Contact Import Issue<br />\n- Other Improvements & Bug Fixes</p>\n<p>= 2.9.24 (Date: Aug 20, 2024) =<br />\n- Hotfix: Abandoned Cart Condition Issue Fixed</p>\n<p>= 2.9.23 (Date: August 19, 2024) =<br />\n- Added Custom Field or Date of Birth on Wait Time in Automation<br />\n- Added WooCommerce Variation Product on Advanced Filter and Automation Conditions<br />\n- Added keyboard ⌘ (or ctr) + s to save emails and automations<br />\n- Added Links Report for Individual Contacts<br />\n- Fixed: Dynamic Segment Contact Count Issue<br />\n- Fied: WooCommerce Revenue Report Issue fixed on Contact Profile<br />\n- Added contact.company.* smartcodes<br />\n- Added SMTP2GO Bounce Handler</p>\n<p>= 2.9.20 (Date: August 12, 2024) =<br />\n- New: Abandoned Cart<br />\n- New: Built-in Automation Templates<br />\n- New: FluentSMTP logs to the Emails Section of Profile<br />\n- New: Email Filter to the Emails Section of Profile<br />\n- Fixed: Email Editor Issue<br />\n- Fixed: ActiveCampaign Import Contacts Issue<br />\n- Fixed: Event Tracking Fetch Issue<br />\n- Fixed: Sending Double opt-in Email<br />\n- Fixed: Webhook Issue<br />\n- Fixed: Automation Twice Run Issue<br />\n- Improvement: UI of the Custom Fields<br />\n- Other Improvements & Bug Fixes</p>\n<p>= 2.9.1 (Date: June 04, 2024) =<br />\n- Fixed Dynamic Posts Block Query Issue</p>\n<p>= 2.9.0 (Date: May 29, 2024) =<br />\n- New: WooCommerce Coupon Creation Action<br />\n- New: Custom Fields on Company Module<br />\n- New: Bricks Builder Conditional Elements Integration<br />\n- New: All Automations Activity Feed<br />\n- New: Create Tags on the fly from the contact profile<br />\n- New: Added taxonomy filter for Latest Post Block<br />\n- CSV Import Improvement<br />\n- Contact Bulk Actions Update - Now you can select all the contacts from the filter<br />\n- Improvement: Improved FluentCRM PHP API for Contacts<br />\n- Improvement: Improved FluentCRM REST API for Contacts<br />\n- Improvement: Advanced Filter Improvements<br />\n- Improvement: Automation Improvements & Bug Fixes<br />\n- Fixed: Thrive Suites Integration Issue Fixed<br />\n- Fixed: PHP 8.x Compatibility Issue Fixed for CSV import</p>\n<p>= 2.8.45 (Date: March 01, 2024) =<br />\n- New: WooCommerce Subscription Expiration Trigger<br />\n- New: WP User Role Based Segmentation for Advanced Filters<br />\n- New: BuddyBoss / BuddyPress Tags for Invites and Group Membership<br />\n- Performance: Improved Email Sending Database Queries<br />\n- Fix: WooCommerce Address Field Syncing Issue Fixed<br />\n- Fix: LearnDash Course SmartCode Issue Fixed<br />\n- Elementor Form Integration Improvement<br />\n- Security Improvement: Company Logo Auto Fetching File-Type Check Added</p>\n<p>= 2.8.44 (Date: Feb 06, 2024) =<br />\n- Improved Action Scheduler for Email Sending<br />\n- Added Campaign Email Shareable Link<br />\n- New Smart Codes - WP User<br />\n- Improved Contact Profile API<br />\n- Bug Fixes and Improvements<br />\n- Improved Data Clean-Up Tool<br />\n- Improved Security on Auto Login for Smart Links</p>\n<p>= 2.8.43 (Date: Jan 30, 2024) =<br />\n- Auto Login Option with Smart Links<br />\n- Add All Post Type for Recurring Campaigns Conditions<br />\n- Improved WooCommerce Orders History and Sync<br />\n- Email Campaign Analytics Improvement<br />\n- Fixed Template Import issue</p>\n<p>= 2.8.42 (Date: Jan 28, 2024) =<br />\n* Support For WooCommerce HPOS Integration<br />\n* Fixed Customer\'s Order History Issues<br />\n* Improve Litespeed Cache Compatibility</p>\n<p>= 2.8.40 (Date: Jan 26, 2024) =<br />\n* Multi Threader Email - Send Emails faster<br />\n* Custom Contacts Fields Grouping<br />\n* Event Tracking for contacts<br />\n* Latest Post Block improvement<br />\n* One-click List-Unsubscription Header<br />\n* System Logs for debugging<br />\n* New Goal/Benchmark Added for SureCart (pro)<br />\n* New Automation Trigger: Paid Membership Pro - Membership Cancelled (pro)<br />\n* Scheduled Jobs improvement<br />\n* Added Postal Server support for Email Bounce Handling<br />\n* Webview for Email Campaigns improvements and privacy improvements<br />\n* Other Improvements &amp; Bug Fixes</p>\n<p>= 2.8.33 (Date: Nov 03, 2023) =<br />\n* Fixed Spacing &amp; FontSize Issue<br />\n* Improvement &amp; Bug Fixes on Both Global &amp; Custom Footer<br />\n* Fixed Syntax Issue in Recurring Email History<br />\n* Fixed Email Open Performance Issue<br />\n* Other Improvements &amp; Bug Fixes</p>\n<p>= 2.8.32 (Date: Oct 27, 2023) =<br />\n* WooCommerce HPOS Compatibility Added<br />\n* Conditional Checks for LearnDash groups and items issue fixed<br />\n* Fixed Restart issue in UserLogin Trigger<br />\n* Permission UX Improvement with addition of Import Permission<br />\n* Color Improvement in Automations<br />\n* UI Improvement of Latest Post Block in Email Builder</p>\n<p>= 2.8.30 (Date: Sep 05, 2023) =<br />\n* Improvement on Company module<br />\n* New trigger: Company added to contact Trigger<br />\n* New Trigger: Company Removed Trigger<br />\n* Company Specific Automation Actions<br />\n* Custom email preference management page<br />\n* New Trigger: Contact Created<br />\n* Navigation and UI improvements<br />\n* Duplicate segment or export contacts<br />\n* Other improvements including translatable strings, permissions in CRM managers<br />\n* Other Bug Fixes</p>\n<p>= 2.8.20 (Date: Jul 18, 2023) =<br />\n* Campaign Email Scheduling and sending speed optimized<br />\n* DeepIntegration with TutorLMS<br />\n* Integration with SureCart<br />\n* New Trigger: SureCart Order payment refund<br />\n* New Trigger: SureCart Payment success<br />\n* New Triggers: Tutor LMS Lesson Completed<br />\n* New Triggers: RCP Subscription Expired<br />\n* Advanced Filtering: Empty/Not Empty Filter<br />\n* Confirmation prompt for email campaigns<br />\n* Double Opt-in Email pre-header<br />\n* Ability to delete contact profile picture<br />\n* Company attach/detach from bulk actions<br />\n* Autofill for Woo commerce checkout fields<br />\n* Schedule Email by time range</p>\n<p>= 2.8.0 (Date: Apr 14, 2023) =<br />\n* Added Company module<br />\n* More detailed contact overview<br />\n* Massive UI enhancements<br />\n* FluentCRM Navigation Experience<br />\n* Ability to check email preview for specific contacts<br />\n* New WooCommerce Subscription Triggers (Pro)<br />\n* Improvements and bug fixes</p>\n<p>= 2.7.40 (Date: Mar 01, 2023) =<br />\n* Fixed recurring emails date time issues<br />\n* Email Conditional Sections issues fixed<br />\n* List &amp; Tag selection UI improved<br />\n* Replaced Google Fonts with BunnyCDN fonts for frontend rending<br />\n* Campaign Email Activity Improvements<br />\n* Fixed Redirecting issues for non-Unicode characters<br />\n* Fixed import issue for Restrict Content Pro</p>\n<p>= 2.7.3 Date: Feb 10, 2023 =<br />\n* Fixed Versioning Issues</p>\n<p>= 2.7.2 Date: Feb 06, 2023 =<br />\n* Fixed Recurring Campaign Timezone issues<br />\n* Added New Smartcode for latest post title and Custom Date Format for smartcode<br />\n* Send Email Notification for new draft Email Campaign for recurring Campaign<br />\n* Elastic Email bounce handler added</p>\n<p>= 2.7.0 Date: Jan 23, 2023 =<br />\n* Latest post block<br />\n* Recurring campaign<br />\n* Improvements in Contact Filtering<br />\n* New developer documentation<br />\n* Refactored plugin and performance improvements<br />\n* Enhancements and bug fixes</p>\n<p>= 2.6.52 Date: Nov 24, 2022 =<br />\n* Conditional Sections on Visual Builder<br />\n* Email Preview issue on Campaign Review Screens<br />\n* Added Tag Based Redirect after Double Optin (Check Settings -&gt; Double Optin)<br />\n* Date Time Filters issue fixed for custom Fields<br />\n* Template Import / Export<br />\n* Save as Template from Campaign Screen</p>\n<p>= 2.6.5 Date: Nov 17, 2022 =<br />\n* Brand New Drag and Drop Email Builder<br />\n* Email Audit for invalid Links for Email Editor<br />\n* Integration Improvements (Woo, BuddyPress)<br />\n* In-Page Documentation for top-level feature pages<br />\n* UI &amp; UX improvement across the full application<br />\n* Better Mobile optimized screens<br />\n* User registration automation trigger issues are solved</p>\n<p>= 2.6.0 (Date: Oct 20, 2022) =<br />\n* New Trigger: Birthday Automation<br />\n* New Trigger: Leave from a Course (LearnDash)<br />\n* New Action: Remove WordPress User Role<br />\n* Advanced Contact Filters: Email campaign, sequence, automation activity conditions<br />\n* New WooCommerce/EDD/LearnDash/LifterLMS conditions<br />\n* Experimental: Email Archives in the frontend<br />\n* Faster email editor<br />\n* Select and modify email template blocks in bulk<br />\n* Improved Email Sequences<br />\n* Improvement on Automation Goals<br />\n* Experimental features for Faster Contact Navigations, Date Formats<br />\n* UI &amp; UX Improvements<br />\n* Bug fixes and minor improvements</p>\n<p>= 2.5.95 (Date: Aug 19, 2022) =<br />\n* Advanced wait action in Automation<br />\n* Added restart automation to all(almost) triggers<br />\n* Sequence filtering for automation<br />\n* View revenue for specific emails<br />\n* Create Fluent Support tickets from Automation<br />\n* Split test automation scenarios (pro)<br />\n* Revenue metrics in email sequences<br />\n* More conditions in Advanced Filtering (pro)<br />\n* Enable/Disable auto sync for integrated tools<br />\n* Email preference management short-code<br />\n* Detailed CRM reporting (pro)<br />\n* Pre-populate Fluent Forms data from FluentCRM<br />\n* Bug fixes &amp; improvements</p>\n<p>= 2.5.93 (Date: July 07, 2022 ) =<br />\n* Improved scheduled campaigns<br />\n* Huge Performance Improvement<br />\n* Fixed Country Name Filters<br />\n* Improved Contact Imports<br />\n* WP User Sync Issue fixed<br />\n* Contact Exclude from campaign fixed<br />\n* WP Ultimo conflict issue resolved</p>\n<p>= 2.5.91 (Date: May 28, 2022 ) =<br />\n* Fixed WooCommerce Data Sync</p>\n<p>= 2.5.9 (Date: May 27, 2022 ) =<br />\n* WooCommerce Subscriptions integration<br />\n* EDD Software Licensing integration<br />\n* MemberPress Contact Importer<br />\n* Export contacts by advanced filters<br />\n* Export/Import Email Sequences<br />\n* New bulk action: send double opt in<br />\n* Manual actions: delete contact, add contact to automation &amp; email sequences<br />\n* Fetch profile picture from Fluent Forms entry<br />\n* Smartcode/Merge tags Transformer<br />\n* Improvements and bug fixes</p>\n<p>= 2.5.7 (Date: March 07, 2022 ) =<br />\n* Added Merge tags for WooCommerce, Affiliate WP, LearnDash and LifterLMS<br />\n* Fixed issue with LearnDash events<br />\n* Added option to add contacts to an Automation<br />\n* Added option to add contacts to an Email Sequence<br />\n* Fixed campaign sending issue for some server<br />\n* Double Optin issue has been fixed<br />\n* Integration Improvements<br />\n* UI Improvements</p>\n<p>= 2.5.6 (Date: February 28, 2022 ) =<br />\n* Added Auto Migration from ActiveCampaign, MailerLite, MailChimp, Drip, ConvertKit<br />\n* Fixed CSV Import Issue for duplicate emails<br />\n* Email Builder Issues fixed for the latest version of WP<br />\n* Improved Contact Filtering<br />\n* Integration Improvements<br />\n* Improved UI</p>\n<p>= 2.5.5 (Date: February 07, 2022 ) =<br />\n* Bulk Actions Improvements for Contacts<br />\n* Add Name Prefix filter to Advanced Filter<br />\n* WooCommerce Data Sync and Automations issues Fixed<br />\n* EDD Advanced Filter and Automation Triggers Fixed<br />\n* Email sequence issues fixed<br />\n* Webhook issues fixed<br />\n* UI &amp; UX improvements</p>\n<p>= 2.5.4 (Date: February 06, 2022 ) =<br />\n* (HOT FIX) Fix Multiple Automation Trigger for Woo and EDD</p>\n<p>= 2.5.3 (Date: February 01, 2022 ) =<br />\n* Compatability with WordPress 5.9<br />\n* Improved Email Builder<br />\n* CSV import duplicate data issue fixed<br />\n* Automation Improvement<br />\n* Tagging Improvement<br />\n* Fixed Advanced Filters for Woo,EDD,LearnDash and LifterLMS<br />\n* Fixed JSON issue for HTTP Action<br />\n* UI&amp;UX improvement in several screens across the app</p>\n<p>= 2.5.1 (Date: January 28, 2022) =<br />\n* Micro-target contacts!<br />\n* Send targeted email campaigns<br />\n* Create better dynamic segments<br />\n* Run automation with advanced conditional logic!<br />\n* Synchronize WooCommerce, EDD, LifterLMS, and LearnDash data!<br />\n* Import EDD &amp; WooCommerce contacts by product purchases!<br />\n* View customer summary at a glance!<br />\n* Advanced reporting (for WooCommerce, EDD, LifterLMS, and LearnDash)<br />\n* Enroll/Remove students and Add/Remove memberships, automatically!<br />\n* Automate emails for trial products<br />\n* New Goal: Email Sequence Completed<br />\n* Beaver Builder subscription form integration<br />\n* Bug fixes &amp; improvements</p>\n<p>= 2.3.1 (Date: July 20, 2021) =<br />\n* BuddyBoss/BuddyPress Integration<br />\n* ThriveCart Integration (Addon)<br />\n* LearnPress Integration<br />\n* Dynamically Import Existing users from LMS/Membership/BuddyBoss<br />\n* Email Editor Improvement<br />\n* Persistent Contact Page<br />\n* Dynamic Segment Improvement and Bulk Operations<br />\n* Automation Funnel Improvement<br />\n* Integration improvements<br />\n* ... and so many new features and improvements</p>\n<p>= 2.2.0 (Date: July 20, 2021) =<br />\n* Whole New Dashboard Design<br />\n* Added Lots of WooCommerce Integrations<br />\n* More integration added with LifterLMS, LearnDash, and TutorLMS<br />\n* Outgoing Webhook in Automation<br />\n* WooCommerce Conditional Block and new action and triggers added<br />\n* User Registration Action Block added to Automation<br />\n* Custom fields improvements<br />\n* Added Plain Text Email Template<br />\n* Added Fluent Forms force subscribe feature<br />\n* User role-based tagging feature added<br />\n* Added Redirection Option after Double-Optin<br />\n* Email Builder Blocks Improvements<br />\n* Add Option to remove contacts on WP User delete<br />\n* Showing in details purchase history from WooCommerce on Contact Screen<br />\n* Webhook bounce handler with all major Email Service providers</p>\n<p>= 2.0.4 (Date: June 03, 2021) =<br />\n* This is a minor update (no new feature, sorry!)<br />\n* Webhook issue fixed for some providers<br />\n* ENd Funnel Issues Fixed<br />\n* Fix CRON Issues for some specific server<br />\n* UI Color issue fixed<br />\n* Fluent Forms conditional issues fixed</p>\n<p>= 2.0.3 (Date: May 07, 2021) =<br />\n* Add Selected Days to Sending Emails for Email Sequences<br />\n* Fix CRON Jobs issues<br />\n* Image alignment issue for Emails fixed</p>\n<p>= 2.0.2 (Date: May 03, 2021) =<br />\n* Condition Content Block for Oxygen Builder<br />\n* Restart Automation<br />\n* Color Codes for Automation Blocks<br />\n* NEW: WooCommerce Product Refund Trigger<br />\n* New: Notes and Activities Action Block<br />\n* Email Sending Speed Improvement<br />\n* Build-in Documentation Page<br />\n* Lots Improvements and Fixes</p>\n<p>= 2.0.1 (Date: March 31, 2021) =<br />\n* CSV Issue Fixed<br />\n* New: Added Contact Property Update from Automation<br />\n* New: WooCommerce Subscription Box in Checkout Page<br />\n* Automation UI improvement</p>\n<p>= 2.0.0 (Date: March 30, 2021) =<br />\n* Multi-Path Conditional Automation Funnel<br />\n* New Automation Triggers and Blocks<br />\n* CRM Access Roles<br />\n* SmartLinks Improvements<br />\n* More Analytics Data<br />\n* Share an Automation<br />\n* Better RTL Support and Fully Translatable<br />\n* Automation Funnels Improvement<br />\n* RTL issues resolved<br />\n* Email Builder Improvements<br />\n* CSV Import issues fixed<br />\n* Email sending speed improvement<br />\n* Contact Data syncing with WordPress Users<br />\n* Overall UI and REST API improvements</p>\n<p>= 1.1.92 (Date: January 25, 2021) =<br />\n* Added SmartLinks for adding tags and lists dynamically on click tracking<br />\n* Export Contacts Feature added<br />\n* Added Post/Page Block for Dynamic content based on tag or login state<br />\n* Added feature to delete old logs<br />\n* Added all emails activity page<br />\n* Fix issue on dynamic smart tags on email subject<br />\n* UI improvement<br />\n* Added FluentSMTP Support</p>\n\";}s:7:\"banners\";s:41:\"a:2:{s:4:\"high\";s:0:\"\";s:3:\"low\";s:0:\"\";}\";s:5:\"icons\";s:222:\"a:2:{s:2:\"1x\";s:91:\"https://wpmanageninja.com/wp-content/uploads/edd/2020/10/fluentCRM_sales_banner-128x128.png\";s:2:\"2x\";s:91:\"https://wpmanageninja.com/wp-content/uploads/edd/2020/10/fluentCRM_sales_banner-256x256.png\";}\";}}", "off");
INSERT INTO `wp_options` VALUES("8067", "adminhash", "a:2:{s:4:\"hash\";s:32:\"d21dab45ab7b43b9099d73ec575703de\";s:8:\"newemail\";s:21:\"fanaei.amin@gmail.com\";}", "off");
INSERT INTO `wp_options` VALUES("8086", "duplicator_dismissed_admin_notices", "a:1:{s:14:\"review_request\";a:1:{s:4:\"time\";i:1745944530;}}", "on");
INSERT INTO `wp_options` VALUES("8099", "edd_sl_3e5c372e0293bcaf3fffbb030f29724f", "a:2:{s:7:\"timeout\";i:1745955908;s:5:\"value\";s:34381:\"{\"new_version\":\"3.10.4\",\"stable_version\":\"3.10.4\",\"name\":\"Ultimate Dashboard PRO\",\"slug\":\"ultimate-dashboard-pro\",\"url\":\"https:\\/\\/wp-pagebuilderframework.com\\/downloads\\/ultimate-dashboard-pro\\/?changelog=1\",\"last_updated\":\"2025-01-26 10:12:26\",\"homepage\":\"https:\\/\\/wp-pagebuilderframework.com\\/downloads\\/ultimate-dashboard-pro\\/\",\"package\":\"\",\"download_link\":\"\",\"sections\":{\"description\":\"\",\"changelog\":\"<p>Version 3.10.4 - January 26, 2025<\\/p>\\n<ul>\\n<li>Tweak: Improved Bricks support<\\/li>\\n<\\/ul>\\n<p>Version 3.10.3 - November 18, 2024<\\/p>\\n<ul>\\n<li>Fixed: Issue where custom login page logo won\\u2019t show after the release of WordPress 6.7<\\/li>\\n<\\/ul>\\n<p>Version 3.10.1 - August 20, 2024<\\/p>\\n<ul>\\n<li>Fixed: Fatal error in the WordPress admin area if \\u201cHowdy\\u201d-text was changed due to recent WordPress core update (6.6.1)<\\/li>\\n<\\/ul>\\n<p>Version 3.10 - June 19, 2024<\\/p>\\n<ul>\\n<li>New: Dark Mode (experimental)<\\/li>\\n<li>New: Move sub-menu items across top-level menu items in the Admin Menu Editor<\\/li>\\n<li>Tweak: Overall improvements to the Admin Menu Editor<\\/li>\\n<li>Tweak: Overall UI\\/UX improvements<\\/li>\\n<li>Fixed: Performance issues related to the Admin Menu Editor<\\/li>\\n<li>Fixed: Oxygen integration<\\/li>\\n<li>Fixed: Brizy integration<\\/li>\\n<\\/ul>\\n<p>Version 3.9 - January 10, 2024<\\/p>\\n<ul>\\n<li>New: Gutenberg support for Custom Admin Pages<\\/li>\\n<li>New: Divi support for Custom Admin Pages &amp; Page Builder Dashboard<\\/li>\\n<\\/ul>\\n<p>Version 3.8 - January 03, 2024<\\/p>\\n<ul>\\n<li>New: Breakdance support for Custom Admin Pages &amp; Page Builder Dashboard<\\/li>\\n<\\/ul>\\n<p>Version 3.7.0.1 - February 13, 2023<\\/p>\\n<ul>\\n<li>Hotfix: Error with newly introduced Bricks support for Custom Admin Pages.<\\/li>\\n<\\/ul>\\n<p>Version 3.7 - February 10, 2023<\\/p>\\n<ul>\\n<li>New: Bricks Builder support for Custom Admin Pages &amp; Page Builder Dashboard<\\/li>\\n<\\/ul>\\n<p>Version 3.6.4 - July 02, 2022<\\/p>\\n<ul>\\n<li>New: Change the WordPress block editor logo<\\/li>\\n<li>New: Added support for Oxygen 4.0<\\/li>\\n<\\/ul>\\n<p>Version 3.6.3 - June 15, 2022<\\/p>\\n<ul>\\n<li>Tweak: Login Customizer adjustments<\\/li>\\n<\\/ul>\\n<p>Version 3.6.2 - May 13, 2022<\\/p>\\n<ul>\\n<li>Tweak: Further improved Admin Menu Editor functionality<\\/li>\\n<\\/ul>\\n<p>Version 3.6.1 - May 04, 2022<\\/p>\\n<ul>\\n<li>Fixed: Deleting users didn\'t work in Admin Menu Editor<\\/li>\\n<li>Fixed: Some sub-menu items won\\u2019t loade in the Admin Menu Editor, for instance in the WooCommerce Analytics section. If you still don\\u2019t see certain menu or sub-menu items appear, please try resetting the Admin Menu Editor for all or specific user roles.<\\/li>\\n<\\/ul>\\n<p>Version 3.6.0.1 - April 26, 2022<\\/p>\\n<ul>\\n<li>Fixed: Rare fatal error when Admin Menu Editor is disabled under Modules<\\/li>\\n<\\/ul>\\n<p>Version 3.6 - April 25, 2022<\\/p>\\n<ul>\\n<li>New: Refactored import\\/export functionality to allow for more granular control when exporting settings<\\/li>\\n<li>New: Placeholder tags to display information dynamically in Admin Bar &amp; Admin Menu Editor<\\/li>\\n<li>Fixed: Build Admin Menu Editor only when a specific role is clicked instead of loading them all at once (in a row). This was causing performance issues &amp; was interpreted as a security issue by some installs.<\\/li>\\n<li>Fixed: Sub menus disappear when parent menu URL was changed (Admin Menu Editor)<\\/li>\\n<\\/ul>\\n<p>Version 3.5.2 - February 11, 2022<\\/p>\\n<ul>\\n<li>New: Filter to allow 3rd parties to add styles &amp; scripts where we generate the content for admin pages &amp; page builder dashboard (udb_pro_output_builder_content)<\\/li>\\n<li>Fixed: SVG menu items (Admin Menu Editor) don\'t work properly<\\/li>\\n<li>Fixed: Foundation icons won\'t load properly on page builder dashboard with Beaver Builder<\\/li>\\n<\\/ul>\\n<p>Version 3.5.1 - September 07, 2021<\\/p>\\n<ul>\\n<li>Fixed: Brizy support for Admin Pages &amp; Page Builder Framework feature<\\/li>\\n<\\/ul>\\n<p>Version 3.5 - August 19, 2021<\\/p>\\n<ul>\\n<li>New: Oxygen support for Admin Pages<\\/li>\\n<li>New: Oxygen support for Page Builder Dashboard feature<\\/li>\\n<li>New: Change WordPress\' Howdy text (multisite support)<\\/li>\\n<li>New: Change WordPress login URL (multisite support)<\\/li>\\n<li>New: Login Redirect feature (multisite support)<\\/li>\\n<li>New: Redirect yoursite.com\\/wp-admin\\/ for non logged-in users (multisite support)<\\/li>\\n<li>New: Add overlay to Login Customizer background images<\\/li>\\n<li>Tweak: Improved assets rendering if Beaver Builder is used with custom Admin Pages<\\/li>\\n<li>Fixed: PHP warning when 3rd party dashboard widgets are removed<\\/li>\\n<li>Fixed: Bug in Login Customizer output if subsite is set to be blueprint<\\/li>\\n<li>Fixed: Some 3rd party menu items did not appear in the Admin Menu Editor<\\/li>\\n<li>Fixed: Some 3rd party menu items did not appear in the Admin Bar Editor<\\/li>\\n<li>Fixed: Settings link on the plugin screen links to non-existent page<\\/li>\\n<li>Fixed: Remove data on uninstall on multisite installations<\\/li>\\n<li>Fixed: Issue with Elementors new Admin Bar &amp; Ultimate Dashboard PRO\'s modern layout<\\/li>\\n<\\/ul>\\n<p>Version 3.4 - June 22, 2021<\\/p>\\n<ul>\\n<li>New: Advanced White Label settings<\\/li>\\n<\\/ul>\\n<p>Version 3.3.4 - June 8, 2021<\\/p>\\n<ul>\\n<li>New: WordPress admin body classes on multisites: udb-network-admin, udb-is-main-site, udb-is-subsite, udb-site-{site-id}<\\/li>\\n<li>New: Multisite support for our new Welcome Panel feature<\\/li>\\n<li>Tweak: Move Page Builder Dashboard feature to its own metabox<\\/li>\\n<li>Fixed: Rare fatal error with Brizy<\\/li>\\n<li>Fixed: Admin menu doesn\'t apply to super admin if configured specifically for that user in the Admin Menu Editor<\\/li>\\n<\\/ul>\\n<p>Version 3.3.3 - June 1, 2021<\\/p>\\n<ul>\\n<li>New: Remember Users\\/Roles tab when saving in Admin Menu Editor<\\/li>\\n<li>Tweak: Execute Admin Menu changes late to affect all 3rd party plugins<\\/li>\\n<li>Tweak: Notices for super admins that changes made to the Admin Bar and Admin Menu Editor won\'t apply to them<\\/li>\\n<li>Tweak: Exclude super admin from Admin Bar Editor output<\\/li>\\n<li>Tweak: Include senders email address in contact form widget email<\\/li>\\n<li>Fixed: Issue with sub-menu item order with LifterLMS and other 3rd party plugins if Admin Menu Editor is configured<\\/li>\\n<\\/ul>\\n<p>Version 3.3.2 - May 22, 2021<\\/p>\\n<ul>\\n<li>New: Add separators to your admin menu with the Admin Menu Editor<\\/li>\\n<li>Tweak: Show warnings before resetting the Admin Menu &amp; Admin Bar Editor<\\/li>\\n<li>Fixed: Admin Bar Editor settings on non-blueprint sites (multisite) don\'t take effect.<\\/li>\\n<li>Fixed: Some sub menu items can\'t be removed with the Admin Menu Editor<\\/li>\\n<li>Fixed: Custom Admin Pages &amp; Page Builder Dashboard template didn\'t update when the design was changed with Brizy<\\/li>\\n<li>Fixed: On multisites, all menu items are shown no matter what role is selected<\\/li>\\n<li>Fixed: Added missing license key mismatch notice to license page<\\/li>\\n<\\/ul>\\n<p>Version 3.3.1 - May 19, 2021<\\/p>\\n<ul>\\n<li>New: Brizy support for Admin Pages &amp; the Page Builder Dashboard feature<\\/li>\\n<li>Tweak: License key mismatch detection &amp; warning<\\/li>\\n<\\/ul>\\n<p>Version 3.3 - April 15, 2021<\\/p>\\n<ul>\\n<li>New: Admin Bar Editor<\\/li>\\n<li>Fixed: All widgets were active\\/inactive after import, even though if they were active\\/inactive on the original website<\\/li>\\n<\\/ul>\\n<p>Version 3.2 - March 04, 2021<\\/p>\\n<ul>\\n<li>New: Change the admin menu for specific user roles (Admin Menu Editor)<\\/li>\\n<li>New: Add custom menu items to the WordPress admin menu (Admin Menu Editor)<\\/li>\\n<li>New: Added RTL support for default &amp; modern layout (White Label)<\\/li>\\n<li>Tweak: Remove unnecessary menu items from subsites (Multisite Support)<\\/li>\\n<li>Tweak: Refactored \\\"Login Customizer\\\" CSS output<\\/li>\\n<li>Tweak: Removed unnecessary customizer tabs &amp; controls from non-blueprint subsites (Multisite Support)<\\/li>\\n<li>Fixed: Rare fatal error when user tried to access a site that they aren\'t a part of (Multisite Support)<\\/li>\\n<li>Fixed: Rare case where the admin menu was broken after configuring the Admin Menu Editor feature (Admin Menu Editor)<\\/li>\\n<li>Fixed: Broken Gutenberg editor with modern layout (White Label)<\\/li>\\n<li>Fixed: Modern layout admin bar was causing issues with 3rd party plugins (White Label)<\\/li>\\n<li>Fixed: Long menu item titles flow into icons with modern layout (White Label)<\\/li>\\n<li>Fixed: Glitch when switching layouts when form background color was applied (Login Customizer)<\\/li>\\n<\\/ul>\\n<p>Version 3.1.3 - December 26, 2020<\\/p>\\n<ul>\\n<li>Fixed: Non-static method should not be called statically<\\/li>\\n<\\/ul>\\n<p>Version 3.1.2 - December 26, 2020<\\/p>\\n<ul>\\n<li>Fixed: Issue with new \\\"Modules\\\" feature on multisite installations result in fatal error<\\/li>\\n<li>Tweak: Show license page only on the main site of the network<\\/li>\\n<li>Tweak: License page styling<\\/li>\\n<\\/ul>\\n<p>Version 3.1.1 - December 09, 2020<\\/p>\\n<ul>\\n<li>Fixed: plugin updater issue<\\/li>\\n<\\/ul>\\n<p>Version 3.1 - December 09, 2020<\\/p>\\n<ul>\\n<li>New: Load modules conditionally based on settings in the free version<\\/li>\\n<li>Tweak: Updated &amp; improved settings page UI<\\/li>\\n<li>Tweak: Show \\\"free version required\\\" message to all users that can manage_options instead of only the main site of the multisite network to prevent it from being missed<\\/li>\\n<li>Fixed: WooCommerce layout with \\\"Modern\\\" admin styling<\\/li>\\n<\\/ul>\\n<p>Version 3.0 - October 27, 2020<\\/p>\\n<ul>\\n<li>Rewritten plugin from the ground up<\\/li>\\n<li>Ultimate Dashboard PRO now requires &amp; extends Ultimate Dashboard for better maintainability<\\/li>\\n<li>New: Admin Menu Editor<\\/li>\\n<li>Other tweaks &amp; improvements<\\/li>\\n<\\/ul>\\n<p>Version 2.11.5.1 - August 12, 2020<\\/p>\\n<ul>\\n<li>Fixed: Due to the new \\\"Active\\\" toggle, all existing dashboard widgets were hidden<\\/li>\\n<\\/ul>\\n<p>Version 2.11.5 - August 12, 2020<\\/p>\\n<ul>\\n<li>New: Option to remove FontAwesome<\\/li>\\n<li>New: Added super admin role to role settings<\\/li>\\n<li>New: Activate\\/deactivate toggle for Ultimate Dashboard widgets<\\/li>\\n<li>New: Multisite support for Custom Admin Pages<\\/li>\\n<li>New: Added French translation<\\/li>\\n<li>Fixed: WordPress 5.5 compatibility<\\/li>\\n<li>Fixed: Login page styling<\\/li>\\n<li>Fixed: Dashboard CSS doesn\'t take affect<\\/li>\\n<\\/ul>\\n<p>Version 2.11.4 - May 26, 2020<\\/p>\\n<ul>\\n<li>Fixed: HTML widget strips out iframes<\\/li>\\n<\\/ul>\\n<p>Version 2.11.3 - May 21, 2020<\\/p>\\n<ul>\\n<li>Maintenance release<\\/li>\\n<\\/ul>\\n<p>Version 2.11.2 - May 9, 2020<\\/p>\\n<ul>\\n<li>Fixed: PHP Notice: undefined title<\\/li>\\n<li>Fixed: Custom admin logo sits at the bottom of the admin area on subsites (Modern Layout)<\\/li>\\n<li>Fixed: Custom admin bar logo URL doesn\'t work<\\/li>\\n<li>Fixed: issue where blueprint settings were ported over to subsites (Multisite Support)<\\/li>\\n<\\/ul>\\n<p>Version 2.11.1 - May 5, 2020<\\/p>\\n<ul>\\n<li>Fixed: Creating an admin page with page builder doesn\'t work<\\/li>\\n<li>Fixed: Sanitizing CSS<\\/li>\\n<\\/ul>\\n<p>Version 2.11 - May 5, 2020<\\/p>\\n<ul>\\n<li>New: Create Admin Pages<\\/li>\\n<li>New: Filter to disable Login Customizer feature (udb_login_customizer)<\\/li>\\n<li>New: Filter to change admin bar logo (udb_admin_bar_logo_image)<\\/li>\\n<li>New: Use {home_url} inside the logo URL to dynamically fetch the current site\'s URL (Login Customizer, Multisite Support)<\\/li>\\n<li>Tweak: Inherit the main site logo size by default (Login Customizer, Multisite Support)<\\/li>\\n<li>Fixed: Display issues with Modern Layout &amp; Gutenberg (White Label)<\\/li>\\n<li>Fixed: Admin bar logo URL is missing from Modern Layout (White Label)<\\/li>\\n<li>Fixed: Screen Options tab is removed by default on multisite installations<\\/li>\\n<li>Fixed: Fatal error with WP Ultimo &amp; our \\\"Remove Help Tab\\\" feature during signup<\\/li>\\n<li>Fixed: Sanitization<\\/li>\\n<\\/ul>\\n<p>Version 2.10.1 - April 6, 2020<\\/p>\\n<ul>\\n<li>New: A<span class=\\\"css-p6tgoi edzl37l0\\\">dded support for health status widget<\\/span><\\/li>\\n<li>Tweak: Remove the auto-generated page - we found a better way! :)<\\/li>\\n<li>Fixed: <span class=\\\"css-p6tgoi edzl37l0\\\">Deprecated udb_pro_remove_help_tab notice<\\/span><\\/li>\\n<li>Fixed: Left\\/right customizer layouts are now responsive<\\/li>\\n<\\/ul>\\n<p>Version 2.10 - March 27, 2020<\\/p>\\n<ul>\\n<li>New: Login Customizer<\\/li>\\n<li>New: Restrict widgets to user roles<\\/li>\\n<li>New: Restrict widgets to specific users<\\/li>\\n<li>New: Modern wp-admin layout<\\/li>\\n<li>Tweak: Rewritten existing wp-admin layout from scratch<\\/li>\\n<li>Tweak: Restructured options &amp; sections<\\/li>\\n<li>Tweak: Overall code improvements &amp; improvements to the file structure<\\/li>\\n<li>Fixed: Long tooltips overlay icons so they can\'t be clicked<\\/li>\\n<li>Fixed: Widget order doesn\'t save<\\/li>\\n<\\/ul>\\n<p>Version 2.9 - February 19, 2020<\\/p>\\n<ul>\\n<li>New: Page Builder Support - Create a custom WordPress dashboard with Beaver Builder &amp; Elementor<\\/li>\\n<li>New: Option to set custom Logo URL for login screen<\\/li>\\n<li>New: Option to remove \\\"Help\\\" tab<\\/li>\\n<li>New: Option to remove \\\"Screen Options\\\" tab<\\/li>\\n<li>New: Option to change Dashboard headline<\\/li>\\n<li>New: Field to add custom CSS to the entire wp-admin area<\\/li>\\n<li>Tweak: White Label setting now has its own sub menu item<\\/li>\\n<li>Tweak: improved admin settings page styling<\\/li>\\n<\\/ul>\\n<p>Version 2.8.2 - January 3, 2020<\\/p>\\n<ul>\\n<li>Fixed: Text decoration issue<\\/li>\\n<\\/ul>\\n<p>Version 2.8.1 - November 28, 2019<\\/p>\\n<ul>\\n<li>Minor tweaks &amp; improvements<\\/li>\\n<li>Tweak: Optimized license key activation process + added revalidate button<\\/li>\\n<li>Fixed: Contact Form Widget logging doesn\'t work from subsites on a multisite installation<\\/li>\\n<\\/ul>\\n<p>Version 2.8 - November 16, 2019<\\/p>\\n<ul>\\n<li>Maintenance Release<\\/li>\\n<li>New: Hooks for developers to add custom widgets<\\/li>\\n<li>Fixed: Make widget order apply to newly registered users<\\/li>\\n<li>Fixed: Some Contact Form Widget features not working properly on multisites<\\/li>\\n<\\/ul>\\n<p>Version 2.7 - September 5, 2019<\\/p>\\n<ul>\\n<li>New: Contact Form Widget<\\/li>\\n<\\/ul>\\n<p>Version 2.6 - June 6, 2019<\\/p>\\n<ul>\\n<li>New: Import\\/Export Widgets &amp; Settings<\\/li>\\n<li>New: Improved UX\\/UI<\\/li>\\n<li>New: Option to remove data on uninstall<\\/li>\\n<li>Fixed: performance issue where the widget order setting caused an usermeta-update on every page load for all users<\\/li>\\n<\\/ul>\\n<p>Version 2.5 - December 12, 2018<\\/p>\\n<ul>\\n<li>New: HTML widget<\\/li>\\n<li>New: Custom Dashboard CSS field under Widgets -&gt; Settings<\\/li>\\n<li>Tweak: re-organized post columns<\\/li>\\n<li>Tweak: proper messages for udb_widgets custom post type<\\/li>\\n<\\/ul>\\n<p>Version 2.4.2 - October 12, 2018<\\/p>\\n<ul>\\n<li>Tweak: allow touch-action on widget headlines<\\/li>\\n<\\/ul>\\n<p>Version 2.4.1 - October 4, 2018<\\/p>\\n<ul>\\n<li>New: license key activation notice<\\/li>\\n<li>New: bail out if free version is active<\\/li>\\n<li>Tweak: cleaned up code base &amp; proper prefixing of all functions<\\/li>\\n<\\/ul>\\n<p>Version 2.4 - September 11, 2018<\\/p>\\n<ul>\\n<li>New: exclude certain websites from the \\\"blueprint\\\" dashboard<\\/li>\\n<li>New: custom admin bar logo URL<\\/li>\\n<li>Tweak: fixed logic for footer &amp; version text on subsites (subsite settings do now override blueprint settings)<\\/li>\\n<li>Fixed: admin bar styling &amp; admin bar logo settings don\'t apply to frontend<\\/li>\\n<li>Minor tweaks &amp; improvements<\\/li>\\n<\\/ul>\\n<p>Version 2.3 - July 30, 2018<\\/p>\\n<ul>\\n<li>New: video widget<\\/li>\\n<li>New: dashboard column setting<\\/li>\\n<li>New: custom admin bar logo<\\/li>\\n<li>New: widget headline color setting<\\/li>\\n<li>New: widget icon\\/text color setting<\\/li>\\n<li>Tweak: updated settings page UI<\\/li>\\n<\\/ul>\\n<p>Version 2.2.4 - 05\\/31\\/2018<\\/p>\\n<ul>\\n<li>Fixed: Number of Dashboard Widgets is limited by the \\\"Reading\\\" settings under Appearance -&gt; Reading<\\/li>\\n<\\/ul>\\n<p>Version 2.2.3 - 03\\/20\\/2018<\\/p>\\n<ul>\\n<li>Fixed: dashboard widgets are not being removed from subsites<\\/li>\\n<\\/ul>\\n<p>Version 2.2.2 - 03\\/18\\/2018<\\/p>\\n<ul>\\n<li>Fixed: some settings disappear after saving<\\/li>\\n<\\/ul>\\n<p>Version 2.2.1 - 03\\/18\\/2018<\\/p>\\n<ul>\\n<li>Fixed: action link not showing up on non-multisites<\\/li>\\n<\\/ul>\\n<p>Version 2.2 - 03\\/18\\/2018<\\/p>\\n<ul>\\n<li>maintenance release<\\/li>\\n<li>Added: action links<\\/li>\\n<li>Tweak: save deactivated dashboard widgets in a single array<\\/li>\\n<li>Fixed: errors when debug mode is turned on<\\/li>\\n<li>Fixed: wrong hook used to remove dashboard widgets<\\/li>\\n<\\/ul>\\n<p>Version 2.1 - 01\\/04\\/2018<\\/p>\\n<ul>\\n<li>New: Branding options<\\/li>\\n<li>Tweak: Branding options multisite compatibility<\\/li>\\n<\\/ul>\\n<p>Version 2.0.3 - 12\\/07\\/2017<\\/p>\\n<ul>\\n<li>Fixed: curl &amp; ssl issue<\\/li>\\n<\\/ul>\\n<p>Version 2.0.2 - 11\\/21\\/2017<\\/p>\\n<ul>\\n<li>Fixed: backwards compatibility<\\/li>\\n<\\/ul>\\n<p>Version 2.0.1 - 11\\/18\\/2017<\\/p>\\n<ul>\\n<li>Fixed: License key activation redirect<\\/li>\\n<\\/ul>\\n<p>Version 2.0 - 11\\/18\\/2017<\\/p>\\n<ul>\\n<li>Initial Release<\\/li>\\n<\\/ul>\\n\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":[],\"msg\":\"No license key has been provided.\",\"description\":[\"\"],\"changelog\":[\"<p>Version 3.10.4 - January 26, 2025<\\/p>\\n<ul>\\n<li>Tweak: Improved Bricks support<\\/li>\\n<\\/ul>\\n<p>Version 3.10.3 - November 18, 2024<\\/p>\\n<ul>\\n<li>Fixed: Issue where custom login page logo won\\u2019t show after the release of WordPress 6.7<\\/li>\\n<\\/ul>\\n<p>Version 3.10.1 - August 20, 2024<\\/p>\\n<ul>\\n<li>Fixed: Fatal error in the WordPress admin area if \\u201cHowdy\\u201d-text was changed due to recent WordPress core update (6.6.1)<\\/li>\\n<\\/ul>\\n<p>Version 3.10 - June 19, 2024<\\/p>\\n<ul>\\n<li>New: Dark Mode (experimental)<\\/li>\\n<li>New: Move sub-menu items across top-level menu items in the Admin Menu Editor<\\/li>\\n<li>Tweak: Overall improvements to the Admin Menu Editor<\\/li>\\n<li>Tweak: Overall UI\\/UX improvements<\\/li>\\n<li>Fixed: Performance issues related to the Admin Menu Editor<\\/li>\\n<li>Fixed: Oxygen integration<\\/li>\\n<li>Fixed: Brizy integration<\\/li>\\n<\\/ul>\\n<p>Version 3.9 - January 10, 2024<\\/p>\\n<ul>\\n<li>New: Gutenberg support for Custom Admin Pages<\\/li>\\n<li>New: Divi support for Custom Admin Pages &amp; Page Builder Dashboard<\\/li>\\n<\\/ul>\\n<p>Version 3.8 - January 03, 2024<\\/p>\\n<ul>\\n<li>New: Breakdance support for Custom Admin Pages &amp; Page Builder Dashboard<\\/li>\\n<\\/ul>\\n<p>Version 3.7.0.1 - February 13, 2023<\\/p>\\n<ul>\\n<li>Hotfix: Error with newly introduced Bricks support for Custom Admin Pages.<\\/li>\\n<\\/ul>\\n<p>Version 3.7 - February 10, 2023<\\/p>\\n<ul>\\n<li>New: Bricks Builder support for Custom Admin Pages &amp; Page Builder Dashboard<\\/li>\\n<\\/ul>\\n<p>Version 3.6.4 - July 02, 2022<\\/p>\\n<ul>\\n<li>New: Change the WordPress block editor logo<\\/li>\\n<li>New: Added support for Oxygen 4.0<\\/li>\\n<\\/ul>\\n<p>Version 3.6.3 - June 15, 2022<\\/p>\\n<ul>\\n<li>Tweak: Login Customizer adjustments<\\/li>\\n<\\/ul>\\n<p>Version 3.6.2 - May 13, 2022<\\/p>\\n<ul>\\n<li>Tweak: Further improved Admin Menu Editor functionality<\\/li>\\n<\\/ul>\\n<p>Version 3.6.1 - May 04, 2022<\\/p>\\n<ul>\\n<li>Fixed: Deleting users didn\'t work in Admin Menu Editor<\\/li>\\n<li>Fixed: Some sub-menu items won\\u2019t loade in the Admin Menu Editor, for instance in the WooCommerce Analytics section. If you still don\\u2019t see certain menu or sub-menu items appear, please try resetting the Admin Menu Editor for all or specific user roles.<\\/li>\\n<\\/ul>\\n<p>Version 3.6.0.1 - April 26, 2022<\\/p>\\n<ul>\\n<li>Fixed: Rare fatal error when Admin Menu Editor is disabled under Modules<\\/li>\\n<\\/ul>\\n<p>Version 3.6 - April 25, 2022<\\/p>\\n<ul>\\n<li>New: Refactored import\\/export functionality to allow for more granular control when exporting settings<\\/li>\\n<li>New: Placeholder tags to display information dynamically in Admin Bar &amp; Admin Menu Editor<\\/li>\\n<li>Fixed: Build Admin Menu Editor only when a specific role is clicked instead of loading them all at once (in a row). This was causing performance issues &amp; was interpreted as a security issue by some installs.<\\/li>\\n<li>Fixed: Sub menus disappear when parent menu URL was changed (Admin Menu Editor)<\\/li>\\n<\\/ul>\\n<p>Version 3.5.2 - February 11, 2022<\\/p>\\n<ul>\\n<li>New: Filter to allow 3rd parties to add styles &amp; scripts where we generate the content for admin pages &amp; page builder dashboard (udb_pro_output_builder_content)<\\/li>\\n<li>Fixed: SVG menu items (Admin Menu Editor) don\'t work properly<\\/li>\\n<li>Fixed: Foundation icons won\'t load properly on page builder dashboard with Beaver Builder<\\/li>\\n<\\/ul>\\n<p>Version 3.5.1 - September 07, 2021<\\/p>\\n<ul>\\n<li>Fixed: Brizy support for Admin Pages &amp; Page Builder Framework feature<\\/li>\\n<\\/ul>\\n<p>Version 3.5 - August 19, 2021<\\/p>\\n<ul>\\n<li>New: Oxygen support for Admin Pages<\\/li>\\n<li>New: Oxygen support for Page Builder Dashboard feature<\\/li>\\n<li>New: Change WordPress\' Howdy text (multisite support)<\\/li>\\n<li>New: Change WordPress login URL (multisite support)<\\/li>\\n<li>New: Login Redirect feature (multisite support)<\\/li>\\n<li>New: Redirect yoursite.com\\/wp-admin\\/ for non logged-in users (multisite support)<\\/li>\\n<li>New: Add overlay to Login Customizer background images<\\/li>\\n<li>Tweak: Improved assets rendering if Beaver Builder is used with custom Admin Pages<\\/li>\\n<li>Fixed: PHP warning when 3rd party dashboard widgets are removed<\\/li>\\n<li>Fixed: Bug in Login Customizer output if subsite is set to be blueprint<\\/li>\\n<li>Fixed: Some 3rd party menu items did not appear in the Admin Menu Editor<\\/li>\\n<li>Fixed: Some 3rd party menu items did not appear in the Admin Bar Editor<\\/li>\\n<li>Fixed: Settings link on the plugin screen links to non-existent page<\\/li>\\n<li>Fixed: Remove data on uninstall on multisite installations<\\/li>\\n<li>Fixed: Issue with Elementors new Admin Bar &amp; Ultimate Dashboard PRO\'s modern layout<\\/li>\\n<\\/ul>\\n<p>Version 3.4 - June 22, 2021<\\/p>\\n<ul>\\n<li>New: Advanced White Label settings<\\/li>\\n<\\/ul>\\n<p>Version 3.3.4 - June 8, 2021<\\/p>\\n<ul>\\n<li>New: WordPress admin body classes on multisites: udb-network-admin, udb-is-main-site, udb-is-subsite, udb-site-{site-id}<\\/li>\\n<li>New: Multisite support for our new Welcome Panel feature<\\/li>\\n<li>Tweak: Move Page Builder Dashboard feature to its own metabox<\\/li>\\n<li>Fixed: Rare fatal error with Brizy<\\/li>\\n<li>Fixed: Admin menu doesn\'t apply to super admin if configured specifically for that user in the Admin Menu Editor<\\/li>\\n<\\/ul>\\n<p>Version 3.3.3 - June 1, 2021<\\/p>\\n<ul>\\n<li>New: Remember Users\\/Roles tab when saving in Admin Menu Editor<\\/li>\\n<li>Tweak: Execute Admin Menu changes late to affect all 3rd party plugins<\\/li>\\n<li>Tweak: Notices for super admins that changes made to the Admin Bar and Admin Menu Editor won\'t apply to them<\\/li>\\n<li>Tweak: Exclude super admin from Admin Bar Editor output<\\/li>\\n<li>Tweak: Include senders email address in contact form widget email<\\/li>\\n<li>Fixed: Issue with sub-menu item order with LifterLMS and other 3rd party plugins if Admin Menu Editor is configured<\\/li>\\n<\\/ul>\\n<p>Version 3.3.2 - May 22, 2021<\\/p>\\n<ul>\\n<li>New: Add separators to your admin menu with the Admin Menu Editor<\\/li>\\n<li>Tweak: Show warnings before resetting the Admin Menu &amp; Admin Bar Editor<\\/li>\\n<li>Fixed: Admin Bar Editor settings on non-blueprint sites (multisite) don\'t take effect.<\\/li>\\n<li>Fixed: Some sub menu items can\'t be removed with the Admin Menu Editor<\\/li>\\n<li>Fixed: Custom Admin Pages &amp; Page Builder Dashboard template didn\'t update when the design was changed with Brizy<\\/li>\\n<li>Fixed: On multisites, all menu items are shown no matter what role is selected<\\/li>\\n<li>Fixed: Added missing license key mismatch notice to license page<\\/li>\\n<\\/ul>\\n<p>Version 3.3.1 - May 19, 2021<\\/p>\\n<ul>\\n<li>New: Brizy support for Admin Pages &amp; the Page Builder Dashboard feature<\\/li>\\n<li>Tweak: License key mismatch detection &amp; warning<\\/li>\\n<\\/ul>\\n<p>Version 3.3 - April 15, 2021<\\/p>\\n<ul>\\n<li>New: Admin Bar Editor<\\/li>\\n<li>Fixed: All widgets were active\\/inactive after import, even though if they were active\\/inactive on the original website<\\/li>\\n<\\/ul>\\n<p>Version 3.2 - March 04, 2021<\\/p>\\n<ul>\\n<li>New: Change the admin menu for specific user roles (Admin Menu Editor)<\\/li>\\n<li>New: Add custom menu items to the WordPress admin menu (Admin Menu Editor)<\\/li>\\n<li>New: Added RTL support for default &amp; modern layout (White Label)<\\/li>\\n<li>Tweak: Remove unnecessary menu items from subsites (Multisite Support)<\\/li>\\n<li>Tweak: Refactored \\\"Login Customizer\\\" CSS output<\\/li>\\n<li>Tweak: Removed unnecessary customizer tabs &amp; controls from non-blueprint subsites (Multisite Support)<\\/li>\\n<li>Fixed: Rare fatal error when user tried to access a site that they aren\'t a part of (Multisite Support)<\\/li>\\n<li>Fixed: Rare case where the admin menu was broken after configuring the Admin Menu Editor feature (Admin Menu Editor)<\\/li>\\n<li>Fixed: Broken Gutenberg editor with modern layout (White Label)<\\/li>\\n<li>Fixed: Modern layout admin bar was causing issues with 3rd party plugins (White Label)<\\/li>\\n<li>Fixed: Long menu item titles flow into icons with modern layout (White Label)<\\/li>\\n<li>Fixed: Glitch when switching layouts when form background color was applied (Login Customizer)<\\/li>\\n<\\/ul>\\n<p>Version 3.1.3 - December 26, 2020<\\/p>\\n<ul>\\n<li>Fixed: Non-static method should not be called statically<\\/li>\\n<\\/ul>\\n<p>Version 3.1.2 - December 26, 2020<\\/p>\\n<ul>\\n<li>Fixed: Issue with new \\\"Modules\\\" feature on multisite installations result in fatal error<\\/li>\\n<li>Tweak: Show license page only on the main site of the network<\\/li>\\n<li>Tweak: License page styling<\\/li>\\n<\\/ul>\\n<p>Version 3.1.1 - December 09, 2020<\\/p>\\n<ul>\\n<li>Fixed: plugin updater issue<\\/li>\\n<\\/ul>\\n<p>Version 3.1 - December 09, 2020<\\/p>\\n<ul>\\n<li>New: Load modules conditionally based on settings in the free version<\\/li>\\n<li>Tweak: Updated &amp; improved settings page UI<\\/li>\\n<li>Tweak: Show \\\"free version required\\\" message to all users that can manage_options instead of only the main site of the multisite network to prevent it from being missed<\\/li>\\n<li>Fixed: WooCommerce layout with \\\"Modern\\\" admin styling<\\/li>\\n<\\/ul>\\n<p>Version 3.0 - October 27, 2020<\\/p>\\n<ul>\\n<li>Rewritten plugin from the ground up<\\/li>\\n<li>Ultimate Dashboard PRO now requires &amp; extends Ultimate Dashboard for better maintainability<\\/li>\\n<li>New: Admin Menu Editor<\\/li>\\n<li>Other tweaks &amp; improvements<\\/li>\\n<\\/ul>\\n<p>Version 2.11.5.1 - August 12, 2020<\\/p>\\n<ul>\\n<li>Fixed: Due to the new \\\"Active\\\" toggle, all existing dashboard widgets were hidden<\\/li>\\n<\\/ul>\\n<p>Version 2.11.5 - August 12, 2020<\\/p>\\n<ul>\\n<li>New: Option to remove FontAwesome<\\/li>\\n<li>New: Added super admin role to role settings<\\/li>\\n<li>New: Activate\\/deactivate toggle for Ultimate Dashboard widgets<\\/li>\\n<li>New: Multisite support for Custom Admin Pages<\\/li>\\n<li>New: Added French translation<\\/li>\\n<li>Fixed: WordPress 5.5 compatibility<\\/li>\\n<li>Fixed: Login page styling<\\/li>\\n<li>Fixed: Dashboard CSS doesn\'t take affect<\\/li>\\n<\\/ul>\\n<p>Version 2.11.4 - May 26, 2020<\\/p>\\n<ul>\\n<li>Fixed: HTML widget strips out iframes<\\/li>\\n<\\/ul>\\n<p>Version 2.11.3 - May 21, 2020<\\/p>\\n<ul>\\n<li>Maintenance release<\\/li>\\n<\\/ul>\\n<p>Version 2.11.2 - May 9, 2020<\\/p>\\n<ul>\\n<li>Fixed: PHP Notice: undefined title<\\/li>\\n<li>Fixed: Custom admin logo sits at the bottom of the admin area on subsites (Modern Layout)<\\/li>\\n<li>Fixed: Custom admin bar logo URL doesn\'t work<\\/li>\\n<li>Fixed: issue where blueprint settings were ported over to subsites (Multisite Support)<\\/li>\\n<\\/ul>\\n<p>Version 2.11.1 - May 5, 2020<\\/p>\\n<ul>\\n<li>Fixed: Creating an admin page with page builder doesn\'t work<\\/li>\\n<li>Fixed: Sanitizing CSS<\\/li>\\n<\\/ul>\\n<p>Version 2.11 - May 5, 2020<\\/p>\\n<ul>\\n<li>New: Create Admin Pages<\\/li>\\n<li>New: Filter to disable Login Customizer feature (udb_login_customizer)<\\/li>\\n<li>New: Filter to change admin bar logo (udb_admin_bar_logo_image)<\\/li>\\n<li>New: Use {home_url} inside the logo URL to dynamically fetch the current site\'s URL (Login Customizer, Multisite Support)<\\/li>\\n<li>Tweak: Inherit the main site logo size by default (Login Customizer, Multisite Support)<\\/li>\\n<li>Fixed: Display issues with Modern Layout &amp; Gutenberg (White Label)<\\/li>\\n<li>Fixed: Admin bar logo URL is missing from Modern Layout (White Label)<\\/li>\\n<li>Fixed: Screen Options tab is removed by default on multisite installations<\\/li>\\n<li>Fixed: Fatal error with WP Ultimo &amp; our \\\"Remove Help Tab\\\" feature during signup<\\/li>\\n<li>Fixed: Sanitization<\\/li>\\n<\\/ul>\\n<p>Version 2.10.1 - April 6, 2020<\\/p>\\n<ul>\\n<li>New: A<span class=\\\"css-p6tgoi edzl37l0\\\">dded support for health status widget<\\/span><\\/li>\\n<li>Tweak: Remove the auto-generated page - we found a better way! :)<\\/li>\\n<li>Fixed: <span class=\\\"css-p6tgoi edzl37l0\\\">Deprecated udb_pro_remove_help_tab notice<\\/span><\\/li>\\n<li>Fixed: Left\\/right customizer layouts are now responsive<\\/li>\\n<\\/ul>\\n<p>Version 2.10 - March 27, 2020<\\/p>\\n<ul>\\n<li>New: Login Customizer<\\/li>\\n<li>New: Restrict widgets to user roles<\\/li>\\n<li>New: Restrict widgets to specific users<\\/li>\\n<li>New: Modern wp-admin layout<\\/li>\\n<li>Tweak: Rewritten existing wp-admin layout from scratch<\\/li>\\n<li>Tweak: Restructured options &amp; sections<\\/li>\\n<li>Tweak: Overall code improvements &amp; improvements to the file structure<\\/li>\\n<li>Fixed: Long tooltips overlay icons so they can\'t be clicked<\\/li>\\n<li>Fixed: Widget order doesn\'t save<\\/li>\\n<\\/ul>\\n<p>Version 2.9 - February 19, 2020<\\/p>\\n<ul>\\n<li>New: Page Builder Support - Create a custom WordPress dashboard with Beaver Builder &amp; Elementor<\\/li>\\n<li>New: Option to set custom Logo URL for login screen<\\/li>\\n<li>New: Option to remove \\\"Help\\\" tab<\\/li>\\n<li>New: Option to remove \\\"Screen Options\\\" tab<\\/li>\\n<li>New: Option to change Dashboard headline<\\/li>\\n<li>New: Field to add custom CSS to the entire wp-admin area<\\/li>\\n<li>Tweak: White Label setting now has its own sub menu item<\\/li>\\n<li>Tweak: improved admin settings page styling<\\/li>\\n<\\/ul>\\n<p>Version 2.8.2 - January 3, 2020<\\/p>\\n<ul>\\n<li>Fixed: Text decoration issue<\\/li>\\n<\\/ul>\\n<p>Version 2.8.1 - November 28, 2019<\\/p>\\n<ul>\\n<li>Minor tweaks &amp; improvements<\\/li>\\n<li>Tweak: Optimized license key activation process + added revalidate button<\\/li>\\n<li>Fixed: Contact Form Widget logging doesn\'t work from subsites on a multisite installation<\\/li>\\n<\\/ul>\\n<p>Version 2.8 - November 16, 2019<\\/p>\\n<ul>\\n<li>Maintenance Release<\\/li>\\n<li>New: Hooks for developers to add custom widgets<\\/li>\\n<li>Fixed: Make widget order apply to newly registered users<\\/li>\\n<li>Fixed: Some Contact Form Widget features not working properly on multisites<\\/li>\\n<\\/ul>\\n<p>Version 2.7 - September 5, 2019<\\/p>\\n<ul>\\n<li>New: Contact Form Widget<\\/li>\\n<\\/ul>\\n<p>Version 2.6 - June 6, 2019<\\/p>\\n<ul>\\n<li>New: Import\\/Export Widgets &amp; Settings<\\/li>\\n<li>New: Improved UX\\/UI<\\/li>\\n<li>New: Option to remove data on uninstall<\\/li>\\n<li>Fixed: performance issue where the widget order setting caused an usermeta-update on every page load for all users<\\/li>\\n<\\/ul>\\n<p>Version 2.5 - December 12, 2018<\\/p>\\n<ul>\\n<li>New: HTML widget<\\/li>\\n<li>New: Custom Dashboard CSS field under Widgets -&gt; Settings<\\/li>\\n<li>Tweak: re-organized post columns<\\/li>\\n<li>Tweak: proper messages for udb_widgets custom post type<\\/li>\\n<\\/ul>\\n<p>Version 2.4.2 - October 12, 2018<\\/p>\\n<ul>\\n<li>Tweak: allow touch-action on widget headlines<\\/li>\\n<\\/ul>\\n<p>Version 2.4.1 - October 4, 2018<\\/p>\\n<ul>\\n<li>New: license key activation notice<\\/li>\\n<li>New: bail out if free version is active<\\/li>\\n<li>Tweak: cleaned up code base &amp; proper prefixing of all functions<\\/li>\\n<\\/ul>\\n<p>Version 2.4 - September 11, 2018<\\/p>\\n<ul>\\n<li>New: exclude certain websites from the \\\"blueprint\\\" dashboard<\\/li>\\n<li>New: custom admin bar logo URL<\\/li>\\n<li>Tweak: fixed logic for footer &amp; version text on subsites (subsite settings do now override blueprint settings)<\\/li>\\n<li>Fixed: admin bar styling &amp; admin bar logo settings don\'t apply to frontend<\\/li>\\n<li>Minor tweaks &amp; improvements<\\/li>\\n<\\/ul>\\n<p>Version 2.3 - July 30, 2018<\\/p>\\n<ul>\\n<li>New: video widget<\\/li>\\n<li>New: dashboard column setting<\\/li>\\n<li>New: custom admin bar logo<\\/li>\\n<li>New: widget headline color setting<\\/li>\\n<li>New: widget icon\\/text color setting<\\/li>\\n<li>Tweak: updated settings page UI<\\/li>\\n<\\/ul>\\n<p>Version 2.2.4 - 05\\/31\\/2018<\\/p>\\n<ul>\\n<li>Fixed: Number of Dashboard Widgets is limited by the \\\"Reading\\\" settings under Appearance -&gt; Reading<\\/li>\\n<\\/ul>\\n<p>Version 2.2.3 - 03\\/20\\/2018<\\/p>\\n<ul>\\n<li>Fixed: dashboard widgets are not being removed from subsites<\\/li>\\n<\\/ul>\\n<p>Version 2.2.2 - 03\\/18\\/2018<\\/p>\\n<ul>\\n<li>Fixed: some settings disappear after saving<\\/li>\\n<\\/ul>\\n<p>Version 2.2.1 - 03\\/18\\/2018<\\/p>\\n<ul>\\n<li>Fixed: action link not showing up on non-multisites<\\/li>\\n<\\/ul>\\n<p>Version 2.2 - 03\\/18\\/2018<\\/p>\\n<ul>\\n<li>maintenance release<\\/li>\\n<li>Added: action links<\\/li>\\n<li>Tweak: save deactivated dashboard widgets in a single array<\\/li>\\n<li>Fixed: errors when debug mode is turned on<\\/li>\\n<li>Fixed: wrong hook used to remove dashboard widgets<\\/li>\\n<\\/ul>\\n<p>Version 2.1 - 01\\/04\\/2018<\\/p>\\n<ul>\\n<li>New: Branding options<\\/li>\\n<li>Tweak: Branding options multisite compatibility<\\/li>\\n<\\/ul>\\n<p>Version 2.0.3 - 12\\/07\\/2017<\\/p>\\n<ul>\\n<li>Fixed: curl &amp; ssl issue<\\/li>\\n<\\/ul>\\n<p>Version 2.0.2 - 11\\/21\\/2017<\\/p>\\n<ul>\\n<li>Fixed: backwards compatibility<\\/li>\\n<\\/ul>\\n<p>Version 2.0.1 - 11\\/18\\/2017<\\/p>\\n<ul>\\n<li>Fixed: License key activation redirect<\\/li>\\n<\\/ul>\\n<p>Version 2.0 - 11\\/18\\/2017<\\/p>\\n<ul>\\n<li>Initial Release<\\/li>\\n<\\/ul>\\n\"],\"plugin\":\"ultimate-dashboard-pro\\/ultimate-dashboard-pro.php\",\"id\":\"ultimate-dashboard-pro\\/ultimate-dashboard-pro.php\",\"tested\":null}\";}", "off");
INSERT INTO `wp_options` VALUES("8102", "ultimate_dashboard_license_key", "123456-123456-123456-123456", "auto");
INSERT INTO `wp_options` VALUES("8103", "ultimate_dashboard_license_status", "valid", "auto");
INSERT INTO `wp_options` VALUES("8104", "udb_install_date", "2025-04-29 20:15:16", "auto");
INSERT INTO `wp_options` VALUES("8105", "udb_plugin_activated", "1", "auto");
INSERT INTO `wp_options` VALUES("8106", "udb_pro_site_url", "digitalrev.ir", "auto");
INSERT INTO `wp_options` VALUES("8107", "udb_pro_plugin_activated", "1", "auto");
INSERT INTO `wp_options` VALUES("8108", "udb_login_customizer_flush_url", "1", "auto");
INSERT INTO `wp_options` VALUES("8109", "udb_settings", "a:14:{s:10:\"remove-all\";s:1:\"1\";s:13:\"welcome_panel\";s:1:\"1\";s:10:\"icon_color\";s:7:\"#555555\";s:14:\"headline_color\";s:7:\"#23282d\";s:21:\"welcome_panel_content\";s:1508:\"<div class=\"welcome-panel-content\">\r\n<div class=\"welcome-panel-header\">\r\n<div class=\"welcome-panel-header-image\">\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n</div>\r\n<h2>به وردپرس فارسی خوش آمدید!</h2>\r\n<a href=\"https://medadghermez.com/wp-admin/about.php\">\r\nLearn more about the 6.6.1 version. </a>\r\n\r\n</div>\r\n<div class=\"welcome-panel-column-container\">\r\n<div class=\"welcome-panel-column\">\r\n<div class=\"welcome-panel-column-content\">\r\n<h3>Author rich content with blocks and patterns</h3>\r\nBlock patterns are pre-configured block layouts. Use them to get inspired or create new pages in a flash.\r\n\r\n<a href=\"https://medadghermez.com/wp-admin/post-new.php?post_type=page\">Add a new page</a>\r\n\r\n</div>\r\n</div>\r\n<div class=\"welcome-panel-column\">\r\n<div class=\"welcome-panel-column-content\">\r\n<h3>Start Customizing</h3>\r\nConfigure your site’s logo, header, menus, and more in the Customizer.\r\n\r\n<a class=\"load-customize hide-if-no-customize\" href=\"https://medadghermez.com/wp-admin/customize.php\">Open the Customizer</a>\r\n\r\n</div>\r\n</div>\r\n<div class=\"welcome-panel-column\">\r\n<div class=\"welcome-panel-column-content\">\r\n<h3>Discover a new way to build your site.</h3>\r\nThere is a new kind of WordPress theme, called a block theme, that lets you build the site you’ve always wanted — with blocks and styles.\r\n\r\n<a href=\"https://wordpress.org/documentation/article/block-themes/\">Learn about block themes</a>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\";s:21:\"page_builder_template\";a:9:{s:3:\"all\";s:0:\"\";s:13:\"administrator\";s:0:\"\";s:6:\"editor\";s:0:\"\";s:6:\"author\";s:0:\"\";s:11:\"contributor\";s:0:\"\";s:10:\"subscriber\";s:0:\"\";s:8:\"customer\";s:0:\"\";s:12:\"shop_manager\";s:0:\"\";s:6:\"seller\";s:0:\"\";}s:15:\"remove_help_tab\";s:1:\"1\";s:21:\"remove_screen_options\";s:1:\"1\";s:18:\"dashboard_headline\";s:0:\"\";s:10:\"howdy_text\";s:0:\"\";s:17:\"dashboard_columns\";s:1:\"1\";s:12:\"widget_order\";s:1:\"0\";s:10:\"custom_css\";s:0:\"\";s:16:\"custom_admin_css\";s:36:\".xts-popup{bottom: auto !important;}\";}", "auto");
INSERT INTO `wp_options` VALUES("8110", "udb_compat_old_option", "1", "auto");
INSERT INTO `wp_options` VALUES("8111", "udb_compat_widget_status", "1", "auto");
INSERT INTO `wp_options` VALUES("8112", "udb_compat_settings_meta", "1", "auto");
INSERT INTO `wp_options` VALUES("8113", "udb_compat_delete_login_customizer_page", "1", "auto");
INSERT INTO `wp_options` VALUES("8114", "udb_compat_branding_meta", "1", "auto");
INSERT INTO `wp_options` VALUES("8117", "elementor_pro_tracker_notice", "1", "auto");
INSERT INTO `wp_options` VALUES("8118", "elementor_tracker_notice", "1", "auto");
INSERT INTO `wp_options` VALUES("8119", "udb_import", "", "auto");
INSERT INTO `wp_options` VALUES("8122", "udb_modules", "a:6:{s:11:\"white_label\";s:4:\"true\";s:16:\"login_customizer\";s:4:\"true\";s:14:\"login_redirect\";s:4:\"true\";s:11:\"admin_pages\";s:4:\"true\";s:17:\"admin_menu_editor\";s:4:\"true\";s:16:\"admin_bar_editor\";s:4:\"true\";}", "auto");
INSERT INTO `wp_options` VALUES("8123", "udb_branding", "a:13:{s:7:\"enabled\";s:1:\"1\";s:6:\"layout\";s:6:\"modern\";s:17:\"wp_admin_darkmode\";s:1:\"1\";s:12:\"accent_color\";s:7:\"#0073AA\";s:15:\"menu_item_color\";s:7:\"#ffffff\";s:18:\"admin_bar_bg_color\";s:7:\"#232931\";s:19:\"admin_menu_bg_color\";s:7:\"#2E3640\";s:22:\"admin_submenu_bg_color\";s:7:\"#38404B\";s:20:\"admin_bar_logo_image\";s:71:\"https://digitalrev.ir/partmeta/wp-content/uploads/2025/02/Logo-afda.png\";s:18:\"admin_bar_logo_url\";s:0:\"\";s:23:\"block_editor_logo_image\";s:71:\"https://digitalrev.ir/partmeta/wp-content/uploads/2025/02/Logo-afda.png\";s:11:\"footer_text\";s:60:\"<a href=\"https://aminfanaei.com\" target=\"_blank\">A.F.D.A</a>\";s:12:\"version_text\";s:4:\"5.10\";}", "auto");
INSERT INTO `wp_options` VALUES("8124", "udb_login", "a:25:{s:8:\"template\";s:4:\"left\";s:13:\"form_position\";s:4:\"left\";s:10:\"logo_image\";s:76:\"https://digitalrev.ir/digihome/wp-content/uploads/2025/04/Logo-dark-blue.png\";s:8:\"logo_url\";s:1:\"/\";s:10:\"logo_title\";s:16:\"power by A.F.D.A\";s:8:\"bg_image\";s:79:\"https://digitalrev.ir/digihome/wp-content/uploads/2025/04/cropped-Logo-afda.png\";s:13:\"form_bg_color\";s:7:\"#fc6722\";s:10:\"form_width\";s:5:\"247px\";s:9:\"box_width\";s:3:\"43%\";s:16:\"form_top_padding\";s:4:\"50px\";s:19:\"form_bottom_padding\";s:4:\"83px\";s:20:\"button_border_radius\";s:4:\"10px\";s:28:\"remove_register_lost_pw_link\";i:1;s:24:\"remove_back_to_site_link\";i:1;s:20:\"remove_lang_switcher\";i:1;s:16:\"labels_font_size\";s:4:\"12px\";s:16:\"fields_font_size\";s:4:\"14px\";s:15:\"button_bg_color\";s:7:\"#000a35\";s:25:\"fields_border_color_focus\";s:7:\"#dd3333\";s:8:\"bg_color\";s:7:\"#000a35\";s:11:\"bg_position\";s:12:\"right center\";s:7:\"bg_size\";s:6:\"custom\";s:23:\"enable_bg_overlay_color\";i:0;s:14:\"bg_custom_size\";s:3:\"50%\";s:21:\"button_bg_color_hover\";s:7:\"#000a35\";}", "auto");
INSERT INTO `wp_options` VALUES("8125", "udb_login_redirect", "a:2:{s:14:\"login_url_slug\";s:4:\"afda\";s:22:\"wp_admin_redirect_slug\";s:3:\"404\";}", "auto");
INSERT INTO `wp_options` VALUES("8126", "udb_admin_menu", "a:1:{s:13:\"administrator\";a:30:{i:0;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:9:\"index.php\";s:10:\"id_default\";s:14:\"menu-dashboard\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:3:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:9:\"index.php\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:15:\"update-core.php\";}i:2;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:26:\"duplicator-getting-started\";}}}i:1;a:13:{s:4:\"type\";s:9:\"separator\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:10:\"separator1\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:10:\"id_default\";s:0:\"\";s:7:\"submenu\";a:0:{}}i:2;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:8:\"edit.php\";s:10:\"id_default\";s:10:\"menu-posts\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:4:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:8:\"edit.php\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:12:\"post-new.php\";}i:2;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:31:\"edit-tags.php?taxonomy=category\";}i:3;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:31:\"edit-tags.php?taxonomy=post_tag\";}}}i:3;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:10:\"upload.php\";s:10:\"id_default\";s:10:\"menu-media\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:2:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:10:\"upload.php\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:13:\"media-new.php\";}}}i:4;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:23:\"edit.php?post_type=page\";s:10:\"id_default\";s:10:\"menu-pages\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:2:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:23:\"edit.php?post_type=page\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:27:\"post-new.php?post_type=page\";}}}i:5;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:17:\"edit-comments.php\";s:10:\"id_default\";s:13:\"menu-comments\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:0:{}}i:6;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:12:\"fluent_forms\";s:10:\"id_default\";s:26:\"toplevel_page_fluent_forms\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:8:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:12:\"fluent_forms\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:18:\"fluent_forms#add=1\";}i:2;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:24:\"fluent_forms_all_entries\";}i:3;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:21:\"fluent_forms_settings\";}i:4;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:21:\"fluent_forms_transfer\";}i:5;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:17:\"fluent_forms_smtp\";}i:6;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:20:\"fluent_forms_add_ons\";}i:7;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:17:\"fluent_forms_docs\";}}}i:7;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"1\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:30:\"edit.php?post_type=udb_widgets\";s:10:\"id_default\";s:22:\"menu-posts-udb_widgets\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:12:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:30:\"edit.php?post_type=udb_widgets\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:34:\"post-new.php?post_type=udb_widgets\";}i:2;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:12:\"udb_features\";}i:3;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:12:\"udb_settings\";}i:4;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:12:\"udb_branding\";}i:5;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:33:\"edit.php?post_type=udb_admin_page\";}i:6;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:89:\"http://tabancrm.ir/wp-admin/customize.php?autofocus%5Bpanel%5D=udb_login_customizer_panel\";}i:7;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:18:\"udb_login_redirect\";}i:8;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:14:\"udb_admin_menu\";}i:9;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:13:\"udb_admin_bar\";}i:10;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:9:\"udb_tools\";}i:11;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:11:\"udb-license\";}}}i:8;a:13:{s:4:\"type\";s:9:\"separator\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:30:\"separator-croco-plugins-before\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:10:\"id_default\";s:0:\"\";s:7:\"submenu\";a:0:{}}i:9;a:13:{s:4:\"type\";s:9:\"separator\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:21:\"separator-croco-after\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:10:\"id_default\";s:0:\"\";s:7:\"submenu\";a:0:{}}i:10;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:26:\"jet-cct-customers_comments\";s:10:\"id_default\";s:40:\"toplevel_page_jet-cct-customers_comments\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:0:{}}i:11;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:20:\"jet-cct-team_members\";s:10:\"id_default\";s:34:\"toplevel_page_jet-cct-team_members\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:0:{}}i:12;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:27:\"edit.php?post_type=projects\";s:10:\"id_default\";s:19:\"menu-posts-projects\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:3:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:27:\"edit.php?post_type=projects\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:31:\"post-new.php?post_type=projects\";}i:2;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:55:\"edit-tags.php?taxonomy=work_category&post_type=projects\";}}}i:13;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:27:\"edit.php?post_type=services\";s:10:\"id_default\";s:19:\"menu-posts-services\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:2:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:27:\"edit.php?post_type=services\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:31:\"post-new.php?post_type=services\";}}}i:14;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:10:\"duplicator\";s:10:\"id_default\";s:24:\"toplevel_page_duplicator\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:8:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:10:\"duplicator\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:17:\"duplicator-import\";}i:2;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:20:\"duplicator-schedules\";}i:3;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:18:\"duplicator-storage\";}i:4;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:16:\"duplicator-tools\";}i:5;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:19:\"duplicator-settings\";}i:6;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:19:\"duplicator-about-us\";}i:7;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:130:\"https://duplicator.com/lite-upgrade/?utm_medium=admin-menu&utm_content=Upgrade+to+Pro&utm_source=WordPress&utm_campaign=liteplugin\";}}}i:15;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:25:\"flexy-breadcrumb-settings\";s:10:\"id_default\";s:39:\"toplevel_page_flexy-breadcrumb-settings\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:0:{}}i:16;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"1\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:30:\"abzarwp-easy-installer-license\";s:10:\"id_default\";s:44:\"toplevel_page_abzarwp-easy-installer-license\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:0:{}}i:17;a:13:{s:4:\"type\";s:9:\"separator\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:19:\"separator-elementor\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:10:\"id_default\";s:0:\"\";s:7:\"submenu\";a:0:{}}i:18;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:9:\"elementor\";s:10:\"id_default\";s:23:\"toplevel_page_elementor\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:14:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:9:\"elementor\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:33:\"edit.php?post_type=elementor_font\";}i:2;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:34:\"edit.php?post_type=elementor_icons\";}i:3;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:36:\"edit.php?post_type=elementor_snippet\";}i:4;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:17:\"elementor-connect\";}i:5;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:22:\"elementor-role-manager\";}i:6;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:15:\"elementor-tools\";}i:7;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:25:\"elementor-element-manager\";}i:8;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:21:\"elementor-system-info\";}i:9;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:25:\"elementor-getting-started\";}i:10;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:25:\"elementor-pro-notes-proxy\";}i:11;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:22:\"go_knowledge_base_site\";}i:12;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:14:\"elementor-apps\";}i:13;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:18:\"e-form-submissions\";}}}i:19;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:13:\"jet-dashboard\";s:10:\"id_default\";s:27:\"toplevel_page_jet-dashboard\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:1:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:27:\"jet-dashboard-settings-page\";}}}i:20;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:36:\"edit.php?post_type=elementor_library\";s:10:\"id_default\";s:28:\"menu-posts-elementor_library\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:7:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:55:\"edit.php?post_type=elementor_library&tabs_group=library\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:82:\"edit.php?post_type=elementor_library&tabs_group=popup&elementor_library_type=popup\";}i:2;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:80:\"http://tabancrm.ir/wp-admin/admin.php?page=elementor-app&ver=3.18.1#/site-editor\";}i:3;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:80:\"http://tabancrm.ir/wp-admin/admin.php?page=elementor-app&ver=3.18.1#/kit-library\";}i:4;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:72:\"http://tabancrm.ir/wp-admin/edit.php?post_type=elementor_library#add_new\";}i:5;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:14:\"e-landing-page\";}i:6;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:77:\"edit-tags.php?taxonomy=elementor_library_category&post_type=elementor_library\";}}}i:21;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:10:\"themes.php\";s:10:\"id_default\";s:15:\"menu-appearance\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:6:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:10:\"themes.php\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:26:\"site-editor.php?p=/pattern\";}i:2;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:57:\"customize.php?return=%2Ftaban%2Fwp-admin%2Fadmin-ajax.php\";}i:3;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:20:\"hello-theme-settings\";}i:4;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:13:\"nav-menus.php\";}i:5;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:16:\"theme-editor.php\";}}}i:22;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:11:\"plugins.php\";s:10:\"id_default\";s:12:\"menu-plugins\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:3:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:11:\"plugins.php\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:18:\"plugin-install.php\";}i:2;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:17:\"plugin-editor.php\";}}}i:23;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:9:\"users.php\";s:10:\"id_default\";s:10:\"menu-users\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:3:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:9:\"users.php\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:12:\"user-new.php\";}i:2;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:11:\"profile.php\";}}}i:24;a:13:{s:4:\"type\";s:9:\"separator\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:14:\"separator-last\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:10:\"id_default\";s:0:\"\";s:7:\"submenu\";a:0:{}}i:25;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:10:\"jet-engine\";s:10:\"id_default\";s:24:\"toplevel_page_jet-engine\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:9:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:10:\"jet-engine\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:29:\"edit.php?post_type=jet-engine\";}i:2;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:14:\"jet-engine-cpt\";}i:3;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:15:\"jet-engine-meta\";}i:4;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:18:\"jet-engine-cpt-tax\";}i:5;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:20:\"jet-engine-relations\";}i:6;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:24:\"jet-engine-options-pages\";}i:7;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:16:\"jet-engine-query\";}i:8;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:14:\"jet-engine-cct\";}}}i:26;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:17:\"jet-smart-filters\";s:10:\"id_default\";s:31:\"toplevel_page_jet-smart-filters\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:3:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:61:\"http://tabancrm.ir/wp-admin/admin.php?page=jet-smart-filters#\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:65:\"http://tabancrm.ir/wp-admin/admin.php?page=jet-smart-filters#/new\";}i:2;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:113:\"http://tabancrm.ir/wp-admin/admin.php?page=jet-dashboard-settings-page&subpage=jet-smart-filters-general-settings\";}}}i:27;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:17:\"wp-parsi-settings\";s:10:\"id_default\";s:31:\"toplevel_page_wp-parsi-settings\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:0:{}}i:28;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:9:\"tools.php\";s:10:\"id_default\";s:10:\"menu-tools\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:6:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:9:\"tools.php\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:10:\"import.php\";}i:2;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:10:\"export.php\";}i:3;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:15:\"site-health.php\";}i:4;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:24:\"export-personal-data.php\";}i:5;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:23:\"erase-personal-data.php\";}}}i:29;a:13:{s:4:\"type\";s:4:\"menu\";s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:11:\"url_default\";s:19:\"options-general.php\";s:10:\"id_default\";s:13:\"menu-settings\";s:5:\"title\";s:0:\"\";s:8:\"dashicon\";s:0:\"\";s:8:\"icon_svg\";s:0:\"\";s:9:\"icon_type\";s:0:\"\";s:7:\"submenu\";a:7:{i:0;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:19:\"options-general.php\";}i:1;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:19:\"options-writing.php\";}i:2;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:19:\"options-reading.php\";}i:3;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:22:\"options-discussion.php\";}i:4;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:17:\"options-media.php\";}i:5;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:21:\"options-permalink.php\";}i:6;a:5:{s:9:\"is_hidden\";s:1:\"0\";s:9:\"was_added\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"url_default\";s:19:\"options-privacy.php\";}}}}}", "auto");
INSERT INTO `wp_options` VALUES("8127", "udb_admin_bar", "a:49:{s:7:\"wp-logo\";a:11:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:1;s:2:\"id\";s:7:\"wp-logo\";s:10:\"id_default\";s:7:\"wp-logo\";s:5:\"title\";s:0:\"\";s:6:\"parent\";b:0;s:14:\"parent_default\";s:5:\"false\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:31:\"http://ayasagallery.ir/wp-admin\";s:4:\"icon\";s:0:\"\";s:13:\"title_default\";s:29:\"<span class=\"ab-icon\"></span>\";}s:5:\"about\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:5:\"about\";s:10:\"id_default\";s:5:\"about\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:7:\"wp-logo\";s:14:\"parent_default\";s:7:\"wp-logo\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:41:\"http://ayasagallery.ir/wp-admin/about.php\";s:13:\"title_default\";s:15:\"About WordPress\";}s:10:\"contribute\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:10:\"contribute\";s:10:\"id_default\";s:10:\"contribute\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:7:\"wp-logo\";s:14:\"parent_default\";s:7:\"wp-logo\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:46:\"http://ayasagallery.ir/wp-admin/contribute.php\";s:13:\"title_default\";s:12:\"Get Involved\";}s:16:\"wp-logo-external\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:16:\"wp-logo-external\";s:10:\"id_default\";s:16:\"wp-logo-external\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:7:\"wp-logo\";s:14:\"parent_default\";s:7:\"wp-logo\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:5:\"false\";s:13:\"title_default\";b:0;}s:5:\"wporg\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:5:\"wporg\";s:10:\"id_default\";s:5:\"wporg\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:16:\"wp-logo-external\";s:14:\"parent_default\";s:16:\"wp-logo-external\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:22:\"https://wordpress.org/\";s:13:\"title_default\";s:13:\"WordPress.org\";}s:13:\"documentation\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:13:\"documentation\";s:10:\"id_default\";s:13:\"documentation\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:16:\"wp-logo-external\";s:14:\"parent_default\";s:16:\"wp-logo-external\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:36:\"https://wordpress.org/documentation/\";s:13:\"title_default\";s:13:\"Documentation\";}s:5:\"learn\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:5:\"learn\";s:10:\"id_default\";s:5:\"learn\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:16:\"wp-logo-external\";s:14:\"parent_default\";s:16:\"wp-logo-external\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:28:\"https://learn.wordpress.org/\";s:13:\"title_default\";s:15:\"Learn WordPress\";}s:14:\"support-forums\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:14:\"support-forums\";s:10:\"id_default\";s:14:\"support-forums\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:16:\"wp-logo-external\";s:14:\"parent_default\";s:16:\"wp-logo-external\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:37:\"https://wordpress.org/support/forums/\";s:13:\"title_default\";s:7:\"Support\";}s:8:\"feedback\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:8:\"feedback\";s:10:\"id_default\";s:8:\"feedback\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:16:\"wp-logo-external\";s:14:\"parent_default\";s:16:\"wp-logo-external\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:57:\"https://wordpress.org/support/forum/requests-and-feedback\";s:13:\"title_default\";s:8:\"Feedback\";}s:9:\"site-name\";a:11:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:9:\"site-name\";s:10:\"id_default\";s:9:\"site-name\";s:5:\"title\";s:0:\"\";s:6:\"parent\";b:0;s:14:\"parent_default\";s:5:\"false\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:23:\"http://ayasagallery.ir/\";s:4:\"icon\";s:0:\"\";s:13:\"title_default\";s:11:\"courseinuse\";}s:9:\"view-site\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:9:\"view-site\";s:10:\"id_default\";s:9:\"view-site\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:9:\"site-name\";s:14:\"parent_default\";s:9:\"site-name\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:23:\"http://ayasagallery.ir/\";s:13:\"title_default\";s:10:\"Visit Site\";}s:10:\"view-store\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:10:\"view-store\";s:10:\"id_default\";s:10:\"view-store\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:9:\"site-name\";s:14:\"parent_default\";s:9:\"site-name\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:28:\"http://ayasagallery.ir/shop/\";s:13:\"title_default\";s:11:\"Visit Store\";}s:10:\"lp-courses\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:10:\"lp-courses\";s:10:\"id_default\";s:10:\"lp-courses\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:9:\"site-name\";s:14:\"parent_default\";s:9:\"site-name\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:31:\"http://ayasagallery.ir/courses/\";s:13:\"title_default\";s:47:\"<span class=\"ab-label\">View Page Courses</span>\";}s:10:\"lp-profile\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:10:\"lp-profile\";s:10:\"id_default\";s:10:\"lp-profile\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:9:\"site-name\";s:14:\"parent_default\";s:9:\"site-name\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:34:\"http://ayasagallery.ir/lp-profile/\";s:13:\"title_default\";s:47:\"<span class=\"ab-label\">View Page Profile</span>\";}s:14:\"lp-instructors\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:14:\"lp-instructors\";s:10:\"id_default\";s:14:\"lp-instructors\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:9:\"site-name\";s:14:\"parent_default\";s:9:\"site-name\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:35:\"http://ayasagallery.ir/instructors/\";s:13:\"title_default\";s:51:\"<span class=\"ab-label\">View Page Instructors</span>\";}s:18:\"site-name-frontend\";a:11:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:1;s:2:\"id\";s:18:\"site-name-frontend\";s:10:\"id_default\";s:18:\"site-name-frontend\";s:5:\"title\";s:0:\"\";s:6:\"parent\";b:0;s:14:\"parent_default\";s:5:\"false\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:32:\"http://ayasagallery.ir/wp-admin/\";s:4:\"icon\";s:0:\"\";s:13:\"title_default\";s:0:\"\";}s:9:\"dashboard\";a:11:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:9:\"dashboard\";s:10:\"id_default\";s:9:\"dashboard\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:9:\"site-name\";s:14:\"parent_default\";s:9:\"site-name\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:32:\"http://ayasagallery.ir/wp-admin/\";s:13:\"frontend_only\";i:1;s:13:\"title_default\";s:9:\"Dashboard\";}s:10:\"appearance\";a:11:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:10:\"appearance\";s:10:\"id_default\";s:10:\"appearance\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:9:\"site-name\";s:14:\"parent_default\";s:9:\"site-name\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:0:\"\";s:13:\"frontend_only\";i:1;s:13:\"title_default\";s:0:\"\";}s:6:\"themes\";a:11:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:6:\"themes\";s:10:\"id_default\";s:6:\"themes\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:10:\"appearance\";s:14:\"parent_default\";s:10:\"appearance\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:42:\"http://ayasagallery.ir/wp-admin/themes.php\";s:13:\"frontend_only\";i:1;s:13:\"title_default\";s:6:\"Themes\";}s:7:\"widgets\";a:11:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:7:\"widgets\";s:10:\"id_default\";s:7:\"widgets\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:10:\"appearance\";s:14:\"parent_default\";s:10:\"appearance\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:43:\"http://ayasagallery.ir/wp-admin/widgets.php\";s:13:\"frontend_only\";i:1;s:13:\"title_default\";s:7:\"Widgets\";}s:5:\"menus\";a:11:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:5:\"menus\";s:10:\"id_default\";s:5:\"menus\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:10:\"appearance\";s:14:\"parent_default\";s:10:\"appearance\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:45:\"http://ayasagallery.ir/wp-admin/nav-menus.php\";s:13:\"frontend_only\";i:1;s:13:\"title_default\";s:5:\"Menus\";}s:9:\"customize\";a:12:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:9:\"customize\";s:10:\"id_default\";s:9:\"customize\";s:5:\"title\";s:0:\"\";s:6:\"parent\";b:0;s:14:\"parent_default\";s:5:\"false\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:13:\"frontend_only\";i:1;s:13:\"title_default\";s:9:\"Customize\";}s:7:\"updates\";a:11:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:7:\"updates\";s:10:\"id_default\";s:7:\"updates\";s:5:\"title\";s:0:\"\";s:6:\"parent\";b:0;s:14:\"parent_default\";s:5:\"false\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:47:\"http://ayasagallery.ir/wp-admin/update-core.php\";s:4:\"icon\";s:0:\"\";s:13:\"title_default\";s:180:\"<span class=\"ab-icon\" aria-hidden=\"true\"></span><span class=\"ab-label\" aria-hidden=\"true\">7</span><span class=\"screen-reader-text updates-available-text\">7 updates available</span>\";}s:8:\"comments\";a:11:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:8:\"comments\";s:10:\"id_default\";s:8:\"comments\";s:5:\"title\";s:0:\"\";s:6:\"parent\";b:0;s:14:\"parent_default\";s:5:\"false\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:49:\"http://ayasagallery.ir/wp-admin/edit-comments.php\";s:4:\"icon\";s:0:\"\";s:13:\"title_default\";s:228:\"<span class=\"ab-icon\" aria-hidden=\"true\"></span><span class=\"ab-label awaiting-mod pending-count count-32\" aria-hidden=\"true\">32</span><span class=\"screen-reader-text comments-in-moderation-text\">32 Comments in moderation</span>\";}s:11:\"new-content\";a:11:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:11:\"new-content\";s:10:\"id_default\";s:11:\"new-content\";s:5:\"title\";s:0:\"\";s:6:\"parent\";b:0;s:14:\"parent_default\";s:5:\"false\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:44:\"http://ayasagallery.ir/wp-admin/post-new.php\";s:4:\"icon\";s:0:\"\";s:13:\"title_default\";s:81:\"<span class=\"ab-icon\" aria-hidden=\"true\"></span><span class=\"ab-label\">New</span>\";}s:8:\"new-post\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:8:\"new-post\";s:10:\"id_default\";s:8:\"new-post\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:44:\"http://ayasagallery.ir/wp-admin/post-new.php\";s:13:\"title_default\";s:4:\"Post\";}s:9:\"new-media\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:9:\"new-media\";s:10:\"id_default\";s:9:\"new-media\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:45:\"http://ayasagallery.ir/wp-admin/media-new.php\";s:13:\"title_default\";s:5:\"Media\";}s:8:\"new-page\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:8:\"new-page\";s:10:\"id_default\";s:8:\"new-page\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:59:\"http://ayasagallery.ir/wp-admin/post-new.php?post_type=page\";s:13:\"title_default\";s:4:\"Page\";}s:12:\"new-tp_event\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:12:\"new-tp_event\";s:10:\"id_default\";s:12:\"new-tp_event\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:63:\"http://ayasagallery.ir/wp-admin/post-new.php?post_type=tp_event\";s:13:\"title_default\";s:5:\"Event\";}s:18:\"new-e-landing-page\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:18:\"new-e-landing-page\";s:10:\"id_default\";s:18:\"new-e-landing-page\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:146:\"http://ayasagallery.ir/wp-admin/edit.php?action=elementor_new_post&post_type=e-landing-page&template_type=landing-page&_wpnonce=7efc43d5e0#library\";s:13:\"title_default\";s:12:\"Landing Page\";}s:21:\"new-elementor_library\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:21:\"new-elementor_library\";s:10:\"id_default\";s:21:\"new-elementor_library\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:72:\"http://ayasagallery.ir/wp-admin/post-new.php?post_type=elementor_library\";s:13:\"title_default\";s:8:\"Template\";}s:11:\"new-product\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:11:\"new-product\";s:10:\"id_default\";s:11:\"new-product\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:62:\"http://ayasagallery.ir/wp-admin/post-new.php?post_type=product\";s:13:\"title_default\";s:7:\"Product\";}s:14:\"new-shop_order\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:14:\"new-shop_order\";s:10:\"id_default\";s:14:\"new-shop_order\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:65:\"http://ayasagallery.ir/wp-admin/post-new.php?post_type=shop_order\";s:13:\"title_default\";s:5:\"Order\";}s:15:\"new-shop_coupon\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:15:\"new-shop_coupon\";s:10:\"id_default\";s:15:\"new-shop_coupon\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:66:\"http://ayasagallery.ir/wp-admin/post-new.php?post_type=shop_coupon\";s:13:\"title_default\";s:6:\"Coupon\";}s:13:\"new-lp_course\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:13:\"new-lp_course\";s:10:\"id_default\";s:13:\"new-lp_course\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:64:\"http://ayasagallery.ir/wp-admin/post-new.php?post_type=lp_course\";s:13:\"title_default\";s:6:\"Course\";}s:13:\"new-lp_lesson\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:13:\"new-lp_lesson\";s:10:\"id_default\";s:13:\"new-lp_lesson\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:64:\"http://ayasagallery.ir/wp-admin/post-new.php?post_type=lp_lesson\";s:13:\"title_default\";s:6:\"Lesson\";}s:11:\"new-lp_quiz\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:11:\"new-lp_quiz\";s:10:\"id_default\";s:11:\"new-lp_quiz\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:62:\"http://ayasagallery.ir/wp-admin/post-new.php?post_type=lp_quiz\";s:13:\"title_default\";s:4:\"Quiz\";}s:15:\"new-lp_question\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:15:\"new-lp_question\";s:10:\"id_default\";s:15:\"new-lp_question\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:66:\"http://ayasagallery.ir/wp-admin/post-new.php?post_type=lp_question\";s:13:\"title_default\";s:8:\"Question\";}s:20:\"new-thim_ekits_slide\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:20:\"new-thim_ekits_slide\";s:10:\"id_default\";s:20:\"new-thim_ekits_slide\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:71:\"http://ayasagallery.ir/wp-admin/post-new.php?post_type=thim_ekits_slide\";s:13:\"title_default\";s:8:\"All Item\";}s:13:\"new-portfolio\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:13:\"new-portfolio\";s:10:\"id_default\";s:13:\"new-portfolio\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:64:\"http://ayasagallery.ir/wp-admin/post-new.php?post_type=portfolio\";s:13:\"title_default\";s:7:\"Project\";}s:15:\"new-udb_widgets\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:15:\"new-udb_widgets\";s:10:\"id_default\";s:15:\"new-udb_widgets\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:66:\"http://ayasagallery.ir/wp-admin/post-new.php?post_type=udb_widgets\";s:13:\"title_default\";s:16:\"Dashboard Widget\";}s:8:\"new-user\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:8:\"new-user\";s:10:\"id_default\";s:8:\"new-user\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:11:\"new-content\";s:14:\"parent_default\";s:11:\"new-content\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:44:\"http://ayasagallery.ir/wp-admin/user-new.php\";s:13:\"title_default\";s:4:\"User\";}s:4:\"edit\";a:12:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:4:\"edit\";s:10:\"id_default\";s:4:\"edit\";s:5:\"title\";s:0:\"\";s:6:\"parent\";b:0;s:14:\"parent_default\";s:5:\"false\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:13:\"frontend_only\";i:1;s:13:\"title_default\";s:16:\"Edit {post_type}\";}s:13:\"top-secondary\";a:11:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:13:\"top-secondary\";s:10:\"id_default\";s:13:\"top-secondary\";s:5:\"title\";s:0:\"\";s:6:\"parent\";b:0;s:14:\"parent_default\";s:5:\"false\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:5:\"false\";s:4:\"icon\";s:0:\"\";s:13:\"title_default\";b:0;}s:6:\"search\";a:11:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:6:\"search\";s:10:\"id_default\";s:6:\"search\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:13:\"top-secondary\";s:14:\"parent_default\";s:13:\"top-secondary\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:0:\"\";s:13:\"frontend_only\";i:1;s:13:\"title_default\";s:0:\"\";}s:10:\"my-account\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:10:\"my-account\";s:10:\"id_default\";s:10:\"my-account\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:13:\"top-secondary\";s:14:\"parent_default\";s:13:\"top-secondary\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:43:\"http://ayasagallery.ir/wp-admin/profile.php\";s:13:\"title_default\";s:201:\"Howdy, <span class=\"display-name\">courseinuse</span><img alt=\"User Avatar\" class=\"avatar\" src=\"https://secure.gravatar.com/avatar/43015e66c57944cbcd505b4b897e6e86?s=96&d=mm&r=g\" height=\"26\" width=\"26\">\";}s:12:\"user-actions\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:12:\"user-actions\";s:10:\"id_default\";s:12:\"user-actions\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:10:\"my-account\";s:14:\"parent_default\";s:10:\"my-account\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:5:\"false\";s:13:\"title_default\";b:0;}s:9:\"user-info\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:9:\"user-info\";s:10:\"id_default\";s:9:\"user-info\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:12:\"user-actions\";s:14:\"parent_default\";s:12:\"user-actions\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:43:\"http://ayasagallery.ir/wp-admin/profile.php\";s:13:\"title_default\";s:253:\"<img alt=\"User Avatar\" class=\"avatar\" src=\"https://secure.gravatar.com/avatar/43015e66c57944cbcd505b4b897e6e86?s=96&d=mm&r=g\" height=\"64\" width=\"64\"><span class=\'display-name\'>courseinuse</span><span class=\'display-name edit-profile\'>Edit Profile</span>\";}s:6:\"logout\";a:10:{s:9:\"was_added\";i:0;s:9:\"is_hidden\";i:0;s:2:\"id\";s:6:\"logout\";s:10:\"id_default\";s:6:\"logout\";s:5:\"title\";s:0:\"\";s:6:\"parent\";s:12:\"user-actions\";s:14:\"parent_default\";s:12:\"user-actions\";s:4:\"href\";s:0:\"\";s:12:\"href_default\";s:69:\"http://ayasagallery.ir/wp-login.php?action=logout&_wpnonce=ba6ac1abfc\";s:13:\"title_default\";s:7:\"Log Out\";}}", "auto");
INSERT INTO `wp_options` VALUES("8130", "udb_compat_widget_type", "1", "auto");
INSERT INTO `wp_options` VALUES("8296", "review_notice_dismissed", "1", "auto");
INSERT INTO `wp_options` VALUES("8304", "duplicator_install_info", "a:3:{s:7:\"version\";s:7:\"1.5.7.1\";s:4:\"time\";i:1701856237;s:10:\"updateTime\";i:1752059602;}", "off");
INSERT INTO `wp_options` VALUES("8305", "duplicator_notifications", "a:4:{s:6:\"update\";i:1766791166;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("8310", "duplicator_migration_data", "{\n    \"plugin\": \"dup-lite\",\n    \"installerVersion\": \"1.5.7.1\",\n    \"installType\": -1,\n    \"logicModes\": [\n        \"CLASSIC\"\n    ],\n    \"template\": \"base\",\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home\\/tabanc\\/public_html\\/20231206_d8b3d8a7db8cd8aad8a2d985d8a7d8_2087d17888f42e016318_20250709111413_archive.zip\",\n    \"packageHash\": \"2087d17-09111413\",\n    \"installerPath\": \"\\/home\\/tabanc\\/public_html\\/installer.php\",\n    \"installerBootLog\": \"\\/home\\/tabanc\\/public_html\\/dup-installer-bootlog__4096faa-09111413.txt\",\n    \"installerLog\": \"\\/home\\/tabanc\\/public_html\\/dup-installer\\/dup-installer-log__4096faa-09111413.txt\",\n    \"dupInstallerPath\": \"\\/home\\/tabanc\\/public_html\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home\\/tabanc\\/public_html\\/dup-installer\\/original_files_2087d17-09111413\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true,\n    \"licenseType\": 0,\n    \"phpVersion\": \"8.1.30\",\n    \"archiveType\": \"zip\",\n    \"siteSize\": 122113674,\n    \"siteNumFiles\": 13244,\n    \"siteDbSize\": 18307952,\n    \"siteDBNumTables\": 54,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"ustatIdentifier\": \"\",\n    \"time\": 1752069806\n}", "no");
INSERT INTO `wp_options` VALUES("8324", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"6Op_,p__I+KyfzoIc-OUvdPNQaPWn=ZpkjEBFxNfC7x4\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 309.529999999999972715158946812152862548828125,\n    \"siteNumFiles\": 17901,\n    \"siteDbSizeMB\": 23.910000000000000142108547152020037174224853515625,\n    \"siteDbNumTables\": 59\n}", "auto");
INSERT INTO `wp_options` VALUES("8341", "theme_mods_twentytwentyfive", "a:4:{i:0;b:0;s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1752074913;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("8344", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:3:\"6.9\";s:5:\"files\";a:584:{i:0;s:27:\"accordion-heading/style.css\";i:1;s:31:\"accordion-heading/style.min.css\";i:2;s:31:\"accordion-heading/style-rtl.css\";i:3;s:35:\"accordion-heading/style-rtl.min.css\";i:4;s:24:\"accordion-item/style.css\";i:5;s:28:\"accordion-item/style.min.css\";i:6;s:28:\"accordion-item/style-rtl.css\";i:7;s:32:\"accordion-item/style-rtl.min.css\";i:8;s:25:\"accordion-panel/style.css\";i:9;s:29:\"accordion-panel/style.min.css\";i:10;s:29:\"accordion-panel/style-rtl.css\";i:11;s:33:\"accordion-panel/style-rtl.min.css\";i:12;s:19:\"accordion/style.css\";i:13;s:23:\"accordion/style.min.css\";i:14;s:23:\"accordion/style-rtl.css\";i:15;s:27:\"accordion/style-rtl.min.css\";i:16;s:19:\"archives/editor.css\";i:17;s:23:\"archives/editor.min.css\";i:18;s:23:\"archives/editor-rtl.css\";i:19;s:27:\"archives/editor-rtl.min.css\";i:20;s:18:\"archives/style.css\";i:21;s:22:\"archives/style.min.css\";i:22;s:22:\"archives/style-rtl.css\";i:23;s:26:\"archives/style-rtl.min.css\";i:24;s:16:\"audio/editor.css\";i:25;s:20:\"audio/editor.min.css\";i:26;s:20:\"audio/editor-rtl.css\";i:27;s:24:\"audio/editor-rtl.min.css\";i:28;s:15:\"audio/style.css\";i:29;s:19:\"audio/style.min.css\";i:30;s:19:\"audio/style-rtl.css\";i:31;s:23:\"audio/style-rtl.min.css\";i:32;s:15:\"audio/theme.css\";i:33;s:19:\"audio/theme.min.css\";i:34;s:19:\"audio/theme-rtl.css\";i:35;s:23:\"audio/theme-rtl.min.css\";i:36;s:17:\"avatar/editor.css\";i:37;s:21:\"avatar/editor.min.css\";i:38;s:21:\"avatar/editor-rtl.css\";i:39;s:25:\"avatar/editor-rtl.min.css\";i:40;s:16:\"avatar/style.css\";i:41;s:20:\"avatar/style.min.css\";i:42;s:20:\"avatar/style-rtl.css\";i:43;s:24:\"avatar/style-rtl.min.css\";i:44;s:17:\"button/editor.css\";i:45;s:21:\"button/editor.min.css\";i:46;s:21:\"button/editor-rtl.css\";i:47;s:25:\"button/editor-rtl.min.css\";i:48;s:18:\"buttons/editor.css\";i:49;s:22:\"buttons/editor.min.css\";i:50;s:22:\"buttons/editor-rtl.css\";i:51;s:26:\"buttons/editor-rtl.min.css\";i:52;s:17:\"buttons/style.css\";i:53;s:21:\"buttons/style.min.css\";i:54;s:21:\"buttons/style-rtl.css\";i:55;s:25:\"buttons/style-rtl.min.css\";i:56;s:16:\"button/style.css\";i:57;s:20:\"button/style.min.css\";i:58;s:20:\"button/style-rtl.css\";i:59;s:24:\"button/style-rtl.min.css\";i:60;s:18:\"calendar/style.css\";i:61;s:22:\"calendar/style.min.css\";i:62;s:22:\"calendar/style-rtl.css\";i:63;s:26:\"calendar/style-rtl.min.css\";i:64;s:21:\"categories/editor.css\";i:65;s:25:\"categories/editor.min.css\";i:66;s:25:\"categories/editor-rtl.css\";i:67;s:29:\"categories/editor-rtl.min.css\";i:68;s:20:\"categories/style.css\";i:69;s:24:\"categories/style.min.css\";i:70;s:24:\"categories/style-rtl.css\";i:71;s:28:\"categories/style-rtl.min.css\";i:72;s:15:\"code/editor.css\";i:73;s:19:\"code/editor.min.css\";i:74;s:19:\"code/editor-rtl.css\";i:75;s:23:\"code/editor-rtl.min.css\";i:76;s:14:\"code/style.css\";i:77;s:18:\"code/style.min.css\";i:78;s:18:\"code/style-rtl.css\";i:79;s:22:\"code/style-rtl.min.css\";i:80;s:14:\"code/theme.css\";i:81;s:18:\"code/theme.min.css\";i:82;s:18:\"code/theme-rtl.css\";i:83;s:22:\"code/theme-rtl.min.css\";i:84;s:18:\"columns/editor.css\";i:85;s:22:\"columns/editor.min.css\";i:86;s:22:\"columns/editor-rtl.css\";i:87;s:26:\"columns/editor-rtl.min.css\";i:88;s:17:\"columns/style.css\";i:89;s:21:\"columns/style.min.css\";i:90;s:21:\"columns/style-rtl.css\";i:91;s:25:\"columns/style-rtl.min.css\";i:92;s:29:\"comment-author-name/style.css\";i:93;s:33:\"comment-author-name/style.min.css\";i:94;s:33:\"comment-author-name/style-rtl.css\";i:95;s:37:\"comment-author-name/style-rtl.min.css\";i:96;s:25:\"comment-content/style.css\";i:97;s:29:\"comment-content/style.min.css\";i:98;s:29:\"comment-content/style-rtl.css\";i:99;s:33:\"comment-content/style-rtl.min.css\";i:100;s:22:\"comment-date/style.css\";i:101;s:26:\"comment-date/style.min.css\";i:102;s:26:\"comment-date/style-rtl.css\";i:103;s:30:\"comment-date/style-rtl.min.css\";i:104;s:27:\"comment-edit-link/style.css\";i:105;s:31:\"comment-edit-link/style.min.css\";i:106;s:31:\"comment-edit-link/style-rtl.css\";i:107;s:35:\"comment-edit-link/style-rtl.min.css\";i:108;s:28:\"comment-reply-link/style.css\";i:109;s:32:\"comment-reply-link/style.min.css\";i:110;s:32:\"comment-reply-link/style-rtl.css\";i:111;s:36:\"comment-reply-link/style-rtl.min.css\";i:112;s:19:\"comments/editor.css\";i:113;s:23:\"comments/editor.min.css\";i:114;s:23:\"comments/editor-rtl.css\";i:115;s:27:\"comments/editor-rtl.min.css\";i:116;s:30:\"comments-pagination/editor.css\";i:117;s:34:\"comments-pagination/editor.min.css\";i:118;s:34:\"comments-pagination/editor-rtl.css\";i:119;s:38:\"comments-pagination/editor-rtl.min.css\";i:120;s:38:\"comments-pagination-numbers/editor.css\";i:121;s:42:\"comments-pagination-numbers/editor.min.css\";i:122;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:123;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:124;s:29:\"comments-pagination/style.css\";i:125;s:33:\"comments-pagination/style.min.css\";i:126;s:33:\"comments-pagination/style-rtl.css\";i:127;s:37:\"comments-pagination/style-rtl.min.css\";i:128;s:18:\"comments/style.css\";i:129;s:22:\"comments/style.min.css\";i:130;s:22:\"comments/style-rtl.css\";i:131;s:26:\"comments/style-rtl.min.css\";i:132;s:25:\"comments-title/editor.css\";i:133;s:29:\"comments-title/editor.min.css\";i:134;s:29:\"comments-title/editor-rtl.css\";i:135;s:33:\"comments-title/editor-rtl.min.css\";i:136;s:26:\"comment-template/style.css\";i:137;s:30:\"comment-template/style.min.css\";i:138;s:30:\"comment-template/style-rtl.css\";i:139;s:34:\"comment-template/style-rtl.min.css\";i:140;s:16:\"cover/editor.css\";i:141;s:20:\"cover/editor.min.css\";i:142;s:20:\"cover/editor-rtl.css\";i:143;s:24:\"cover/editor-rtl.min.css\";i:144;s:15:\"cover/style.css\";i:145;s:19:\"cover/style.min.css\";i:146;s:19:\"cover/style-rtl.css\";i:147;s:23:\"cover/style-rtl.min.css\";i:148;s:18:\"details/editor.css\";i:149;s:22:\"details/editor.min.css\";i:150;s:22:\"details/editor-rtl.css\";i:151;s:26:\"details/editor-rtl.min.css\";i:152;s:17:\"details/style.css\";i:153;s:21:\"details/style.min.css\";i:154;s:21:\"details/style-rtl.css\";i:155;s:25:\"details/style-rtl.min.css\";i:156;s:16:\"embed/editor.css\";i:157;s:20:\"embed/editor.min.css\";i:158;s:20:\"embed/editor-rtl.css\";i:159;s:24:\"embed/editor-rtl.min.css\";i:160;s:15:\"embed/style.css\";i:161;s:19:\"embed/style.min.css\";i:162;s:19:\"embed/style-rtl.css\";i:163;s:23:\"embed/style-rtl.min.css\";i:164;s:15:\"embed/theme.css\";i:165;s:19:\"embed/theme.min.css\";i:166;s:19:\"embed/theme-rtl.css\";i:167;s:23:\"embed/theme-rtl.min.css\";i:168;s:15:\"file/editor.css\";i:169;s:19:\"file/editor.min.css\";i:170;s:19:\"file/editor-rtl.css\";i:171;s:23:\"file/editor-rtl.min.css\";i:172;s:14:\"file/style.css\";i:173;s:18:\"file/style.min.css\";i:174;s:18:\"file/style-rtl.css\";i:175;s:22:\"file/style-rtl.min.css\";i:176;s:19:\"footnotes/style.css\";i:177;s:23:\"footnotes/style.min.css\";i:178;s:23:\"footnotes/style-rtl.css\";i:179;s:27:\"footnotes/style-rtl.min.css\";i:180;s:19:\"freeform/editor.css\";i:181;s:23:\"freeform/editor.min.css\";i:182;s:23:\"freeform/editor-rtl.css\";i:183;s:27:\"freeform/editor-rtl.min.css\";i:184;s:18:\"gallery/editor.css\";i:185;s:22:\"gallery/editor.min.css\";i:186;s:22:\"gallery/editor-rtl.css\";i:187;s:26:\"gallery/editor-rtl.min.css\";i:188;s:17:\"gallery/style.css\";i:189;s:21:\"gallery/style.min.css\";i:190;s:21:\"gallery/style-rtl.css\";i:191;s:25:\"gallery/style-rtl.min.css\";i:192;s:17:\"gallery/theme.css\";i:193;s:21:\"gallery/theme.min.css\";i:194;s:21:\"gallery/theme-rtl.css\";i:195;s:25:\"gallery/theme-rtl.min.css\";i:196;s:16:\"group/editor.css\";i:197;s:20:\"group/editor.min.css\";i:198;s:20:\"group/editor-rtl.css\";i:199;s:24:\"group/editor-rtl.min.css\";i:200;s:15:\"group/style.css\";i:201;s:19:\"group/style.min.css\";i:202;s:19:\"group/style-rtl.css\";i:203;s:23:\"group/style-rtl.min.css\";i:204;s:15:\"group/theme.css\";i:205;s:19:\"group/theme.min.css\";i:206;s:19:\"group/theme-rtl.css\";i:207;s:23:\"group/theme-rtl.min.css\";i:208;s:17:\"heading/style.css\";i:209;s:21:\"heading/style.min.css\";i:210;s:21:\"heading/style-rtl.css\";i:211;s:25:\"heading/style-rtl.min.css\";i:212;s:15:\"html/editor.css\";i:213;s:19:\"html/editor.min.css\";i:214;s:19:\"html/editor-rtl.css\";i:215;s:23:\"html/editor-rtl.min.css\";i:216;s:16:\"image/editor.css\";i:217;s:20:\"image/editor.min.css\";i:218;s:20:\"image/editor-rtl.css\";i:219;s:24:\"image/editor-rtl.min.css\";i:220;s:15:\"image/style.css\";i:221;s:19:\"image/style.min.css\";i:222;s:19:\"image/style-rtl.css\";i:223;s:23:\"image/style-rtl.min.css\";i:224;s:15:\"image/theme.css\";i:225;s:19:\"image/theme.min.css\";i:226;s:19:\"image/theme-rtl.css\";i:227;s:23:\"image/theme-rtl.min.css\";i:228;s:25:\"latest-comments/style.css\";i:229;s:29:\"latest-comments/style.min.css\";i:230;s:29:\"latest-comments/style-rtl.css\";i:231;s:33:\"latest-comments/style-rtl.min.css\";i:232;s:23:\"latest-posts/editor.css\";i:233;s:27:\"latest-posts/editor.min.css\";i:234;s:27:\"latest-posts/editor-rtl.css\";i:235;s:31:\"latest-posts/editor-rtl.min.css\";i:236;s:22:\"latest-posts/style.css\";i:237;s:26:\"latest-posts/style.min.css\";i:238;s:26:\"latest-posts/style-rtl.css\";i:239;s:30:\"latest-posts/style-rtl.min.css\";i:240;s:14:\"list/style.css\";i:241;s:18:\"list/style.min.css\";i:242;s:18:\"list/style-rtl.css\";i:243;s:22:\"list/style-rtl.min.css\";i:244;s:18:\"loginout/style.css\";i:245;s:22:\"loginout/style.min.css\";i:246;s:22:\"loginout/style-rtl.css\";i:247;s:26:\"loginout/style-rtl.min.css\";i:248;s:15:\"math/editor.css\";i:249;s:19:\"math/editor.min.css\";i:250;s:19:\"math/editor-rtl.css\";i:251;s:23:\"math/editor-rtl.min.css\";i:252;s:14:\"math/style.css\";i:253;s:18:\"math/style.min.css\";i:254;s:18:\"math/style-rtl.css\";i:255;s:22:\"math/style-rtl.min.css\";i:256;s:21:\"media-text/editor.css\";i:257;s:25:\"media-text/editor.min.css\";i:258;s:25:\"media-text/editor-rtl.css\";i:259;s:29:\"media-text/editor-rtl.min.css\";i:260;s:20:\"media-text/style.css\";i:261;s:24:\"media-text/style.min.css\";i:262;s:24:\"media-text/style-rtl.css\";i:263;s:28:\"media-text/style-rtl.min.css\";i:264;s:15:\"more/editor.css\";i:265;s:19:\"more/editor.min.css\";i:266;s:19:\"more/editor-rtl.css\";i:267;s:23:\"more/editor-rtl.min.css\";i:268;s:21:\"navigation/editor.css\";i:269;s:25:\"navigation/editor.min.css\";i:270;s:25:\"navigation/editor-rtl.css\";i:271;s:29:\"navigation/editor-rtl.min.css\";i:272;s:26:\"navigation-link/editor.css\";i:273;s:30:\"navigation-link/editor.min.css\";i:274;s:30:\"navigation-link/editor-rtl.css\";i:275;s:34:\"navigation-link/editor-rtl.min.css\";i:276;s:25:\"navigation-link/style.css\";i:277;s:29:\"navigation-link/style.min.css\";i:278;s:29:\"navigation-link/style-rtl.css\";i:279;s:33:\"navigation-link/style-rtl.min.css\";i:280;s:20:\"navigation/style.css\";i:281;s:24:\"navigation/style.min.css\";i:282;s:24:\"navigation/style-rtl.css\";i:283;s:28:\"navigation/style-rtl.min.css\";i:284;s:29:\"navigation-submenu/editor.css\";i:285;s:33:\"navigation-submenu/editor.min.css\";i:286;s:33:\"navigation-submenu/editor-rtl.css\";i:287;s:37:\"navigation-submenu/editor-rtl.min.css\";i:288;s:19:\"nextpage/editor.css\";i:289;s:23:\"nextpage/editor.min.css\";i:290;s:23:\"nextpage/editor-rtl.css\";i:291;s:27:\"nextpage/editor-rtl.min.css\";i:292;s:20:\"page-list/editor.css\";i:293;s:24:\"page-list/editor.min.css\";i:294;s:24:\"page-list/editor-rtl.css\";i:295;s:28:\"page-list/editor-rtl.min.css\";i:296;s:19:\"page-list/style.css\";i:297;s:23:\"page-list/style.min.css\";i:298;s:23:\"page-list/style-rtl.css\";i:299;s:27:\"page-list/style-rtl.min.css\";i:300;s:20:\"paragraph/editor.css\";i:301;s:24:\"paragraph/editor.min.css\";i:302;s:24:\"paragraph/editor-rtl.css\";i:303;s:28:\"paragraph/editor-rtl.min.css\";i:304;s:19:\"paragraph/style.css\";i:305;s:23:\"paragraph/style.min.css\";i:306;s:23:\"paragraph/style-rtl.css\";i:307;s:27:\"paragraph/style-rtl.min.css\";i:308;s:31:\"post-author-biography/style.css\";i:309;s:35:\"post-author-biography/style.min.css\";i:310;s:35:\"post-author-biography/style-rtl.css\";i:311;s:39:\"post-author-biography/style-rtl.min.css\";i:312;s:26:\"post-author-name/style.css\";i:313;s:30:\"post-author-name/style.min.css\";i:314;s:30:\"post-author-name/style-rtl.css\";i:315;s:34:\"post-author-name/style-rtl.min.css\";i:316;s:21:\"post-author/style.css\";i:317;s:25:\"post-author/style.min.css\";i:318;s:25:\"post-author/style-rtl.css\";i:319;s:29:\"post-author/style-rtl.min.css\";i:320;s:29:\"post-comments-count/style.css\";i:321;s:33:\"post-comments-count/style.min.css\";i:322;s:33:\"post-comments-count/style-rtl.css\";i:323;s:37:\"post-comments-count/style-rtl.min.css\";i:324;s:29:\"post-comments-form/editor.css\";i:325;s:33:\"post-comments-form/editor.min.css\";i:326;s:33:\"post-comments-form/editor-rtl.css\";i:327;s:37:\"post-comments-form/editor-rtl.min.css\";i:328;s:28:\"post-comments-form/style.css\";i:329;s:32:\"post-comments-form/style.min.css\";i:330;s:32:\"post-comments-form/style-rtl.css\";i:331;s:36:\"post-comments-form/style-rtl.min.css\";i:332;s:28:\"post-comments-link/style.css\";i:333;s:32:\"post-comments-link/style.min.css\";i:334;s:32:\"post-comments-link/style-rtl.css\";i:335;s:36:\"post-comments-link/style-rtl.min.css\";i:336;s:22:\"post-content/style.css\";i:337;s:26:\"post-content/style.min.css\";i:338;s:26:\"post-content/style-rtl.css\";i:339;s:30:\"post-content/style-rtl.min.css\";i:340;s:19:\"post-date/style.css\";i:341;s:23:\"post-date/style.min.css\";i:342;s:23:\"post-date/style-rtl.css\";i:343;s:27:\"post-date/style-rtl.min.css\";i:344;s:23:\"post-excerpt/editor.css\";i:345;s:27:\"post-excerpt/editor.min.css\";i:346;s:27:\"post-excerpt/editor-rtl.css\";i:347;s:31:\"post-excerpt/editor-rtl.min.css\";i:348;s:22:\"post-excerpt/style.css\";i:349;s:26:\"post-excerpt/style.min.css\";i:350;s:26:\"post-excerpt/style-rtl.css\";i:351;s:30:\"post-excerpt/style-rtl.min.css\";i:352;s:30:\"post-featured-image/editor.css\";i:353;s:34:\"post-featured-image/editor.min.css\";i:354;s:34:\"post-featured-image/editor-rtl.css\";i:355;s:38:\"post-featured-image/editor-rtl.min.css\";i:356;s:29:\"post-featured-image/style.css\";i:357;s:33:\"post-featured-image/style.min.css\";i:358;s:33:\"post-featured-image/style-rtl.css\";i:359;s:37:\"post-featured-image/style-rtl.min.css\";i:360;s:30:\"post-navigation-link/style.css\";i:361;s:34:\"post-navigation-link/style.min.css\";i:362;s:34:\"post-navigation-link/style-rtl.css\";i:363;s:38:\"post-navigation-link/style-rtl.min.css\";i:364;s:23:\"post-template/style.css\";i:365;s:27:\"post-template/style.min.css\";i:366;s:27:\"post-template/style-rtl.css\";i:367;s:31:\"post-template/style-rtl.min.css\";i:368;s:20:\"post-terms/style.css\";i:369;s:24:\"post-terms/style.min.css\";i:370;s:24:\"post-terms/style-rtl.css\";i:371;s:28:\"post-terms/style-rtl.min.css\";i:372;s:27:\"post-time-to-read/style.css\";i:373;s:31:\"post-time-to-read/style.min.css\";i:374;s:31:\"post-time-to-read/style-rtl.css\";i:375;s:35:\"post-time-to-read/style-rtl.min.css\";i:376;s:20:\"post-title/style.css\";i:377;s:24:\"post-title/style.min.css\";i:378;s:24:\"post-title/style-rtl.css\";i:379;s:28:\"post-title/style-rtl.min.css\";i:380;s:22:\"preformatted/style.css\";i:381;s:26:\"preformatted/style.min.css\";i:382;s:26:\"preformatted/style-rtl.css\";i:383;s:30:\"preformatted/style-rtl.min.css\";i:384;s:20:\"pullquote/editor.css\";i:385;s:24:\"pullquote/editor.min.css\";i:386;s:24:\"pullquote/editor-rtl.css\";i:387;s:28:\"pullquote/editor-rtl.min.css\";i:388;s:19:\"pullquote/style.css\";i:389;s:23:\"pullquote/style.min.css\";i:390;s:23:\"pullquote/style-rtl.css\";i:391;s:27:\"pullquote/style-rtl.min.css\";i:392;s:19:\"pullquote/theme.css\";i:393;s:23:\"pullquote/theme.min.css\";i:394;s:23:\"pullquote/theme-rtl.css\";i:395;s:27:\"pullquote/theme-rtl.min.css\";i:396;s:16:\"query/editor.css\";i:397;s:20:\"query/editor.min.css\";i:398;s:20:\"query/editor-rtl.css\";i:399;s:24:\"query/editor-rtl.min.css\";i:400;s:27:\"query-pagination/editor.css\";i:401;s:31:\"query-pagination/editor.min.css\";i:402;s:31:\"query-pagination/editor-rtl.css\";i:403;s:35:\"query-pagination/editor-rtl.min.css\";i:404;s:35:\"query-pagination-numbers/editor.css\";i:405;s:39:\"query-pagination-numbers/editor.min.css\";i:406;s:39:\"query-pagination-numbers/editor-rtl.css\";i:407;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:408;s:26:\"query-pagination/style.css\";i:409;s:30:\"query-pagination/style.min.css\";i:410;s:30:\"query-pagination/style-rtl.css\";i:411;s:34:\"query-pagination/style-rtl.min.css\";i:412;s:21:\"query-title/style.css\";i:413;s:25:\"query-title/style.min.css\";i:414;s:25:\"query-title/style-rtl.css\";i:415;s:29:\"query-title/style-rtl.min.css\";i:416;s:21:\"query-total/style.css\";i:417;s:25:\"query-total/style.min.css\";i:418;s:25:\"query-total/style-rtl.css\";i:419;s:29:\"query-total/style-rtl.min.css\";i:420;s:15:\"quote/style.css\";i:421;s:19:\"quote/style.min.css\";i:422;s:19:\"quote/style-rtl.css\";i:423;s:23:\"quote/style-rtl.min.css\";i:424;s:15:\"quote/theme.css\";i:425;s:19:\"quote/theme.min.css\";i:426;s:19:\"quote/theme-rtl.css\";i:427;s:23:\"quote/theme-rtl.min.css\";i:428;s:19:\"read-more/style.css\";i:429;s:23:\"read-more/style.min.css\";i:430;s:23:\"read-more/style-rtl.css\";i:431;s:27:\"read-more/style-rtl.min.css\";i:432;s:14:\"rss/editor.css\";i:433;s:18:\"rss/editor.min.css\";i:434;s:18:\"rss/editor-rtl.css\";i:435;s:22:\"rss/editor-rtl.min.css\";i:436;s:13:\"rss/style.css\";i:437;s:17:\"rss/style.min.css\";i:438;s:17:\"rss/style-rtl.css\";i:439;s:21:\"rss/style-rtl.min.css\";i:440;s:17:\"search/editor.css\";i:441;s:21:\"search/editor.min.css\";i:442;s:21:\"search/editor-rtl.css\";i:443;s:25:\"search/editor-rtl.min.css\";i:444;s:16:\"search/style.css\";i:445;s:20:\"search/style.min.css\";i:446;s:20:\"search/style-rtl.css\";i:447;s:24:\"search/style-rtl.min.css\";i:448;s:16:\"search/theme.css\";i:449;s:20:\"search/theme.min.css\";i:450;s:20:\"search/theme-rtl.css\";i:451;s:24:\"search/theme-rtl.min.css\";i:452;s:20:\"separator/editor.css\";i:453;s:24:\"separator/editor.min.css\";i:454;s:24:\"separator/editor-rtl.css\";i:455;s:28:\"separator/editor-rtl.min.css\";i:456;s:19:\"separator/style.css\";i:457;s:23:\"separator/style.min.css\";i:458;s:23:\"separator/style-rtl.css\";i:459;s:27:\"separator/style-rtl.min.css\";i:460;s:19:\"separator/theme.css\";i:461;s:23:\"separator/theme.min.css\";i:462;s:23:\"separator/theme-rtl.css\";i:463;s:27:\"separator/theme-rtl.min.css\";i:464;s:20:\"shortcode/editor.css\";i:465;s:24:\"shortcode/editor.min.css\";i:466;s:24:\"shortcode/editor-rtl.css\";i:467;s:28:\"shortcode/editor-rtl.min.css\";i:468;s:20:\"site-logo/editor.css\";i:469;s:24:\"site-logo/editor.min.css\";i:470;s:24:\"site-logo/editor-rtl.css\";i:471;s:28:\"site-logo/editor-rtl.min.css\";i:472;s:19:\"site-logo/style.css\";i:473;s:23:\"site-logo/style.min.css\";i:474;s:23:\"site-logo/style-rtl.css\";i:475;s:27:\"site-logo/style-rtl.min.css\";i:476;s:23:\"site-tagline/editor.css\";i:477;s:27:\"site-tagline/editor.min.css\";i:478;s:27:\"site-tagline/editor-rtl.css\";i:479;s:31:\"site-tagline/editor-rtl.min.css\";i:480;s:22:\"site-tagline/style.css\";i:481;s:26:\"site-tagline/style.min.css\";i:482;s:26:\"site-tagline/style-rtl.css\";i:483;s:30:\"site-tagline/style-rtl.min.css\";i:484;s:21:\"site-title/editor.css\";i:485;s:25:\"site-title/editor.min.css\";i:486;s:25:\"site-title/editor-rtl.css\";i:487;s:29:\"site-title/editor-rtl.min.css\";i:488;s:20:\"site-title/style.css\";i:489;s:24:\"site-title/style.min.css\";i:490;s:24:\"site-title/style-rtl.css\";i:491;s:28:\"site-title/style-rtl.min.css\";i:492;s:22:\"social-link/editor.css\";i:493;s:26:\"social-link/editor.min.css\";i:494;s:26:\"social-link/editor-rtl.css\";i:495;s:30:\"social-link/editor-rtl.min.css\";i:496;s:23:\"social-links/editor.css\";i:497;s:27:\"social-links/editor.min.css\";i:498;s:27:\"social-links/editor-rtl.css\";i:499;s:31:\"social-links/editor-rtl.min.css\";i:500;s:22:\"social-links/style.css\";i:501;s:26:\"social-links/style.min.css\";i:502;s:26:\"social-links/style-rtl.css\";i:503;s:30:\"social-links/style-rtl.min.css\";i:504;s:17:\"spacer/editor.css\";i:505;s:21:\"spacer/editor.min.css\";i:506;s:21:\"spacer/editor-rtl.css\";i:507;s:25:\"spacer/editor-rtl.min.css\";i:508;s:16:\"spacer/style.css\";i:509;s:20:\"spacer/style.min.css\";i:510;s:20:\"spacer/style-rtl.css\";i:511;s:24:\"spacer/style-rtl.min.css\";i:512;s:16:\"table/editor.css\";i:513;s:20:\"table/editor.min.css\";i:514;s:20:\"table/editor-rtl.css\";i:515;s:24:\"table/editor-rtl.min.css\";i:516;s:15:\"table/style.css\";i:517;s:19:\"table/style.min.css\";i:518;s:19:\"table/style-rtl.css\";i:519;s:23:\"table/style-rtl.min.css\";i:520;s:15:\"table/theme.css\";i:521;s:19:\"table/theme.min.css\";i:522;s:19:\"table/theme-rtl.css\";i:523;s:23:\"table/theme-rtl.min.css\";i:524;s:20:\"tag-cloud/editor.css\";i:525;s:24:\"tag-cloud/editor.min.css\";i:526;s:24:\"tag-cloud/editor-rtl.css\";i:527;s:28:\"tag-cloud/editor-rtl.min.css\";i:528;s:19:\"tag-cloud/style.css\";i:529;s:23:\"tag-cloud/style.min.css\";i:530;s:23:\"tag-cloud/style-rtl.css\";i:531;s:27:\"tag-cloud/style-rtl.min.css\";i:532;s:24:\"template-part/editor.css\";i:533;s:28:\"template-part/editor.min.css\";i:534;s:28:\"template-part/editor-rtl.css\";i:535;s:32:\"template-part/editor-rtl.min.css\";i:536;s:23:\"template-part/theme.css\";i:537;s:27:\"template-part/theme.min.css\";i:538;s:27:\"template-part/theme-rtl.css\";i:539;s:31:\"template-part/theme-rtl.min.css\";i:540;s:20:\"term-count/style.css\";i:541;s:24:\"term-count/style.min.css\";i:542;s:24:\"term-count/style-rtl.css\";i:543;s:28:\"term-count/style-rtl.min.css\";i:544;s:26:\"term-description/style.css\";i:545;s:30:\"term-description/style.min.css\";i:546;s:30:\"term-description/style-rtl.css\";i:547;s:34:\"term-description/style-rtl.min.css\";i:548;s:19:\"term-name/style.css\";i:549;s:23:\"term-name/style.min.css\";i:550;s:23:\"term-name/style-rtl.css\";i:551;s:27:\"term-name/style-rtl.min.css\";i:552;s:24:\"term-template/editor.css\";i:553;s:28:\"term-template/editor.min.css\";i:554;s:28:\"term-template/editor-rtl.css\";i:555;s:32:\"term-template/editor-rtl.min.css\";i:556;s:23:\"term-template/style.css\";i:557;s:27:\"term-template/style.min.css\";i:558;s:27:\"term-template/style-rtl.css\";i:559;s:31:\"term-template/style-rtl.min.css\";i:560;s:23:\"text-columns/editor.css\";i:561;s:27:\"text-columns/editor.min.css\";i:562;s:27:\"text-columns/editor-rtl.css\";i:563;s:31:\"text-columns/editor-rtl.min.css\";i:564;s:22:\"text-columns/style.css\";i:565;s:26:\"text-columns/style.min.css\";i:566;s:26:\"text-columns/style-rtl.css\";i:567;s:30:\"text-columns/style-rtl.min.css\";i:568;s:15:\"verse/style.css\";i:569;s:19:\"verse/style.min.css\";i:570;s:19:\"verse/style-rtl.css\";i:571;s:23:\"verse/style-rtl.min.css\";i:572;s:16:\"video/editor.css\";i:573;s:20:\"video/editor.min.css\";i:574;s:20:\"video/editor-rtl.css\";i:575;s:24:\"video/editor-rtl.min.css\";i:576;s:15:\"video/style.css\";i:577;s:19:\"video/style.min.css\";i:578;s:19:\"video/style-rtl.css\";i:579;s:23:\"video/style-rtl.min.css\";i:580;s:15:\"video/theme.css\";i:581;s:19:\"video/theme.min.css\";i:582;s:19:\"video/theme-rtl.css\";i:583;s:23:\"video/theme-rtl.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("8348", "abzarwp-demo-hide-license-page", "1", "auto");
INSERT INTO `wp_options` VALUES("8394", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("8407", "wp_check_theme_update_id_XAI6oFXPCFpAWPoItIoWpRpQQqpCP6qW", "NDI1ODE5Ng==", "auto");
INSERT INTO `wp_options` VALUES("8411", "IqIWIpQPRQCqoQTWRonXXWARCnFRoFRt", "=KCRgGySCaJpCrSuhAfZIOgttH7QekbfWOJXdfpVJrv5EOftt5cOsAbhZVKx7eB1J161chHW7KIrfWb4DhhtI1HhZrx4YY4j5ZLrbqrtCZhrTcMjaYV14BQiiBa7RcMjwY87wZ8kjBujfIOkS6rGbYY7iBMcKcRX7cOtwYYACSMXfYaW7cOAJlhc46vEEYVk5l1WbWOXGfVxbKdjNZU7aYY7iBMcKIOkZ6rGNYYWiB116IdW7fUEbxhtGYOWfcrWllv1bH1tGYCXfIvtt7QkbjOXGYCcKIdtylv1bvhtIDVr4KdjysujNSMGaKMSY6rxzoL7MYVWNByGNvMGaKMSoWUEbDhtGYVrVKdjU6875fZcuYVrvY5WlBrrbCOpCZhrzZ5jqYrGNYZr7Ba7cYYjzY8pwYYACSaWfIdtyobkbWQpCS1WfcrWllv1bH1tGYvkKYMW77QkbxOXCorrvYrW7fUEbqrtIjhrvYR1qLdtEc11ffC7qv5jU6V14BVWiBuWwcQW77QkbxOXGYOcKYuW7BRkbCOpGBhrTcMjQYV1BZhtdZhxSwdjNdV1BortGlVrVKdju6V1BpOXGfVxSwdjwYrGsfYtiBMSTHujbsaWPSk7KZVXncRx6cQXb95STS1jTjRGNs1tPSe7foL7MYVWNByGqsaWPHajCjujRjMGfKMSdYQhCErpdoVWNByGNvMGaKMjbOaj6vMj6W1jTdQGyOrXfc5STgMGaKMEIvuG6SuETdQGygrtnL8Xf7VSTWMGaKMSbYViKBRxzZVxlc5STv1jTjRGygrtnL8pfE5STWMGaK1jTSQGyOVpfcRxlo6WfByGIsaWPvMGyKMSCBh70ZQhCIQXb7QhYcrtsByGQvMGaK5GIs1x", "auto");
INSERT INTO `wp_options` VALUES("8412", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"5bee6bf6035680b037def116f1e1cdb1\";s:6:\"blocks\";a:6:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:18:\"core/term-template\";s:120:\":where(.wp-block-term-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-term-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("8417", "https_migration_required", "1", "auto");
INSERT INTO `wp_options` VALUES("8553", "elementor_safe_mode", "", "auto");
INSERT INTO `wp_options` VALUES("8556", "_elementor_global_css", "a:6:{s:4:\"time\";i:1752393686;s:5:\"fonts\";a:0:{}s:5:\"icons\";a:0:{}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;b:0;}", "auto");
INSERT INTO `wp_options` VALUES("8557", "_elementor_assets_data", "a:1:{s:3:\"css\";a:1:{s:7:\"widgets\";a:30:{s:4:\"icon\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:6:\"3.18.1\";}s:5:\"image\";a:2:{s:7:\"content\";s:269:\"<style>/*! elementor - v3.18.0 - 06-12-2023 */\n.elementor-widget-image{text-align:center}.elementor-widget-image a{display:inline-block}.elementor-widget-image a img[src$=\".svg\"]{width:48px}.elementor-widget-image img{vertical-align:middle;display:inline-block}</style>\";s:7:\"version\";s:6:\"3.18.1\";}s:8:\"nav-menu\";a:2:{s:7:\"content\";s:122:\"<link rel=\"stylesheet\" href=\"https://tabancrm.ir/wp-content/plugins/elementor-pro/assets/css/widget-nav-menu-rtl.min.css\">\";s:7:\"version\";s:6:\"3.18.0\";}s:8:\"icon-box\";a:2:{s:7:\"content\";s:118:\"<link rel=\"stylesheet\" href=\"https://tabancrm.ir/wp-content/plugins/elementor/assets/css/widget-icon-box-rtl.min.css\">\";s:7:\"version\";s:6:\"3.18.1\";}s:6:\"button\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:6:\"3.18.1\";}s:7:\"heading\";a:2:{s:7:\"content\";s:673:\"<style>/*! elementor - v3.18.0 - 06-12-2023 */\n.elementor-heading-title{padding:0;margin:0;line-height:1}.elementor-widget-heading .elementor-heading-title[class*=elementor-size-]>a{color:inherit;font-size:inherit;line-height:inherit}.elementor-widget-heading .elementor-heading-title.elementor-size-small{font-size:15px}.elementor-widget-heading .elementor-heading-title.elementor-size-medium{font-size:19px}.elementor-widget-heading .elementor-heading-title.elementor-size-large{font-size:29px}.elementor-widget-heading .elementor-heading-title.elementor-size-xl{font-size:39px}.elementor-widget-heading .elementor-heading-title.elementor-size-xxl{font-size:59px}</style>\";s:7:\"version\";s:6:\"3.18.1\";}s:11:\"text-editor\";a:2:{s:7:\"content\";s:720:\"<style>/*! elementor - v3.18.0 - 06-12-2023 */\n.elementor-widget-text-editor.elementor-drop-cap-view-stacked .elementor-drop-cap{background-color:#69727d;color:#fff}.elementor-widget-text-editor.elementor-drop-cap-view-framed .elementor-drop-cap{color:#69727d;border:3px solid;background-color:transparent}.elementor-widget-text-editor:not(.elementor-drop-cap-view-default) .elementor-drop-cap{margin-top:8px}.elementor-widget-text-editor:not(.elementor-drop-cap-view-default) .elementor-drop-cap-letter{width:1em;height:1em}.elementor-widget-text-editor .elementor-drop-cap{float:right;text-align:center;line-height:1;font-size:50px}.elementor-widget-text-editor .elementor-drop-cap-letter{display:inline-block}</style>\";s:7:\"version\";s:6:\"3.18.1\";}s:14:\"image-carousel\";a:2:{s:7:\"content\";s:555:\"<style>/*! elementor - v3.18.0 - 06-12-2023 */\n.elementor-widget-image-carousel .swiper,.elementor-widget-image-carousel .swiper-container{position:static}.elementor-widget-image-carousel .swiper-container .swiper-slide figure,.elementor-widget-image-carousel .swiper .swiper-slide figure{line-height:inherit}.elementor-widget-image-carousel .swiper-slide{text-align:center}.elementor-image-carousel-wrapper:not(.swiper-container-initialized):not(.swiper-initialized) .swiper-slide{max-width:calc(100% / var(--e-image-carousel-slides-to-show, 3))}</style>\";s:7:\"version\";s:6:\"3.18.1\";}s:25:\"jet-listing-dynamic-field\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:6:\"3.18.1\";}s:16:\"jet-listing-grid\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:6:\"3.18.1\";}s:7:\"counter\";a:2:{s:7:\"content\";s:549:\"<style>/*! elementor - v3.18.0 - 06-12-2023 */\n.elementor-counter .elementor-counter-number-wrapper{display:flex;font-size:69px;font-weight:600;line-height:1}.elementor-counter .elementor-counter-number-prefix,.elementor-counter .elementor-counter-number-suffix{flex-grow:1;white-space:pre-wrap}.elementor-counter .elementor-counter-number-prefix{text-align:left}.elementor-counter .elementor-counter-number-suffix{text-align:right}.elementor-counter .elementor-counter-title{text-align:center;font-size:19px;font-weight:400;line-height:2.5}</style>\";s:7:\"version\";s:6:\"3.18.1\";}s:25:\"jet-listing-dynamic-terms\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:6:\"3.18.1\";}s:8:\"jet-tabs\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:6:\"3.18.1\";}s:11:\"star-rating\";a:2:{s:7:\"content\";s:2695:\"<style>/*! elementor - v3.18.0 - 06-12-2023 */\n@charset \"UTF-8\";.elementor-star-rating{color:#ccd6df;font-family:eicons;display:inline-block}.elementor-star-rating i{display:inline-block;position:relative;font-style:normal;cursor:default}.elementor-star-rating i:before{content:\"\\e934\";display:block;font-size:inherit;font-family:inherit;position:absolute;overflow:hidden;color:#f0ad4e;top:0;right:0}.elementor-star-rating .elementor-star-empty:before{content:none}.elementor-star-rating .elementor-star-1:before{width:10%}.elementor-star-rating .elementor-star-2:before{width:20%}.elementor-star-rating .elementor-star-3:before{width:30%}.elementor-star-rating .elementor-star-4:before{width:40%}.elementor-star-rating .elementor-star-5:before{width:50%}.elementor-star-rating .elementor-star-6:before{width:60%}.elementor-star-rating .elementor-star-7:before{width:70%}.elementor-star-rating .elementor-star-8:before{width:80%}.elementor-star-rating .elementor-star-9:before{width:90%}.elementor-star-rating__wrapper{display:flex;align-items:center}.elementor-star-rating__title{margin-left:10px}.elementor-star-rating--align-right .elementor-star-rating__wrapper{text-align:right;justify-content:flex-start}.elementor-star-rating--align-left .elementor-star-rating__wrapper{text-align:left;justify-content:flex-end}.elementor-star-rating--align-center .elementor-star-rating__wrapper{text-align:center;justify-content:center}.elementor-star-rating--align-justify .elementor-star-rating__title{margin-left:auto}@media (max-width:1024px){.elementor-star-rating-tablet--align-right .elementor-star-rating__wrapper{text-align:right;justify-content:flex-start}.elementor-star-rating-tablet--align-left .elementor-star-rating__wrapper{text-align:left;justify-content:flex-end}.elementor-star-rating-tablet--align-center .elementor-star-rating__wrapper{text-align:center;justify-content:center}.elementor-star-rating-tablet--align-justify .elementor-star-rating__title{margin-left:auto}}@media (max-width:767px){.elementor-star-rating-mobile--align-right .elementor-star-rating__wrapper{text-align:right;justify-content:flex-start}.elementor-star-rating-mobile--align-left .elementor-star-rating__wrapper{text-align:left;justify-content:flex-end}.elementor-star-rating-mobile--align-center .elementor-star-rating__wrapper{text-align:center;justify-content:center}.elementor-star-rating-mobile--align-justify .elementor-star-rating__title{margin-left:auto}}.last-star{letter-spacing:0}.elementor--star-style-star_unicode .elementor-star-rating{font-family:Arial,Helvetica,sans-serif}.elementor--star-style-star_unicode .elementor-star-rating i:not(.elementor-star-empty):before{content:\"★\"}</style>\";s:7:\"version\";s:6:\"3.18.1\";}s:9:\"icon-list\";a:2:{s:7:\"content\";s:119:\"<link rel=\"stylesheet\" href=\"https://tabancrm.ir/wp-content/plugins/elementor/assets/css/widget-icon-list-rtl.min.css\">\";s:7:\"version\";s:6:\"3.18.1\";}s:14:\"theme-elements\";a:2:{s:7:\"content\";s:128:\"<link rel=\"stylesheet\" href=\"https://tabancrm.ir/wp-content/plugins/elementor-pro/assets/css/widget-theme-elements-rtl.min.css\">\";s:7:\"version\";s:6:\"3.18.0\";}s:12:\"social-icons\";a:2:{s:7:\"content\";s:4943:\"<style>/*! elementor - v3.18.0 - 06-12-2023 */\n.elementor-widget-social-icons.elementor-grid-0 .elementor-widget-container,.elementor-widget-social-icons.elementor-grid-mobile-0 .elementor-widget-container,.elementor-widget-social-icons.elementor-grid-tablet-0 .elementor-widget-container{line-height:1;font-size:0}.elementor-widget-social-icons:not(.elementor-grid-0):not(.elementor-grid-tablet-0):not(.elementor-grid-mobile-0) .elementor-grid{display:inline-grid}.elementor-widget-social-icons .elementor-grid{grid-column-gap:var(--grid-column-gap,5px);grid-row-gap:var(--grid-row-gap,5px);grid-template-columns:var(--grid-template-columns);justify-content:var(--justify-content,center);justify-items:var(--justify-content,center)}.elementor-icon.elementor-social-icon{font-size:var(--icon-size,25px);line-height:var(--icon-size,25px);width:calc(var(--icon-size, 25px) + 2 * var(--icon-padding, .5em));height:calc(var(--icon-size, 25px) + 2 * var(--icon-padding, .5em))}.elementor-social-icon{--e-social-icon-icon-color:#fff;display:inline-flex;background-color:#69727d;align-items:center;justify-content:center;text-align:center;cursor:pointer}.elementor-social-icon i{color:var(--e-social-icon-icon-color)}.elementor-social-icon svg{fill:var(--e-social-icon-icon-color)}.elementor-social-icon:last-child{margin:0}.elementor-social-icon:hover{opacity:.9;color:#fff}.elementor-social-icon-android{background-color:#a4c639}.elementor-social-icon-apple{background-color:#999}.elementor-social-icon-behance{background-color:#1769ff}.elementor-social-icon-bitbucket{background-color:#205081}.elementor-social-icon-codepen{background-color:#000}.elementor-social-icon-delicious{background-color:#39f}.elementor-social-icon-deviantart{background-color:#05cc47}.elementor-social-icon-digg{background-color:#005be2}.elementor-social-icon-dribbble{background-color:#ea4c89}.elementor-social-icon-elementor{background-color:#d30c5c}.elementor-social-icon-envelope{background-color:#ea4335}.elementor-social-icon-facebook,.elementor-social-icon-facebook-f{background-color:#3b5998}.elementor-social-icon-flickr{background-color:#0063dc}.elementor-social-icon-foursquare{background-color:#2d5be3}.elementor-social-icon-free-code-camp,.elementor-social-icon-freecodecamp{background-color:#006400}.elementor-social-icon-github{background-color:#333}.elementor-social-icon-gitlab{background-color:#e24329}.elementor-social-icon-globe{background-color:#69727d}.elementor-social-icon-google-plus,.elementor-social-icon-google-plus-g{background-color:#dd4b39}.elementor-social-icon-houzz{background-color:#7ac142}.elementor-social-icon-instagram{background-color:#262626}.elementor-social-icon-jsfiddle{background-color:#487aa2}.elementor-social-icon-link{background-color:#818a91}.elementor-social-icon-linkedin,.elementor-social-icon-linkedin-in{background-color:#0077b5}.elementor-social-icon-medium{background-color:#00ab6b}.elementor-social-icon-meetup{background-color:#ec1c40}.elementor-social-icon-mixcloud{background-color:#273a4b}.elementor-social-icon-odnoklassniki{background-color:#f4731c}.elementor-social-icon-pinterest{background-color:#bd081c}.elementor-social-icon-product-hunt{background-color:#da552f}.elementor-social-icon-reddit{background-color:#ff4500}.elementor-social-icon-rss{background-color:#f26522}.elementor-social-icon-shopping-cart{background-color:#4caf50}.elementor-social-icon-skype{background-color:#00aff0}.elementor-social-icon-slideshare{background-color:#0077b5}.elementor-social-icon-snapchat{background-color:#fffc00}.elementor-social-icon-soundcloud{background-color:#f80}.elementor-social-icon-spotify{background-color:#2ebd59}.elementor-social-icon-stack-overflow{background-color:#fe7a15}.elementor-social-icon-steam{background-color:#00adee}.elementor-social-icon-stumbleupon{background-color:#eb4924}.elementor-social-icon-telegram{background-color:#2ca5e0}.elementor-social-icon-thumb-tack{background-color:#1aa1d8}.elementor-social-icon-tripadvisor{background-color:#589442}.elementor-social-icon-tumblr{background-color:#35465c}.elementor-social-icon-twitch{background-color:#6441a5}.elementor-social-icon-twitter{background-color:#1da1f2}.elementor-social-icon-viber{background-color:#665cac}.elementor-social-icon-vimeo{background-color:#1ab7ea}.elementor-social-icon-vk{background-color:#45668e}.elementor-social-icon-weibo{background-color:#dd2430}.elementor-social-icon-weixin{background-color:#31a918}.elementor-social-icon-whatsapp{background-color:#25d366}.elementor-social-icon-wordpress{background-color:#21759b}.elementor-social-icon-xing{background-color:#026466}.elementor-social-icon-yelp{background-color:#af0606}.elementor-social-icon-youtube{background-color:#cd201f}.elementor-social-icon-500px{background-color:#0099e5}.elementor-shape-rounded .elementor-icon.elementor-social-icon{border-radius:10%}.elementor-shape-circle .elementor-icon.elementor-social-icon{border-radius:50%}</style>\";s:7:\"version\";s:6:\"3.18.1\";}s:28:\"jet-smart-filters-pagination\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:6:\"3.18.1\";}s:9:\"shortcode\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:6:\"3.18.1\";}s:25:\"theme-post-featured-image\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:6:\"3.18.0\";}s:7:\"divider\";a:2:{s:7:\"content\";s:3594:\"<style>/*! elementor - v3.18.0 - 06-12-2023 */\n.elementor-widget-divider{--divider-border-style:none;--divider-border-width:1px;--divider-color:#0c0d0e;--divider-icon-size:20px;--divider-element-spacing:10px;--divider-pattern-height:24px;--divider-pattern-size:20px;--divider-pattern-url:none;--divider-pattern-repeat:repeat-x}.elementor-widget-divider .elementor-divider{display:flex}.elementor-widget-divider .elementor-divider__text{font-size:15px;line-height:1;max-width:95%}.elementor-widget-divider .elementor-divider__element{margin:0 var(--divider-element-spacing);flex-shrink:0}.elementor-widget-divider .elementor-icon{font-size:var(--divider-icon-size)}.elementor-widget-divider .elementor-divider-separator{display:flex;margin:0;direction:ltr}.elementor-widget-divider--view-line_icon .elementor-divider-separator,.elementor-widget-divider--view-line_text .elementor-divider-separator{align-items:center}.elementor-widget-divider--view-line_icon .elementor-divider-separator:after,.elementor-widget-divider--view-line_icon .elementor-divider-separator:before,.elementor-widget-divider--view-line_text .elementor-divider-separator:after,.elementor-widget-divider--view-line_text .elementor-divider-separator:before{display:block;content:\"\";border-bottom:0;flex-grow:1;border-top:var(--divider-border-width) var(--divider-border-style) var(--divider-color)}.elementor-widget-divider--element-align-left .elementor-divider .elementor-divider-separator>.elementor-divider__svg:first-of-type{flex-grow:0;flex-shrink:100}.elementor-widget-divider--element-align-left .elementor-divider-separator:before{content:none}.elementor-widget-divider--element-align-left .elementor-divider__element{margin-left:0}.elementor-widget-divider--element-align-right .elementor-divider .elementor-divider-separator>.elementor-divider__svg:last-of-type{flex-grow:0;flex-shrink:100}.elementor-widget-divider--element-align-right .elementor-divider-separator:after{content:none}.elementor-widget-divider--element-align-right .elementor-divider__element{margin-right:0}.elementor-widget-divider:not(.elementor-widget-divider--view-line_text):not(.elementor-widget-divider--view-line_icon) .elementor-divider-separator{border-top:var(--divider-border-width) var(--divider-border-style) var(--divider-color)}.elementor-widget-divider--separator-type-pattern{--divider-border-style:none}.elementor-widget-divider--separator-type-pattern.elementor-widget-divider--view-line .elementor-divider-separator,.elementor-widget-divider--separator-type-pattern:not(.elementor-widget-divider--view-line) .elementor-divider-separator:after,.elementor-widget-divider--separator-type-pattern:not(.elementor-widget-divider--view-line) .elementor-divider-separator:before,.elementor-widget-divider--separator-type-pattern:not([class*=elementor-widget-divider--view]) .elementor-divider-separator{width:100%;min-height:var(--divider-pattern-height);-webkit-mask-size:var(--divider-pattern-size) 100%;mask-size:var(--divider-pattern-size) 100%;-webkit-mask-repeat:var(--divider-pattern-repeat);mask-repeat:var(--divider-pattern-repeat);background-color:var(--divider-color);-webkit-mask-image:var(--divider-pattern-url);mask-image:var(--divider-pattern-url)}.elementor-widget-divider--no-spacing{--divider-pattern-size:auto}.elementor-widget-divider--bg-round{--divider-pattern-repeat:round}.rtl .elementor-widget-divider .elementor-divider__text{direction:rtl}.e-con-inner>.elementor-widget-divider,.e-con>.elementor-widget-divider{width:var(--container-widget-width,100%);--flex-grow:var(--container-widget-flex-grow)}</style>\";s:7:\"version\";s:6:\"3.18.1\";}s:16:\"theme-post-title\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:6:\"3.18.0\";}s:18:\"theme-post-content\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:6:\"3.18.0\";}s:5:\"forms\";a:2:{s:7:\"content\";s:6246:\"<style>/*! elementor-pro - v3.18.0 - 04-12-2023 */\n.elementor-button.elementor-hidden,.elementor-hidden{display:none}.e-form__step{width:100%}.e-form__step:not(.elementor-hidden){display:flex;flex-wrap:wrap}.e-form__buttons{flex-wrap:wrap}.e-form__buttons,.e-form__buttons__wrapper{display:flex}.e-form__indicators{display:flex;justify-content:space-between;align-items:center;flex-wrap:nowrap;font-size:13px;margin-bottom:var(--e-form-steps-indicators-spacing)}.e-form__indicators__indicator{display:flex;flex-direction:column;align-items:center;justify-content:center;flex-basis:0;padding:0 var(--e-form-steps-divider-gap)}.e-form__indicators__indicator__progress{width:100%;position:relative;background-color:var(--e-form-steps-indicator-progress-background-color);border-radius:var(--e-form-steps-indicator-progress-border-radius);overflow:hidden}.e-form__indicators__indicator__progress__meter{width:var(--e-form-steps-indicator-progress-meter-width,0);height:var(--e-form-steps-indicator-progress-height);line-height:var(--e-form-steps-indicator-progress-height);padding-right:15px;border-radius:var(--e-form-steps-indicator-progress-border-radius);background-color:var(--e-form-steps-indicator-progress-color);color:var(--e-form-steps-indicator-progress-meter-color);text-align:right;transition:width .1s linear}.e-form__indicators__indicator:first-child{padding-left:0}.e-form__indicators__indicator:last-child{padding-right:0}.e-form__indicators__indicator--state-inactive{color:var(--e-form-steps-indicator-inactive-primary-color,#c2cbd2)}.e-form__indicators__indicator--state-inactive [class*=indicator--shape-]:not(.e-form__indicators__indicator--shape-none){background-color:var(--e-form-steps-indicator-inactive-secondary-color,#fff)}.e-form__indicators__indicator--state-inactive object,.e-form__indicators__indicator--state-inactive svg{fill:var(--e-form-steps-indicator-inactive-primary-color,#c2cbd2)}.e-form__indicators__indicator--state-active{color:var(--e-form-steps-indicator-active-primary-color,#39b54a);border-color:var(--e-form-steps-indicator-active-secondary-color,#fff)}.e-form__indicators__indicator--state-active [class*=indicator--shape-]:not(.e-form__indicators__indicator--shape-none){background-color:var(--e-form-steps-indicator-active-secondary-color,#fff)}.e-form__indicators__indicator--state-active object,.e-form__indicators__indicator--state-active svg{fill:var(--e-form-steps-indicator-active-primary-color,#39b54a)}.e-form__indicators__indicator--state-completed{color:var(--e-form-steps-indicator-completed-secondary-color,#fff)}.e-form__indicators__indicator--state-completed [class*=indicator--shape-]:not(.e-form__indicators__indicator--shape-none){background-color:var(--e-form-steps-indicator-completed-primary-color,#39b54a)}.e-form__indicators__indicator--state-completed .e-form__indicators__indicator__label{color:var(--e-form-steps-indicator-completed-primary-color,#39b54a)}.e-form__indicators__indicator--state-completed .e-form__indicators__indicator--shape-none{color:var(--e-form-steps-indicator-completed-primary-color,#39b54a);background-color:initial}.e-form__indicators__indicator--state-completed object,.e-form__indicators__indicator--state-completed svg{fill:var(--e-form-steps-indicator-completed-secondary-color,#fff)}.e-form__indicators__indicator__icon{width:var(--e-form-steps-indicator-padding,30px);height:var(--e-form-steps-indicator-padding,30px);font-size:var(--e-form-steps-indicator-icon-size);border-width:1px;border-style:solid;display:flex;justify-content:center;align-items:center;overflow:hidden;margin-bottom:10px}.e-form__indicators__indicator__icon img,.e-form__indicators__indicator__icon object,.e-form__indicators__indicator__icon svg{width:var(--e-form-steps-indicator-icon-size);height:auto}.e-form__indicators__indicator__icon .e-font-icon-svg{height:1em}.e-form__indicators__indicator__number{width:var(--e-form-steps-indicator-padding,30px);height:var(--e-form-steps-indicator-padding,30px);border-width:1px;border-style:solid;display:flex;justify-content:center;align-items:center;margin-bottom:10px}.e-form__indicators__indicator--shape-circle{border-radius:50%}.e-form__indicators__indicator--shape-square{border-radius:0}.e-form__indicators__indicator--shape-rounded{border-radius:5px}.e-form__indicators__indicator--shape-none{border:0}.e-form__indicators__indicator__label{text-align:center}.e-form__indicators__indicator__separator{width:100%;height:var(--e-form-steps-divider-width);background-color:#babfc5}.e-form__indicators--type-icon,.e-form__indicators--type-icon_text,.e-form__indicators--type-number,.e-form__indicators--type-number_text{align-items:flex-start}.e-form__indicators--type-icon .e-form__indicators__indicator__separator,.e-form__indicators--type-icon_text .e-form__indicators__indicator__separator,.e-form__indicators--type-number .e-form__indicators__indicator__separator,.e-form__indicators--type-number_text .e-form__indicators__indicator__separator{margin-top:calc(var(--e-form-steps-indicator-padding, 30px) / 2 - var(--e-form-steps-divider-width, 1px) / 2)}.elementor-field-type-hidden{display:none}.elementor-field-type-html{display:inline-block}.elementor-field-type-tel input{direction:inherit}.elementor-login .elementor-lost-password,.elementor-login .elementor-remember-me{font-size:.85em}.elementor-field-type-recaptcha_v3 .elementor-field-label{display:none}.elementor-field-type-recaptcha_v3 .grecaptcha-badge{z-index:1}.elementor-button .elementor-form-spinner{order:3}.elementor-form .elementor-button>span{display:flex;justify-content:center;align-items:center}.elementor-form .elementor-button .elementor-button-text{white-space:normal;flex-grow:0}.elementor-form .elementor-button svg{height:auto}.elementor-form .elementor-button .e-font-icon-svg{height:1em}.elementor-select-wrapper .select-caret-down-wrapper{position:absolute;top:50%;transform:translateY(-50%);inset-inline-end:10px;pointer-events:none;font-size:11px}.elementor-select-wrapper .select-caret-down-wrapper svg{display:unset;width:1em;aspect-ratio:unset;fill:currentColor}.elementor-select-wrapper .select-caret-down-wrapper i{font-size:19px;line-height:2}.elementor-select-wrapper.remove-before:before{content:\"\"!important}</style>\";s:7:\"version\";s:6:\"3.18.0\";}s:8:\"template\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:6:\"3.18.0\";}s:7:\"gallery\";a:2:{s:7:\"content\";s:6197:\"<style>/*! elementor-pro - v3.18.0 - 04-12-2023 */\n.elementor-gallery__container{min-height:1px}.elementor-gallery-item{position:relative;overflow:hidden;display:block;text-decoration:none;border:solid var(--image-border-width) var(--image-border-color);border-radius:var(--image-border-radius)}.elementor-gallery-item__content,.elementor-gallery-item__overlay{height:100%;width:100%;position:absolute;top:0;left:0}.elementor-gallery-item__overlay{mix-blend-mode:var(--overlay-mix-blend-mode);transition-duration:var(--overlay-transition-duration);transition-property:mix-blend-mode,transform,opacity,background-color}.elementor-gallery-item__image.e-gallery-image{transition-duration:var(--image-transition-duration);transition-property:filter,transform}.elementor-gallery-item__content{display:flex;flex-direction:column;justify-content:var(--content-justify-content,center);align-items:center;text-align:var(--content-text-align);padding:var(--content-padding)}.elementor-gallery-item__content>div{transition-duration:var(--content-transition-duration)}.elementor-gallery-item__content.elementor-gallery--sequenced-animation>div:nth-child(2){transition-delay:calc(var(--content-transition-delay) / 3)}.elementor-gallery-item__content.elementor-gallery--sequenced-animation>div:nth-child(3){transition-delay:calc(var(--content-transition-delay) / 3 * 2)}.elementor-gallery-item__content.elementor-gallery--sequenced-animation>div:nth-child(4){transition-delay:calc(var(--content-transition-delay) / 3 * 3)}.elementor-gallery-item__description{color:var(--description-text-color,#fff);width:100%}.elementor-gallery-item__title{color:var(--title-text-color,#fff);font-weight:700;width:100%}.elementor-gallery__titles-container{display:flex;flex-wrap:wrap;justify-content:var(--titles-container-justify-content,center);margin-bottom:20px}.elementor-gallery__titles-container:not(.e--pointer-framed) .elementor-item:after,.elementor-gallery__titles-container:not(.e--pointer-framed) .elementor-item:before{background-color:var(--galleries-pointer-bg-color-hover)}.elementor-gallery__titles-container:not(.e--pointer-framed) .elementor-item.elementor-item-active:after,.elementor-gallery__titles-container:not(.e--pointer-framed) .elementor-item.elementor-item-active:before{background-color:var(--galleries-pointer-bg-color-active)}.elementor-gallery__titles-container.e--pointer-framed .elementor-item:before{border-color:var(--galleries-pointer-bg-color-hover);border-width:var(--galleries-pointer-border-width)}.elementor-gallery__titles-container.e--pointer-framed .elementor-item:after{border-color:var(--galleries-pointer-bg-color-hover)}.elementor-gallery__titles-container.e--pointer-framed .elementor-item.elementor-item-active:after,.elementor-gallery__titles-container.e--pointer-framed .elementor-item.elementor-item-active:before{border-color:var(--galleries-pointer-bg-color-active)}.elementor-gallery__titles-container.e--pointer-framed.e--animation-draw .elementor-item:before{border-left-width:var(--galleries-pointer-border-width);border-bottom-width:var(--galleries-pointer-border-width);border-right-width:0;border-top-width:0}.elementor-gallery__titles-container.e--pointer-framed.e--animation-draw .elementor-item:after{border-left-width:0;border-bottom-width:0;border-right-width:var(--galleries-pointer-border-width);border-top-width:var(--galleries-pointer-border-width)}.elementor-gallery__titles-container.e--pointer-framed.e--animation-corners .elementor-item:before{border-left-width:var(--galleries-pointer-border-width);border-bottom-width:0;border-right-width:0;border-top-width:var(--galleries-pointer-border-width)}.elementor-gallery__titles-container.e--pointer-framed.e--animation-corners .elementor-item:after{border-left-width:0;border-bottom-width:var(--galleries-pointer-border-width);border-right-width:var(--galleries-pointer-border-width);border-top-width:0}.elementor-gallery__titles-container .e--pointer-double-line .elementor-item:after,.elementor-gallery__titles-container .e--pointer-double-line .elementor-item:before,.elementor-gallery__titles-container .e--pointer-overline .elementor-item:before,.elementor-gallery__titles-container .e--pointer-underline .elementor-item:after{height:var(--galleries-pointer-border-width)}.elementor-gallery-title{--space-between:10px;cursor:pointer;color:#6d7882;font-weight:500;position:relative;padding:7px 14px;transition:all .3s}.elementor-gallery-title--active{color:#495157}.elementor-gallery-title:not(:last-child){margin-left:var(--space-between)}.elementor-gallery-item__title+.elementor-gallery-item__description{margin-top:var(--description-margin-top)}.e-gallery-item.elementor-gallery-item{transition-property:all}.e-gallery-item.elementor-animated-content .elementor-animated-item--enter-from-bottom,.e-gallery-item.elementor-animated-content .elementor-animated-item--enter-from-left,.e-gallery-item.elementor-animated-content .elementor-animated-item--enter-from-right,.e-gallery-item.elementor-animated-content .elementor-animated-item--enter-from-top,.e-gallery-item:focus .elementor-gallery__item-overlay-bg,.e-gallery-item:focus .elementor-gallery__item-overlay-content,.e-gallery-item:focus .elementor-gallery__item-overlay-content__description,.e-gallery-item:focus .elementor-gallery__item-overlay-content__title,.e-gallery-item:hover .elementor-gallery__item-overlay-bg,.e-gallery-item:hover .elementor-gallery__item-overlay-content,.e-gallery-item:hover .elementor-gallery__item-overlay-content__description,.e-gallery-item:hover .elementor-gallery__item-overlay-content__title{opacity:1}a.elementor-item.elementor-gallery-title{color:var(--galleries-title-color-normal)}a.elementor-item.elementor-gallery-title.elementor-item-active,a.elementor-item.elementor-gallery-title.highlighted,a.elementor-item.elementor-gallery-title:focus,a.elementor-item.elementor-gallery-title:hover{color:var(--galleries-title-color-hover)}a.elementor-item.elementor-gallery-title.elementor-item-active{color:var(--gallery-title-color-active)}.e-con-inner>.elementor-widget-gallery,.e-con>.elementor-widget-gallery{width:var(--container-widget-width);--flex-grow:var(--container-widget-flex-grow)}</style>\";s:7:\"version\";s:6:\"3.18.0\";}s:17:\"table-of-contents\";a:2:{s:7:\"content\";s:3908:\"<style>/*! elementor-pro - v3.18.0 - 04-12-2023 */\n.elementor-widget-table-of-contents .elementor-toc__header-title{color:var(--header-color)}.elementor-widget-table-of-contents.elementor-toc--collapsed .elementor-toc__toggle-button--collapse,.elementor-widget-table-of-contents:not(.elementor-toc--collapsed) .elementor-toc__toggle-button--expand{display:none}.elementor-widget-table-of-contents .elementor-widget-container{min-height:var(--box-min-height);border:var(--box-border-width,1px) solid var(--box-border-color,#9da5ae);border-radius:var(--box-border-radius,3px);background-color:var(--box-background-color);transition:min-height .4s;overflow:hidden}.elementor-toc__header{display:flex;align-items:center;justify-content:space-between;padding:var(--box-padding,20px);background-color:var(--header-background-color);border-bottom:var(--separator-width,1px) solid var(--box-border-color,#9da5ae)}.elementor-toc__header-title{font-size:18px;margin:0;color:var(--header-color)}.elementor-toc__toggle-button{cursor:pointer;display:inline-flex}.elementor-toc__toggle-button i{color:var(--toggle-button-color)}.elementor-toc__toggle-button svg{height:1em;width:1em;fill:var(--toggle-button-color)}.elementor-toc__spinner-container{text-align:center}.elementor-toc__spinner{font-size:2em}.elementor-toc__spinner.e-font-icon-svg{height:1em;width:1em}.elementor-toc__body{padding:var(--box-padding,20px);max-height:var(--toc-body-max-height);overflow-y:auto}.elementor-toc__body::-webkit-scrollbar{width:7px}.elementor-toc__body::-webkit-scrollbar-thumb{background-color:#babfc5;border-radius:10px}.elementor-toc__list-wrapper{list-style:none;padding:0}.elementor-toc__list-item{margin-bottom:.5em}.elementor-toc__list-item.elementor-item-active{font-weight:700}.elementor-toc__list-item .elementor-toc__list-wrapper{margin-top:.5em;margin-right:var(--nested-list-indent,1em)}.elementor-toc__list-item-text:hover{color:var(--item-text-hover-color);-webkit-text-decoration:var(--item-text-hover-decoration);text-decoration:var(--item-text-hover-decoration)}.elementor-toc__list-item-text.elementor-item-active{color:var(--item-text-active-color);-webkit-text-decoration:var(--item-text-active-decoration);text-decoration:var(--item-text-active-decoration)}.elementor-toc__list-item-text-wrapper{display:flex;align-items:center}.elementor-toc__list-item-text-wrapper:before,.elementor-toc__list-item-text-wrapper i{margin-left:8px;color:var(--marker-color)}.elementor-toc__list-item-text-wrapper svg{margin-left:8px;fill:var(--marker-color);height:var(--marker-size,.5em);width:var(--marker-size,.5em)}.elementor-toc__list-item-text-wrapper i{font-size:var(--marker-size,.5em)}.elementor-toc__list-item-text-wrapper:before{font-size:var(--marker-size,1em)}.elementor-toc--content-ellipsis .elementor-toc__list-item-text{white-space:nowrap;overflow:hidden;text-overflow:ellipsis}.elementor-toc__list-items--collapsible>.elementor-toc__list-wrapper>.elementor-toc__list-item>.elementor-toc__list-wrapper{display:none}.elementor-toc__heading-anchor{position:absolute}.elementor-toc__body .elementor-toc__list-item-text{color:var(--item-text-color);-webkit-text-decoration:var(--item-text-decoration);text-decoration:var(--item-text-decoration)}.elementor-toc__body .elementor-toc__list-item-text:hover{color:var(--item-text-hover-color);-webkit-text-decoration:var(--item-text-hover-decoration);text-decoration:var(--item-text-hover-decoration)}.elementor-toc__body .elementor-toc__list-item-text.elementor-item-active{color:var(--item-text-active-color);-webkit-text-decoration:var(--item-text-active-decoration);text-decoration:var(--item-text-active-decoration)}ol.elementor-toc__list-wrapper{counter-reset:item}ol.elementor-toc__list-wrapper .elementor-toc__list-item{counter-increment:item}ol.elementor-toc__list-wrapper .elementor-toc__list-item-text-wrapper:before{content:counters(item,\".\") \". \"}</style>\";s:7:\"version\";s:6:\"3.18.0\";}s:5:\"video\";a:2:{s:7:\"content\";s:1883:\"<style>/*! elementor - v3.18.0 - 06-12-2023 */\n.elementor-widget-video .elementor-widget-container{overflow:hidden;transform:translateZ(0)}.elementor-widget-video .elementor-wrapper{aspect-ratio:var(--video-aspect-ratio)}.elementor-widget-video .elementor-wrapper iframe,.elementor-widget-video .elementor-wrapper video{height:100%;width:100%;display:flex;border:none;background-color:#000}@supports not (aspect-ratio:1/1){.elementor-widget-video .elementor-wrapper{position:relative;overflow:hidden;height:0;padding-bottom:calc(100% / var(--video-aspect-ratio))}.elementor-widget-video .elementor-wrapper iframe,.elementor-widget-video .elementor-wrapper video{position:absolute;top:0;right:0;bottom:0;left:0}}.elementor-widget-video .elementor-open-inline .elementor-custom-embed-image-overlay{position:absolute;top:0;right:0;bottom:0;left:0;background-size:cover;background-position:50%}.elementor-widget-video .elementor-custom-embed-image-overlay{cursor:pointer;text-align:center}.elementor-widget-video .elementor-custom-embed-image-overlay:hover .elementor-custom-embed-play i{opacity:1}.elementor-widget-video .elementor-custom-embed-image-overlay img{display:block;width:100%;aspect-ratio:var(--video-aspect-ratio);-o-object-fit:cover;object-fit:cover;-o-object-position:center center;object-position:center center}@supports not (aspect-ratio:1/1){.elementor-widget-video .elementor-custom-embed-image-overlay{position:relative;overflow:hidden;height:0;padding-bottom:calc(100% / var(--video-aspect-ratio))}.elementor-widget-video .elementor-custom-embed-image-overlay img{position:absolute;top:0;right:0;bottom:0;left:0}}.elementor-widget-video .e-hosted-video .elementor-video{-o-object-fit:cover;object-fit:cover}.e-con-inner>.elementor-widget-video,.e-con>.elementor-widget-video{width:var(--container-widget-width);--flex-grow:var(--container-widget-flex-grow)}</style>\";s:7:\"version\";s:6:\"3.18.1\";}s:7:\"pricing\";a:2:{s:7:\"content\";s:5045:\"<style>/*! elementor-pro - v3.18.0 - 04-12-2023 */\n.elementor-widget-price-list .elementor-price-list{list-style:none;padding:0;margin:0}.elementor-widget-price-list .elementor-price-list li{margin:0}.elementor-price-list li:not(:last-child){margin-bottom:20px}.elementor-price-list .elementor-price-list-image{max-width:50%;flex-shrink:0;padding-left:25px}.elementor-price-list .elementor-price-list-image img{width:100%}.elementor-price-list .elementor-price-list-header,.elementor-price-list .elementor-price-list-item,.elementor-price-list .elementor-price-list-text{display:flex}.elementor-price-list .elementor-price-list-item{align-items:flex-start}.elementor-price-list .elementor-price-list-item .elementor-price-list-text{align-items:flex-start;flex-wrap:wrap;flex-grow:1}.elementor-price-list .elementor-price-list-item .elementor-price-list-header{align-items:center;flex-basis:100%;font-size:19px;font-weight:600;margin-bottom:10px;justify-content:space-between}.elementor-price-list .elementor-price-list-item .elementor-price-list-title{max-width:80%}.elementor-price-list .elementor-price-list-item .elementor-price-list-price{font-weight:600}.elementor-price-list .elementor-price-list-item p.elementor-price-list-description{flex-basis:100%;font-size:14px;margin:0}.elementor-price-list .elementor-price-list-item .elementor-price-list-separator{flex-grow:1;margin-left:10px;margin-right:10px;border-bottom-style:dotted;border-bottom-width:2px;height:0}.elementor-price-table{text-align:center}.elementor-price-table .elementor-price-table__header{background:var(--e-price-table-header-background-color,#555);padding:20px 0}.elementor-price-table .elementor-price-table__heading{margin:0;padding:0;line-height:1.2;font-size:24px;font-weight:600;color:#fff}.elementor-price-table .elementor-price-table__subheading{font-size:13px;font-weight:400;color:#fff}.elementor-price-table .elementor-price-table__original-price{margin-left:15px;text-decoration:line-through;font-size:.5em;line-height:1;font-weight:400;align-self:center}.elementor-price-table .elementor-price-table__original-price .elementor-price-table__currency{font-size:1em;margin:0}.elementor-price-table .elementor-price-table__price{display:flex;justify-content:center;align-items:center;flex-wrap:wrap;flex-direction:row-reverse;color:#555;font-weight:800;font-size:65px;padding:40px 0}.elementor-price-table .elementor-price-table__price .elementor-typo-excluded{line-height:normal;letter-spacing:normal;text-transform:none;font-weight:400;font-size:medium;font-style:normal}.elementor-price-table .elementor-price-table__after-price{display:flex;flex-wrap:wrap;text-align:start;align-self:stretch;align-items:flex-start;flex-direction:column}.elementor-price-table .elementor-price-table__integer-part{line-height:.8}.elementor-price-table .elementor-price-table__currency,.elementor-price-table .elementor-price-table__fractional-part{line-height:1;font-size:.3em}.elementor-price-table .elementor-price-table__currency{margin-left:3px}.elementor-price-table .elementor-price-table__period{width:100%;font-size:13px;font-weight:400}.elementor-price-table .elementor-price-table__features-list{list-style-type:none;margin:0;padding:0;line-height:1;color:var(--e-price-table-features-list-color)}.elementor-price-table .elementor-price-table__features-list li{font-size:14px;line-height:1;margin:0;padding:0}.elementor-price-table .elementor-price-table__features-list li .elementor-price-table__feature-inner{margin-left:15px;margin-right:15px}.elementor-price-table .elementor-price-table__features-list li:not(:first-child):before{content:\"\";display:block;border:0 solid hsla(0,0%,47.8%,.3);margin:10px 12.5%}.elementor-price-table .elementor-price-table__features-list i{margin-left:10px;font-size:1.3em}.elementor-price-table .elementor-price-table__features-list svg{margin-left:10px;fill:var(--e-price-table-features-list-color);height:1.3em;width:1.3em}.elementor-price-table .elementor-price-table__features-list svg~*{vertical-align:text-top}.elementor-price-table .elementor-price-table__footer{padding:30px 0}.elementor-price-table .elementor-price-table__additional_info{margin:0;font-size:13px;line-height:1.4}.elementor-price-table__ribbon{position:absolute;top:0;left:0;right:auto;transform:rotate(0);width:150px;overflow:hidden;height:150px}.elementor-price-table__ribbon-inner{text-align:center;left:0;width:200%;transform:translateY(-50%) translateX(0) translateX(35px) rotate(-45deg);margin-top:35px;font-size:13px;line-height:2;font-weight:800;text-transform:uppercase;background:#000}.elementor-price-table__ribbon.elementor-ribbon-left{transform:rotate(0);left:0;right:auto}.elementor-price-table__ribbon.elementor-ribbon-right{transform:rotate(90deg);left:auto;right:0}.elementor-widget-price-table .elementor-widget-container{overflow:hidden;background-color:#f9fafa}.e-con-inner>.elementor-widget-price-list,.e-con>.elementor-widget-price-list{width:var(--container-widget-width);--flex-grow:var(--container-widget-flex-grow)}</style>\";s:7:\"version\";s:6:\"3.18.0\";}s:19:\"theme-archive-title\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:6:\"3.18.0\";}}}}", "auto");
INSERT INTO `wp_options` VALUES("8605", "_transient_health-check-site-status-result", "{\"good\":15,\"recommended\":6,\"critical\":2}", "on");
INSERT INTO `wp_options` VALUES("8619", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[],\"failedPackageIds\":[]}", "auto");
INSERT INTO `wp_options` VALUES("9606", "category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("9660", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"25.6\";}", "auto");
INSERT INTO `wp_options` VALUES("9661", "wpseo", "a:115:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:21:\"post_type_made_public\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"25.6\";s:16:\"previous_version\";s:0:\"\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:1;s:22:\"ai_enabled_pre_default\";b:0;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1754723523;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:12:\"/%postname%/\";s:8:\"home_url\";s:19:\"https://tabancrm.ir\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:4:{s:22:\"elementor_library_type\";s:22:\"elementor_library_type\";s:26:\"elementor_library_category\";s:26:\"elementor_library_category\";s:13:\"work_category\";s:13:\"work_category\";s:19:\"elementor_font_type\";s:19:\"elementor_font_type\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:0:{}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:18:\"first_time_install\";b:1;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1754723525;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:19:\"deny_ccbot_crawling\";b:0;s:29:\"deny_google_extended_crawling\";b:0;s:20:\"deny_gptbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:7:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:14:\"e-landing-page\";i:3;s:14:\"udb_admin_page\";i:4;s:10:\"jet-engine\";i:5;s:8:\"projects\";i:6;s:8:\"services\";}s:28:\"last_known_public_taxonomies\";a:4:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";i:3;s:13:\"work_category\";}s:23:\"last_known_no_unindexed\";a:5:{s:40:\"wpseo_total_unindexed_post_type_archives\";i:1766820988;s:31:\"wpseo_unindexed_post_link_count\";i:1764027166;s:31:\"wpseo_unindexed_term_link_count\";i:1766820988;s:35:\"wpseo_total_unindexed_general_items\";i:1766820988;s:27:\"wpseo_total_unindexed_terms\";i:1766820988;}s:14:\"new_post_types\";a:1:{i:4;s:10:\"jet-engine\";}s:14:\"new_taxonomies\";a:0:{}s:34:\"show_new_content_type_notification\";b:1;s:44:\"site_kit_configuration_permanently_dismissed\";b:0;s:18:\"site_kit_connected\";b:0;s:37:\"site_kit_tracking_setup_widget_loaded\";s:2:\"no\";s:41:\"site_kit_tracking_first_interaction_stage\";s:0:\"\";s:40:\"site_kit_tracking_last_interaction_stage\";s:0:\"\";s:52:\"site_kit_tracking_setup_widget_temporarily_dismissed\";s:2:\"no\";s:52:\"site_kit_tracking_setup_widget_permanently_dismissed\";s:2:\"no\";s:31:\"google_site_kit_feature_enabled\";b:0;s:25:\"ai_free_sparks_started_on\";s:10:\"1755053910\";s:15:\"enable_llms_txt\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("9662", "wpseo_titles", "a:220:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:51:\"%%name%%, نویسنده در %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:84:\"شما برای %%searchphrase%% جستجو کردید %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:45:\"صفحه پیدا نشد %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:79:\"نوشته %%POSTLINK%% اولین بار در %%BLOGLINK%%. پدیدار شد.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:38:\"خطای 404: صفحه پیدا نشد\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:30:\"بایگانی‌ها برای\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:8:\"خانه\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:39:\"شما جستجو نمودید برای\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:24:\"publishing_principles_id\";i:0;s:25:\"ownership_funding_info_id\";i:0;s:29:\"actionable_feedback_policy_id\";i:0;s:21:\"corrections_policy_id\";i:0;s:16:\"ethics_policy_id\";i:0;s:19:\"diversity_policy_id\";i:0;s:28:\"diversity_staffing_report_id\";i:0;s:15:\"org-description\";s:0:\"\";s:9:\"org-email\";s:0:\"\";s:9:\"org-phone\";s:0:\"\";s:14:\"org-legal-name\";s:0:\"\";s:17:\"org-founding-date\";s:0:\"\";s:20:\"org-number-employees\";s:0:\"\";s:10:\"org-vat-id\";s:0:\"\";s:10:\"org-tax-id\";s:0:\"\";s:7:\"org-iso\";s:0:\"\";s:8:\"org-duns\";s:0:\"\";s:11:\"org-leicode\";s:0:\"\";s:9:\"org-naics\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:20:\"title-e-landing-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-e-landing-page\";s:0:\"\";s:22:\"noindex-e-landing-page\";b:0;s:33:\"display-metabox-pt-e-landing-page\";b:1;s:33:\"post_types-e-landing-page-maintax\";i:0;s:31:\"schema-page-type-e-landing-page\";s:7:\"WebPage\";s:34:\"schema-article-type-e-landing-page\";s:4:\"None\";s:27:\"social-title-e-landing-page\";s:9:\"%%title%%\";s:33:\"social-description-e-landing-page\";s:0:\"\";s:31:\"social-image-url-e-landing-page\";s:0:\"\";s:30:\"social-image-id-e-landing-page\";i:0;s:23:\"title-elementor_library\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-elementor_library\";s:0:\"\";s:25:\"noindex-elementor_library\";b:0;s:36:\"display-metabox-pt-elementor_library\";b:1;s:36:\"post_types-elementor_library-maintax\";i:0;s:34:\"schema-page-type-elementor_library\";s:7:\"WebPage\";s:37:\"schema-article-type-elementor_library\";s:4:\"None\";s:30:\"social-title-elementor_library\";s:9:\"%%title%%\";s:36:\"social-description-elementor_library\";s:0:\"\";s:34:\"social-image-url-elementor_library\";s:0:\"\";s:33:\"social-image-id-elementor_library\";i:0;s:20:\"title-udb_admin_page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-udb_admin_page\";s:0:\"\";s:22:\"noindex-udb_admin_page\";b:0;s:33:\"display-metabox-pt-udb_admin_page\";b:1;s:33:\"post_types-udb_admin_page-maintax\";i:0;s:31:\"schema-page-type-udb_admin_page\";s:7:\"WebPage\";s:34:\"schema-article-type-udb_admin_page\";s:4:\"None\";s:27:\"social-title-udb_admin_page\";s:9:\"%%title%%\";s:33:\"social-description-udb_admin_page\";s:0:\"\";s:31:\"social-image-url-udb_admin_page\";s:0:\"\";s:30:\"social-image-id-udb_admin_page\";i:0;s:16:\"title-jet-engine\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-jet-engine\";s:0:\"\";s:18:\"noindex-jet-engine\";b:0;s:29:\"display-metabox-pt-jet-engine\";b:1;s:29:\"post_types-jet-engine-maintax\";i:0;s:27:\"schema-page-type-jet-engine\";s:7:\"WebPage\";s:30:\"schema-article-type-jet-engine\";s:4:\"None\";s:23:\"social-title-jet-engine\";s:9:\"%%title%%\";s:29:\"social-description-jet-engine\";s:0:\"\";s:27:\"social-image-url-jet-engine\";s:0:\"\";s:26:\"social-image-id-jet-engine\";i:0;s:14:\"title-projects\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:17:\"metadesc-projects\";s:0:\"\";s:16:\"noindex-projects\";b:0;s:27:\"display-metabox-pt-projects\";b:1;s:27:\"post_types-projects-maintax\";i:0;s:25:\"schema-page-type-projects\";s:7:\"WebPage\";s:28:\"schema-article-type-projects\";s:4:\"None\";s:21:\"social-title-projects\";s:9:\"%%title%%\";s:27:\"social-description-projects\";s:0:\"\";s:25:\"social-image-url-projects\";s:0:\"\";s:24:\"social-image-id-projects\";i:0;s:24:\"title-ptarchive-projects\";s:58:\"بایگانی %%pt_plural%% %%page%% %%sep%% %%sitename%%\";s:27:\"metadesc-ptarchive-projects\";s:0:\"\";s:26:\"bctitle-ptarchive-projects\";s:0:\"\";s:26:\"noindex-ptarchive-projects\";b:0;s:31:\"social-title-ptarchive-projects\";s:28:\"بایگانی %%pt_plural%%\";s:37:\"social-description-ptarchive-projects\";s:0:\"\";s:35:\"social-image-url-ptarchive-projects\";s:0:\"\";s:34:\"social-image-id-ptarchive-projects\";i:0;s:14:\"title-services\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:17:\"metadesc-services\";s:0:\"\";s:16:\"noindex-services\";b:0;s:27:\"display-metabox-pt-services\";b:1;s:27:\"post_types-services-maintax\";i:0;s:25:\"schema-page-type-services\";s:7:\"WebPage\";s:28:\"schema-article-type-services\";s:4:\"None\";s:21:\"social-title-services\";s:9:\"%%title%%\";s:27:\"social-description-services\";s:0:\"\";s:25:\"social-image-url-services\";s:0:\"\";s:24:\"social-image-id-services\";i:0;s:24:\"title-ptarchive-services\";s:58:\"بایگانی %%pt_plural%% %%page%% %%sep%% %%sitename%%\";s:27:\"metadesc-ptarchive-services\";s:0:\"\";s:26:\"bctitle-ptarchive-services\";s:0:\"\";s:26:\"noindex-ptarchive-services\";b:0;s:31:\"social-title-ptarchive-services\";s:28:\"بایگانی %%pt_plural%%\";s:37:\"social-description-ptarchive-services\";s:0:\"\";s:35:\"social-image-url-ptarchive-services\";s:0:\"\";s:34:\"social-image-id-ptarchive-services\";i:0;s:18:\"title-tax-category\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:38:\"بایگانی‌های %%term_title%%\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:38:\"بایگانی‌های %%term_title%%\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:38:\"بایگانی‌های %%term_title%%\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:23:\"title-tax-work_category\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-tax-work_category\";s:0:\"\";s:33:\"display-metabox-tax-work_category\";b:1;s:25:\"noindex-tax-work_category\";b:0;s:30:\"social-title-tax-work_category\";s:38:\"بایگانی‌های %%term_title%%\";s:36:\"social-description-tax-work_category\";s:0:\"\";s:34:\"social-image-url-tax-work_category\";s:0:\"\";s:33:\"social-image-id-tax-work_category\";i:0;s:31:\"taxonomy-work_category-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}", "auto");
INSERT INTO `wp_options` VALUES("9663", "wpseo_social", "a:20:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:0:{}s:12:\"mastodon_url\";s:0:\"\";}", "auto");
INSERT INTO `wp_options` VALUES("9664", "wpseo_llmstxt", "a:7:{s:23:\"llms_txt_selection_mode\";s:4:\"auto\";s:13:\"about_us_page\";i:0;s:12:\"contact_page\";i:0;s:10:\"terms_page\";i:0;s:19:\"privacy_policy_page\";i:0;s:9:\"shop_page\";i:0;s:20:\"other_included_pages\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("9681", "jetpack_activated", "1", "auto");
INSERT INTO `wp_options` VALUES("9684", "jetpack_activation_source", "a:2:{i:0;s:4:\"list\";i:1;N;}", "auto");
INSERT INTO `wp_options` VALUES("9685", "jetpack_sync_settings_disable", "0", "on");
INSERT INTO `wp_options` VALUES("9686", "jetpack_options", "a:4:{s:7:\"version\";s:17:\"14.9.1:1754723542\";s:11:\"old_version\";s:17:\"14.9.1:1754723542\";s:14:\"last_heartbeat\";i:1766739883;s:28:\"fallback_no_verify_ssl_certs\";i:0;}", "auto");
INSERT INTO `wp_options` VALUES("9687", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:25:\"{{WP_PLUGIN_DIR}}/jetpack\";}", "on");
INSERT INTO `wp_options` VALUES("9690", "jetpack_available_modules", "a:1:{s:6:\"14.9.1\";a:43:{s:18:\"account-protection\";s:4:\"14.5\";s:5:\"blaze\";s:4:\"12.3\";s:6:\"blocks\";s:8:\"13.9-a.8\";s:8:\"carousel\";s:3:\"1.5\";s:13:\"comment-likes\";s:3:\"5.1\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:9:\"copy-post\";s:3:\"7.0\";s:20:\"custom-content-types\";s:3:\"3.1\";s:12:\"google-fonts\";s:6:\"10.8.0\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:5:\"likes\";s:3:\"2.2\";s:8:\"markdown\";s:3:\"2.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:10:\"photon-cdn\";s:3:\"6.6\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:9:\"post-list\";s:4:\"11.3\";s:7:\"protect\";s:3:\"3.4\";s:9:\"publicize\";s:3:\"2.0\";s:13:\"related-posts\";s:3:\"2.9\";s:6:\"search\";s:3:\"5.0\";s:9:\"seo-tools\";s:3:\"4.4\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:8:\"sitemaps\";s:3:\"3.9\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:3:\"waf\";s:4:\"10.9\";s:7:\"widgets\";s:3:\"1.2\";s:17:\"widget-visibility\";s:3:\"2.4\";s:21:\"woocommerce-analytics\";s:3:\"8.4\";s:7:\"wordads\";s:5:\"4.5.0\";}}", "auto");
INSERT INTO `wp_options` VALUES("9692", "do_activate", "0", "auto");
INSERT INTO `wp_options` VALUES("9693", "jetpack_sync_https_history_home_url", "a:5:{i:0;s:4:\"http\";i:1;s:4:\"http\";i:2;s:5:\"https\";i:3;s:4:\"http\";i:4;s:5:\"https\";}", "auto");
INSERT INTO `wp_options` VALUES("9694", "jetpack_sync_https_history_site_url", "a:5:{i:0;s:4:\"http\";i:1;s:4:\"http\";i:2;s:5:\"https\";i:3;s:4:\"http\";i:4;s:5:\"https\";}", "auto");
INSERT INTO `wp_options` VALUES("9699", "jetpack_waf_needs_update", "", "auto");
INSERT INTO `wp_options` VALUES("9700", "jetpack_active_modules", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("9703", "jetpack_tos_agreed", "1", "auto");
INSERT INTO `wp_options` VALUES("9704", "jetpack_secrets", "a:1:{s:18:\"jetpack_register_4\";a:3:{s:8:\"secret_1\";s:32:\"KXVG02XjBncvo12atZJh5S7S7EzC2WBI\";s:8:\"secret_2\";s:32:\"GiHkEnUbTiXdtM6UDYt5y93JdYpFLSnS\";s:3:\"exp\";i:1754724164;}}", "no");
INSERT INTO `wp_options` VALUES("9705", "_transient_jetpack_assumed_site_creation_date", "2023-10-09 18:49:38", "on");
INSERT INTO `wp_options` VALUES("15941", "wp_notes_notify", "1", "on");
INSERT INTO `wp_options` VALUES("15947", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:63:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.9.zip\";s:6:\"locale\";s:5:\"fa_IR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:63:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.9.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.9\";s:7:\"version\";s:3:\"6.9\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1766791627;s:15:\"version_checked\";s:3:\"6.9\";s:12:\"translations\";a:1:{i:0;a:7:{s:4:\"type\";s:4:\"core\";s:4:\"slug\";s:7:\"default\";s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-25 18:17:43\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/fa_IR.zip\";s:10:\"autoupdate\";b:1;}}}", "off");
INSERT INTO `wp_options` VALUES("16847", "_site_transient_timeout_php_check_b177535be5f1790a48742622cfd50ecb", "1767017204", "off");
INSERT INTO `wp_options` VALUES("16848", "_site_transient_php_check_b177535be5f1790a48742622cfd50ecb", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("16973", "_transient_timeout_jetpack_file_data_14.9.1", "1769089305", "off");
INSERT INTO `wp_options` VALUES("16974", "_transient_jetpack_file_data_14.9.1", "a:1:{s:32:\"3fd340ad52927afb3bbb9e98575eccfd\";a:15:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:24:\"requires_user_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}}", "off");
INSERT INTO `wp_options` VALUES("17093", "_site_transient_timeout_jet_dashboard_license_expire_check", "1766834366", "off");
INSERT INTO `wp_options` VALUES("17094", "_site_transient_jet_dashboard_license_expire_check", "true", "off");
INSERT INTO `wp_options` VALUES("17095", "_site_transient_timeout_theme_roots", "1766792971", "off");
INSERT INTO `wp_options` VALUES("17096", "_site_transient_theme_roots", "a:2:{s:15:\"hello-elementor\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("17099", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1766791639;s:8:\"response\";a:6:{s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.5.14\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.5.14.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:23:\"elementor/elementor.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:6:\"3.34.0\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.34.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:19:\"jetpack/jetpack.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:21:\"w.org/plugins/jetpack\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:6:\"15.3.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/jetpack.15.3.1.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237\";s:3:\"svg\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/jetpack/assets/banner-1544x500.png?rev=2653649\";s:2:\"1x\";s:62:\"https://ps.w.org/jetpack/assets/banner-772x250.png?rev=2653649\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.7\";s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}}s:41:\"ultimate-dashboard/ultimate-dashboard.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:32:\"w.org/plugins/ultimate-dashboard\";s:4:\"slug\";s:18:\"ultimate-dashboard\";s:6:\"plugin\";s:41:\"ultimate-dashboard/ultimate-dashboard.php\";s:11:\"new_version\";s:6:\"3.8.12\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/ultimate-dashboard/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/ultimate-dashboard.3.8.12.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/ultimate-dashboard/assets/icon-256x256.png?rev=2859260\";s:2:\"1x\";s:71:\"https://ps.w.org/ultimate-dashboard/assets/icon-256x256.png?rev=2859260\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/ultimate-dashboard/assets/banner-1544x500.jpg?rev=2859272\";s:2:\"1x\";s:73:\"https://ps.w.org/ultimate-dashboard/assets/banner-772x250.jpg?rev=2859272\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"5.6\";s:16:\"requires_plugins\";a:0:{}}s:29:\"wp-parsidate/wp-parsidate.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:26:\"w.org/plugins/wp-parsidate\";s:4:\"slug\";s:12:\"wp-parsidate\";s:6:\"plugin\";s:29:\"wp-parsidate/wp-parsidate.php\";s:11:\"new_version\";s:7:\"5.1.8.2\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wp-parsidate/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/wp-parsidate.5.1.8.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:57:\"https://ps.w.org/wp-parsidate/assets/icon.svg?rev=1036248\";s:3:\"svg\";s:57:\"https://ps.w.org/wp-parsidate/assets/icon.svg?rev=1036248\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:67:\"https://ps.w.org/wp-parsidate/assets/banner-772x250.jpg?rev=2044005\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:4:\"26.6\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.26.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-256x256.gif?rev=3419908\";s:2:\"1x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-128x128.gif?rev=3419908\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=3257862\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=3257862\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=3257862\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=3257862\";}s:8:\"requires\";s:3:\"6.7\";s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:1:{s:37:\"flexy-breadcrumb/flexy-breadcrumb.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:30:\"w.org/plugins/flexy-breadcrumb\";s:4:\"slug\";s:16:\"flexy-breadcrumb\";s:6:\"plugin\";s:37:\"flexy-breadcrumb/flexy-breadcrumb.php\";s:11:\"new_version\";s:5:\"1.2.1\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/flexy-breadcrumb/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/flexy-breadcrumb.1.2.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/flexy-breadcrumb/assets/icon-256x256.png?rev=1839281\";s:2:\"1x\";s:69:\"https://ps.w.org/flexy-breadcrumb/assets/icon-128x128.png?rev=1839281\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:71:\"https://ps.w.org/flexy-breadcrumb/assets/banner-772x250.jpg?rev=2132060\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}}s:7:\"checked\";a:16:{s:29:\"abzarwp-auto-update/index.php\";s:6:\"1.3.17\";s:25:\"duplicator/duplicator.php\";s:7:\"1.5.7.1\";s:23:\"elementor/elementor.php\";s:6:\"3.18.1\";s:31:\"elementor-pro/elementor-pro.php\";s:6:\"3.18.0\";s:37:\"flexy-breadcrumb/flexy-breadcrumb.php\";s:5:\"1.2.1\";s:25:\"jet-engine/jet-engine.php\";s:5:\"3.3.1\";s:53:\"jet-engine-trim-callback/jet-engine-trim-callback.php\";s:5:\"1.0.3\";s:19:\"jetpack/jetpack.php\";s:6:\"14.9.1\";s:24:\"jet-plugin-pro/index.php\";s:5:\"1.5.1\";s:39:\"jet-smart-filters/jet-smart-filters.php\";s:5:\"3.2.0\";s:21:\"jet-tabs/jet-tabs.php\";s:6:\"2.1.21\";s:41:\"ultimate-dashboard/ultimate-dashboard.php\";s:5:\"3.8.8\";s:49:\"ultimate-dashboard-pro/ultimate-dashboard-pro.php\";s:6:\"3.10.4\";s:29:\"wp-parsidate/wp-parsidate.php\";s:5:\"4.0.2\";s:24:\"wordpress-seo/wp-seo.php\";s:4:\"25.6\";s:35:\"abzarwp-license/abzarwp-license.php\";s:5:\"1.2.4\";}}", "off");
INSERT INTO `wp_options` VALUES("17100", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1766791641;s:7:\"checked\";a:2:{s:15:\"hello-elementor\";s:5:\"2.9.0\";s:16:\"twentytwentyfive\";s:3:\"1.2\";}s:8:\"response\";a:2:{s:15:\"hello-elementor\";a:6:{s:5:\"theme\";s:15:\"hello-elementor\";s:11:\"new_version\";s:5:\"3.4.5\";s:3:\"url\";s:45:\"https://wordpress.org/themes/hello-elementor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/hello-elementor.3.4.5.zip\";s:8:\"requires\";s:3:\"6.0\";s:12:\"requires_php\";s:3:\"7.4\";}s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfive.1.4.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("17127", "_site_transient_timeout_wp_theme_files_patterns-238435eacf7fe38fd9152d53e9066886", "1766821319", "off");
INSERT INTO `wp_options` VALUES("17128", "_site_transient_wp_theme_files_patterns-238435eacf7fe38fd9152d53e9066886", "a:2:{s:7:\"version\";s:5:\"2.9.0\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("17131", "_site_transient_timeout_available_translations", "1766831273", "off");
INSERT INTO `wp_options` VALUES("17132", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.11/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.7/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-07-10 08:09:09\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.7/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2024-12-26 00:37:42\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.28/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-01 10:38:20\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-21 05:53:45\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-14 10:28:42\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-11 21:36:34\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-26 15:18:01\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-18 15:47:02\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-10-23 12:01:47\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-22 10:44:48\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.9/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-22 11:40:23\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 08:11:27\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 08:08:17\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.9/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-18 14:30:43\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-25 13:30:15\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-24 12:51:19\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-13 06:27:29\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-15 12:18:56\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-23 16:40:44\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-20 14:13:54\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 13:13:48\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-13 04:21:30\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-16 02:35:00\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-10-01 22:54:47\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.12/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.18/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.23/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 11:10:15\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-12 22:21:48\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-11-05 21:53:17\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9-RC/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-25 18:17:43\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-02-14 17:29:08\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-29 11:04:04\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-10-03 04:54:28\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.7/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-10 11:15:06\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2025-12-20 19:08:53\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2025-10-21 16:35:04\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.8/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-18 15:51:09\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-09 11:14:55\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.34\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.34/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2025-02-06 05:17:11\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 02:14:36\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 02:11:55\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-16 09:07:30\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-01 17:48:46\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 11:59:02\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-25 08:25:07\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9-RC/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.23/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-13 14:52:59\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-16 00:49:25\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-08 08:55:07\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.9/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-23 15:08:15\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.9/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-09-27 20:51:17\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-07-15 19:11:43\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.0.11/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-25 18:47:08\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.7/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-05 11:38:40\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.17\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.17/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 19:55:58\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-11-07 08:26:32\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 09:40:20\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-18 15:26:13\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.9/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-16 18:13:25\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-01 09:45:52\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.35\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.35/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 18:21:27\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 10:17:43\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 00:03:57\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/6.9/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-09 09:48:35\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-08 13:01:10\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.18/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-01 04:57:17\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-04-24 16:58:02\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/6.9-RC/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-10-29 11:19:02\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-24 16:29:39\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 15:37:44\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-27 15:18:03\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-16 17:19:56\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.12/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-13 08:39:22\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-26 15:28:41\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-24 03:42:11\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"6.8\";s:7:\"updated\";s:19:\"2025-04-18 21:10:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.8/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.18/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-09-01 09:12:13\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 00:32:44\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 08:19:35\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}", "off");
INSERT INTO `wp_options` VALUES("17133", "_transient_timeout_jetpack_https_test", "1766907348", "off");
INSERT INTO `wp_options` VALUES("17134", "_transient_jetpack_https_test", "0", "off");
INSERT INTO `wp_options` VALUES("17135", "_transient_timeout_jetpack_https_test_message", "1766907348", "off");
INSERT INTO `wp_options` VALUES("17136", "_transient_jetpack_https_test_message", "WordPress گزارش می‌دهد که پشتیبانی از SSL وجود ندارد", "off");
INSERT INTO `wp_options` VALUES("17139", "_transient_timeout_wpseo_total_unindexed_posts_limited", "1766821848", "off");
INSERT INTO `wp_options` VALUES("17140", "_transient_wpseo_total_unindexed_posts_limited", "2", "off");
INSERT INTO `wp_options` VALUES("17141", "_site_transient_timeout_browser_89db729cfcdc129111f017b0e7ac324a", "1767425749", "off");
INSERT INTO `wp_options` VALUES("17142", "_site_transient_browser_89db729cfcdc129111f017b0e7ac324a", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"143.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("17143", "_transient_timeout_elementor_remote_info_api_data_3.18.1", "1766864150", "off");
INSERT INTO `wp_options` VALUES("17144", "_transient_elementor_remote_info_api_data_3.18.1", "a:4:{s:9:\"timestamp\";s:10:\"1766820066\";s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:82:{i:0;a:4:{s:4:\"name\";s:6:\"search\";s:5:\"title\";s:6:\"Search\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:3;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-2\";s:5:\"title\";s:7:\"Classic\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:4;a:4:{s:4:\"name\";s:9:\"mega-menu\";s:5:\"title\";s:4:\"Menu\";s:4:\"icon\";s:15:\"eicon-mega-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:5;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-3\";s:5:\"title\";s:8:\"Showcase\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:6;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-4\";s:5:\"title\";s:5:\"Links\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:8;a:4:{s:4:\"name\";s:9:\"loop-grid\";s:5:\"title\";s:9:\"Loop Grid\";s:4:\"icon\";s:18:\"eicon-loop-builder\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:9;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-5\";s:5:\"title\";s:8:\"Services\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:10;a:4:{s:4:\"name\";s:13:\"loop-carousel\";s:5:\"title\";s:13:\"Loop Carousel\";s:4:\"icon\";s:19:\"eicon-carousel-loop\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:11;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-6\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:12;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-7\";s:5:\"title\";s:13:\"Business Card\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:14;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:16;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:19;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:20;a:4:{s:4:\"name\";s:15:\"nested-carousel\";s:5:\"title\";s:8:\"Carousel\";s:4:\"icon\";s:21:\"eicon-nested-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:21;a:4:{s:4:\"name\";s:10:\"off-canvas\";s:5:\"title\";s:10:\"Off-Canvas\";s:4:\"icon\";s:16:\"eicon-off-canvas\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:22;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:23;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:24;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:25;a:4:{s:4:\"name\";s:6:\"lottie\";s:5:\"title\";s:6:\"Lottie\";s:4:\"icon\";s:12:\"eicon-lottie\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:26;a:4:{s:4:\"name\";s:7:\"hotspot\";s:5:\"title\";s:7:\"Hotspot\";s:4:\"icon\";s:19:\"eicon-image-hotspot\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:27;a:4:{s:4:\"name\";s:13:\"paypal-button\";s:5:\"title\";s:13:\"PayPal Button\";s:4:\"icon\";s:19:\"eicon-paypal-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:28;a:4:{s:4:\"name\";s:14:\"code-highlight\";s:5:\"title\";s:14:\"Code Highlight\";s:4:\"icon\";s:20:\"eicon-code-highlight\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:29;a:4:{s:4:\"name\";s:14:\"video-playlist\";s:5:\"title\";s:14:\"Video Playlist\";s:4:\"icon\";s:20:\"eicon-video-playlist\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:30;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:31;a:4:{s:4:\"name\";s:13:\"stripe-button\";s:5:\"title\";s:13:\"Stripe Button\";s:4:\"icon\";s:19:\"eicon-stripe-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:32;a:4:{s:4:\"name\";s:16:\"progress-tracker\";s:5:\"title\";s:16:\"Progress Tracker\";s:4:\"icon\";s:22:\"eicon-progress-tracker\";s:10:\"categories\";s:40:\"[\"pro-elements\",\"theme-elements-single\"]\";}i:33;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:34;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:35;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:36;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:37;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:38;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:39;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:40;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:41;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:42;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:43;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:44;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:45;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:46;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:47;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:48;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:49;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:50;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:51;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:52;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:53;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:54;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:55;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:56;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:57;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:58;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:59;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:60;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:61;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:62;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:63;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:64;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:65;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:66;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:67;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:68;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:69;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:70;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:71;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:72;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:73;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:74;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:75;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:76;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:77;a:4:{s:4:\"name\";s:25:\"woocommerce-checkout-page\";s:5:\"title\";s:8:\"Checkout\";s:4:\"icon\";s:14:\"eicon-checkout\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:78;a:4:{s:4:\"name\";s:16:\"woocommerce-cart\";s:5:\"title\";s:4:\"Cart\";s:4:\"icon\";s:14:\"eicon-woo-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:79;a:4:{s:4:\"name\";s:22:\"woocommerce-my-account\";s:5:\"title\";s:10:\"My Account\";s:4:\"icon\";s:16:\"eicon-my-account\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:80;a:4:{s:4:\"name\";s:28:\"woocommerce-purchase-summary\";s:5:\"title\";s:16:\"Purchase Summary\";s:4:\"icon\";s:22:\"eicon-purchase-summary\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:81;a:4:{s:4:\"name\";s:19:\"woocommerce-notices\";s:5:\"title\";s:19:\"WooCommerce Notices\";s:4:\"icon\";s:25:\"eicon-woocommerce-notices\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.6.0\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:0:{}}}", "off");
INSERT INTO `wp_options` VALUES("17145", "can_compress_scripts", "0", "on");
INSERT INTO `wp_options` VALUES("17146", "_transient_timeout_wpseo_total_unindexed_posts", "1766907388", "off");
INSERT INTO `wp_options` VALUES("17147", "_transient_wpseo_total_unindexed_posts", "12", "off");
INSERT INTO `wp_options` VALUES("17148", "_transient_timeout_wpseo_total_unindexed_terms", "1766907388", "off");
INSERT INTO `wp_options` VALUES("17149", "_transient_wpseo_total_unindexed_terms", "0", "off");
INSERT INTO `wp_options` VALUES("17150", "_transient_timeout_wpseo_total_unindexed_post_type_archives", "1766907388", "off");
INSERT INTO `wp_options` VALUES("17151", "_transient_wpseo_total_unindexed_post_type_archives", "0", "off");
INSERT INTO `wp_options` VALUES("17152", "_transient_timeout_wpseo_total_unindexed_general_items", "1766907388", "off");
INSERT INTO `wp_options` VALUES("17153", "_transient_wpseo_total_unindexed_general_items", "0", "off");
INSERT INTO `wp_options` VALUES("17154", "_transient_timeout_wpseo_unindexed_post_link_count", "1766907388", "off");
INSERT INTO `wp_options` VALUES("17155", "_transient_wpseo_unindexed_post_link_count", "12", "off");
INSERT INTO `wp_options` VALUES("17156", "_transient_timeout_wpseo_unindexed_term_link_count", "1766907388", "off");
INSERT INTO `wp_options` VALUES("17157", "_transient_wpseo_unindexed_term_link_count", "0", "off");
INSERT INTO `wp_options` VALUES("17158", "_site_transient_timeout_browser_3c9fc7ddec9b58823c1c96756dbd45d8", "1767425790", "off");
INSERT INTO `wp_options` VALUES("17159", "_site_transient_browser_3c9fc7ddec9b58823c1c96756dbd45d8", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"142.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("9", "9", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("10", "9", "_elementor_template_type", "kit");
INSERT INTO `wp_postmeta` VALUES("59", "33", "_edit_lock", "1753757152:7");
INSERT INTO `wp_postmeta` VALUES("60", "35", "_edit_lock", "1745234587:6");
INSERT INTO `wp_postmeta` VALUES("62", "39", "_edit_lock", "1753643720:7");
INSERT INTO `wp_postmeta` VALUES("63", "41", "_edit_lock", "1763939608:7");
INSERT INTO `wp_postmeta` VALUES("64", "42", "_edit_lock", "1753519406:7");
INSERT INTO `wp_postmeta` VALUES("65", "45", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("66", "45", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("67", "45", "_menu_item_object_id", "42");
INSERT INTO `wp_postmeta` VALUES("68", "45", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("69", "45", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("70", "45", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("71", "45", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("72", "45", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("74", "46", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("75", "46", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("76", "46", "_menu_item_object_id", "41");
INSERT INTO `wp_postmeta` VALUES("77", "46", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("78", "46", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("79", "46", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("80", "46", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("81", "46", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("101", "49", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("102", "49", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("103", "49", "_menu_item_object_id", "35");
INSERT INTO `wp_postmeta` VALUES("104", "49", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("105", "49", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("106", "49", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("107", "49", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("108", "49", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("123", "52", "_edit_lock", "1745241418:6");
INSERT INTO `wp_postmeta` VALUES("126", "54", "_edit_lock", "1745241444:6");
INSERT INTO `wp_postmeta` VALUES("129", "56", "_edit_lock", "1745241393:6");
INSERT INTO `wp_postmeta` VALUES("132", "58", "_edit_lock", "1745241357:6");
INSERT INTO `wp_postmeta` VALUES("135", "60", "_edit_lock", "1745241159:6");
INSERT INTO `wp_postmeta` VALUES("142", "64", "_edit_lock", "1755279108:7");
INSERT INTO `wp_postmeta` VALUES("161", "54", "_thumbnail_id", "4359");
INSERT INTO `wp_postmeta` VALUES("164", "52", "_thumbnail_id", "4363");
INSERT INTO `wp_postmeta` VALUES("167", "56", "_thumbnail_id", "4360");
INSERT INTO `wp_postmeta` VALUES("173", "60", "_thumbnail_id", "4361");
INSERT INTO `wp_postmeta` VALUES("174", "60", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("181", "35", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("182", "35", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("183", "33", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("184", "33", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("185", "41", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("186", "41", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("189", "42", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("190", "42", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("191", "39", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("192", "39", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("194", "76", "_elementor_source", "post");
INSERT INTO `wp_postmeta` VALUES("195", "76", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("196", "76", "_elementor_template_type", "header");
INSERT INTO `wp_postmeta` VALUES("197", "76", "_elementor_version", "3.18.1");
INSERT INTO `wp_postmeta` VALUES("198", "76", "_elementor_pro_version", "3.18.0");
INSERT INTO `wp_postmeta` VALUES("199", "76", "_edit_lock", "1752400156:4");
INSERT INTO `wp_postmeta` VALUES("200", "9", "_edit_lock", "1745240275:4");
INSERT INTO `wp_postmeta` VALUES("212", "9", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("213", "9", "_elementor_page_settings", "a:69:{s:32:\"colors_enable_styleguide_preview\";s:3:\"yes\";s:13:\"system_colors\";a:4:{i:0;a:3:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"اولیه\";s:5:\"color\";s:7:\"#007B8A\";}i:1;a:3:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:22:\"رنگ عنوان ها\";s:5:\"color\";s:7:\"#00A8BD\";}i:2;a:3:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:6:\"متن\";s:5:\"color\";s:7:\"#333333\";}i:3;a:3:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"شدت\";s:5:\"color\";s:7:\"#FFE9AD\";}}s:13:\"custom_colors\";a:1:{i:0;a:3:{s:3:\"_id\";s:7:\"e111679\";s:5:\"title\";s:20:\"آیتم جدید #1\";s:5:\"color\";s:7:\"#181B31\";}}s:36:\"typography_enable_styleguide_preview\";s:3:\"yes\";s:17:\"system_typography\";a:4:{i:0;a:7:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:19:\"عنوان اصلی\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:16:\"IRANSansWeb_Bold\";s:22:\"typography_font_weight\";s:3:\"700\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:32;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:3:\"rem\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}}i:1;a:7:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:17:\"عنوان دوم\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:18:\"IRANSansWeb_Medium\";s:22:\"typography_font_weight\";s:3:\"700\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:3:\"rem\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}}i:2;a:7:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:6:\"متن\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:9:\"Vazirmatn\";s:22:\"typography_font_weight\";s:3:\"400\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:3:\"rem\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}}i:3;a:6:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"شدت\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:25:\"iranyekanwebregular_FaNum\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}}}s:17:\"custom_typography\";a:0:{}s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:9:\"site_name\";s:14:\"CRM تابان\";s:15:\"container_width\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:1300;s:5:\"sizes\";a:0:{}}s:19:\"page_title_selector\";s:14:\"h1.entry-title\";s:27:\"hello_footer_copyright_text\";s:41:\"کلیه‌ی حقوق محفوظ است.\";s:15:\"activeItemIndex\";i:1;s:11:\"viewport_md\";i:768;s:11:\"viewport_lg\";i:1025;s:26:\"body_background_background\";s:7:\"classic\";s:21:\"body_background_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:4:\"size\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:6:\"source\";s:7:\"library\";}s:24:\"body_background_position\";s:13:\"bottom center\";s:20:\"body_background_xpos\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:-127;s:5:\"sizes\";a:0:{}}s:20:\"body_background_ypos\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:142;s:5:\"sizes\";a:0:{}}s:22:\"body_background_repeat\";s:9:\"no-repeat\";s:20:\"body_background_size\";s:5:\"cover\";s:21:\"body_background_color\";s:7:\"#FAFAFA\";s:17:\"container_padding\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"0\";s:5:\"right\";s:2:\"10\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:2:\"10\";s:8:\"isLinked\";b:0;}s:24:\"container_padding_tablet\";a:6:{s:4:\"unit\";s:3:\"rem\";s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:0;}s:24:\"container_padding_mobile\";a:6:{s:4:\"unit\";s:3:\"rem\";s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:0;}s:11:\"__globals__\";a:14:{s:10:\"body_color\";s:0:\"\";s:26:\"body_typography_typography\";s:26:\"globals/typography?id=text\";s:8:\"h1_color\";s:0:\"\";s:8:\"h2_color\";s:0:\"\";s:24:\"h1_typography_typography\";s:29:\"globals/typography?id=primary\";s:24:\"h2_typography_typography\";s:29:\"globals/typography?id=primary\";s:8:\"h3_color\";s:0:\"\";s:8:\"h4_color\";s:25:\"globals/colors?id=e111679\";s:8:\"h5_color\";s:25:\"globals/colors?id=e111679\";s:8:\"h6_color\";s:25:\"globals/colors?id=e111679\";s:24:\"h3_typography_typography\";s:31:\"globals/typography?id=secondary\";s:24:\"h4_typography_typography\";s:0:\"\";s:24:\"h5_typography_typography\";s:0:\"\";s:24:\"h6_typography_typography\";s:0:\"\";}s:10:\"body_color\";s:7:\"#333333\";s:26:\"body_typography_typography\";s:6:\"custom\";s:27:\"body_typography_font_family\";s:25:\"iranyekanwebregular_FaNum\";s:25:\"body_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:27:\"body_typography_font_weight\";s:3:\"400\";s:27:\"body_typography_line_height\";a:3:{s:4:\"unit\";s:3:\"rem\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:8:\"h1_color\";s:7:\"#333333\";s:24:\"h1_typography_typography\";s:6:\"custom\";s:25:\"h1_typography_font_family\";s:14:\"YekanBakhFaNum\";s:23:\"h1_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:32;s:5:\"sizes\";a:0:{}}s:25:\"h1_typography_font_weight\";s:3:\"700\";s:25:\"h1_typography_line_height\";a:3:{s:4:\"unit\";s:3:\"rem\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:8:\"h2_color\";s:7:\"#333333\";s:24:\"h2_typography_typography\";s:6:\"custom\";s:25:\"h2_typography_font_family\";s:14:\"YekanBakhFaNum\";s:23:\"h2_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:32;s:5:\"sizes\";a:0:{}}s:25:\"h2_typography_font_weight\";s:3:\"700\";s:25:\"h2_typography_line_height\";a:3:{s:4:\"unit\";s:3:\"rem\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:8:\"h3_color\";s:7:\"#181B31\";s:24:\"h3_typography_typography\";s:6:\"custom\";s:25:\"h3_typography_font_family\";s:14:\"YekanBakhFaNum\";s:23:\"h3_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}s:25:\"h3_typography_font_weight\";s:3:\"700\";s:25:\"h3_typography_line_height\";a:3:{s:4:\"unit\";s:3:\"rem\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:8:\"h4_color\";s:7:\"#181B31\";s:24:\"h4_typography_typography\";s:6:\"custom\";s:25:\"h4_typography_font_family\";s:14:\"YekanBakhFaNum\";s:23:\"h4_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:22;s:5:\"sizes\";a:0:{}}s:25:\"h4_typography_font_weight\";s:3:\"700\";s:25:\"h4_typography_line_height\";a:3:{s:4:\"unit\";s:3:\"rem\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:8:\"h5_color\";s:7:\"#181B31\";s:24:\"h5_typography_typography\";s:6:\"custom\";s:25:\"h5_typography_font_family\";s:14:\"YekanBakhFaNum\";s:23:\"h5_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:25:\"h5_typography_font_weight\";s:3:\"700\";s:25:\"h5_typography_line_height\";a:3:{s:4:\"unit\";s:3:\"rem\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:8:\"h6_color\";s:7:\"#181B31\";s:24:\"h6_typography_typography\";s:6:\"custom\";s:25:\"h6_typography_font_family\";s:14:\"YekanBakhFaNum\";s:23:\"h6_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:25:\"h6_typography_font_weight\";s:3:\"700\";s:25:\"h6_typography_line_height\";a:3:{s:4:\"unit\";s:3:\"rem\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:16:\"site_description\";s:57:\"روشن برای رشد، دقیق برای پیگیری\";}");
INSERT INTO `wp_postmeta` VALUES("214", "9", "_rankmath__data", "[]");
INSERT INTO `wp_postmeta` VALUES("220", "9", "_elementor_page_assets", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("221", "9", "_elementor_version", "3.18.1");
INSERT INTO `wp_postmeta` VALUES("222", "9", "_elementor_pro_version", "3.18.0");
INSERT INTO `wp_postmeta` VALUES("231", "76", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("232", "76", "_rankmath__data", "[{\"id\":\"1f28b73\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"column\":\"0\",\"row\":\"0\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"boxed_width\":{\"unit\":\"px\",\"size\":1300,\"sizes\":[]},\"margin\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"6b4d893\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":false},\"border_color\":\"#E1E1E1\",\"border_radius\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"15\",\"isLinked\":false},\"padding\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"1\",\"left\":\"0\",\"isLinked\":false},\"flex_justify_content\":\"center\",\"flex_align_items\":\"center\",\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0.5\",\"right\":\"0\",\"bottom\":\"0.5\",\"left\":\"0\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"0.7\",\"right\":\"1\",\"bottom\":\"0.7\",\"left\":\"1\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#FFFFFF\",\"box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":2,\"blur\":10,\"spread\":0,\"color\":\"rgba(0, 0, 0, 0.05)\"},\"box_shadow_box_shadow_type\":\"yes\",\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"boxed_width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"boxed_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_gap_tablet\":{\"column\":\"10\",\"row\":\"0\",\"isLinked\":false,\"unit\":\"px\",\"size\":10},\"flex_gap_mobile\":{\"column\":\"0\",\"row\":\"0\",\"isLinked\":false,\"unit\":\"px\",\"size\":0}},\"elements\":[{\"id\":\"a37e150\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":15,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"width_tablet\":{\"unit\":\"%\",\"size\":17,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":20,\"sizes\":[]},\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_align_items_mobile\":\"flex-start\",\"flex_gap_mobile\":{\"column\":\"0\",\"row\":\"0\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"hide_desktop\":\"hidden-desktop\",\"hide_tablet\":\"hidden-tablet\"},\"elements\":[{\"id\":\"347facf\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-bars\",\"library\":\"fa-solid\"},\"size_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_margin_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-4\",\"left\":\"0\",\"isLinked\":false},\"_padding_mobile\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"__dynamic__\":{\"link\":\"[elementor-tag id=\\\"df667af\\\" name=\\\"popup\\\" settings=\\\"%7B%22popup%22%3A%224018%22%7D\\\"]\"},\"__globals__\":{\"primary_color\":\"globals\\/colors?id=primary\"}},\"elements\":[],\"widgetType\":\"icon\"}],\"isInner\":true},{\"id\":\"b35bf40\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":15,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"width_tablet\":{\"unit\":\"%\",\"size\":19,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":60,\"sizes\":[]}},\"elements\":[{\"id\":\"08e4304\",\"elType\":\"widget\",\"settings\":{\"image_size\":\"full\",\"image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/taban-logo.png\",\"id\":4625,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"link_to\":\"custom\",\"link\":{\"url\":\"http:\\/\\/tabancrm.ir\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":true},{\"id\":\"e5d9bfa\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":15,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"width_tablet\":{\"unit\":\"%\",\"size\":17,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":20,\"sizes\":[]},\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_align_items_mobile\":\"flex-end\",\"hide_desktop\":\"hidden-desktop\",\"hide_tablet\":\"hidden-tablet\"},\"elements\":[{\"id\":\"6f337e4\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-phone\",\"library\":\"fa-solid\"},\"view\":\"stacked\",\"link\":{\"url\":\"http:\\/\\/tabancrm.ir\\/contact-us\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"size_mobile\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"0.5\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"icon\"}],\"isInner\":true},{\"id\":\"38cd006\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":45,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"flex_align_items\":\"center\",\"flex_direction\":\"row\",\"width_tablet\":{\"unit\":\"%\",\"size\":60,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"hide_mobile\":\"hidden-mobile\"},\"elements\":[{\"id\":\"42aadfc\",\"elType\":\"widget\",\"settings\":{\"menu\":\"main-menu\",\"__globals__\":{\"menu_typography_typography\":\"\",\"color_menu_item\":\"globals\\/colors?id=secondary\",\"color_menu_item_active\":\"globals\\/colors?id=primary\",\"color_menu_item_hover\":\"globals\\/colors?id=primary\"},\"menu_typography_typography\":\"custom\",\"menu_typography_font_family\":\"iranyekanwebregular_FaNum\",\"menu_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"menu_typography_font_weight\":\"600\",\"pointer\":\"none\",\"color_menu_item_active\":\"#FF5538\",\"menu_typography_line_height\":{\"unit\":\"rem\",\"size\":1.8000000000000000444089209850062616169452667236328125,\"sizes\":[]},\"color_menu_item_hover\":\"#FF5538\",\"dropdown\":\"none\",\"toggle_icon_normal\":{\"value\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/dashboard_4942694.svg\",\"id\":2513},\"library\":\"svg\"},\"menu_typography_font_size_tablet\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"padding_horizontal_menu_item_tablet\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"nav-menu\"}],\"isInner\":true},{\"id\":\"3029fd5\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":35,\"sizes\":[]},\"flex_direction\":\"row\",\"flex_justify_content\":\"flex-end\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"flex_align_items\":\"center\",\"flex_gap\":{\"column\":\"40\",\"row\":\"0\",\"isLinked\":false,\"unit\":\"px\",\"size\":40},\"width_tablet\":{\"unit\":\"%\",\"size\":15,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_gap_tablet\":{\"column\":\"0\",\"row\":\"0\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"hide_mobile\":\"hidden-mobile\"},\"elements\":[{\"id\":\"e462d65\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-phone\",\"library\":\"fa-solid\"},\"view\":\"stacked\",\"title_text\":\"\\u062a\\u0644\\u0641\\u0646 \\u062a\\u0645\\u0627\\u0633 :\",\"description_text\":\"1234567 - 021\",\"position\":\"right\",\"content_vertical_alignment\":\"middle\",\"text_align\":\"right\",\"hover_secondary_color\":\"#FFFFFF\",\"icon_space\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"icon_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"title_bottom_space\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"title_color\":\"#181B31\",\"title_typography_typography\":\"custom\",\"title_typography_font_family\":\"YekanBakhFaNum\",\"title_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"title_typography_font_weight\":\"600\",\"title_typography_line_height\":{\"unit\":\"rem\",\"size\":0.8000000000000000444089209850062616169452667236328125,\"sizes\":[]},\"description_typography_typography\":\"custom\",\"description_typography_font_family\":\"iranyekanwebregular_FaNum\",\"description_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"description_typography_font_weight\":\"400\",\"description_typography_line_height\":{\"unit\":\"rem\",\"size\":1.8000000000000000444089209850062616169452667236328125,\"sizes\":[]},\"__globals__\":{\"title_color\":\"globals\\/colors?id=e111679\",\"description_typography_typography\":\"\"},\"hide_tablet\":\"hidden-tablet\"},\"elements\":[],\"widgetType\":\"icon-box\"},{\"id\":\"3b98313\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u062f\\u0645\\u0648\\u06cc CRM\",\"link\":{\"url\":\"https:\\/\\/digitalrev.ir\\/crm\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"2\",\"right\":\"2\",\"bottom\":\"2\",\"left\":\"2\",\"isLinked\":true},\"border_color\":\"#02010100\",\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"button_box_shadow_box_shadow_type\":\"yes\",\"button_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":10,\"blur\":30,\"spread\":0,\"color\":\"rgba(248, 84.99999999999999, 78, 0.15)\"},\"text_padding\":{\"unit\":\"px\",\"top\":\"9\",\"right\":\"20\",\"bottom\":\"9\",\"left\":\"20\",\"isLinked\":false},\"_offset_x\":{\"unit\":\"px\",\"size\":74,\"sizes\":[]},\"_offset_y\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"\",\"hover_color\":\"globals\\/colors?id=primary\",\"button_background_hover_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=primary\"},\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhFaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_font_weight\":\"600\",\"background_color\":\"#FF5538\",\"hover_color\":\"#FF5538\",\"button_background_hover_color\":\"#FFEAE6\",\"button_hover_border_color\":\"#FF5538\",\"text_padding_tablet\":{\"unit\":\"px\",\"top\":\"5\",\"right\":\"10\",\"bottom\":\"5\",\"left\":\"10\",\"isLinked\":false},\"_flex_order_tablet\":\"start\",\"icon_indent\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"button\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("233", "76", "_elementor_page_assets", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("251", "76", "_elementor_conditions", "a:1:{i:0;s:15:\"include/general\";}");
INSERT INTO `wp_postmeta` VALUES("454", "33", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("455", "33", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("456", "33", "_elementor_version", "3.18.1");
INSERT INTO `wp_postmeta` VALUES("457", "33", "_elementor_pro_version", "3.18.0");
INSERT INTO `wp_postmeta` VALUES("479", "33", "_elementor_page_settings", "a:6:{s:10:\"hide_title\";s:3:\"yes\";s:21:\"background_background\";s:7:\"classic\";s:16:\"background_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:4:\"size\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:6:\"source\";s:7:\"library\";}s:17:\"background_repeat\";s:9:\"no-repeat\";s:15:\"background_size\";s:5:\"cover\";s:19:\"background_position\";s:13:\"bottom center\";}");
INSERT INTO `wp_postmeta` VALUES("480", "33", "_rankmath__data", "[{\"id\":\"572563f\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"margin\":{\"unit\":\"rem\",\"top\":\"2\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"ea3cbdf\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_justify_content\":\"flex-start\",\"background_background\":\"classic\",\"background_image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/svgexport-10.svg\",\"id\":138,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"initial\",\"background_ypos\":{\"unit\":\"px\",\"size\":320,\"sizes\":[]},\"background_repeat\":\"no-repeat\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding\":{\"unit\":\"rem\",\"top\":\"3\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"flex_gap_tablet\":{\"column\":\"0\",\"row\":\"8\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"background_position_tablet\":\"bottom left\",\"background_ypos_tablet\":{\"unit\":\"px\",\"size\":371,\"sizes\":[]},\"background_size_tablet\":\"initial\",\"background_bg_width_tablet\":{\"unit\":\"px\",\"size\":80,\"sizes\":[]},\"background_position_mobile\":\"initial\",\"background_ypos_mobile\":{\"unit\":\"px\",\"size\":294,\"sizes\":[]}},\"elements\":[{\"id\":\"25aaacf\",\"elType\":\"widget\",\"settings\":{\"title\":\" CRM \\u062a\\u0627\\u0628\\u0627\\u0646\",\"header_size\":\"p\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_family\":\"iranyekanwebregular_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_padding\":{\"unit\":\"rem\",\"top\":\"0.5\",\"right\":\"0.8\",\"bottom\":\"0.5\",\"left\":\"0.8\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"rem\",\"top\":\"0.3\",\"right\":\"0.6\",\"bottom\":\"0.3\",\"left\":\"0.6\",\"isLinked\":false},\"_padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":24.048999999999999},\"_background_background\":\"classic\",\"_background_color\":\"#F3EBD6\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"50\",\"right\":\"50\",\"bottom\":\"50\",\"left\":\"50\",\"isLinked\":true},\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\"},\"typography_line_height\":{\"unit\":\"rem\",\"size\":1,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"px\",\"size\":89,\"sizes\":[]},\"_flex_size\":\"none\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"9dc1538\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0631\\u0627\\u0647\\u200c\\u062d\\u0644 \\u06cc\\u06a9\\u067e\\u0627\\u0631\\u0686\\u0647 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0631\\u062a\\u0628\\u0627\\u0637 \\u0628\\u0627 \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646 \\u0628\\u0631\\u0627\\u06cc  <span>\\u062f\\u0641\\u0627\\u062a\\u0631 \\u067e\\u06cc\\u0634\\u062e\\u0648\\u0627\\u0646 \\u0648 \\u06a9\\u0633\\u0628\\u200c\\u0648\\u06a9\\u0627\\u0631\\u0647\\u0627\\u06cc \\u062e\\u062f\\u0645\\u0627\\u062a\\u06cc<\\/span>\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=secondary\",\"typography_typography\":\"\"},\"custom_css\":\"selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #F3EBD6;\\n    height: 10px;\\n    width: 165px;\\n    position: absolute;\\n    top: 0.9em;\\n    z-index: -1;\\n}\\n@media only screen and (max-width: 1242px){\\n    selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #F3EBD6;\\n    height: 8px;\\n    width: 127px;\\n    position: absolute;\\n    top: 3.9rem;\\n    right: 0;\\n    z-index: -1;\\n    }\\n}\\n@media only screen and (max-width: 767px){\\n    selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #FFB99E80;\\n    height: 8px;\\n    width: 102px;\\n    position: absolute;\\n    top: 3em;\\n    right: 0;\\n    z-index: -1;\\n    }\\n}\\n\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":79.468999999999994},\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhFaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":32,\"sizes\":[]},\"typography_font_weight\":\"700\",\"typography_line_height\":{\"unit\":\"rem\",\"size\":3,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":98,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":91,\"sizes\":[]},\"align\":\"right\",\"title_color\":\"#1A3760\",\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":2.3999999999999999,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_flex_size\":\"none\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"cb66769\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p class=\\\"ds-markdown-paragraph\\\"><strong>CRM \\u062a\\u0627\\u0628\\u0627\\u0646<\\/strong> \\u0627\\u0648\\u0644\\u06cc\\u0646 \\u0633\\u06cc\\u0633\\u062a\\u0645 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0631\\u062a\\u0628\\u0627\\u0637 \\u0628\\u0627 \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646 <strong>\\u0645\\u062e\\u0635\\u0648\\u0635 \\u062f\\u0641\\u0627\\u062a\\u0631 \\u067e\\u06cc\\u0634\\u062e\\u0648\\u0627\\u0646 \\u0648 \\u06a9\\u0633\\u0628\\u200c\\u0648\\u06a9\\u0627\\u0631\\u0647\\u0627\\u06cc \\u062e\\u062f\\u0645\\u0627\\u062a\\u06cc<\\/strong> \\u0627\\u0633\\u062a \\u06a9\\u0647 \\u0628\\u0647 \\u0634\\u0645\\u0627 \\u06a9\\u0645\\u06a9 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f \\u0641\\u0631\\u0622\\u06cc\\u0646\\u062f\\u0647\\u0627\\u06cc \\u062f\\u0627\\u062e\\u0644\\u06cc \\u0631\\u0627 <strong>\\u0628\\u062f\\u0648\\u0646 \\u062f\\u0631\\u062f\\u0633\\u0631<\\/strong> \\u062f\\u06cc\\u062c\\u06cc\\u062a\\u0627\\u0644\\u06cc \\u06a9\\u0646\\u06cc\\u062f\\u060c \\u0627\\u0631\\u062a\\u0628\\u0627\\u0637 \\u0634\\u0641\\u0627\\u0641\\u200c\\u062a\\u0631\\u06cc \\u0628\\u0627 \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646 \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u06cc\\u062f \\u0648 \\u062f\\u0631 \\u0632\\u0645\\u0627\\u0646 \\u0648 \\u0647\\u0632\\u06cc\\u0646\\u0647\\u200c\\u0647\\u0627\\u06cc \\u062e\\u0648\\u062f <strong>\\u062a\\u0627 \\u06f5\\u06f0% \\u0635\\u0631\\u0641\\u0647\\u200c\\u062c\\u0648\\u06cc\\u06cc<\\/strong> \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"align\":\"right\",\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"__globals__\":{\"typography_typography\":\"\"},\"typography_typography\":\"custom\",\"typography_font_family\":\"iranyekanwebregular_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_font_weight\":\"400\",\"typography_line_height\":{\"unit\":\"rem\",\"size\":1.8,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"6f76066\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"flex_gap_mobile\":{\"column\":\"8\",\"row\":\"8\",\"isLinked\":true,\"unit\":\"px\",\"size\":8},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"8\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"dac3cb1\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0628\\u06cc\\u0634\\u062a\\u0631 \\u0628\\u062e\\u0648\\u0627\\u0646\\u06cc\\u062f\",\"link\":{\"url\":\"http:\\/\\/tabancrm.ir\\/about-us\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"button_box_shadow_box_shadow_type\":\"yes\",\"button_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":10,\"blur\":30,\"spread\":0,\"color\":\"rgba(248, 84.99999999999999, 78, 0.15)\"},\"__globals__\":{\"background_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"\",\"hover_color\":\"globals\\/colors?id=primary\",\"button_background_hover_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=primary\",\"border_color\":\"globals\\/colors?id=primary\"},\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"typography_typography\":\"custom\",\"typography_font_family\":\"iranyekanwebregular_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"background_color\":\"#FF5538\"},\"elements\":[],\"widgetType\":\"button\"},{\"id\":\"5f7dda5\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0627\\u0645\\u06a9\\u0627\\u0646\\u0627\\u062a\",\"link\":{\"url\":\"http:\\/\\/tabancrm.ir\\/our-services\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"button_box_shadow_box_shadow_type\":\"yes\",\"button_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":10,\"blur\":30,\"spread\":0,\"color\":\"rgba(248, 84.99999999999999, 78, 0.15)\"},\"__globals__\":{\"background_color\":\"globals\\/colors?id=accent\",\"typography_typography\":\"\",\"border_color\":\"globals\\/colors?id=primary\",\"button_text_color\":\"globals\\/colors?id=primary\",\"button_background_hover_color\":\"globals\\/colors?id=primary\",\"button_hover_border_color\":\"globals\\/colors?id=primary\",\"hover_color\":\"\"},\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"typography_typography\":\"custom\",\"typography_font_family\":\"iranyekanwebregular_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"typography_font_weight\":\"600\",\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"border_color\":\"#FF5538\",\"hover_color\":\"#FFFFFF\",\"button_hover_border_color\":\"#FF5538\",\"button_text_color\":\"#FF5538\",\"background_color\":\"#FFEAE6\",\"button_background_hover_color\":\"#FF5538\",\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"button\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"dd8c7ee\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"flex_justify_content_tablet\":\"center\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"52e116f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2025\\/04\\/main3.png\",\"id\":4637,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"width\":{\"unit\":\"%\",\"size\":90,\"sizes\":[]},\"image_border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"150\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"3ee1a6a\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/11\\/1.png\",\"id\":2296,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"image_border_radius\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"15\",\"bottom\":\"15\",\"left\":\"15\",\"isLinked\":true},\"image_box_shadow_box_shadow_type\":\"yes\",\"image_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":10,\"spread\":4,\"color\":\"rgba(0, 0, 0, 0.09)\"},\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":29,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_orientation_v\":\"end\",\"motion_fx_motion_fx_scrolling\":\"yes\",\"motion_fx_translateX_effect\":\"yes\",\"motion_fx_translateX_speed\":{\"unit\":\"px\",\"size\":0.59999999999999998,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":35,\"sizes\":[]},\"_offset_y_end_tablet\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"motion_fx_devices\":[\"desktop\"],\"_offset_y_end_mobile\":{\"unit\":\"px\",\"size\":-22,\"sizes\":[]},\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":44,\"sizes\":[]},\"_offset_x_end\":{\"size\":-7.4000000000000004,\"unit\":\"px\"},\"_offset_y_end\":{\"size\":-17,\"unit\":\"px\"},\"_element_width_mobile\":\"initial\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"8d2dd39\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"margin\":{\"unit\":\"rem\",\"top\":\"3\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"flex_gap\":{\"column\":\"0\",\"row\":\"20\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"flex_gap_tablet\":{\"column\":\"15\",\"row\":\"15\",\"isLinked\":true,\"unit\":\"px\",\"size\":15}},\"elements\":[{\"id\":\"4f77c84\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0628\\u06cc\\u0634 \\u0627\\u0632 10000 \\u0634\\u0631\\u06a9\\u062a \\u0628\\u0647 \\u0645\\u0627 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u06a9\\u0631\\u062f\\u0646\\u062f!\\n\",\"header_size\":\"span\",\"align\":\"center\",\"title_color\":\"#336AEA\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhFaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"typography_font_weight\":\"700\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=e111679\",\"typography_typography\":\"\"},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"em\",\"size\":0.10000000000000001,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"31be470\",\"elType\":\"widget\",\"settings\":{\"carousel\":[{\"id\":139,\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/svgexport-11.svg\"},{\"id\":140,\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/svgexport-12.svg\"},{\"id\":141,\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/svgexport-13.svg\"},{\"id\":142,\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/svgexport-14.svg\"},{\"id\":143,\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/svgexport-15.svg\"},{\"id\":144,\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/svgexport-16.svg\"}],\"thumbnail_size\":\"full\",\"slides_to_show\":\"5\",\"slides_to_show_tablet\":\"4\",\"slides_to_show_mobile\":\"2\",\"navigation\":\"arrows\",\"arrows_position\":\"outside\",\"arrows_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"gallery_vertical_align\":\"center\",\"gallery_vertical_align_mobile\":\"center\",\"image_spacing\":\"custom\",\"image_spacing_custom_tablet\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"image_spacing_custom_mobile\":{\"unit\":\"px\",\"size\":24,\"sizes\":[]},\"_padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"__globals__\":{\"arrows_color\":\"globals\\/colors?id=primary\"},\"image_spacing_custom\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"custom_css\":\"selector img.swiper-slide-image:hover {\\r\\n    scale: 1.1;\\r\\n    transition: 0.4s;\\r\\n    z-index:20;\\r\\n}\\r\\nselector img.swiper-slide-image:not(:hover) {\\r\\n    transition: 0.4s;\\r\\n}\"},\"elements\":[],\"widgetType\":\"image-carousel\"}],\"isInner\":false},{\"id\":\"a16f8c4\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"margin\":{\"unit\":\"rem\",\"top\":\"5\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"flex_justify_content\":\"flex-end\",\"flex_gap\":{\"column\":\"0\",\"row\":\"0\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"flex_align_items\":\"center\",\"flex_direction_tablet\":\"column\",\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"flex_gap_tablet\":{\"column\":\"0\",\"row\":\"10\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"flex_gap_mobile\":{\"column\":\"5\",\"row\":\"5\",\"isLinked\":true,\"unit\":\"px\",\"size\":5}},\"elements\":[{\"id\":\"afaf1d1\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0628\\u0627 \\u0631\\u0627\\u0647\\u06a9\\u0627\\u0631\\u0647\\u0627\\u06cc \\u0647\\u0648\\u0634\\u0645\\u0646\\u062f \\u0645\\u0627\\u060c \\u062a\\u062c\\u0631\\u0628\\u0647 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646 \\u0631\\u0627 \\u0645\\u062a\\u062d\\u0648\\u0644 \\u06a9\\u0646\\u06cc\\u062f!\",\"header_size\":\"p\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_family\":\"DanaFaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_padding\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_element_custom_width\":{\"unit\":\"%\",\"size\":7,\"sizes\":[]},\"_background_background\":\"classic\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"50\",\"right\":\"50\",\"bottom\":\"50\",\"left\":\"50\",\"isLinked\":true},\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\"},\"_margin\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"1\",\"left\":\"0\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"em\",\"size\":1,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"58cef40\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u062e\\u062f\\u0645\\u0627\\u062a \\u062a\\u062e\\u0635\\u0635\\u06cc CRM \\u062a\\u0627\\u0628\\u0627\\u0646 <br> \\u0631\\u0627\\u0647\\u06a9\\u0627\\u0631\\u0647\\u0627\\u06cc \\u06cc\\u06a9\\u067e\\u0627\\u0631\\u0686\\u0647 \\u0628\\u0631\\u0627\\u06cc \\u0633\\u0627\\u062f\\u0647\\u200c\\u0633\\u0627\\u0632\\u06cc\\u060c \\u0628\\u0647\\u06cc\\u0646\\u0647\\u200c\\u0633\\u0627\\u0632\\u06cc \\u0648 \\u0631\\u0634\\u062f \\u06a9\\u0633\\u0628\\u200c\\u0648\\u06a9\\u0627\\u0631 \\u0634\\u0645\\u0627\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=secondary\",\"typography_typography\":\"\"},\"align\":\"center\",\"title_color\":\"#1A3760\",\"_margin\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"01.5\",\"left\":\"0\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":51,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhFaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":32,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"typography_font_weight\":\"700\",\"typography_line_height\":{\"unit\":\"rem\",\"size\":3,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":64,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":2.3999999999999999,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":2.3999999999999999,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"1324878\",\"elType\":\"widget\",\"settings\":{\"lisitng_id\":\"526\",\"columns\":\"4\",\"not_found_message\":\"\\u0647\\u06cc\\u0686 \\u062f\\u0627\\u062f\\u0647 \\u0627\\u06cc \\u06cc\\u0627\\u0641\\u062a \\u0646\\u0634\\u062f\",\"posts_query\":[],\"terms_meta_query\":[],\"users_meta_query\":[],\"carousel_enabled\":\"yes\",\"horizontal_gap\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"vertical_gap\":{\"unit\":\"px\",\"size\":70,\"sizes\":[]},\"arrows_box_size\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"prev_top_position\":{\"unit\":\"%\",\"size\":99,\"sizes\":[]},\"prev_hor_position\":\"right\",\"prev_left_position\":{\"unit\":\"px\",\"size\":400,\"sizes\":[]},\"prev_right_position\":{\"unit\":\"%\",\"size\":4,\"sizes\":[]},\"next_top_position\":{\"unit\":\"%\",\"size\":99,\"sizes\":[]},\"next_left_position\":{\"unit\":\"px\",\"size\":400,\"sizes\":[]},\"custom_css\":\"selector .jet-listing-grid__slider-icon.prev-arrow{\\n    border-radius: 20px;\\n}\\nselector .jet-listing-grid__slider-icon.next-arrow{\\n  border-radius: 20px;  \\n}\",\"__globals__\":{\"arrow_bg_color\":\"globals\\/colors?id=primary\",\"arrow_bg_color_hover\":\"globals\\/colors?id=secondary\"},\"prev_top_position_tablet\":{\"unit\":\"%\",\"size\":99,\"sizes\":[]},\"prev_top_position_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"prev_right_position_tablet\":{\"unit\":\"%\",\"size\":7,\"sizes\":[]},\"prev_right_position_mobile\":{\"unit\":\"%\",\"size\":17,\"sizes\":[]},\"next_top_position_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"next_top_position_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"next_right_position\":{\"unit\":\"%\",\"size\":1,\"sizes\":[]},\"next_right_position_tablet\":{\"unit\":\"%\",\"size\":3,\"sizes\":[]},\"next_right_position_mobile\":{\"unit\":\"%\",\"size\":7,\"sizes\":[]},\"columns_tablet\":\"2\",\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"horizontal_gap_tablet\":{\"unit\":\"px\",\"size\":38,\"sizes\":[]},\"arrows_box_size_tablet\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"_padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"_padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"columns_mobile\":\"1\",\"vertical_gap_mobile\":{\"unit\":\"px\",\"size\":35,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"jet-listing-grid\"}],\"isInner\":false},{\"id\":\"f78d145\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"margin\":{\"unit\":\"rem\",\"top\":\"7\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"5\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"flex_gap\":{\"column\":\"40\",\"row\":\"0\",\"isLinked\":false,\"unit\":\"px\",\"size\":40},\"flex_gap_mobile\":{\"column\":\"0\",\"row\":\"50\",\"isLinked\":false,\"unit\":\"px\",\"size\":0}},\"elements\":[{\"id\":\"0c579be\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_justify_content\":\"center\",\"background_background\":\"classic\",\"background_image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"initial\",\"background_ypos\":{\"unit\":\"px\",\"size\":320,\"sizes\":[]},\"background_repeat\":\"no-repeat\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding\":{\"unit\":\"rem\",\"top\":\"3\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"7\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"width\":{\"unit\":\"%\",\"size\":55,\"sizes\":[]},\"flex_gap_tablet\":{\"column\":\"0\",\"row\":\"8\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]}},\"elements\":[{\"id\":\"53b86f5\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u062a\\u062c\\u0631\\u0628\\u06cc\\u0627\\u062a \\u0645\\u0627\",\"header_size\":\"h6\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_family\":\"iranyekanwebregular_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_padding\":{\"unit\":\"rem\",\"top\":\"0.5\",\"right\":\"0.8\",\"bottom\":\"0.5\",\"left\":\"0.8\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"rem\",\"top\":\"0.3\",\"right\":\"0.6\",\"bottom\":\"0.3\",\"left\":\"0.6\",\"isLinked\":false},\"_padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_element_custom_width\":{\"unit\":\"%\",\"size\":19,\"sizes\":[]},\"_background_background\":\"classic\",\"_background_color\":\"#FFEAE6\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"50\",\"right\":\"50\",\"bottom\":\"50\",\"left\":\"50\",\"isLinked\":true},\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\"},\"typography_line_height\":{\"unit\":\"rem\",\"size\":1,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"px\",\"size\":89,\"sizes\":[]},\"_flex_align_self\":\"flex-start\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"805cdbb\",\"elType\":\"widget\",\"settings\":{\"title\":\" <span> \\u062f\\u0627\\u0646\\u0634 \\u0641\\u0646\\u06cc \\u0648 \\u062a\\u062c\\u0631\\u0628\\u0647\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0627 \\u062f\\u0631 \\u0637\\u0631\\u0627\\u062d\\u06cc \\u0631\\u0627\\u0647\\u06a9\\u0627\\u0631\\u0647\\u0627\\u06cc \\u0627\\u062e\\u062a\\u0635\\u0627\\u0635\\u06cc CRM \\u0628\\u0631\\u0627\\u06cc \\u062f\\u0641\\u0627\\u062a\\u0631 \\u067e\\u06cc\\u0634\\u062e\\u0648\\u0627\\u0646 <\\/span>\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=secondary\",\"typography_typography\":\"\"},\"title_color\":\"#1A3760\",\"custom_css\":\"selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #FFB99E80;\\n    height: 10px;\\n    width: 230px;\\n    position: absolute;\\n    top: 0.9em;\\n    z-index: -1;\\n}\\n@media only screen and (max-width: 1242px){\\n    selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #FFB99E80;\\n    height: 8px;\\n    width: 185px;\\n    position: absolute;\\n    top: 1em;\\n    left: 3em;\\n    z-index: -1;\\n    }\\n}\\n@media only screen and (max-width: 767px){\\n    selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #FFB99E80;\\n    height: 8px;\\n    width: 150px;\\n    position: absolute;\\n    top: 1.2em;\\n    left: 1rem;\\n    z-index: -1;\\n    }\\n}\\n\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":95,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhFaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":32,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"typography_font_weight\":\"700\",\"typography_line_height\":{\"unit\":\"rem\",\"size\":3,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":92,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":2.3999999999999999,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":2.3999999999999999,\"sizes\":[]},\"_element_width_mobile\":\"inherit\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"3ac47ea\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p class=\\\"ds-markdown-paragraph\\\"><strong>\\u062a\\u062c\\u0631\\u0628\\u06cc\\u0627\\u062a \\u062a\\u062e\\u0635\\u0635\\u06cc \\u0645\\u0627<\\/strong> \\u062d\\u0627\\u0635\\u0644 \\u0633\\u0627\\u0644\\u200c\\u0647\\u0627 \\u06a9\\u0627\\u0631 \\u0645\\u06cc\\u062f\\u0627\\u0646\\u06cc \\u0628\\u0627 \\u0635\\u062f\\u0647\\u0627 \\u062f\\u0641\\u062a\\u0631 \\u067e\\u06cc\\u0634\\u062e\\u0648\\u0627\\u0646 \\u0648 \\u06a9\\u0633\\u0628\\u200c\\u0648\\u06a9\\u0627\\u0631 \\u062e\\u062f\\u0645\\u0627\\u062a\\u06cc \\u0627\\u0633\\u062a. \\u0645\\u0627 \\u0628\\u0647\\u200c\\u062e\\u0648\\u0628\\u06cc \\u0645\\u06cc\\u200c\\u062f\\u0627\\u0646\\u06cc\\u0645 \\u06a9\\u0647 \\u0686\\u0627\\u0644\\u0634\\u200c\\u0647\\u0627\\u06cc \\u0634\\u0645\\u0627 \\u0641\\u0631\\u0627\\u062a\\u0631 \\u0627\\u0632 \\u06cc\\u06a9 \\u0646\\u0631\\u0645\\u200c\\u0627\\u0641\\u0632\\u0627\\u0631 \\u0633\\u0627\\u062f\\u0647 \\u0627\\u0633\\u062a\\u061b <strong>\\u0645\\u0633\\u0627\\u0626\\u0644\\u06cc \\u0645\\u062b\\u0644<\\/strong> \\u067e\\u06cc\\u0686\\u06cc\\u062f\\u06af\\u06cc\\u200c\\u0647\\u0627\\u06cc \\u062b\\u0628\\u062a \\u062f\\u0631\\u062e\\u0648\\u0627\\u0633\\u062a\\u200c\\u0647\\u0627\\u06cc \\u0627\\u062f\\u0627\\u0631\\u06cc\\u060c \\u062a\\u0646\\u0648\\u0639 \\u0633\\u0644\\u06cc\\u0642\\u0647 \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646\\u060c \\u0646\\u06cc\\u0627\\u0632 \\u0628\\u0647 \\u06af\\u0632\\u0627\\u0631\\u0634\\u200c\\u06af\\u06cc\\u0631\\u06cc \\u0641\\u0648\\u0631\\u06cc \\u0628\\u0631\\u0627\\u06cc \\u0645\\u0631\\u0627\\u062c\\u0639 \\u0642\\u0627\\u0646\\u0648\\u0646\\u06cc\\u060c \\u0648 \\u0645\\u0647\\u0645\\u200c\\u062a\\u0631 \\u0627\\u0632 \\u0647\\u0645\\u0647\\u060c <strong>\\u0636\\u0631\\u0648\\u0631\\u062a \\u0633\\u0627\\u062f\\u06af\\u06cc \\u062f\\u0631 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647<\\/strong> \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0627\\u0631\\u0645\\u0646\\u062f\\u0627\\u0646 \\u063a\\u06cc\\u0631\\u0641\\u0646\\u06cc.<\\/p>\",\"align\":\"right\",\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"__globals__\":{\"typography_typography\":\"\"},\"typography_typography\":\"custom\",\"typography_font_family\":\"iranyekanwebregular_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_font_weight\":\"400\",\"typography_line_height\":{\"unit\":\"rem\",\"size\":1.8,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"712cae9\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u062f\\u0631\\u0628\\u0627\\u0631\\u0647 \\u0645\\u0627 \\u0628\\u062e\\u0648\\u0627\\u0646\",\"link\":{\"url\":\"http:\\/\\/tabancrm.ir\\/about-us\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"button_box_shadow_box_shadow_type\":\"yes\",\"button_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":10,\"blur\":30,\"spread\":0,\"color\":\"rgba(248, 84.99999999999999, 78, 0.15)\"},\"__globals__\":{\"background_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"\",\"button_hover_border_color\":\"globals\\/colors?id=primary\",\"button_background_hover_color\":\"globals\\/colors?id=accent\",\"hover_color\":\"globals\\/colors?id=primary\",\"border_color\":\"globals\\/colors?id=primary\"},\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"background_color\":\"#FF5538\",\"typography_typography\":\"custom\",\"typography_font_family\":\"iranyekanwebregular_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_font_weight\":\"600\",\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"border_width_tablet\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"button\"}],\"isInner\":true},{\"id\":\"8e31208\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":45,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"flex_justify_content_tablet\":\"center\"},\"elements\":[{\"id\":\"eb1c775\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/12\\/pic1.jpg\",\"id\":4372,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"align\":\"right\",\"width\":{\"unit\":\"%\",\"size\":71,\"sizes\":[]},\"image_border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"_transform_flipX_effect\":\"transform\",\"width_tablet\":{\"unit\":\"%\",\"size\":61,\"sizes\":[]},\"align_mobile\":\"right\",\"width_mobile\":{\"unit\":\"%\",\"size\":59,\"sizes\":[]},\"align_tablet\":\"right\",\"image_border_radius_tablet\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"15\",\"bottom\":\"15\",\"left\":\"15\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"71d4415\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/12\\/pic4.jpg\",\"id\":4374,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"align\":\"center\",\"width\":{\"unit\":\"%\",\"size\":70,\"sizes\":[]},\"image_border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"_padding\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-36,\"unit\":\"%\"},\"_offset_y_end\":{\"size\":-280,\"unit\":\"px\"},\"_background_background\":\"classic\",\"_background_image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/svgexport-20.svg\",\"id\":148,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"_background_position\":\"bottom right\",\"_background_xpos\":{\"unit\":\"px\",\"size\":280,\"sizes\":[]},\"_background_ypos\":{\"unit\":\"px\",\"size\":-637,\"sizes\":[]},\"_background_repeat\":\"no-repeat\",\"_offset_y\":{\"unit\":\"%\",\"size\":38,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":48,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"px\",\"size\":303,\"sizes\":[]},\"_offset_x_tablet\":{\"unit\":\"%\",\"size\":-21,\"sizes\":[]},\"_offset_y_tablet\":{\"unit\":\"%\",\"size\":69,\"sizes\":[]},\"align_mobile\":\"left\",\"width_mobile\":{\"unit\":\"%\",\"size\":55,\"sizes\":[]},\"_offset_x_mobile\":{\"unit\":\"%\",\"size\":-44,\"sizes\":[]},\"_offset_y_mobile\":{\"unit\":\"%\",\"size\":56,\"sizes\":[]},\"image_border_radius_tablet\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"15\",\"bottom\":\"15\",\"left\":\"15\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"e92338e\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/12\\/pic2.jpg\",\"id\":4373,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"width\":{\"unit\":\"%\",\"size\":46,\"sizes\":[]},\"image_border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-44,\"unit\":\"%\"},\"_offset_y\":{\"size\":-13,\"unit\":\"%\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":57,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":51,\"sizes\":[]},\"_offset_x_tablet\":{\"unit\":\"%\",\"size\":-19,\"sizes\":[]},\"_offset_y_tablet\":{\"unit\":\"%\",\"size\":24,\"sizes\":[]},\"align_mobile\":\"left\",\"width_mobile\":{\"unit\":\"%\",\"size\":43,\"sizes\":[]},\"_offset_x_mobile\":{\"unit\":\"%\",\"size\":-53,\"sizes\":[]},\"_offset_y_mobile\":{\"unit\":\"%\",\"size\":-9,\"sizes\":[]},\"image_border_radius_tablet\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"15\",\"bottom\":\"15\",\"left\":\"15\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"2275a7a\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"margin\":{\"unit\":\"rem\",\"top\":\"5\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"5\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"7\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"19a93d2\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_justify_content\":\"flex-start\",\"background_background\":\"classic\",\"background_image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"initial\",\"background_ypos\":{\"unit\":\"px\",\"size\":320,\"sizes\":[]},\"background_repeat\":\"no-repeat\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding\":{\"unit\":\"rem\",\"top\":\"3\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_flex_order\":\"end\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"flex_gap_tablet\":{\"column\":\"0\",\"row\":\"10\",\"isLinked\":false,\"unit\":\"px\",\"size\":0}},\"elements\":[{\"id\":\"afa0e12\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u062a\\u062c\\u0631\\u0628\\u0647 \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646\\n\",\"header_size\":\"h6\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_family\":\"iranyekanwebregular_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_padding\":{\"unit\":\"rem\",\"top\":\"0.5\",\"right\":\"0.8\",\"bottom\":\"0.5\",\"left\":\"0.8\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"rem\",\"top\":\"0.3\",\"right\":\"0.6\",\"bottom\":\"0.3\",\"left\":\"0.6\",\"isLinked\":false},\"_padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_element_custom_width\":{\"unit\":\"%\",\"size\":19,\"sizes\":[]},\"_background_background\":\"classic\",\"_background_color\":\"#F3EBD6\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"50\",\"right\":\"50\",\"bottom\":\"50\",\"left\":\"50\",\"isLinked\":true},\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\"},\"typography_line_height\":{\"unit\":\"rem\",\"size\":1,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"px\",\"size\":89,\"sizes\":[]},\"_flex_align_self\":\"flex-start\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"6ce60db\",\"elType\":\"widget\",\"settings\":{\"title\":\"<span> \\u062a\\u062c\\u0631\\u0628\\u0647\\u200c\\u0647\\u0627\\u06cc \\u0639\\u0645\\u0644\\u06cc \\u0627\\u0632 \\u062a\\u062d\\u0648\\u0644 \\u0641\\u0631\\u0622\\u06cc\\u0646\\u062f\\u0647\\u0627\\u06cc \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0645\\u0634\\u062a\\u0631\\u06cc\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=secondary\",\"typography_typography\":\"\"},\"title_color\":\"#1A3760\",\"align\":\"right\",\"custom_css\":\"selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #F3EBD6;\\n    height: 10px;\\n    width: 165px;\\n    position: absolute;\\n    top: 0.9em;\\n    z-index: -1;\\n}\\n@media only screen and (max-width: 1242px){\\n    selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #F3EBD6;\\n    height: 8px;\\n    width: 127px;\\n    position: absolute;\\n    top: 3.9rem;\\n    right: 0;\\n    z-index: -1;\\n    }\\n}\\n@media only screen and (max-width: 767px){\\n    selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #FFB99E80;\\n    height: 8px;\\n    width: 102px;\\n    position: absolute;\\n    top: 3em;\\n    right: 0;\\n    z-index: -1;\\n    }\\n}\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":82,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhFaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":32,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"typography_font_weight\":\"700\",\"typography_line_height\":{\"unit\":\"rem\",\"size\":3,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":98,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":91,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":2.3999999999999999,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"_element_width_mobile\":\"inherit\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"4c993c4\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p class=\\\"ds-markdown-paragraph\\\">\\u0645\\u0637\\u0627\\u0628\\u0642 \\u06af\\u0632\\u0627\\u0631\\u0634 \\u062f\\u0641\\u062a\\u0631 \\u0627\\u0633\\u0646\\u0627\\u062f \\u0631\\u0633\\u0645\\u06cc \\u0622\\u0631\\u06cc\\u0646 \\u062f\\u0631 \\u062a\\u0647\\u0631\\u0627\\u0646 \\u06a9\\u0647 \\u0627\\u0632 \\u0633\\u06cc\\u0633\\u062a\\u0645 \\u0645\\u0627 \\u0628\\u0647\\u0631\\u0647 \\u0645\\u06cc\\u200c\\u0628\\u0631\\u062f\\u060c \\u0634\\u0627\\u0647\\u062f <strong>\\u06a9\\u0627\\u0647\\u0634 \\u06f7\\u06f0 \\u062f\\u0631\\u0635\\u062f\\u06cc \\u0632\\u0645\\u0627\\u0646 \\u062c\\u0633\\u062a\\u062c\\u0648\\u06cc \\u067e\\u0631\\u0648\\u0646\\u062f\\u0647\\u200c\\u0647\\u0627<\\/strong> \\u0648 <strong>\\u0627\\u0641\\u0632\\u0627\\u06cc\\u0634 \\u06f4\\u06f0 \\u062f\\u0631\\u0635\\u062f\\u06cc \\u0631\\u0636\\u0627\\u06cc\\u062a \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646<\\/strong> \\u0628\\u0648\\u062f\\u0647\\u200c\\u0627\\u0646\\u062f. \\u0627\\u06cc\\u0646 \\u0646\\u062a\\u0627\\u06cc\\u062c \\u062d\\u0627\\u0635\\u0644 \\u067e\\u06cc\\u0627\\u062f\\u0647\\u200c\\u0633\\u0627\\u0632\\u06cc \\u0645\\u06a9\\u0627\\u0646\\u06cc\\u0632\\u0645\\u200c\\u0647\\u0627\\u06cc \\u067e\\u06cc\\u06af\\u06cc\\u0631\\u06cc \\u062e\\u0648\\u062f\\u06a9\\u0627\\u0631 \\u0648 \\u0634\\u0641\\u0627\\u0641\\u200c\\u0633\\u0627\\u0632\\u06cc \\u0641\\u0631\\u0622\\u06cc\\u0646\\u062f\\u0647\\u0627 \\u062f\\u0631 \\u0633\\u0627\\u0645\\u0627\\u0646\\u0647 \\u0645\\u0627 \\u0628\\u0648\\u062f\\u0647 \\u0627\\u0633\\u062a.<\\/p>\",\"align\":\"right\",\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"__globals__\":{\"typography_typography\":\"\"},\"typography_typography\":\"custom\",\"typography_font_family\":\"iranyekanwebregular_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_font_weight\":\"400\",\"typography_line_height\":{\"unit\":\"rem\",\"size\":1.8,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true},{\"id\":\"2e7d2a1\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_justify_content\":\"center\",\"background_background\":\"classic\",\"background_image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/svgexport-20.svg\",\"id\":148,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"bottom left\",\"background_repeat\":\"no-repeat\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"flex_gap\":{\"column\":\"6\",\"row\":\"0\",\"isLinked\":false,\"unit\":\"px\",\"size\":6},\"flex_gap_tablet\":{\"column\":\"15\",\"row\":\"0\",\"isLinked\":false,\"unit\":\"px\",\"size\":15},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_wrap_mobile\":\"nowrap\",\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_flex_order_mobile\":\"end\"},\"elements\":[{\"id\":\"a59e1f8\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_justify_content\":\"flex-end\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":32,\"sizes\":[]},\"flex_gap\":{\"column\":\"0\",\"row\":\"25\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"width_tablet\":{\"unit\":\"%\",\"size\":43,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"flex_justify_content_tablet\":\"center\",\"flex_gap_tablet\":{\"column\":\"0\",\"row\":\"15\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"flex_justify_content_mobile\":\"flex-end\",\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"eb96a98\",\"elType\":\"widget\",\"settings\":{\"ending_number\":150,\"suffix\":\"+\",\"title\":\"\\u067e\\u0631\\u0648\\u0698\\u0647 \\u0645\\u0648\\u0641\\u0642\",\"number_color\":\"#1A3760\",\"typography_number_typography\":\"custom\",\"typography_number_font_family\":\"YekanBakhFaNum\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#999999\",\"typography_title_typography\":\"custom\",\"typography_title_font_family\":\"YekanBakhFaNum\",\"typography_title_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"typography_title_font_weight\":\"600\",\"__globals__\":{\"number_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"\",\"_background_color\":\"\"},\"_padding\":{\"unit\":\"rem\",\"top\":\"2\",\"right\":\"0\",\"bottom\":\"1\",\"left\":\"0\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"1\",\"left\":\"0\",\"isLinked\":false},\"_padding_mobile\":{\"unit\":\"rem\",\"top\":\"1.5\",\"right\":\"0\",\"bottom\":\"1.5\",\"left\":\"0\",\"isLinked\":false},\"_background_background\":\"classic\",\"_background_color\":\"#FFFFFF\",\"_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"_border_color\":\"#E1E1E1\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":true},\"_box_shadow_box_shadow_type\":\"yes\",\"_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":10,\"spread\":4,\"color\":\"rgba(0, 0, 0, 0.07)\"},\"_box_shadow_hover_box_shadow_type\":\"yes\",\"_box_shadow_hover_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":20,\"spread\":0,\"color\":\"rgba(0, 0, 0, 0.21)\"},\"typography_number_font_size_tablet\":{\"unit\":\"px\",\"size\":38,\"sizes\":[]},\"typography_title_font_size_tablet\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"typography_number_font_size_mobile\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"typography_title_font_size_mobile\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"counter\"},{\"id\":\"7336061\",\"elType\":\"widget\",\"settings\":{\"ending_number\":1500,\"title\":\"\\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646 \\u0648\\u0641\\u0627\\u062f\\u0627\\u0631\",\"number_color\":\"#1A3760\",\"typography_number_typography\":\"custom\",\"typography_number_font_family\":\"YekanBakhFaNum\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"typography_title_typography\":\"custom\",\"typography_title_font_family\":\"YekanBakhFaNum\",\"typography_title_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"typography_title_font_weight\":\"600\",\"__globals__\":{\"number_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"\",\"_background_color\":\"\"},\"_padding\":{\"unit\":\"rem\",\"top\":\"2\",\"right\":\"0\",\"bottom\":\"1\",\"left\":\"0\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"1\",\"left\":\"0\",\"isLinked\":false},\"_padding_mobile\":{\"unit\":\"rem\",\"top\":\"1.5\",\"right\":\"0\",\"bottom\":\"1.5\",\"left\":\"0\",\"isLinked\":false},\"_background_background\":\"classic\",\"_background_color\":\"#FFFFFF\",\"_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"_border_color\":\"#E1E1E1\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":true},\"_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":10,\"spread\":4,\"color\":\"rgba(0, 0, 0, 0.07)\"},\"title_color\":\"#999999\",\"_box_shadow_box_shadow_type\":\"yes\",\"_box_shadow_hover_box_shadow_type\":\"yes\",\"_box_shadow_hover_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":20,\"spread\":0,\"color\":\"rgba(0, 0, 0, 0.21)\"},\"typography_number_font_size_tablet\":{\"unit\":\"px\",\"size\":38,\"sizes\":[]},\"typography_title_font_size_tablet\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"typography_number_font_size_mobile\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"typography_title_font_size_mobile\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"suffix\":\"+\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true},{\"id\":\"f360262\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"column\",\"flex_justify_content\":\"flex-start\",\"width\":{\"unit\":\"%\",\"size\":32,\"sizes\":[]},\"flex_gap\":{\"column\":\"0\",\"row\":\"25\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"width_tablet\":{\"unit\":\"%\",\"size\":43,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"flex_gap_tablet\":{\"column\":\"0\",\"row\":\"15\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"fffd7e6\",\"elType\":\"widget\",\"settings\":{\"ending_number\":19,\"suffix\":\"+\",\"title\":\"\\u062e\\u062f\\u0645\\u0627\\u062a \\u0628\\u0631\\u062a\\u0631\",\"number_color\":\"#1A3760\",\"typography_number_typography\":\"custom\",\"typography_number_font_family\":\"YekanBakhFaNum\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"typography_title_typography\":\"custom\",\"typography_title_font_family\":\"YekanBakhFaNum\",\"typography_title_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"typography_title_font_weight\":\"600\",\"_background_background\":\"classic\",\"__globals__\":{\"number_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"\",\"_background_color\":\"\"},\"_padding_tablet\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"1\",\"left\":\"0\",\"isLinked\":false},\"_padding_mobile\":{\"unit\":\"rem\",\"top\":\"1.5\",\"right\":\"0\",\"bottom\":\"1.5\",\"left\":\"0\",\"isLinked\":false},\"_padding\":{\"unit\":\"rem\",\"top\":\"2\",\"right\":\"0\",\"bottom\":\"1\",\"left\":\"0\",\"isLinked\":false},\"_background_color\":\"#FFFFFF\",\"_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"_border_color\":\"#E1E1E1\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":true},\"title_color\":\"#999999\",\"_box_shadow_box_shadow_type\":\"yes\",\"_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":10,\"spread\":4,\"color\":\"rgba(0, 0, 0, 0.07)\"},\"_box_shadow_hover_box_shadow_type\":\"yes\",\"_box_shadow_hover_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":20,\"spread\":0,\"color\":\"rgba(0, 0, 0, 0.21)\"},\"typography_number_font_size_tablet\":{\"unit\":\"px\",\"size\":38,\"sizes\":[]},\"typography_title_font_size_tablet\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"typography_number_font_size_mobile\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"typography_title_font_size_mobile\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"counter\"},{\"id\":\"2cc4e28\",\"elType\":\"widget\",\"settings\":{\"ending_number\":75,\"suffix\":\"+\",\"title\":\"\\u0627\\u0639\\u0636\\u0627\\u06cc \\u062a\\u06cc\\u0645 \",\"number_color\":\"#1A3760\",\"typography_number_typography\":\"custom\",\"typography_number_font_family\":\"YekanBakhFaNum\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"typography_title_typography\":\"custom\",\"typography_title_font_family\":\"YekanBakhFaNum\",\"typography_title_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"typography_title_font_weight\":\"600\",\"__globals__\":{\"number_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"\",\"_background_color\":\"\"},\"_padding\":{\"unit\":\"rem\",\"top\":\"2\",\"right\":\"0\",\"bottom\":\"1\",\"left\":\"0\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"1\",\"left\":\"0\",\"isLinked\":false},\"_padding_mobile\":{\"unit\":\"rem\",\"top\":\"1.5\",\"right\":\"0\",\"bottom\":\"1.5\",\"left\":\"0\",\"isLinked\":false},\"_background_background\":\"classic\",\"_background_color\":\"#FFFFFF\",\"_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"_border_color\":\"#E1E1E1\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":true},\"title_color\":\"#999999\",\"_box_shadow_box_shadow_type\":\"yes\",\"_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":10,\"spread\":4,\"color\":\"rgba(0, 0, 0, 0.07)\"},\"_box_shadow_hover_box_shadow_type\":\"yes\",\"_box_shadow_hover_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":20,\"spread\":0,\"color\":\"rgba(0, 0, 0, 0.21)\"},\"typography_number_font_size_tablet\":{\"unit\":\"px\",\"size\":38,\"sizes\":[]},\"typography_title_font_size_tablet\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"typography_number_font_size_mobile\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"typography_title_font_size_mobile\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"f21dbce\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"column\":\"0\",\"row\":\"0\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"background_background\":\"classic\",\"margin\":{\"unit\":\"rem\",\"top\":\"12\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"7\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"7\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"__globals__\":{\"background_color\":\"\"},\"padding\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"flex_direction_mobile\":\"column\"},\"elements\":[{\"id\":\"e95237a\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"row\",\"flex_gap\":{\"column\":\"0\",\"row\":\"0\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"background_background\":\"classic\",\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"margin\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"__globals__\":{\"background_color\":\"globals\\/colors?id=secondary\"},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0.2\",\"left\":\"0\",\"isLinked\":false},\"width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_align_items_mobile\":\"center\",\"flex_gap_mobile\":{\"column\":\"0\",\"row\":\"5\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"6b5ea77\",\"elType\":\"container\",\"settings\":{\"background_background\":\"classic\",\"background_image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/11\\/magicpattern-blob-1698862096044-1.png\",\"id\":2168,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"initial\",\"margin\":{\"unit\":\"rem\",\"top\":\"-3\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"-4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":30,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":30,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":55,\"sizes\":[]},\"boxed_width\":{\"unit\":\"%\",\"size\":40,\"sizes\":[]},\"boxed_width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"boxed_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"background_position_mobile\":\"bottom center\",\"background_xpos_mobile\":{\"unit\":\"px\",\"size\":43,\"sizes\":[]},\"background_ypos_mobile\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"background_size_mobile\":\"initial\",\"background_bg_width_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"background_position_tablet\":\"initial\",\"background_ypos_tablet\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"bfee55f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/12\\/4600-removebg-preview.png\",\"id\":4410,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"width\":{\"unit\":\"%\",\"size\":80,\"sizes\":[]},\"_margin\":{\"unit\":\"rem\",\"top\":\"-7\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"-4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"width_tablet\":{\"unit\":\"%\",\"size\":90,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":true},{\"id\":\"5314312\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_justify_content\":\"center\",\"flex_gap\":{\"column\":\"0\",\"row\":\"20\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"padding\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0.5\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0.6\",\"left\":\"0\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"width\":{\"unit\":\"%\",\"size\":70,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":70,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":80,\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"center\",\"flex_gap_mobile\":{\"column\":\"0\",\"row\":\"5\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"flex_gap_tablet\":{\"column\":\"0\",\"row\":\"10\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"flex_direction\":\"column\"},\"elements\":[{\"id\":\"aa128f6\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0646\\u0633\\u062e\\u0647 \\u0646\\u0645\\u0627\\u06cc\\u0634\\u06cc \\u0631\\u0627\\u06cc\\u06af\\u0627\\u0646 \\u0633\\u0627\\u0645\\u0627\\u0646\\u0647 CRM \\u062a\\u0627\\u0628\\u0627\\u0646 \\u0631\\u0627 \\u0647\\u0645\\u06cc\\u0646 \\u0627\\u0645\\u0631\\u0648\\u0632 \\u062a\\u0633\\u062a \\u06a9\\u0646\\u06cc\\u062f.\",\"title_color\":\"#FFFFFF\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":57,\"sizes\":[]},\"__globals__\":{\"typography_typography\":\"\"},\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhFaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":24,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"typography_font_weight\":\"700\",\"typography_line_height\":{\"unit\":\"rem\",\"size\":3,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":2,\"sizes\":[]},\"align_mobile\":\"center\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"db0ebd2\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/11\\/Vector-47-min.png\",\"id\":2180,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"width\":{\"unit\":\"%\",\"size\":72,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"size\":20,\"unit\":\"%\"},\"_offset_y\":{\"size\":34,\"unit\":\"%\"},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_offset_x_end_tablet\":{\"size\":19,\"unit\":\"%\"},\"_offset_y_tablet\":{\"size\":40,\"unit\":\"%\"},\"_offset_x_end_mobile\":{\"size\":-0.90000000000000002,\"unit\":\"%\"},\"_offset_y_mobile\":{\"size\":43,\"unit\":\"%\"},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_offset_y_end_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"_offset_y_end_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"b73843b\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u062f\\u0631\\u062e\\u0648\\u0627\\u0633\\u062a \\u062f\\u0645\\u0648\\u06cc \\u0631\\u0627\\u06cc\\u06af\\u0627\\u0646\",\"link\":{\"url\":\"http:\\/\\/tabancrm.ir\\/our-services\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"button_box_shadow_box_shadow_type\":\"yes\",\"button_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":10,\"blur\":30,\"spread\":0,\"color\":\"rgba(248, 84.99999999999999, 78, 0.15)\"},\"__globals__\":{\"background_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"\",\"hover_color\":\"globals\\/colors?id=primary\",\"button_background_hover_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=primary\",\"border_color\":\"globals\\/colors?id=primary\"},\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"typography_typography\":\"custom\",\"typography_font_family\":\"iranyekanwebregular_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"typography_font_weight\":\"600\",\"selected_icon\":{\"value\":\"far fa-arrow-alt-circle-left\",\"library\":\"fa-regular\"},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"background_color\":\"#FF5538\",\"_margin\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"align\":\"center\"},\"elements\":[],\"widgetType\":\"button\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"beaf6f7\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_align_items\":\"center\",\"margin\":{\"unit\":\"rem\",\"top\":\"5\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"flex_gap_tablet\":{\"column\":\"0\",\"row\":\"10\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"flex_gap\":{\"column\":\"0\",\"row\":\"10\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"7b80ed6\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0646\\u0645\\u0648\\u0646\\u0647 \\u06a9\\u0627\\u0631\\u0647\\u0627\",\"header_size\":\"h6\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_family\":\"iranyekanwebregular_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_padding\":{\"unit\":\"rem\",\"top\":\"0.5\",\"right\":\"0.8\",\"bottom\":\"0.5\",\"left\":\"0.8\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"rem\",\"top\":\"0.3\",\"right\":\"0.6\",\"bottom\":\"0.3\",\"left\":\"0.6\",\"isLinked\":false},\"_padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_element_custom_width\":{\"unit\":\"%\",\"size\":19,\"sizes\":[]},\"_background_background\":\"classic\",\"_background_color\":\"#F3EBD6\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"50\",\"right\":\"50\",\"bottom\":\"50\",\"left\":\"50\",\"isLinked\":true},\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\"},\"typography_line_height\":{\"unit\":\"rem\",\"size\":1,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"px\",\"size\":89,\"sizes\":[]},\"_flex_align_self\":\"center\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"6a3aa95\",\"elType\":\"widget\",\"settings\":{\"title\":\"<span>\\u0646\\u0645\\u0648\\u0646\\u0647\\u200c\\u0647\\u0627\\u06cc \\u0648\\u0627\\u0642\\u0639\\u06cc \\u062a\\u062d\\u0648\\u0644 \\u062f\\u06cc\\u062c\\u06cc\\u062a\\u0627\\u0644 \\u0628\\u0627 \\u0631\\u0627\\u0647\\u06a9\\u0627\\u0631\\u0647\\u0627\\u06cc \\u0645\\u0627 <\\/span> \",\"__globals__\":{\"title_color\":\"globals\\/colors?id=secondary\",\"typography_typography\":\"\"},\"title_color\":\"#1A3760\",\"align\":\"center\",\"custom_css\":\"selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #F3EBD6;\\n    height: 10px;\\n    width: 170px;\\n    position: absolute;\\n    top: 0.9em;\\n    z-index: -1;\\n}\\n@media only screen and (max-width: 1242px){\\n    selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #F3EBD6;\\n    height: 8px;\\n    width: 138px;\\n    position: absolute;\\n    top:1em;\\n    right: 3.3em;\\n    z-index: -1;\\n    }\\n}\\n@media only screen and (max-width: 767px){\\n    selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #FFB99E80;\\n    height: 8px;\\n    width: 112px;\\n    position: absolute;\\n    top:1.1em;\\n    right: 3.5em;\\n    z-index: -1;\\n    }\\n}\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":34,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhFaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":32,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"typography_font_weight\":\"700\",\"typography_line_height\":{\"unit\":\"rem\",\"size\":3,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":46,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":80,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":2.3999999999999999,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":2.3999999999999999,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"f9529fd\",\"elType\":\"widget\",\"settings\":{\"tabs\":[{\"item_label\":\"\\u0647\\u0645\\u0647 \\u0646\\u0645\\u0648\\u0646\\u0647 \\u06a9\\u0627\\u0631\\u0647\\u0627\",\"_id\":\"4751e3f\",\"selected_item_icon\":{\"value\":\"\",\"library\":\"\"},\"item_template_id\":\"590\",\"item_editor_content\":\"<p>\\u0645\\u062d\\u062a\\u0648\\u0627\\u06cc \\u0645\\u0648\\u0631\\u062f \\u0632\\u0628\\u0627\\u0646\\u0647<\\/p>\"},{\"item_label\":\"\\u062f\\u0641\\u0627\\u062a\\u0631 \\u0627\\u0633\\u0646\\u0627\\u062f \\u0631\\u0633\\u0645\\u06cc\",\"selected_item_icon\":{\"value\":\"\",\"library\":\"\"},\"item_template_id\":\"568\",\"_id\":\"1ca6a98\",\"__dynamic__\":[],\"item_editor_content\":\"<p>\\u0645\\u062d\\u062a\\u0648\\u0627\\u06cc \\u0645\\u0648\\u0631\\u062f \\u0632\\u0628\\u0627\\u0646\\u0647<\\/p>\"},{\"item_label\":\"\\u0645\\u0627\\u0644\\u06cc \\u0648 \\u062d\\u0633\\u0627\\u0628\\u062f\\u0627\\u0631\\u06cc\",\"selected_item_icon\":{\"value\":\"\",\"library\":\"\"},\"item_template_id\":\"581\",\"_id\":\"f5208e7\",\"item_editor_content\":\"<p>\\u0645\\u062d\\u062a\\u0648\\u0627\\u06cc \\u0645\\u0648\\u0631\\u062f \\u0632\\u0628\\u0627\\u0646\\u0647<\\/p>\"},{\"item_label\":\"\\u0645\\u0631\\u0627\\u06a9\\u0632 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0645\\u0646\\u0638\\u0648\\u0631\\u0647\",\"selected_item_icon\":{\"value\":\"\",\"library\":\"\"},\"item_template_id\":\"587\",\"_id\":\"ae35b54\",\"item_editor_content\":\"<p>\\u0645\\u062d\\u062a\\u0648\\u0627\\u06cc \\u0645\\u0648\\u0631\\u062f \\u0632\\u0628\\u0627\\u0646\\u0647<\\/p>\"},{\"item_label\":\"\\u062f\\u0641\\u0627\\u062a\\u0631 \\u0632\\u0646\\u062c\\u06cc\\u0631\\u0647\\u200c\\u0627\\u06cc\",\"selected_item_icon\":{\"value\":\"\",\"library\":\"\"},\"item_template_id\":\"578\",\"_id\":\"9090f39\",\"item_editor_content\":\"<p>\\u0645\\u062d\\u062a\\u0648\\u0627\\u06cc \\u0645\\u0648\\u0631\\u062f \\u0632\\u0628\\u0627\\u0646\\u0647<\\/p>\"},{\"item_label\":\"\\u0627\\u0633\\u062a\\u0627\\u0631\\u062a\\u0627\\u067e\\u200c\\u0647\\u0627\\u06cc \\u062e\\u062f\\u0645\\u0627\\u062a\\u06cc \\u0646\\u0648\\u067e\\u0627\",\"selected_item_icon\":{\"value\":\"\",\"library\":\"\"},\"item_template_id\":\"584\",\"_id\":\"b32350a\",\"item_editor_content\":\"<p>\\u0645\\u062d\\u062a\\u0648\\u0627\\u06cc \\u0645\\u0648\\u0631\\u062f \\u0632\\u0628\\u0627\\u0646\\u0647<\\/p>\"}],\"tabs_controls_aligment\":\"center\",\"tabs_control_label_typography_typography\":\"custom\",\"tabs_control_label_typography_font_family\":\"iranyekanwebregular_FaNum\",\"tabs_control_label_typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"tabs_control_label_typography_font_weight\":\"600\",\"tabs_control_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"5\",\"left\":\"0\",\"isLinked\":false},\"tabs_control_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"tabs_control_border_radius\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":true},\"tabs_control_label_typography_hover_typography\":\"custom\",\"tabs_control_label_typography_hover_font_family\":\"iranyekanwebregular_FaNum\",\"tabs_control_label_typography_hover_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"tabs_control_label_typography_hover_font_weight\":\"600\",\"tabs_control_label_typography_active_typography\":\"custom\",\"tabs_control_label_typography_active_font_family\":\"iranyekanwebregular_FaNum\",\"tabs_control_label_typography_active_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"tabs_control_label_typography_active_font_weight\":\"600\",\"tabs_control_border_active_width\":{\"unit\":\"px\",\"top\":\"0.3\",\"right\":\"0.3\",\"bottom\":\"0.3\",\"left\":\"0.3\",\"isLinked\":false},\"tabs_control_border_radius_active\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":true},\"__globals__\":{\"tabs_control_label_typography_typography\":\"\",\"tabs_control_label_color_hover\":\"globals\\/colors?id=primary\",\"tabs_control_label_color_active\":\"globals\\/colors?id=primary\",\"tabs_control_border_active_color\":\"globals\\/colors?id=primary\",\"tabs_control_border_color\":\"globals\\/colors?id=primary\"},\"tabs_content_wrapper_background_background\":\"classic\",\"tabs_content_background_background\":\"classic\",\"tabs_content_background_color\":\"#E7282800\",\"tabs_content_wrapper_background_color\":\"#C1010100\",\"tabs_control_background_background\":\"classic\",\"tabs_control_background_active_background\":\"classic\",\"_flex_align_self\":\"stretch\",\"tabs_control_border_color\":\"#FF5538\",\"tabs_control_label_color_active\":\"#FF5538\",\"tabs_control_border_active_color\":\"#FF5538\",\"tabs_controls_container_aligment\":\"center\",\"tabs_control_label_typography_font_size_tablet\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"tabs_control_label_typography_hover_font_size_tablet\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"tabs_control_label_typography_active_font_size_tablet\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"_padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"tabs_control_label_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"tabs_content_padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"tabs_control_padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"14\",\"bottom\":\"0\",\"left\":\"14\",\"isLinked\":false},\"tabs_content_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"tabs_content_typography_typography\":\"custom\",\"tabs_control_margin_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"19\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"jet-tabs\"}],\"isInner\":false},{\"id\":\"615f3d4\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"margin\":{\"unit\":\"rem\",\"top\":\"4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"flex_gap\":{\"column\":\"50\",\"row\":\"0\",\"isLinked\":false,\"unit\":\"px\",\"size\":50},\"flex_gap_mobile\":{\"column\":\"0\",\"row\":\"15\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"flex_gap_tablet\":{\"column\":\"30\",\"row\":\"0\",\"isLinked\":false,\"unit\":\"px\",\"size\":30}},\"elements\":[{\"id\":\"3c77c74\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_justify_content\":\"center\",\"background_background\":\"classic\",\"background_image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"initial\",\"background_ypos\":{\"unit\":\"px\",\"size\":320,\"sizes\":[]},\"background_repeat\":\"no-repeat\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_flex_order\":\"end\",\"flex_gap\":{\"column\":\"0\",\"row\":\"15\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"width\":{\"unit\":\"%\",\"size\":60,\"sizes\":[]},\"flex_gap_tablet\":{\"column\":\"0\",\"row\":\"10\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"width_tablet\":{\"unit\":\"%\",\"size\":60,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_wrap_mobile\":\"nowrap\",\"flex_justify_content_tablet\":\"center\",\"flex_gap_mobile\":{\"column\":\"7\",\"row\":\"7\",\"isLinked\":true,\"unit\":\"px\",\"size\":7}},\"elements\":[{\"id\":\"6ec7986\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0631\\u0636\\u0627\\u06cc\\u062a \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646\",\"header_size\":\"h6\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_family\":\"iranyekanwebregular_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_padding\":{\"unit\":\"rem\",\"top\":\"0.5\",\"right\":\"0.8\",\"bottom\":\"0.5\",\"left\":\"0.8\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"rem\",\"top\":\"0.3\",\"right\":\"0.6\",\"bottom\":\"0.3\",\"left\":\"0.6\",\"isLinked\":false},\"_padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_element_custom_width\":{\"unit\":\"%\",\"size\":19,\"sizes\":[]},\"_background_background\":\"classic\",\"_background_color\":\"#F3EBD6\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"50\",\"right\":\"50\",\"bottom\":\"50\",\"left\":\"50\",\"isLinked\":true},\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\"},\"typography_line_height\":{\"unit\":\"rem\",\"size\":1,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"px\",\"size\":89,\"sizes\":[]},\"_flex_align_self\":\"flex-start\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"df0c8d1\",\"elType\":\"widget\",\"settings\":{\"title\":\"<span>\\u0635\\u062f\\u0627\\u06cc \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646 \\u0645\\u0627 <\\/span> \",\"__globals__\":{\"title_color\":\"globals\\/colors?id=secondary\",\"typography_typography\":\"\"},\"title_color\":\"#1A3760\",\"custom_css\":\"selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #F3EBD6;\\n    height: 10px;\\n    width: 205px;\\n    position: absolute;\\n    top: 0.9em;\\n    z-index: -1;\\n}\\n@media only screen and (max-width: 1242px){\\n    selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #F3EBD6;\\n    height: 8px;\\n    width: 160px;\\n    position: absolute;\\n    top: 1em;\\n    right: 0;\\n    z-index: -1;\\n    }\\n}\\n@media only screen and (max-width: 767px){\\n    selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #FFB99E80;\\n    height: 8px;\\n    width: 130px;\\n    position: absolute;\\n    top: 1.2em;\\n    right: 0;\\n    z-index: -1;\\n    }\\n}\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhFaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":32,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"typography_font_weight\":\"700\",\"typography_line_height\":{\"unit\":\"rem\",\"size\":3,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":70,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":2.3999999999999999,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"_element_width_mobile\":\"inherit\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"03075b2\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u0635\\u062f\\u0647\\u0627 \\u06a9\\u0633\\u0628\\u200c\\u0648\\u06a9\\u0627\\u0631 \\u0627\\u0632 \\u062f\\u0641\\u062a\\u0631 \\u067e\\u06cc\\u0634\\u062e\\u0648\\u0627\\u0646 \\u062a\\u0627 \\u0627\\u0633\\u062a\\u0627\\u0631\\u062a\\u0627\\u067e\\u060c \\u0645\\u0647\\u0645\\u200c\\u062a\\u0631\\u06cc\\u0646 \\u0633\\u0631\\u0645\\u0627\\u06cc\\u0647 \\u0645\\u0627\\u0633\\u062a.\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=secondary\",\"typography_typography\":\"\"},\"title_color\":\"#1A3760\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":74,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhFaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":32,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"typography_font_weight\":\"700\",\"typography_line_height\":{\"unit\":\"rem\",\"size\":3,\"sizes\":[]},\"_padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":89,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":92,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":2.3999999999999999,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":2.3999999999999999,\"sizes\":[]},\"_element_width_mobile\":\"inherit\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"26b500c\",\"elType\":\"widget\",\"settings\":{\"lisitng_id\":\"1277\",\"columns\":\"2\",\"not_found_message\":\"\\u0647\\u06cc\\u0686 \\u062f\\u0627\\u062f\\u0647 \\u0627\\u06cc \\u06cc\\u0627\\u0641\\u062a \\u0646\\u0634\\u062f\",\"posts_query\":[],\"terms_meta_query\":[],\"users_meta_query\":[],\"carousel_enabled\":\"yes\",\"posts_num\":\"\",\"arrows_box_size\":{\"unit\":\"px\",\"size\":24,\"sizes\":[]},\"prev_top_position\":{\"unit\":\"%\",\"size\":-8,\"sizes\":[]},\"prev_top_position_tablet\":{\"unit\":\"%\",\"size\":3,\"sizes\":[]},\"prev_top_position_mobile\":{\"unit\":\"%\",\"size\":3,\"sizes\":[]},\"prev_left_position\":{\"unit\":\"%\",\"size\":2,\"sizes\":[]},\"prev_right_position\":{\"unit\":\"%\",\"size\":-26,\"sizes\":[]},\"prev_right_position_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"prev_right_position_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"next_top_position\":{\"unit\":\"%\",\"size\":-8,\"sizes\":[]},\"next_top_position_tablet\":{\"unit\":\"%\",\"size\":3,\"sizes\":[]},\"next_top_position_mobile\":{\"unit\":\"%\",\"size\":3,\"sizes\":[]},\"next_hor_position\":\"left\",\"next_left_position\":{\"unit\":\"%\",\"size\":7,\"sizes\":[]},\"next_right_position\":{\"unit\":\"%\",\"size\":-30,\"sizes\":[]},\"next_right_position_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"next_right_position_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"_margin\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"custom_css\":\"selector .jet-listing-grid__slider-icon.prev-arrow{\\n    border-radius: 20px;\\n}\\nselector .jet-listing-grid__slider-icon.next-arrow{\\n  border-radius: 20px;  \\n}\",\"__globals__\":{\"arrow_bg_color\":\"globals\\/colors?id=primary\",\"arrow_bg_color_hover\":\"globals\\/colors?id=secondary\"},\"prev_left_position_tablet\":{\"unit\":\"%\",\"size\":2,\"sizes\":[]},\"prev_left_position_mobile\":{\"unit\":\"%\",\"size\":3,\"sizes\":[]},\"next_left_position_tablet\":{\"unit\":\"%\",\"size\":10,\"sizes\":[]},\"next_left_position_mobile\":{\"unit\":\"%\",\"size\":12,\"sizes\":[]},\"columns_tablet\":\"1\",\"arrows_box_size_tablet\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"jet-listing-grid\"}],\"isInner\":true},{\"id\":\"9ed8f1d\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_direction\":\"column\",\"flex_justify_content\":\"center\",\"background_background\":\"classic\",\"background_image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/svgexport-20.svg\",\"id\":148,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"bottom right\",\"background_repeat\":\"no-repeat\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"width\":{\"unit\":\"%\",\"size\":40,\"sizes\":[]},\"flex_gap_tablet\":{\"column\":\"0\",\"row\":\"0\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"flex_justify_content_tablet\":\"center\",\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0.2\",\"bottom\":\"0\",\"left\":\"0.2\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"63167b6\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/12\\/MDMS1-min.png\",\"id\":4408,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"_z_index\":1,\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"height_mobile\":{\"unit\":\"px\",\"size\":185,\"sizes\":[]},\"object-fit_mobile\":\"contain\"},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"212fdcd\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/quote1.svg\",\"id\":312,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"motion_fx_motion_fx_scrolling\":\"yes\",\"motion_fx_translateY_effect\":\"yes\",\"motion_fx_translateY_speed\":{\"unit\":\"px\",\"size\":2.7000000000000002,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":70,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":56,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"1e4c5e1\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"margin\":{\"unit\":\"rem\",\"top\":\"5\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"601bb56\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"flex_justify_content\":\"flex-start\",\"background_background\":\"classic\",\"background_image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"initial\",\"background_ypos\":{\"unit\":\"px\",\"size\":320,\"sizes\":[]},\"background_repeat\":\"no-repeat\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding\":{\"unit\":\"rem\",\"top\":\"3\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"flex_gap_tablet\":{\"column\":\"0\",\"row\":\"8\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"42a7647\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u0633\\u06cc\\u0631 \\u062a\\u0648\\u0633\\u0639\\u0647\",\"header_size\":\"h6\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_family\":\"iranyekanwebregular_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_padding\":{\"unit\":\"rem\",\"top\":\"0.5\",\"right\":\"0.8\",\"bottom\":\"0.5\",\"left\":\"0.8\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"rem\",\"top\":\"0.3\",\"right\":\"0.6\",\"bottom\":\"0.3\",\"left\":\"0.6\",\"isLinked\":false},\"_padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_element_custom_width\":{\"unit\":\"%\",\"size\":19,\"sizes\":[]},\"_background_background\":\"classic\",\"_background_color\":\"#F3EBD6\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"50\",\"right\":\"50\",\"bottom\":\"50\",\"left\":\"50\",\"isLinked\":true},\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\"},\"typography_line_height\":{\"unit\":\"rem\",\"size\":1,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"px\",\"size\":89,\"sizes\":[]},\"_flex_align_self\":\"flex-start\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"2271ba0\",\"elType\":\"widget\",\"settings\":{\"title\":\" \\u0627\\u0631\\u0627\\u0626\\u0647 \\u06cc\\u06a9 CRM <span>\\u0633\\u0628\\u06a9 \\u0648 \\u06a9\\u0627\\u0631\\u0628\\u0631\\u062f\\u06cc \\n<\\/span>\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=secondary\",\"typography_typography\":\"\"},\"title_color\":\"#1A3760\",\"align\":\"right\",\"custom_css\":\"selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #F3EBD6;\\n    height: 10px;\\n    width: 85px;\\n    position: absolute;\\n    bottom: 0.25em;\\n    z-index: -1;\\n}\\n@media only screen and (max-width: 1242px){\\n    selector .elementor-heading-title span:before{\\n    content: \\\"\\\";\\n    background-color: #F3EBD6;\\n    height: 8px;\\n    width: 70px;\\n    position: absolute;\\n    bottom: 0.2em;\\n    left: 0.4rem;\\n    z-index: -1;\\n    }\\n}\\n@media only screen and (max-width: 767px){\\n    selector .elementor-heading-title span:before{\\n    width: 58px;\\n    bottom: 0.3em;\\n    left: 1.4rem;\\n    }\\n}\\n\\n@media only screen and (max-width: 567px){\\n    selector .elementor-heading-title span:before{\\n    width: 60px;\\n    top: 1em;\\n    right: 3.3rem;\\n    }\\n}\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":74.412000000000006},\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhFaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":32,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"typography_font_weight\":\"700\",\"typography_line_height\":{\"unit\":\"rem\",\"size\":3,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":69,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":24,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":65,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":2.3999999999999999,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":2.3999999999999999,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_flex_size\":\"none\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"3735fe0\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>\\u0634\\u0631\\u06a9\\u062a \\u0645\\u0627 \\u0645\\u0633\\u06cc\\u0631 \\u062a\\u0648\\u0633\\u0639\\u0647 \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0628\\u0627 \\u0627\\u0631\\u0627\\u0626\\u0647 \\u0646\\u0633\\u062e\\u0647 \\u067e\\u0627\\u06cc\\u0647 CRM \\u0628\\u0631\\u0627\\u06cc \\u062f\\u0641\\u0627\\u062a\\u0631 \\u067e\\u06cc\\u0634\\u062e\\u0648\\u0627\\u0646 \\u0622\\u063a\\u0627\\u0632 \\u06a9\\u0631\\u062f\\u0647 \\u0627\\u0633\\u062a \\u06a9\\u0647 \\u0634\\u0627\\u0645\\u0644 \\u0627\\u0645\\u06a9\\u0627\\u0646\\u0627\\u062a \\u0627\\u0635\\u0644\\u06cc \\u0645\\u0627\\u0646\\u0646\\u062f \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646\\u060c \\u067e\\u06cc\\u06af\\u06cc\\u0631\\u06cc \\u062f\\u0631\\u062e\\u0648\\u0627\\u0633\\u062a\\u200c\\u0647\\u0627 \\u0648 \\u06af\\u0632\\u0627\\u0631\\u0634\\u200c\\u06af\\u06cc\\u0631\\u06cc \\u0633\\u0627\\u062f\\u0647 \\u0645\\u06cc\\u200c\\u0634\\u0648\\u062f. \\u062f\\u0631 \\u06af\\u0627\\u0645 \\u0628\\u0639\\u062f\\u06cc\\u060c \\u0637\\u06cc \\u06f1 \\u062a\\u0627 \\u06f2 \\u0633\\u0627\\u0644 \\u0622\\u06cc\\u0646\\u062f\\u0647\\u060c \\u0627\\u06cc\\u0646 \\u0633\\u06cc\\u0633\\u062a\\u0645 \\u0631\\u0627 \\u0628\\u0627 \\u0627\\u0641\\u0632\\u0648\\u062f\\u0646 \\u0645\\u0627\\u0698\\u0648\\u0644\\u200c\\u0647\\u0627\\u06cc \\u062a\\u062e\\u0635\\u0635\\u06cc \\u0645\\u0627\\u0646\\u0646\\u062f \\u067e\\u0631\\u062f\\u0627\\u062e\\u062a \\u0622\\u0646\\u0644\\u0627\\u06cc\\u0646\\u060c \\u0627\\u062f\\u063a\\u0627\\u0645 \\u0628\\u0627 \\u0646\\u0631\\u0645\\u200c\\u0627\\u0641\\u0632\\u0627\\u0631\\u0647\\u0627\\u06cc \\u062d\\u0633\\u0627\\u0628\\u062f\\u0627\\u0631\\u06cc \\u0648 \\u067e\\u0634\\u062a\\u06cc\\u0628\\u0627\\u0646\\u06cc \\u0627\\u0632 \\u06a9\\u0633\\u0628\\u200c\\u0648\\u06a9\\u0627\\u0631\\u0647\\u0627\\u06cc \\u062e\\u062f\\u0645\\u0627\\u062a\\u06cc \\u0645\\u062a\\u0646\\u0648\\u0639\\u060c \\u0628\\u0647 \\u0646\\u0633\\u062e\\u0647 \\u062d\\u0631\\u0641\\u0647\\u200c\\u0627\\u06cc \\u0627\\u0631\\u062a\\u0642\\u0627 \\u062e\\u0648\\u0627\\u0647\\u06cc\\u0645 \\u062f\\u0627\\u062f. \\u062f\\u0631 \\u0628\\u0644\\u0646\\u062f\\u0645\\u062f\\u062a \\u0646\\u06cc\\u0632 \\u0628\\u0627 \\u0628\\u0647\\u0631\\u0647\\u200c\\u06af\\u06cc\\u0631\\u06cc \\u0627\\u0632 \\u0647\\u0648\\u0634 \\u0645\\u0635\\u0646\\u0648\\u0639\\u06cc\\u060c \\u0633\\u06cc\\u0633\\u062a\\u0645 \\u0631\\u0627 \\u0628\\u0647 \\u0633\\u0645\\u062a \\u062a\\u062d\\u0644\\u06cc\\u0644 \\u0647\\u0648\\u0634\\u0645\\u0646\\u062f \\u0631\\u0641\\u062a\\u0627\\u0631 \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646\\u060c \\u067e\\u06cc\\u0634\\u0646\\u0647\\u0627\\u062f \\u062e\\u0648\\u062f\\u06a9\\u0627\\u0631 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0648 \\u0627\\u06cc\\u062c\\u0627\\u062f \\u06cc\\u06a9 \\u0627\\u06a9\\u0648\\u0633\\u06cc\\u0633\\u062a\\u0645 \\u06cc\\u06a9\\u067e\\u0627\\u0631\\u0686\\u0647 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0633\\u0628\\u200c\\u0648\\u06a9\\u0627\\u0631\\u0647\\u0627\\u06cc \\u0645\\u062d\\u0644\\u06cc \\u062a\\u0648\\u0633\\u0639\\u0647 \\u0645\\u06cc\\u200c\\u062f\\u0647\\u06cc\\u0645 \\u062a\\u0627 \\u0647\\u0645\\u06af\\u0627\\u0645 \\u0628\\u0627 \\u0631\\u0634\\u062f \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646\\u0645\\u0627\\u0646\\u060c \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\\u200c\\u062a\\u0631 \\u0648 \\u06a9\\u0627\\u0631\\u0622\\u0645\\u062f\\u062a\\u0631 \\u0639\\u0645\\u0644 \\u06a9\\u0646\\u062f.<\\/p>\",\"align\":\"right\",\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"__globals__\":{\"typography_typography\":\"\"},\"typography_typography\":\"custom\",\"typography_font_family\":\"iranyekanwebregular_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_font_weight\":\"400\",\"typography_line_height\":{\"unit\":\"rem\",\"size\":1.8,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"583595e\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0628\\u06cc\\u0634\\u062a\\u0631 \\u0628\\u062e\\u0648\\u0627\\u0646\\u06cc\\u062f\",\"link\":{\"url\":\"http:\\/\\/tabancrm.ir\\/about-us\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"button_box_shadow_box_shadow_type\":\"yes\",\"button_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":10,\"blur\":30,\"spread\":0,\"color\":\"rgba(248, 84.99999999999999, 78, 0.15)\"},\"__globals__\":{\"background_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"\",\"button_hover_border_color\":\"globals\\/colors?id=primary\",\"button_background_hover_color\":\"globals\\/colors?id=accent\",\"hover_color\":\"globals\\/colors?id=primary\",\"border_color\":\"globals\\/colors?id=primary\"},\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"typography_typography\":\"custom\",\"typography_font_family\":\"iranyekanwebregular_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"typography_font_weight\":\"600\",\"background_color\":\"#FF5538\",\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"button\"}],\"isInner\":true},{\"id\":\"93354e8\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"min_height_mobile\":{\"unit\":\"px\",\"size\":300,\"sizes\":[]}},\"elements\":[{\"id\":\"082aadc\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/l0.png\",\"id\":1425,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"width\":{\"unit\":\"%\",\"size\":69,\"sizes\":[]},\"image_border_radius\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"16\",\"bottom\":\"16\",\"left\":\"16\",\"isLinked\":true},\"image_box_shadow_box_shadow_type\":\"yes\",\"image_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":10,\"spread\":0,\"color\":\"rgba(0, 0, 0, 0.11)\"},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"size\":21,\"unit\":\"%\"},\"_offset_y\":{\"size\":56,\"unit\":\"%\"},\"width_tablet\":{\"unit\":\"%\",\"size\":56,\"sizes\":[]},\"_offset_x_end_tablet\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"_offset_y_tablet\":{\"unit\":\"%\",\"size\":56,\"sizes\":[]},\"_offset_x_end_mobile\":{\"unit\":\"%\",\"size\":6,\"sizes\":[]},\"_offset_y_mobile\":{\"unit\":\"%\",\"size\":52,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"initial\",\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":37,\"sizes\":[]},\"hover_animation\":\"float\"},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"6fd3a79\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/l2.png\",\"id\":1427,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"image_border_radius\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"16\",\"bottom\":\"16\",\"left\":\"16\",\"isLinked\":true},\"image_box_shadow_box_shadow_type\":\"yes\",\"image_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":10,\"spread\":0,\"color\":\"rgba(0, 0, 0, 0.11)\"},\"width_tablet\":{\"unit\":\"%\",\"size\":49,\"sizes\":[]},\"hover_animation\":\"float\"},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"9acc29e\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/l3.png\",\"id\":1426,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"width\":{\"unit\":\"%\",\"size\":65,\"sizes\":[]},\"image_border_radius\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"16\",\"bottom\":\"16\",\"left\":\"16\",\"isLinked\":true},\"image_box_shadow_box_shadow_type\":\"yes\",\"image_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":10,\"spread\":0,\"color\":\"rgba(0, 0, 0, 0.08)\"},\"_position\":\"absolute\",\"_offset_x\":{\"size\":2,\"unit\":\"%\"},\"_offset_y\":{\"size\":12,\"unit\":\"%\"},\"width_tablet\":{\"unit\":\"%\",\"size\":52,\"sizes\":[]},\"_offset_x_tablet\":{\"unit\":\"%\",\"size\":-8,\"sizes\":[]},\"_offset_y_tablet\":{\"unit\":\"%\",\"size\":25,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_offset_x_mobile\":{\"size\":0,\"unit\":\"%\"},\"_offset_y_mobile\":{\"size\":31.899999999999999,\"unit\":\"%\"},\"_element_width_mobile\":\"initial\",\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":32,\"sizes\":[]},\"hover_animation\":\"float\"},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"eaa58d6\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/l1.png\",\"id\":1428,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"width\":{\"unit\":\"%\",\"size\":42,\"sizes\":[]},\"image_border_radius\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"16\",\"bottom\":\"16\",\"left\":\"16\",\"isLinked\":true},\"image_box_shadow_box_shadow_type\":\"yes\",\"image_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":10,\"spread\":0,\"color\":\"rgba(0, 0, 0, 0.11)\"},\"_position\":\"absolute\",\"_offset_x\":{\"size\":12,\"unit\":\"%\"},\"_offset_y\":{\"size\":52,\"unit\":\"%\"},\"width_tablet\":{\"unit\":\"%\",\"size\":40,\"sizes\":[]},\"_offset_x_tablet\":{\"unit\":\"%\",\"size\":7,\"sizes\":[]},\"_offset_y_tablet\":{\"unit\":\"%\",\"size\":56,\"sizes\":[]},\"_offset_x_mobile\":{\"unit\":\"%\",\"size\":22,\"sizes\":[]},\"_offset_y_mobile\":{\"unit\":\"%\",\"size\":67,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"initial\",\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":25,\"sizes\":[]},\"hover_animation\":\"float\"},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"adc4288\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/l1.png\",\"id\":1428,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"width\":{\"unit\":\"%\",\"size\":42,\"sizes\":[]},\"image_border_radius\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"16\",\"bottom\":\"16\",\"left\":\"16\",\"isLinked\":true},\"image_box_shadow_box_shadow_type\":\"yes\",\"image_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":10,\"spread\":0,\"color\":\"rgba(0, 0, 0, 0.11)\"},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x\":{\"size\":55,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"%\",\"size\":5,\"sizes\":[]},\"_offset_y\":{\"size\":28,\"unit\":\"%\"},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_offset_x_end_tablet\":{\"unit\":\"%\",\"size\":-2,\"sizes\":[]},\"_offset_y_tablet\":{\"unit\":\"%\",\"size\":26,\"sizes\":[]},\"_offset_x_end_mobile\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"_offset_y_mobile\":{\"unit\":\"%\",\"size\":18,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"initial\",\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":24,\"sizes\":[]},\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"px\",\"size\":118,\"sizes\":[]},\"hover_animation\":\"float\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"e551556\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_justify_content\":\"center\",\"flex_align_items\":\"center\",\"margin\":{\"unit\":\"rem\",\"top\":\"5\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"flex_gap\":{\"column\":\"20\",\"row\":\"10\",\"isLinked\":false,\"unit\":\"px\",\"size\":20},\"flex_gap_tablet\":{\"column\":\"0\",\"row\":\"5\",\"isLinked\":false,\"unit\":\"px\",\"size\":0},\"flex_gap_mobile\":{\"column\":\"0\",\"row\":\"8\",\"isLinked\":false,\"unit\":\"px\",\"size\":0}},\"elements\":[{\"id\":\"c9adca5\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0628\\u0627 \\u0645\\u0627 \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a \\u06a9\\u0646\\u06cc\\u062f!\",\"header_size\":\"p\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_family\":\"iranyekanwebregular_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_padding\":{\"unit\":\"rem\",\"top\":\"0.5\",\"right\":\"0.8\",\"bottom\":\"0.5\",\"left\":\"0.8\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"rem\",\"top\":\"0.3\",\"right\":\"0.6\",\"bottom\":\"0.3\",\"left\":\"0.6\",\"isLinked\":false},\"_padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_element_custom_width\":{\"unit\":\"%\",\"size\":19,\"sizes\":[]},\"_background_background\":\"classic\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"50\",\"right\":\"50\",\"bottom\":\"50\",\"left\":\"50\",\"isLinked\":true},\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\"},\"_background_color\":\"#F3EBD6\",\"typography_line_height\":{\"unit\":\"rem\",\"size\":1,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"_element_custom_width_tablet\":{\"unit\":\"px\",\"size\":89,\"sizes\":[]},\"_flex_align_self\":\"center\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"daea96c\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0622\\u062e\\u0631\\u06cc\\u0646 \\u0645\\u0642\\u0627\\u0644\\u0627\\u062a \\u0628\\u0647 \\u0631\\u0648\\u0632 \\u062f\\u0646\\u06cc\\u0627 \\u062f\\u0631 \\u062d\\u0648\\u0632\\u0647 CRM\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=secondary\",\"typography_typography\":\"\"},\"title_color\":\"#1A3760\",\"align\":\"center\",\"_margin\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhFaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":32,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"typography_font_weight\":\"700\",\"typography_line_height\":{\"unit\":\"rem\",\"size\":3,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":2.3999999999999999,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":2.3999999999999999,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"c737fe6\",\"elType\":\"widget\",\"settings\":{\"lisitng_id\":\"318\",\"posts_num\":4,\"not_found_message\":\"\\u0647\\u06cc\\u0686 \\u062f\\u0627\\u062f\\u0647 \\u0627\\u06cc \\u06cc\\u0627\\u0641\\u062a \\u0646\\u0634\\u062f\",\"posts_query\":[],\"terms_meta_query\":[],\"users_meta_query\":[],\"columns\":\"2\",\"horizontal_gap\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"_margin\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"vertical_gap\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"horizontal_gap_tablet\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"vertical_gap_tablet\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"columns_mobile\":\"1\",\"vertical_gap_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"jet-listing-grid\"}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("488", "33", "_elementor_page_assets", "a:1:{s:6:\"styles\";a:5:{i:0;s:12:\"e-animations\";i:1;s:12:\"e-animations\";i:2;s:12:\"e-animations\";i:3;s:12:\"e-animations\";i:4;s:12:\"e-animations\";}}");
INSERT INTO `wp_postmeta` VALUES("619", "138", "_wp_attached_file", "2023/10/svgexport-10.svg");
INSERT INTO `wp_postmeta` VALUES("620", "138", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:2622;s:5:\"width\";i:119;s:6:\"height\";i:119;}");
INSERT INTO `wp_postmeta` VALUES("622", "139", "_wp_attached_file", "2023/10/svgexport-11.svg");
INSERT INTO `wp_postmeta` VALUES("623", "139", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:3147;s:5:\"width\";i:121;s:6:\"height\";i:23;}");
INSERT INTO `wp_postmeta` VALUES("625", "140", "_wp_attached_file", "2023/10/svgexport-12.svg");
INSERT INTO `wp_postmeta` VALUES("626", "140", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:3740;s:5:\"width\";i:83;s:6:\"height\";i:25;}");
INSERT INTO `wp_postmeta` VALUES("628", "141", "_wp_attached_file", "2023/10/svgexport-13.svg");
INSERT INTO `wp_postmeta` VALUES("629", "141", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:3894;s:5:\"width\";i:73;s:6:\"height\";i:41;}");
INSERT INTO `wp_postmeta` VALUES("631", "142", "_wp_attached_file", "2023/10/svgexport-14.svg");
INSERT INTO `wp_postmeta` VALUES("632", "142", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:659;s:5:\"width\";i:82;s:6:\"height\";i:19;}");
INSERT INTO `wp_postmeta` VALUES("634", "143", "_wp_attached_file", "2023/10/svgexport-15.svg");
INSERT INTO `wp_postmeta` VALUES("635", "143", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:1480;s:5:\"width\";i:81;s:6:\"height\";i:24;}");
INSERT INTO `wp_postmeta` VALUES("637", "144", "_wp_attached_file", "2023/10/svgexport-16.svg");
INSERT INTO `wp_postmeta` VALUES("638", "144", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:3433;s:5:\"width\";i:98;s:6:\"height\";i:29;}");
INSERT INTO `wp_postmeta` VALUES("649", "148", "_wp_attached_file", "2023/10/svgexport-20.svg");
INSERT INTO `wp_postmeta` VALUES("650", "148", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:8757;s:5:\"width\";i:119;s:6:\"height\";i:132;}");
INSERT INTO `wp_postmeta` VALUES("670", "155", "_wp_attached_file", "2023/10/svgexport-33.svg");
INSERT INTO `wp_postmeta` VALUES("671", "155", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:1245;s:5:\"width\";i:204;s:6:\"height\";i:179;}");
INSERT INTO `wp_postmeta` VALUES("959", "41", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("960", "41", "_elementor_template_type", "wp-page");
INSERT INTO `wp_postmeta` VALUES("961", "41", "_elementor_version", "3.18.1");
INSERT INTO `wp_postmeta` VALUES("962", "41", "_elementor_pro_version", "3.18.0");
INSERT INTO `wp_postmeta` VALUES("973", "41", "_rankmath__data", "[{\"id\":\"3c8de07a\",\"elType\":\"container\",\"settings\":[],\"elements\":[{\"id\":\"608c0898\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p><!-- \\/wp:paragraph --><\\/p><p><!-- wp:paragraph --><\\/p><p><!-- \\/wp:paragraph --><\\/p><p><!-- wp:paragraph --><\\/p><p><!-- \\/wp:paragraph --><\\/p><p><style>\\/*! elementor - v3.18.0 - 06-12-2023 *\\/<br \\/>.elementor-heading-title{padding:0;margin:0;line-height:1}.elementor-widget-heading .elementor-heading-title[class*=elementor-size-]>a{color:inherit;font-size:inherit;line-height:inherit}.elementor-widget-heading .elementor-heading-title.elementor-size-small{font-size:15px}.elementor-widget-heading .elementor-heading-title.elementor-size-medium{font-size:19px}.elementor-widget-heading .elementor-heading-title.elementor-size-large{font-size:29px}.elementor-widget-heading .elementor-heading-title.elementor-size-xl{font-size:39px}.elementor-widget-heading .elementor-heading-title.elementor-size-xxl{font-size:59px}<\\/style><\\/p><h6>\\u062a\\u062c\\u0631\\u0628\\u0647 \\u062f\\u06cc\\u062c\\u06cc\\u062a\\u0627\\u0644<\\/h6><h2>\\u0647\\u0645\\u0647 \\u0686\\u06cc\\u0632 \\u062f\\u0631\\u0628\\u0627\\u0631\\u0647 \\u0646\\u0631\\u0645 \\u0627\\u0641\\u0632\\u0627\\u0631 \\u062a\\u0627\\u0628\\u0627\\u0646 CRM<\\/h2><p>\\u062a\\u0627\\u0628\\u0627\\u0646 \\u0646\\u062a\\u06cc\\u062c\\u0647\\u200c\\u06cc \\u06cc\\u06a9 \\u0646\\u06cc\\u0627\\u0632 \\u0648\\u0627\\u0642\\u0639\\u06cc \\u062f\\u0631 \\u062f\\u0644 \\u06a9\\u0633\\u0628\\u200c\\u0648\\u06a9\\u0627\\u0631\\u0647\\u0627\\u0633\\u062a\\u061b<br \\/>\\u0645\\u062d\\u0635\\u0648\\u0644 \\u0633\\u0627\\u0644\\u200c\\u0647\\u0627 \\u062a\\u062c\\u0631\\u0628\\u0647\\u200c\\u06cc \\u0645\\u06cc\\u062f\\u0627\\u0646\\u06cc \\u00ab\\u0645\\u062d\\u0645\\u062f\\u0645\\u0647\\u062f\\u06cc \\u0633\\u0627\\u0644\\u0627\\u0631\\u06cc\\u00bb \\u062f\\u0631 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a\\u060c \\u0633\\u06cc\\u0633\\u062a\\u0645\\u200c\\u0633\\u0627\\u0632\\u06cc \\u0648 \\u0628\\u0647\\u0628\\u0648\\u062f \\u0641\\u0631\\u0622\\u06cc\\u0646\\u062f\\u0647\\u0627\\u06cc \\u0639\\u0645\\u0644\\u06cc\\u0627\\u062a\\u06cc.<\\/p><p>\\u0633\\u0627\\u0644\\u0627\\u0631\\u06cc \\u0637\\u06cc \\u0628\\u06cc\\u0634 \\u0627\\u0632 \\u06cc\\u06a9 \\u062f\\u0647\\u0647 \\u0641\\u0639\\u0627\\u0644\\u06cc\\u062a \\u062f\\u0631 \\u0641\\u0636\\u0627\\u06cc \\u062e\\u062f\\u0645\\u0627\\u062a\\u06cc \\u0648 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a\\u06cc\\u060c \\u0627\\u0632 \\u0646\\u0632\\u062f\\u06cc\\u06a9 \\u0628\\u0627 \\u0686\\u0627\\u0644\\u0634\\u200c\\u0647\\u0627\\u06cc\\u06cc \\u0645\\u062b\\u0644 \\u0628\\u06cc\\u200c\\u0646\\u0638\\u0645\\u06cc \\u062f\\u0627\\u062f\\u0647\\u200c\\u0647\\u0627\\u060c \\u062e\\u0637\\u0627\\u06cc \\u0627\\u0646\\u0633\\u0627\\u0646\\u06cc\\u060c \\u0627\\u0632\\u062f\\u062d\\u0627\\u0645 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0627\\u062a\\u060c \\u06af\\u0632\\u0627\\u0631\\u0634\\u200c\\u06af\\u06cc\\u0631\\u06cc\\u200c\\u0647\\u0627\\u06cc \\u0646\\u0627\\u0642\\u0635 \\u0648 \\u0646\\u0628\\u0648\\u062f \\u06cc\\u06a9 \\u0633\\u06cc\\u0633\\u062a\\u0645 \\u06cc\\u06a9\\u067e\\u0627\\u0631\\u0686\\u0647 \\u0631\\u0648\\u0628\\u0647\\u200c\\u0631\\u0648 \\u0628\\u0648\\u062f\\u0647 \\u0627\\u0633\\u062a.<br \\/>\\u062a\\u0627\\u0628\\u0627\\u0646 \\u067e\\u0627\\u0633\\u062e\\u06cc \\u0627\\u0633\\u062a \\u0628\\u0647 \\u0647\\u0645\\u06cc\\u0646 \\u0686\\u0627\\u0644\\u0634\\u200c\\u0647\\u0627\\u061b \\u0633\\u06cc\\u0633\\u062a\\u0645\\u06cc \\u0633\\u0627\\u062f\\u0647\\u060c \\u062f\\u0642\\u06cc\\u0642 \\u0648 \\u0647\\u0648\\u0634\\u0645\\u0646\\u062f \\u06a9\\u0647 \\u0628\\u0631\\u0627\\u06cc \\u0627\\u0641\\u0632\\u0627\\u06cc\\u0634 \\u0628\\u0647\\u0631\\u0647\\u200c\\u0648\\u0631\\u06cc \\u0648 \\u06a9\\u0627\\u0647\\u0634 \\u0627\\u0633\\u062a\\u0631\\u0633 \\u0645\\u062f\\u06cc\\u0631\\u0627\\u0646 \\u0633\\u0627\\u062e\\u062a\\u0647 \\u0634\\u062f\\u0647.<\\/p><p>\\u0645\\u0623\\u0645\\u0648\\u0631\\u06cc\\u062a \\u0645\\u0627:<br \\/>\\u0633\\u0627\\u062e\\u062a \\u0627\\u0628\\u0632\\u0627\\u0631\\u06cc \\u06a9\\u0647 \\u0632\\u0646\\u062f\\u06af\\u06cc\\u0650 \\u06a9\\u0627\\u0631\\u06cc \\u0645\\u062f\\u06cc\\u0631\\u0627\\u0646 \\u0648 \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646 \\u0631\\u0627 \\u0622\\u0633\\u0627\\u0646\\u200c\\u062a\\u0631 \\u06a9\\u0646\\u062f\\u061b<br \\/>\\u0633\\u06cc\\u0633\\u062a\\u0645\\u06cc \\u06a9\\u0647 \\u0646\\u0638\\u0645\\u060c \\u0633\\u0631\\u0639\\u062a \\u0648 \\u06a9\\u0646\\u062a\\u0631\\u0644 \\u0648\\u0627\\u0642\\u0639\\u06cc \\u0631\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0633\\u0628\\u200c\\u0648\\u06a9\\u0627\\u0631 \\u06a9\\u0646\\u062f.<\\/p><p>\\u0622\\u0646\\u0686\\u0647 \\u062a\\u0627\\u0628\\u0627\\u0646 \\u0631\\u0627 \\u0645\\u062a\\u0645\\u0627\\u06cc\\u0632 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f:<\\/p><p>\\u0637\\u0631\\u0627\\u062d\\u06cc\\u200c\\u0634\\u062f\\u0647 \\u0628\\u0631 \\u0627\\u0633\\u0627\\u0633 \\u062a\\u062c\\u0631\\u0628\\u0647\\u200c\\u06cc \\u0648\\u0627\\u0642\\u0639\\u06cc\\u060c \\u0646\\u0647 \\u062a\\u0626\\u0648\\u0631\\u06cc<\\/p><p>\\u0645\\u0646\\u0627\\u0633\\u0628 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0633\\u0628\\u200c\\u0648\\u06a9\\u0627\\u0631\\u0647\\u0627\\u06cc\\u06cc \\u06a9\\u0647 \\u0628\\u0627 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0627\\u062a \\u0628\\u0627\\u0644\\u0627 \\u0648 \\u062f\\u0627\\u062f\\u0647\\u200c\\u0647\\u0627\\u06cc \\u062d\\u0633\\u0627\\u0633 \\u06a9\\u0627\\u0631 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u0646\\u062f<\\/p><p>\\u0642\\u0627\\u0628\\u0644 \\u0634\\u062e\\u0635\\u06cc\\u200c\\u0633\\u0627\\u0632\\u06cc \\u0628\\u0631\\u0627\\u06cc \\u0646\\u06cc\\u0627\\u0632 \\u0647\\u0631 \\u0633\\u0627\\u0632\\u0645\\u0627\\u0646<\\/p><p>\\u06af\\u0632\\u0627\\u0631\\u0634\\u200c\\u06af\\u06cc\\u0631\\u06cc \\u0647\\u0648\\u0634\\u0645\\u0646\\u062f \\u0648 \\u0642\\u0627\\u0628\\u0644 \\u0627\\u062a\\u06a9\\u0627<\\/p><p>\\u0633\\u0627\\u062f\\u0647 \\u0628\\u0631\\u0627\\u06cc \\u06a9\\u0627\\u0631\\u0628\\u0631\\u060c \\u0642\\u062f\\u0631\\u062a\\u0645\\u0646\\u062f \\u0628\\u0631\\u0627\\u06cc \\u0645\\u062f\\u06cc\\u0631<\\/p><p><br \\/>\\u062a\\u0627\\u0628\\u0627\\u0646 \\u0641\\u0642\\u0637 \\u06cc\\u06a9 CRM \\u0646\\u06cc\\u0633\\u062a\\u061b<br \\/>\\u06cc\\u06a9 \\u0632\\u06cc\\u0631\\u0633\\u0627\\u062e\\u062a \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a\\u06cc \\u0627\\u0633\\u062a \\u06a9\\u0647 \\u0628\\u0647 \\u0645\\u062f\\u06cc\\u0631\\u0627\\u0646 \\u06a9\\u0645\\u06a9 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f \\u0628\\u062f\\u0648\\u0646 \\u0627\\u0633\\u062a\\u0631\\u0633 \\u062a\\u0635\\u0645\\u06cc\\u0645 \\u0628\\u06af\\u06cc\\u0631\\u0646\\u062f\\u060c<br \\/>\\u0648 \\u0628\\u0647 \\u06a9\\u0627\\u0631\\u06a9\\u0646\\u0627\\u0646 \\u06a9\\u0645\\u06a9 \\u0645\\u06cc\\u200c\\u06a9\\u0646\\u062f \\u0633\\u0631\\u06cc\\u0639\\u200c\\u062a\\u0631 \\u0648 \\u0628\\u06cc\\u200c\\u062e\\u0637\\u0627 \\u06a9\\u0627\\u0631 \\u06a9\\u0646\\u0646\\u062f.<\\/p><p>\\u0645\\u0627 \\u0645\\u0639\\u062a\\u0642\\u062f\\u06cc\\u0645 \\u0647\\u0631 \\u06a9\\u0633\\u0628\\u200c\\u0648\\u06a9\\u0627\\u0631\\u06cc \\u0645\\u06cc\\u200c\\u062a\\u0648\\u0627\\u0646\\u062f \\u00ab\\u062f\\u0631 \\u0645\\u0633\\u06cc\\u0631 \\u0631\\u0634\\u062f \\u067e\\u0627\\u06cc\\u062f\\u0627\\u0631\\u00bb \\u0642\\u0631\\u0627\\u0631 \\u0628\\u06af\\u06cc\\u0631\\u062f\\u060c<br \\/>\\u0627\\u06af\\u0631 \\u0627\\u0628\\u0632\\u0627\\u0631 \\u0635\\u062d\\u06cc\\u062d \\u0648 \\u0647\\u0648\\u0634\\u0645\\u0646\\u062f \\u062f\\u0631 \\u0627\\u062e\\u062a\\u06cc\\u0627\\u0631\\u0634 \\u0628\\u0627\\u0634\\u062f.<\\/p><p><a role=\\\"button\\\"><br \\/>\\u0648\\u06cc\\u062f\\u0626\\u0648 \\u0645\\u0639\\u0631\\u0641\\u06cc<br \\/><\\/a><br \\/><a href=\\\"http:\\/\\/tabancrm.ir\\/contact-us\\/\\\"><br \\/>\\u062a\\u0645\\u0627\\u0633 \\u0628\\u0627 \\u0634\\u0631\\u06a9\\u062a<br \\/><\\/a><\\/p><p><style>\\/*! elementor - v3.18.0 - 06-12-2023 *\\/<br \\/>.elementor-widget-image{text-align:center}.elementor-widget-image a{display:inline-block}.elementor-widget-image a img[src$=\\\".svg\\\"]{width:48px}.elementor-widget-image img{vertical-align:middle;display:inline-block}<\\/style><\\/p><p><img src=\\\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/12\\/piic2.png\\\" sizes=\\\"(max-width: 772px) 100vw, 772px\\\" srcset=\\\"http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/12\\/piic2.png 772w, http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/12\\/piic2-300x300.png 300w, http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/12\\/piic2-150x150.png 150w, http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/12\\/piic2-768x770.png 768w\\\" alt=\\\"\\\" width=\\\"772\\\" height=\\\"774\\\" \\/><\\/p><p><style>\\/*! elementor - v3.18.0 - 06-12-2023 *\\/<br \\/>.elementor-counter .elementor-counter-number-wrapper{display:flex;font-size:69px;font-weight:600;line-height:1}.elementor-counter .elementor-counter-number-prefix,.elementor-counter .elementor-counter-number-suffix{flex-grow:1;white-space:pre-wrap}.elementor-counter .elementor-counter-number-prefix{text-align:left}.elementor-counter .elementor-counter-number-suffix{text-align:right}.elementor-counter .elementor-counter-title{text-align:center;font-size:19px;font-weight:400;line-height:2.5}<\\/style><\\/p><p>0<br \\/>\\u0645\\u0634\\u062a\\u0631\\u06cc \\u0631\\u0627\\u0636\\u06cc<br \\/>0<br \\/>\\u067e\\u0631\\u0648\\u0698\\u0647 \\u0645\\u0648\\u0641\\u0642<br \\/>0<br \\/>\\u0633\\u0627\\u0644 \\u062a\\u062c\\u0631\\u0628\\u0647<\\/p><h2>\\u0647\\u0631 \\u0622\\u0646\\u0686\\u0647 \\u062f\\u0627\\u0631\\u06cc\\u0645 \\u0627\\u0632 \\u0645\\u0647\\u0631 \\u0634\\u0645\\u0627\\u0633\\u062a.<\\/h2><p>\\u0628\\u0631\\u0627\\u06cc \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u062f\\u06a9\\u0645\\u0647 \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f. \\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a.<\\/p><p>\\u0627\\u0639\\u0636\\u0627\\u06cc \\u06cc\\u06a9 \\u062a\\u06cc\\u0645 \\u062d\\u0631\\u0641\\u0647 \\u0627\\u06cc<\\/p><h2>\\u0645\\u0639\\u0631\\u0641\\u06cc \\u0627\\u0639\\u0636\\u0627\\u06cc \\u062a\\u06cc\\u0645 \\u062f\\u06cc\\u062c\\u06cc\\u062a\\u0627\\u0644 \\u0645\\u0627\\u0631\\u06a9\\u062a\\u06cc\\u0646\\u06af<\\/h2><p><style>.elementor-1379 .elementor-element.elementor-element-0063173{--display:flex;--min-height:300px;--flex-direction:column;--container-widget-width:100%;--container-widget-height:initial;--container-widget-flex-grow:0;--container-widget-align-self:initial;--justify-content:flex-end;--background-transition:0.3s;--overlay-opacity:0.5;--border-radius:16px 16px 16px 16px;--padding-block-start:0rem;--padding-block-end:1rem;--padding-inline-start:0rem;--padding-inline-end:0rem;}.elementor-1379 .elementor-element.elementor-element-0063173:not(.elementor-motion-effects-element-type-background), .elementor-1379 .elementor-element.elementor-element-0063173 > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-position:center center;background-repeat:no-repeat;background-size:cover;}.elementor-1379 .elementor-element.elementor-element-0063173::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .elementor-background-video-container::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .e-con-inner > .elementor-background-video-container::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .elementor-background-slideshow::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .e-con-inner > .elementor-background-slideshow::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .elementor-motion-effects-container > .elementor-motion-effects-layer::before{--background-overlay:\'\';background-color:#7A7A7A8C;}.elementor-1379 .elementor-element.elementor-element-0063173, .elementor-1379 .elementor-element.elementor-element-0063173::before{--border-transition:0.3s;}.elementor-1379 .elementor-element.elementor-element-824384e{--display:flex;--flex-direction:row;--container-widget-width:calc( ( 1 - var( --container-widget-flex-grow ) ) * 100% );--container-widget-height:100%;--container-widget-flex-grow:1;--container-widget-align-self:stretch;--justify-content:space-between;--align-items:center;--gap:8px 8px;--background-transition:0.3s;--border-radius:12px 12px 12px 12px;box-shadow:0px 0px 10px 4px rgba(0, 0, 0, 0.07);--margin-block-start:0rem;--margin-block-end:0rem;--margin-inline-start:3rem;--margin-inline-end:0rem;--padding-block-start:0.5rem;--padding-block-end:0.5rem;--padding-inline-start:1rem;--padding-inline-end:0.5rem;}.elementor-1379 .elementor-element.elementor-element-824384e:not(.elementor-motion-effects-element-type-background), .elementor-1379 .elementor-element.elementor-element-824384e > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-color:#FFFFFF;}.elementor-1379 .elementor-element.elementor-element-824384e, .elementor-1379 .elementor-element.elementor-element-824384e::before{--border-transition:0.3s;}.elementor-1379 .elementor-element.elementor-element-b8ba16b{--display:flex;--gap:9px 9px;--background-transition:0.3s;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-1379 .elementor-element.elementor-element-b8ba16b.e-con{--flex-grow:0;--flex-shrink:0;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field__content{font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:15px;font-weight:600;text-align:left;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field{justify-content:flex-start;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field__content{color:var( --e-global-color-primary );font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:13px;font-weight:500;text-align:right;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field{justify-content:flex-start;}.elementor-1379 .elementor-element.elementor-element-eda72ff{--display:flex;--justify-content:center;--background-transition:0.3s;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating{font-size:11px;}body:not(.rtl) .elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:not(:last-of-type){margin-right:4px;}body.rtl .elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:not(:last-of-type){margin-left:4px;}.elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:before{color:var( --e-global-color-primary );}.elementor-1379 .elementor-element.elementor-element-0bd61cb.elementor-element{--flex-grow:1;--flex-shrink:0;}.jet-listing-item.single-jet-engine.elementor-page-1379 > .elementor{width:300px;margin-left:auto;margin-right:auto;}@media(min-width:768px){.elementor-1379 .elementor-element.elementor-element-824384e{--width:93%;}.elementor-1379 .elementor-element.elementor-element-b8ba16b{--width:60%;}.elementor-1379 .elementor-element.elementor-element-eda72ff{--width:40%;}}@media(max-width:1024px) and (min-width:768px){.elementor-1379 .elementor-element.elementor-element-eda72ff{--width:40%;}}@media(max-width:1024px){.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field__content{font-size:14px;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field__content{font-size:13px;}.elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating{font-size:12px;}}@media(max-width:767px){.elementor-1379 .elementor-element.elementor-element-824384e{--width:93%;--gap:0px 0px;--flex-wrap:nowrap;}.elementor-1379 .elementor-element.elementor-element-b8ba16b{--width:70%;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field__content{line-height:1.5em;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field__content{line-height:1.5em;}.elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating{font-size:10px;}body:not(.rtl) .elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:not(:last-of-type){margin-right:5px;}body.rtl .elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:not(:last-of-type){margin-left:5px;}}\\/* Start custom CSS for container, class: .elementor-element-0063173 *\\/.elementor-1379 .elementor-element.elementor-element-0063173:hover .scena {<br \\/>    transform: translateY(-7px);<br \\/>}\\/* End custom CSS *\\/<\\/style><\\/p><p>\\u062d\\u0627\\u0645\\u062f \\u0639\\u0644\\u06cc\\u0632\\u0627\\u062f\\u0647<br \\/>\\u0637\\u0631\\u0627\\u062d \\u0633\\u0627\\u06cc\\u062a<\\/p><p><style>\\/*! elementor - v3.18.0 - 06-12-2023 *\\/<br \\/>@charset \\\"UTF-8\\\";.elementor-star-rating{color:#ccd6df;font-family:eicons;display:inline-block}.elementor-star-rating i{display:inline-block;position:relative;font-style:normal;cursor:default}.elementor-star-rating i:before{content:\\\"e934\\\";display:block;font-size:inherit;font-family:inherit;position:absolute;overflow:hidden;color:#f0ad4e;top:0;right:0}.elementor-star-rating .elementor-star-empty:before{content:none}.elementor-star-rating .elementor-star-1:before{width:10%}.elementor-star-rating .elementor-star-2:before{width:20%}.elementor-star-rating .elementor-star-3:before{width:30%}.elementor-star-rating .elementor-star-4:before{width:40%}.elementor-star-rating .elementor-star-5:before{width:50%}.elementor-star-rating .elementor-star-6:before{width:60%}.elementor-star-rating .elementor-star-7:before{width:70%}.elementor-star-rating .elementor-star-8:before{width:80%}.elementor-star-rating .elementor-star-9:before{width:90%}.elementor-star-rating__wrapper{display:flex;align-items:center}.elementor-star-rating__title{margin-left:10px}.elementor-star-rating--align-right .elementor-star-rating__wrapper{text-align:right;justify-content:flex-start}.elementor-star-rating--align-left .elementor-star-rating__wrapper{text-align:left;justify-content:flex-end}.elementor-star-rating--align-center .elementor-star-rating__wrapper{text-align:center;justify-content:center}.elementor-star-rating--align-justify .elementor-star-rating__title{margin-left:auto}@media (max-width:1024px){.elementor-star-rating-tablet--align-right .elementor-star-rating__wrapper{text-align:right;justify-content:flex-start}.elementor-star-rating-tablet--align-left .elementor-star-rating__wrapper{text-align:left;justify-content:flex-end}.elementor-star-rating-tablet--align-center .elementor-star-rating__wrapper{text-align:center;justify-content:center}.elementor-star-rating-tablet--align-justify .elementor-star-rating__title{margin-left:auto}}@media (max-width:767px){.elementor-star-rating-mobile--align-right .elementor-star-rating__wrapper{text-align:right;justify-content:flex-start}.elementor-star-rating-mobile--align-left .elementor-star-rating__wrapper{text-align:left;justify-content:flex-end}.elementor-star-rating-mobile--align-center .elementor-star-rating__wrapper{text-align:center;justify-content:center}.elementor-star-rating-mobile--align-justify .elementor-star-rating__title{margin-left:auto}}.last-star{letter-spacing:0}.elementor--star-style-star_unicode .elementor-star-rating{font-family:Arial,Helvetica,sans-serif}.elementor--star-style-star_unicode .elementor-star-rating i:not(.elementor-star-empty):before{content:\\\"\\u2605\\\"}<\\/style><\\/p><p><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i> 5\\/5<\\/p><p><style>.elementor-1379 .elementor-element.elementor-element-0063173{--display:flex;--min-height:300px;--flex-direction:column;--container-widget-width:100%;--container-widget-height:initial;--container-widget-flex-grow:0;--container-widget-align-self:initial;--justify-content:flex-end;--background-transition:0.3s;--overlay-opacity:0.5;--border-radius:16px 16px 16px 16px;--padding-block-start:0rem;--padding-block-end:1rem;--padding-inline-start:0rem;--padding-inline-end:0rem;}.elementor-1379 .elementor-element.elementor-element-0063173:not(.elementor-motion-effects-element-type-background), .elementor-1379 .elementor-element.elementor-element-0063173 > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-position:center center;background-repeat:no-repeat;background-size:cover;}.elementor-1379 .elementor-element.elementor-element-0063173::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .elementor-background-video-container::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .e-con-inner > .elementor-background-video-container::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .elementor-background-slideshow::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .e-con-inner > .elementor-background-slideshow::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .elementor-motion-effects-container > .elementor-motion-effects-layer::before{--background-overlay:\'\';background-color:#7A7A7A8C;}.elementor-1379 .elementor-element.elementor-element-0063173, .elementor-1379 .elementor-element.elementor-element-0063173::before{--border-transition:0.3s;}.elementor-1379 .elementor-element.elementor-element-824384e{--display:flex;--flex-direction:row;--container-widget-width:calc( ( 1 - var( --container-widget-flex-grow ) ) * 100% );--container-widget-height:100%;--container-widget-flex-grow:1;--container-widget-align-self:stretch;--justify-content:space-between;--align-items:center;--gap:8px 8px;--background-transition:0.3s;--border-radius:12px 12px 12px 12px;box-shadow:0px 0px 10px 4px rgba(0, 0, 0, 0.07);--margin-block-start:0rem;--margin-block-end:0rem;--margin-inline-start:3rem;--margin-inline-end:0rem;--padding-block-start:0.5rem;--padding-block-end:0.5rem;--padding-inline-start:1rem;--padding-inline-end:0.5rem;}.elementor-1379 .elementor-element.elementor-element-824384e:not(.elementor-motion-effects-element-type-background), .elementor-1379 .elementor-element.elementor-element-824384e > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-color:#FFFFFF;}.elementor-1379 .elementor-element.elementor-element-824384e, .elementor-1379 .elementor-element.elementor-element-824384e::before{--border-transition:0.3s;}.elementor-1379 .elementor-element.elementor-element-b8ba16b{--display:flex;--gap:9px 9px;--background-transition:0.3s;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-1379 .elementor-element.elementor-element-b8ba16b.e-con{--flex-grow:0;--flex-shrink:0;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field__content{font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:15px;font-weight:600;text-align:left;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field{justify-content:flex-start;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field__content{color:var( --e-global-color-primary );font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:13px;font-weight:500;text-align:right;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field{justify-content:flex-start;}.elementor-1379 .elementor-element.elementor-element-eda72ff{--display:flex;--justify-content:center;--background-transition:0.3s;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating{font-size:11px;}body:not(.rtl) .elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:not(:last-of-type){margin-right:4px;}body.rtl .elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:not(:last-of-type){margin-left:4px;}.elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:before{color:var( --e-global-color-primary );}.elementor-1379 .elementor-element.elementor-element-0bd61cb.elementor-element{--flex-grow:1;--flex-shrink:0;}.jet-listing-item.single-jet-engine.elementor-page-1379 > .elementor{width:300px;margin-left:auto;margin-right:auto;}@media(min-width:768px){.elementor-1379 .elementor-element.elementor-element-824384e{--width:93%;}.elementor-1379 .elementor-element.elementor-element-b8ba16b{--width:60%;}.elementor-1379 .elementor-element.elementor-element-eda72ff{--width:40%;}}@media(max-width:1024px) and (min-width:768px){.elementor-1379 .elementor-element.elementor-element-eda72ff{--width:40%;}}@media(max-width:1024px){.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field__content{font-size:14px;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field__content{font-size:13px;}.elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating{font-size:12px;}}@media(max-width:767px){.elementor-1379 .elementor-element.elementor-element-824384e{--width:93%;--gap:0px 0px;--flex-wrap:nowrap;}.elementor-1379 .elementor-element.elementor-element-b8ba16b{--width:70%;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field__content{line-height:1.5em;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field__content{line-height:1.5em;}.elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating{font-size:10px;}body:not(.rtl) .elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:not(:last-of-type){margin-right:5px;}body.rtl .elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:not(:last-of-type){margin-left:5px;}}\\/* Start custom CSS for container, class: .elementor-element-0063173 *\\/.elementor-1379 .elementor-element.elementor-element-0063173:hover .scena {<br \\/>    transform: translateY(-7px);<br \\/>}\\/* End custom CSS *\\/<\\/style><\\/p><p>\\u0645\\u0647\\u062f\\u06cc \\u0646\\u0638\\u0631\\u06cc<br \\/>\\u0637\\u0631\\u0627\\u062d ui\\/ux<br \\/><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i> 5\\/5<\\/p><p><style>.elementor-1379 .elementor-element.elementor-element-0063173{--display:flex;--min-height:300px;--flex-direction:column;--container-widget-width:100%;--container-widget-height:initial;--container-widget-flex-grow:0;--container-widget-align-self:initial;--justify-content:flex-end;--background-transition:0.3s;--overlay-opacity:0.5;--border-radius:16px 16px 16px 16px;--padding-block-start:0rem;--padding-block-end:1rem;--padding-inline-start:0rem;--padding-inline-end:0rem;}.elementor-1379 .elementor-element.elementor-element-0063173:not(.elementor-motion-effects-element-type-background), .elementor-1379 .elementor-element.elementor-element-0063173 > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-position:center center;background-repeat:no-repeat;background-size:cover;}.elementor-1379 .elementor-element.elementor-element-0063173::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .elementor-background-video-container::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .e-con-inner > .elementor-background-video-container::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .elementor-background-slideshow::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .e-con-inner > .elementor-background-slideshow::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .elementor-motion-effects-container > .elementor-motion-effects-layer::before{--background-overlay:\'\';background-color:#7A7A7A8C;}.elementor-1379 .elementor-element.elementor-element-0063173, .elementor-1379 .elementor-element.elementor-element-0063173::before{--border-transition:0.3s;}.elementor-1379 .elementor-element.elementor-element-824384e{--display:flex;--flex-direction:row;--container-widget-width:calc( ( 1 - var( --container-widget-flex-grow ) ) * 100% );--container-widget-height:100%;--container-widget-flex-grow:1;--container-widget-align-self:stretch;--justify-content:space-between;--align-items:center;--gap:8px 8px;--background-transition:0.3s;--border-radius:12px 12px 12px 12px;box-shadow:0px 0px 10px 4px rgba(0, 0, 0, 0.07);--margin-block-start:0rem;--margin-block-end:0rem;--margin-inline-start:3rem;--margin-inline-end:0rem;--padding-block-start:0.5rem;--padding-block-end:0.5rem;--padding-inline-start:1rem;--padding-inline-end:0.5rem;}.elementor-1379 .elementor-element.elementor-element-824384e:not(.elementor-motion-effects-element-type-background), .elementor-1379 .elementor-element.elementor-element-824384e > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-color:#FFFFFF;}.elementor-1379 .elementor-element.elementor-element-824384e, .elementor-1379 .elementor-element.elementor-element-824384e::before{--border-transition:0.3s;}.elementor-1379 .elementor-element.elementor-element-b8ba16b{--display:flex;--gap:9px 9px;--background-transition:0.3s;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-1379 .elementor-element.elementor-element-b8ba16b.e-con{--flex-grow:0;--flex-shrink:0;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field__content{font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:15px;font-weight:600;text-align:left;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field{justify-content:flex-start;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field__content{color:var( --e-global-color-primary );font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:13px;font-weight:500;text-align:right;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field{justify-content:flex-start;}.elementor-1379 .elementor-element.elementor-element-eda72ff{--display:flex;--justify-content:center;--background-transition:0.3s;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating{font-size:11px;}body:not(.rtl) .elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:not(:last-of-type){margin-right:4px;}body.rtl .elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:not(:last-of-type){margin-left:4px;}.elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:before{color:var( --e-global-color-primary );}.elementor-1379 .elementor-element.elementor-element-0bd61cb.elementor-element{--flex-grow:1;--flex-shrink:0;}.jet-listing-item.single-jet-engine.elementor-page-1379 > .elementor{width:300px;margin-left:auto;margin-right:auto;}@media(min-width:768px){.elementor-1379 .elementor-element.elementor-element-824384e{--width:93%;}.elementor-1379 .elementor-element.elementor-element-b8ba16b{--width:60%;}.elementor-1379 .elementor-element.elementor-element-eda72ff{--width:40%;}}@media(max-width:1024px) and (min-width:768px){.elementor-1379 .elementor-element.elementor-element-eda72ff{--width:40%;}}@media(max-width:1024px){.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field__content{font-size:14px;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field__content{font-size:13px;}.elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating{font-size:12px;}}@media(max-width:767px){.elementor-1379 .elementor-element.elementor-element-824384e{--width:93%;--gap:0px 0px;--flex-wrap:nowrap;}.elementor-1379 .elementor-element.elementor-element-b8ba16b{--width:70%;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field__content{line-height:1.5em;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field__content{line-height:1.5em;}.elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating{font-size:10px;}body:not(.rtl) .elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:not(:last-of-type){margin-right:5px;}body.rtl .elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:not(:last-of-type){margin-left:5px;}}\\/* Start custom CSS for container, class: .elementor-element-0063173 *\\/.elementor-1379 .elementor-element.elementor-element-0063173:hover .scena {<br \\/>    transform: translateY(-7px);<br \\/>}\\/* End custom CSS *\\/<\\/style><\\/p><p>\\u0633\\u0647\\u06cc\\u0644 \\u0631\\u0633\\u0648\\u0644\\u06cc<br \\/>\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 \\u0646\\u0648\\u06cc\\u0633 \\u0641\\u0631\\u0627\\u0646\\u062a \\u0627\\u0646\\u062f<br \\/><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i> 5\\/5<\\/p><p><style>.elementor-1379 .elementor-element.elementor-element-0063173{--display:flex;--min-height:300px;--flex-direction:column;--container-widget-width:100%;--container-widget-height:initial;--container-widget-flex-grow:0;--container-widget-align-self:initial;--justify-content:flex-end;--background-transition:0.3s;--overlay-opacity:0.5;--border-radius:16px 16px 16px 16px;--padding-block-start:0rem;--padding-block-end:1rem;--padding-inline-start:0rem;--padding-inline-end:0rem;}.elementor-1379 .elementor-element.elementor-element-0063173:not(.elementor-motion-effects-element-type-background), .elementor-1379 .elementor-element.elementor-element-0063173 > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-position:center center;background-repeat:no-repeat;background-size:cover;}.elementor-1379 .elementor-element.elementor-element-0063173::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .elementor-background-video-container::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .e-con-inner > .elementor-background-video-container::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .elementor-background-slideshow::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .e-con-inner > .elementor-background-slideshow::before, .elementor-1379 .elementor-element.elementor-element-0063173 > .elementor-motion-effects-container > .elementor-motion-effects-layer::before{--background-overlay:\'\';background-color:#7A7A7A8C;}.elementor-1379 .elementor-element.elementor-element-0063173, .elementor-1379 .elementor-element.elementor-element-0063173::before{--border-transition:0.3s;}.elementor-1379 .elementor-element.elementor-element-824384e{--display:flex;--flex-direction:row;--container-widget-width:calc( ( 1 - var( --container-widget-flex-grow ) ) * 100% );--container-widget-height:100%;--container-widget-flex-grow:1;--container-widget-align-self:stretch;--justify-content:space-between;--align-items:center;--gap:8px 8px;--background-transition:0.3s;--border-radius:12px 12px 12px 12px;box-shadow:0px 0px 10px 4px rgba(0, 0, 0, 0.07);--margin-block-start:0rem;--margin-block-end:0rem;--margin-inline-start:3rem;--margin-inline-end:0rem;--padding-block-start:0.5rem;--padding-block-end:0.5rem;--padding-inline-start:1rem;--padding-inline-end:0.5rem;}.elementor-1379 .elementor-element.elementor-element-824384e:not(.elementor-motion-effects-element-type-background), .elementor-1379 .elementor-element.elementor-element-824384e > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-color:#FFFFFF;}.elementor-1379 .elementor-element.elementor-element-824384e, .elementor-1379 .elementor-element.elementor-element-824384e::before{--border-transition:0.3s;}.elementor-1379 .elementor-element.elementor-element-b8ba16b{--display:flex;--gap:9px 9px;--background-transition:0.3s;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-1379 .elementor-element.elementor-element-b8ba16b.e-con{--flex-grow:0;--flex-shrink:0;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field__content{font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:15px;font-weight:600;text-align:left;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field{justify-content:flex-start;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field__content{color:var( --e-global-color-primary );font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:13px;font-weight:500;text-align:right;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field{justify-content:flex-start;}.elementor-1379 .elementor-element.elementor-element-eda72ff{--display:flex;--justify-content:center;--background-transition:0.3s;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating{font-size:11px;}body:not(.rtl) .elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:not(:last-of-type){margin-right:4px;}body.rtl .elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:not(:last-of-type){margin-left:4px;}.elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:before{color:var( --e-global-color-primary );}.elementor-1379 .elementor-element.elementor-element-0bd61cb.elementor-element{--flex-grow:1;--flex-shrink:0;}.jet-listing-item.single-jet-engine.elementor-page-1379 > .elementor{width:300px;margin-left:auto;margin-right:auto;}@media(min-width:768px){.elementor-1379 .elementor-element.elementor-element-824384e{--width:93%;}.elementor-1379 .elementor-element.elementor-element-b8ba16b{--width:60%;}.elementor-1379 .elementor-element.elementor-element-eda72ff{--width:40%;}}@media(max-width:1024px) and (min-width:768px){.elementor-1379 .elementor-element.elementor-element-eda72ff{--width:40%;}}@media(max-width:1024px){.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field__content{font-size:14px;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field__content{font-size:13px;}.elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating{font-size:12px;}}@media(max-width:767px){.elementor-1379 .elementor-element.elementor-element-824384e{--width:93%;--gap:0px 0px;--flex-wrap:nowrap;}.elementor-1379 .elementor-element.elementor-element-b8ba16b{--width:70%;}.elementor-1379 .elementor-element.elementor-element-10772d6 .jet-listing-dynamic-field__content{line-height:1.5em;}.elementor-1379 .elementor-element.elementor-element-4a7d99d .jet-listing-dynamic-field__content{line-height:1.5em;}.elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating{font-size:10px;}body:not(.rtl) .elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:not(:last-of-type){margin-right:5px;}body.rtl .elementor-1379 .elementor-element.elementor-element-0bd61cb .elementor-star-rating i:not(:last-of-type){margin-left:5px;}}\\/* Start custom CSS for container, class: .elementor-element-0063173 *\\/.elementor-1379 .elementor-element.elementor-element-0063173:hover .scena {<br \\/>    transform: translateY(-7px);<br \\/>}\\/* End custom CSS *\\/<\\/style><\\/p><p>\\u0627\\u06cc\\u0645\\u0627\\u0646 \\u0627\\u0641\\u0636\\u0644\\u06cc<br \\/>\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 \\u0646\\u0648\\u06cc\\u0633 \\u0628\\u06a9 \\u0627\\u0646\\u062f<br \\/><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i> 5\\/5<\\/p><h2>\\u0646\\u0638\\u0631\\u0627\\u062a \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646 \\u0645\\u0627<\\/h2><h2>\\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646 \\u062f\\u0631\\u0628\\u0627\\u0631\\u0647 \\u0645\\u0627 \\u0686\\u0647 \\u0645\\u06cc \\u06af\\u0648\\u06cc\\u0646\\u062f\\u061f!<\\/h2><p>\\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a.<\\/p><p><style>.elementor-1277 .elementor-element.elementor-element-5a381ef{--display:flex;--flex-direction:column;--container-widget-width:100%;--container-widget-height:initial;--container-widget-flex-grow:0;--container-widget-align-self:initial;--background-transition:0.3s;--border-radius:20px 20px 20px 20px;box-shadow:0px 0px 10px 4px rgba(0, 0, 0, 0.07);--margin-block-start:1.8rem;--margin-block-end:0rem;--margin-inline-start:0rem;--margin-inline-end:0rem;--padding-block-start:1rem;--padding-block-end:1rem;--padding-inline-start:1rem;--padding-inline-end:1rem;}.elementor-1277 .elementor-element.elementor-element-5a381ef:not(.elementor-motion-effects-element-type-background), .elementor-1277 .elementor-element.elementor-element-5a381ef > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-color:#FFFFFF;}.elementor-1277 .elementor-element.elementor-element-5a381ef, .elementor-1277 .elementor-element.elementor-element-5a381ef::before{--border-transition:0.3s;}.elementor-1277 .elementor-element.elementor-element-f4d9905{--display:flex;--flex-direction:row;--container-widget-width:initial;--container-widget-height:100%;--container-widget-flex-grow:1;--container-widget-align-self:stretch;--justify-content:space-between;--gap:0px 0px;--background-transition:0.3s;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-1277 .elementor-element.elementor-element-e810113 .jet-listing-dynamic-field__content{font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:14px;font-weight:600;text-align:left;}.elementor-1277 .elementor-element.elementor-element-e810113 .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-1277 .elementor-element.elementor-element-e810113 .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-1277 .elementor-element.elementor-element-e810113 .jet-listing-dynamic-field{justify-content:flex-start;}.elementor-1277 .elementor-element.elementor-element-b60a425{--display:flex;--align-items:center;--container-widget-width:calc( ( 1 - var( --container-widget-flex-grow ) ) * 100% );--background-transition:0.3s;}.elementor-1277 .elementor-element.elementor-element-8357da7 img{width:85%;border-radius:50px 50px 50px 50px;}.elementor-1277 .elementor-element.elementor-element-8357da7 > .elementor-widget-container{margin:-3rem 0rem 0rem 0rem;}.elementor-1277 .elementor-element.elementor-element-8357da7.elementor-element{--flex-grow:0;--flex-shrink:0;}.elementor-1277 .elementor-element.elementor-element-90ab63a .elementor-star-rating{font-size:13px;}body:not(.rtl) .elementor-1277 .elementor-element.elementor-element-90ab63a .elementor-star-rating i:not(:last-of-type){margin-right:5px;}body.rtl .elementor-1277 .elementor-element.elementor-element-90ab63a .elementor-star-rating i:not(:last-of-type){margin-left:5px;}.elementor-1277 .elementor-element.elementor-element-90ab63a .elementor-star-rating i:before{color:var( --e-global-color-primary );}.elementor-1277 .elementor-element.elementor-element-1369a6a .jet-listing-dynamic-field__content{color:var( --e-global-color-text );font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:13px;font-weight:400;line-height:1.8rem;text-align:right;}.elementor-1277 .elementor-element.elementor-element-1369a6a .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-1277 .elementor-element.elementor-element-1369a6a .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-1277 .elementor-element.elementor-element-1369a6a .jet-listing-dynamic-field{justify-content:flex-start;}.jet-listing-item.single-jet-engine.elementor-page-1277 > .elementor{width:450px;margin-left:auto;margin-right:auto;}@media(min-width:768px){.elementor-1277 .elementor-element.elementor-element-b60a425{--width:28%;}}@media(max-width:767px){.elementor-1277 .elementor-element.elementor-element-e810113 .jet-listing-dynamic-field__content{font-size:13px;}.elementor-1277 .elementor-element.elementor-element-b60a425{--width:30%;--justify-content:center;--gap:0px 0px;}.elementor-1277 .elementor-element.elementor-element-8357da7 img{width:100%;}.elementor-1277 .elementor-element.elementor-element-90ab63a .elementor-star-rating{font-size:12px;}.elementor-1277 .elementor-element.elementor-element-1369a6a .jet-listing-dynamic-field__content{font-size:12px;}}<\\/style><\\/p><p>\\u06a9\\u0648\\u0631\\u0648\\u0634 \\u0645\\u062d\\u0645\\u0648\\u062f\\u06cc<br \\/><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i> 5\\/5<br \\/>\\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u0640\\u0640\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e\\u060c \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u0640\\u0640\\u06a9 \\u0627\\u0633\\u062a\\u060c \\u0686\\u0627\\u067e\\u06af\\u0631\\u0647\\u0627 \\u0648 \\u0645\\u062a\\u0648\\u0646 \\u0628\\u0644\\u06a9\\u0647 \\u0631\\u0648\\u0632\\u0646\\u0627\\u0645\\u0647 \\u0648 \\u0645\\u062c\\u0644\\u0647 \\u0627\\u0633\\u062a.<\\/p><p><style>.elementor-1277 .elementor-element.elementor-element-5a381ef{--display:flex;--flex-direction:column;--container-widget-width:100%;--container-widget-height:initial;--container-widget-flex-grow:0;--container-widget-align-self:initial;--background-transition:0.3s;--border-radius:20px 20px 20px 20px;box-shadow:0px 0px 10px 4px rgba(0, 0, 0, 0.07);--margin-block-start:1.8rem;--margin-block-end:0rem;--margin-inline-start:0rem;--margin-inline-end:0rem;--padding-block-start:1rem;--padding-block-end:1rem;--padding-inline-start:1rem;--padding-inline-end:1rem;}.elementor-1277 .elementor-element.elementor-element-5a381ef:not(.elementor-motion-effects-element-type-background), .elementor-1277 .elementor-element.elementor-element-5a381ef > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-color:#FFFFFF;}.elementor-1277 .elementor-element.elementor-element-5a381ef, .elementor-1277 .elementor-element.elementor-element-5a381ef::before{--border-transition:0.3s;}.elementor-1277 .elementor-element.elementor-element-f4d9905{--display:flex;--flex-direction:row;--container-widget-width:initial;--container-widget-height:100%;--container-widget-flex-grow:1;--container-widget-align-self:stretch;--justify-content:space-between;--gap:0px 0px;--background-transition:0.3s;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-1277 .elementor-element.elementor-element-e810113 .jet-listing-dynamic-field__content{font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:14px;font-weight:600;text-align:left;}.elementor-1277 .elementor-element.elementor-element-e810113 .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-1277 .elementor-element.elementor-element-e810113 .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-1277 .elementor-element.elementor-element-e810113 .jet-listing-dynamic-field{justify-content:flex-start;}.elementor-1277 .elementor-element.elementor-element-b60a425{--display:flex;--align-items:center;--container-widget-width:calc( ( 1 - var( --container-widget-flex-grow ) ) * 100% );--background-transition:0.3s;}.elementor-1277 .elementor-element.elementor-element-8357da7 img{width:85%;border-radius:50px 50px 50px 50px;}.elementor-1277 .elementor-element.elementor-element-8357da7 > .elementor-widget-container{margin:-3rem 0rem 0rem 0rem;}.elementor-1277 .elementor-element.elementor-element-8357da7.elementor-element{--flex-grow:0;--flex-shrink:0;}.elementor-1277 .elementor-element.elementor-element-90ab63a .elementor-star-rating{font-size:13px;}body:not(.rtl) .elementor-1277 .elementor-element.elementor-element-90ab63a .elementor-star-rating i:not(:last-of-type){margin-right:5px;}body.rtl .elementor-1277 .elementor-element.elementor-element-90ab63a .elementor-star-rating i:not(:last-of-type){margin-left:5px;}.elementor-1277 .elementor-element.elementor-element-90ab63a .elementor-star-rating i:before{color:var( --e-global-color-primary );}.elementor-1277 .elementor-element.elementor-element-1369a6a .jet-listing-dynamic-field__content{color:var( --e-global-color-text );font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:13px;font-weight:400;line-height:1.8rem;text-align:right;}.elementor-1277 .elementor-element.elementor-element-1369a6a .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-1277 .elementor-element.elementor-element-1369a6a .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-1277 .elementor-element.elementor-element-1369a6a .jet-listing-dynamic-field{justify-content:flex-start;}.jet-listing-item.single-jet-engine.elementor-page-1277 > .elementor{width:450px;margin-left:auto;margin-right:auto;}@media(min-width:768px){.elementor-1277 .elementor-element.elementor-element-b60a425{--width:28%;}}@media(max-width:767px){.elementor-1277 .elementor-element.elementor-element-e810113 .jet-listing-dynamic-field__content{font-size:13px;}.elementor-1277 .elementor-element.elementor-element-b60a425{--width:30%;--justify-content:center;--gap:0px 0px;}.elementor-1277 .elementor-element.elementor-element-8357da7 img{width:100%;}.elementor-1277 .elementor-element.elementor-element-90ab63a .elementor-star-rating{font-size:12px;}.elementor-1277 .elementor-element.elementor-element-1369a6a .jet-listing-dynamic-field__content{font-size:12px;}}<\\/style><\\/p><p>\\u0633\\u0645\\u0627\\u0646\\u0647 \\u0645\\u062d\\u0645\\u0648\\u062f\\u06cc<br \\/><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i> 5\\/5<br \\/>\\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u0640\\u0640\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e\\u060c \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u0640\\u0640\\u06a9 \\u0627\\u0633\\u062a\\u060c \\u0686\\u0627\\u067e\\u06af\\u0631\\u0647\\u0627 \\u0648 \\u0645\\u062a\\u0648\\u0646 \\u0628\\u0644\\u06a9\\u0647 \\u0631\\u0648\\u0632\\u0646\\u0627\\u0645\\u0647 \\u0648 \\u0645\\u062c\\u0644\\u0647 \\u0627\\u0633\\u062a.<\\/p><p><style>.elementor-1277 .elementor-element.elementor-element-5a381ef{--display:flex;--flex-direction:column;--container-widget-width:100%;--container-widget-height:initial;--container-widget-flex-grow:0;--container-widget-align-self:initial;--background-transition:0.3s;--border-radius:20px 20px 20px 20px;box-shadow:0px 0px 10px 4px rgba(0, 0, 0, 0.07);--margin-block-start:1.8rem;--margin-block-end:0rem;--margin-inline-start:0rem;--margin-inline-end:0rem;--padding-block-start:1rem;--padding-block-end:1rem;--padding-inline-start:1rem;--padding-inline-end:1rem;}.elementor-1277 .elementor-element.elementor-element-5a381ef:not(.elementor-motion-effects-element-type-background), .elementor-1277 .elementor-element.elementor-element-5a381ef > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-color:#FFFFFF;}.elementor-1277 .elementor-element.elementor-element-5a381ef, .elementor-1277 .elementor-element.elementor-element-5a381ef::before{--border-transition:0.3s;}.elementor-1277 .elementor-element.elementor-element-f4d9905{--display:flex;--flex-direction:row;--container-widget-width:initial;--container-widget-height:100%;--container-widget-flex-grow:1;--container-widget-align-self:stretch;--justify-content:space-between;--gap:0px 0px;--background-transition:0.3s;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-1277 .elementor-element.elementor-element-e810113 .jet-listing-dynamic-field__content{font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:14px;font-weight:600;text-align:left;}.elementor-1277 .elementor-element.elementor-element-e810113 .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-1277 .elementor-element.elementor-element-e810113 .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-1277 .elementor-element.elementor-element-e810113 .jet-listing-dynamic-field{justify-content:flex-start;}.elementor-1277 .elementor-element.elementor-element-b60a425{--display:flex;--align-items:center;--container-widget-width:calc( ( 1 - var( --container-widget-flex-grow ) ) * 100% );--background-transition:0.3s;}.elementor-1277 .elementor-element.elementor-element-8357da7 img{width:85%;border-radius:50px 50px 50px 50px;}.elementor-1277 .elementor-element.elementor-element-8357da7 > .elementor-widget-container{margin:-3rem 0rem 0rem 0rem;}.elementor-1277 .elementor-element.elementor-element-8357da7.elementor-element{--flex-grow:0;--flex-shrink:0;}.elementor-1277 .elementor-element.elementor-element-90ab63a .elementor-star-rating{font-size:13px;}body:not(.rtl) .elementor-1277 .elementor-element.elementor-element-90ab63a .elementor-star-rating i:not(:last-of-type){margin-right:5px;}body.rtl .elementor-1277 .elementor-element.elementor-element-90ab63a .elementor-star-rating i:not(:last-of-type){margin-left:5px;}.elementor-1277 .elementor-element.elementor-element-90ab63a .elementor-star-rating i:before{color:var( --e-global-color-primary );}.elementor-1277 .elementor-element.elementor-element-1369a6a .jet-listing-dynamic-field__content{color:var( --e-global-color-text );font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:13px;font-weight:400;line-height:1.8rem;text-align:right;}.elementor-1277 .elementor-element.elementor-element-1369a6a .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-1277 .elementor-element.elementor-element-1369a6a .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-1277 .elementor-element.elementor-element-1369a6a .jet-listing-dynamic-field{justify-content:flex-start;}.jet-listing-item.single-jet-engine.elementor-page-1277 > .elementor{width:450px;margin-left:auto;margin-right:auto;}@media(min-width:768px){.elementor-1277 .elementor-element.elementor-element-b60a425{--width:28%;}}@media(max-width:767px){.elementor-1277 .elementor-element.elementor-element-e810113 .jet-listing-dynamic-field__content{font-size:13px;}.elementor-1277 .elementor-element.elementor-element-b60a425{--width:30%;--justify-content:center;--gap:0px 0px;}.elementor-1277 .elementor-element.elementor-element-8357da7 img{width:100%;}.elementor-1277 .elementor-element.elementor-element-90ab63a .elementor-star-rating{font-size:12px;}.elementor-1277 .elementor-element.elementor-element-1369a6a .jet-listing-dynamic-field__content{font-size:12px;}}<\\/style><\\/p><p>\\u0645\\u0648\\u0646\\u0627 \\u0644\\u0637\\u0641\\u06cc<br \\/><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i><i>\\ue934<\\/i> 5\\/5<br \\/>\\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u0640\\u0640\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e\\u060c \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u0640\\u0640\\u06a9 \\u0627\\u0633\\u062a\\u060c \\u0686\\u0627\\u067e\\u06af\\u0631\\u0647\\u0627 \\u0648 \\u0645\\u062a\\u0648\\u0646 \\u0628\\u0644\\u06a9\\u0647 \\u0631\\u0648\\u0632\\u0646\\u0627\\u0645\\u0647 \\u0648 \\u0645\\u062c\\u0644\\u0647 \\u0627\\u0633\\u062a.<\\/p><p>\\u0645\\u0627 \\u06cc\\u06a9 \\u0622\\u0698\\u0627\\u0646\\u0633 \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc \\u0647\\u0633\\u062a\\u06cc\\u0645!<\\/p><h2>\\u0622\\u062e\\u0631\\u06cc\\u0646 \\u0645\\u0642\\u0627\\u0644\\u0627\\u062a \\u0628\\u0647 \\u0631\\u0648\\u0632 \\u062f\\u0646\\u06cc\\u0627 \\u062f\\u0631 \\u062d\\u0648\\u0632\\u0647 \\u062f\\u06cc\\u062c\\u06cc\\u062a\\u0627\\u0644 \\u0645\\u0627\\u0631\\u06a9\\u062a\\u06cc\\u0646\\u06af<\\/h2><p><style>.elementor-318 .elementor-element.elementor-element-d22d862{--display:flex;--flex-direction:row;--container-widget-width:initial;--container-widget-height:100%;--container-widget-flex-grow:1;--container-widget-align-self:stretch;--gap:0px 0px;--background-transition:0.3s;--margin-block-start:0rem;--margin-block-end:0rem;--margin-inline-start:0rem;--margin-inline-end:0rem;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-318 .elementor-element.elementor-element-fa83e65{--display:flex;--justify-content:center;--background-transition:0.3s;--border-radius:20px 20px 20px 20px;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-318 .elementor-element.elementor-element-fa83e65:not(.elementor-motion-effects-element-type-background), .elementor-318 .elementor-element.elementor-element-fa83e65 > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-position:center center;background-repeat:no-repeat;background-size:cover;}.elementor-318 .elementor-element.elementor-element-fa83e65, .elementor-318 .elementor-element.elementor-element-fa83e65::before{--border-transition:0.3s;}.elementor-318 .elementor-element.elementor-element-acfd788 img{width:100%;height:220px;object-fit:cover;object-position:center center;border-radius:20px 20px 20px 20px;}.elementor-318 .elementor-element.elementor-element-fa1c38c{--display:flex;--justify-content:center;--gap:0px 0px;--background-transition:0.3s;--padding-block-start:0rem;--padding-block-end:0rem;--padding-inline-start:0rem;--padding-inline-end:0rem;}.elementor-318 .elementor-element.elementor-element-0e0eb52{--display:flex;--justify-content:center;--gap:10px 10px;--background-transition:0.3s;--border-radius:16px 0px 0px 16px;box-shadow:0px 0px 10px 4px rgba(0, 0, 0, 0.07);--margin-block-start:0rem;--margin-block-end:0rem;--margin-inline-start:0rem;--margin-inline-end:0rem;--padding-block-start:1rem;--padding-block-end:1rem;--padding-inline-start:1rem;--padding-inline-end:1rem;}.elementor-318 .elementor-element.elementor-element-0e0eb52:not(.elementor-motion-effects-element-type-background), .elementor-318 .elementor-element.elementor-element-0e0eb52 > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-color:#FAFAFA;}.elementor-318 .elementor-element.elementor-element-0e0eb52, .elementor-318 .elementor-element.elementor-element-0e0eb52::before{--border-transition:0.3s;}.elementor-318 .elementor-element.elementor-element-a6e74aa .elementor-heading-title{color:var( --e-global-color-secondary );font-family:\\\"YekanBakhFaNum\\\", Sans-serif;font-size:17px;font-weight:700;line-height:0em;}.elementor-318 .elementor-element.elementor-element-a6e74aa > .elementor-widget-container{margin:0rem 0rem 0rem 0rem;padding:0px 0px 0px 0px;}.elementor-318 .elementor-element.elementor-element-79c73da .jet-listing-dynamic-field__content{color:var( --e-global-color-text );font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:13px;font-weight:400;line-height:1.6rem;text-align:right;}.elementor-318 .elementor-element.elementor-element-79c73da .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-318 .elementor-element.elementor-element-79c73da .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-318 .elementor-element.elementor-element-79c73da .jet-listing-dynamic-field{justify-content:flex-start;}.elementor-318 .elementor-element.elementor-element-e095367{--display:flex;--flex-direction:row;--container-widget-width:calc( ( 1 - var( --container-widget-flex-grow ) ) * 100% );--container-widget-height:100%;--container-widget-flex-grow:1;--container-widget-align-self:stretch;--justify-content:space-between;--align-items:center;--background-transition:0.3s;--margin-block-start:0.7rem;--margin-block-end:0rem;--margin-inline-start:0rem;--margin-inline-end:0rem;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-icon i{color:var( --e-global-color-text );font-size:12px;}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-icon svg{fill:var( --e-global-color-text );--e-icon-list-icon-size:12px;}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-icon{width:12px;}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-text, .elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-text a{color:var( --e-global-color-text );}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-item{font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:12px;font-weight:600;}.elementor-318 .elementor-element.elementor-element-4996846 .elementor-button{font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:13px;font-weight:600;fill:#FFFFFF;color:#FFFFFF;background-color:var( --e-global-color-primary );border-style:solid;border-width:1px 1px 1px 1px;border-radius:12px 12px 12px 12px;padding:9px 11px 5px 11px;}.elementor-318 .elementor-element.elementor-element-4996846 .elementor-button:hover, .elementor-318 .elementor-element.elementor-element-4996846 .elementor-button:focus{color:var( --e-global-color-primary );background-color:var( --e-global-color-accent );border-color:var( --e-global-color-primary );}.elementor-318 .elementor-element.elementor-element-4996846 .elementor-button:hover svg, .elementor-318 .elementor-element.elementor-element-4996846 .elementor-button:focus svg{fill:var( --e-global-color-primary );}.jet-listing-item.single-jet-engine.elementor-page-318 > .elementor{width:626px;margin-left:auto;margin-right:auto;}@media(max-width:1024px){.elementor-318 .elementor-element.elementor-element-d22d862{--justify-content:center;--align-items:center;--container-widget-width:calc( ( 1 - var( --container-widget-flex-grow ) ) * 100% );--gap:0px 0px;--flex-wrap:wrap;}.elementor-318 .elementor-element.elementor-element-fa1c38c{--align-items:center;--container-widget-width:calc( ( 1 - var( --container-widget-flex-grow ) ) * 100% );--padding-block-start:0rem;--padding-block-end:0rem;--padding-inline-start:0rem;--padding-inline-end:0rem;}.elementor-318 .elementor-element.elementor-element-0e0eb52{--gap:0px 0px;--border-radius:0px 0px 16px 16px;--padding-block-start:0.6rem;--padding-block-end:0.7rem;--padding-inline-start:0.7rem;--padding-inline-end:0.7rem;}.elementor-318 .elementor-element.elementor-element-a6e74aa .elementor-heading-title{font-size:16px;line-height:1.8em;}.elementor-318 .elementor-element.elementor-element-79c73da .jet-listing-dynamic-field__content{font-size:11px;}.elementor-318 .elementor-element.elementor-element-e095367{--margin-block-start:0rem;--margin-block-end:0rem;--margin-inline-start:0rem;--margin-inline-end:0rem;}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-item{font-size:11px;}.elementor-318 .elementor-element.elementor-element-4996846 .elementor-button{font-size:12px;padding:6px 11px 4px 11px;}}@media(max-width:767px){.elementor-318 .elementor-element.elementor-element-d22d862{--justify-content:center;}.elementor-318 .elementor-element.elementor-element-fa83e65{--width:100%;}.elementor-318 .elementor-element.elementor-element-acfd788 img{height:180px;}.elementor-318 .elementor-element.elementor-element-fa1c38c{--width:100%;}.elementor-318 .elementor-element.elementor-element-0e0eb52{--width:92%;--border-radius:0px 0px 16px 16px;}.elementor-318 .elementor-element.elementor-element-a6e74aa .elementor-heading-title{font-size:15px;}}@media(min-width:768px){.elementor-318 .elementor-element.elementor-element-fa83e65{--width:40%;}.elementor-318 .elementor-element.elementor-element-fa1c38c{--width:60%;}}@media(max-width:1024px) and (min-width:768px){.elementor-318 .elementor-element.elementor-element-fa83e65{--width:100%;}.elementor-318 .elementor-element.elementor-element-fa1c38c{--width:100%;}.elementor-318 .elementor-element.elementor-element-0e0eb52{--width:92%;}}\\/* Start custom CSS for container, class: .elementor-element-d22d862 *\\/.elementor-318 .elementor-element.elementor-element-d22d862:hover {<br \\/>    transform: translateY(-7px);<br \\/>    transition: 0.3s;<br \\/>}<br \\/>.elementor-318 .elementor-element.elementor-element-d22d862:not(:hover) {<br \\/>    transition: 0.3s;<br \\/>}\\/* End custom CSS *\\/<br \\/>\\/* Start Custom Fonts CSS *\\/@font-face {<br \\/>\\tfont-family: \'YekanBakhFaNum\';<br \\/>\\tfont-style: normal;<br \\/>\\tfont-weight: 400;<br \\/>\\tfont-display: auto;<br \\/>\\tsrc: url(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Light.woff2\') format(\'woff2\'),<br \\/>\\t\\turl(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Light.woff\') format(\'woff\');<br \\/>}<br \\/>@font-face {<br \\/>\\tfont-family: \'YekanBakhFaNum\';<br \\/>\\tfont-style: normal;<br \\/>\\tfont-weight: 500;<br \\/>\\tfont-display: auto;<br \\/>\\tsrc: url(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Regular.woff2\') format(\'woff2\'),<br \\/>\\t\\turl(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Regular.woff\') format(\'woff\');<br \\/>}<br \\/>@font-face {<br \\/>\\tfont-family: \'YekanBakhFaNum\';<br \\/>\\tfont-style: normal;<br \\/>\\tfont-weight: 600;<br \\/>\\tfont-display: auto;<br \\/>\\tsrc: url(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Bold.woff2\') format(\'woff2\'),<br \\/>\\t\\turl(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Bold.woff\') format(\'woff\');<br \\/>}<br \\/>@font-face {<br \\/>\\tfont-family: \'YekanBakhFaNum\';<br \\/>\\tfont-style: normal;<br \\/>\\tfont-weight: 700;<br \\/>\\tfont-display: auto;<br \\/>\\tsrc: url(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-ExtraBold.woff2\') format(\'woff2\'),<br \\/>\\t\\turl(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-ExtraBold.woff\') format(\'woff\');<br \\/>}<br \\/>@font-face {<br \\/>\\tfont-family: \'YekanBakhFaNum\';<br \\/>\\tfont-style: normal;<br \\/>\\tfont-weight: 800;<br \\/>\\tfont-display: auto;<br \\/>\\tsrc: url(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Black.woff2\') format(\'woff2\'),<br \\/>\\t\\turl(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Black.woff\') format(\'woff\');<br \\/>}<br \\/>@font-face {<br \\/>\\tfont-family: \'YekanBakhFaNum\';<br \\/>\\tfont-style: normal;<br \\/>\\tfont-weight: 900;<br \\/>\\tfont-display: auto;<br \\/>\\tsrc: url(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-ExtraBlack.woff2\') format(\'woff2\'),<br \\/>\\t\\turl(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-ExtraBlack.woff\') format(\'woff\');<br \\/>}<br \\/>\\/* End Custom Fonts CSS *\\/<\\/style><\\/p><p>\\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e\\u060c \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a. \\u0686\\u0627\\u067e\\u06af\\u0631\\u0647\\u0627 \\u0648 \\u0645\\u062a\\u0648\\u0646 \\u0628\\u0644\\u06a9\\u0647 \\u0631\\u0648\\u0632\\u0646\\u0627\\u0645\\u0647 \\u0648 \\u0645\\u062c\\u0644\\u0647\\u2026<\\/p><ul><li>17 \\u0645\\u0647\\u0631 , 1402<\\/li><\\/ul><p><a role=\\\"button\\\"><br \\/>\\u0627\\u062f\\u0627\\u0645\\u0647 \\u0645\\u0637\\u0644\\u0628<br \\/><\\/a><\\/p><p><style>.elementor-318 .elementor-element.elementor-element-d22d862{--display:flex;--flex-direction:row;--container-widget-width:initial;--container-widget-height:100%;--container-widget-flex-grow:1;--container-widget-align-self:stretch;--gap:0px 0px;--background-transition:0.3s;--margin-block-start:0rem;--margin-block-end:0rem;--margin-inline-start:0rem;--margin-inline-end:0rem;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-318 .elementor-element.elementor-element-fa83e65{--display:flex;--justify-content:center;--background-transition:0.3s;--border-radius:20px 20px 20px 20px;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-318 .elementor-element.elementor-element-fa83e65:not(.elementor-motion-effects-element-type-background), .elementor-318 .elementor-element.elementor-element-fa83e65 > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-position:center center;background-repeat:no-repeat;background-size:cover;}.elementor-318 .elementor-element.elementor-element-fa83e65, .elementor-318 .elementor-element.elementor-element-fa83e65::before{--border-transition:0.3s;}.elementor-318 .elementor-element.elementor-element-acfd788 img{width:100%;height:220px;object-fit:cover;object-position:center center;border-radius:20px 20px 20px 20px;}.elementor-318 .elementor-element.elementor-element-fa1c38c{--display:flex;--justify-content:center;--gap:0px 0px;--background-transition:0.3s;--padding-block-start:0rem;--padding-block-end:0rem;--padding-inline-start:0rem;--padding-inline-end:0rem;}.elementor-318 .elementor-element.elementor-element-0e0eb52{--display:flex;--justify-content:center;--gap:10px 10px;--background-transition:0.3s;--border-radius:16px 0px 0px 16px;box-shadow:0px 0px 10px 4px rgba(0, 0, 0, 0.07);--margin-block-start:0rem;--margin-block-end:0rem;--margin-inline-start:0rem;--margin-inline-end:0rem;--padding-block-start:1rem;--padding-block-end:1rem;--padding-inline-start:1rem;--padding-inline-end:1rem;}.elementor-318 .elementor-element.elementor-element-0e0eb52:not(.elementor-motion-effects-element-type-background), .elementor-318 .elementor-element.elementor-element-0e0eb52 > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-color:#FAFAFA;}.elementor-318 .elementor-element.elementor-element-0e0eb52, .elementor-318 .elementor-element.elementor-element-0e0eb52::before{--border-transition:0.3s;}.elementor-318 .elementor-element.elementor-element-a6e74aa .elementor-heading-title{color:var( --e-global-color-secondary );font-family:\\\"YekanBakhFaNum\\\", Sans-serif;font-size:17px;font-weight:700;line-height:0em;}.elementor-318 .elementor-element.elementor-element-a6e74aa > .elementor-widget-container{margin:0rem 0rem 0rem 0rem;padding:0px 0px 0px 0px;}.elementor-318 .elementor-element.elementor-element-79c73da .jet-listing-dynamic-field__content{color:var( --e-global-color-text );font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:13px;font-weight:400;line-height:1.6rem;text-align:right;}.elementor-318 .elementor-element.elementor-element-79c73da .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-318 .elementor-element.elementor-element-79c73da .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-318 .elementor-element.elementor-element-79c73da .jet-listing-dynamic-field{justify-content:flex-start;}.elementor-318 .elementor-element.elementor-element-e095367{--display:flex;--flex-direction:row;--container-widget-width:calc( ( 1 - var( --container-widget-flex-grow ) ) * 100% );--container-widget-height:100%;--container-widget-flex-grow:1;--container-widget-align-self:stretch;--justify-content:space-between;--align-items:center;--background-transition:0.3s;--margin-block-start:0.7rem;--margin-block-end:0rem;--margin-inline-start:0rem;--margin-inline-end:0rem;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-icon i{color:var( --e-global-color-text );font-size:12px;}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-icon svg{fill:var( --e-global-color-text );--e-icon-list-icon-size:12px;}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-icon{width:12px;}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-text, .elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-text a{color:var( --e-global-color-text );}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-item{font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:12px;font-weight:600;}.elementor-318 .elementor-element.elementor-element-4996846 .elementor-button{font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:13px;font-weight:600;fill:#FFFFFF;color:#FFFFFF;background-color:var( --e-global-color-primary );border-style:solid;border-width:1px 1px 1px 1px;border-radius:12px 12px 12px 12px;padding:9px 11px 5px 11px;}.elementor-318 .elementor-element.elementor-element-4996846 .elementor-button:hover, .elementor-318 .elementor-element.elementor-element-4996846 .elementor-button:focus{color:var( --e-global-color-primary );background-color:var( --e-global-color-accent );border-color:var( --e-global-color-primary );}.elementor-318 .elementor-element.elementor-element-4996846 .elementor-button:hover svg, .elementor-318 .elementor-element.elementor-element-4996846 .elementor-button:focus svg{fill:var( --e-global-color-primary );}.jet-listing-item.single-jet-engine.elementor-page-318 > .elementor{width:626px;margin-left:auto;margin-right:auto;}@media(max-width:1024px){.elementor-318 .elementor-element.elementor-element-d22d862{--justify-content:center;--align-items:center;--container-widget-width:calc( ( 1 - var( --container-widget-flex-grow ) ) * 100% );--gap:0px 0px;--flex-wrap:wrap;}.elementor-318 .elementor-element.elementor-element-fa1c38c{--align-items:center;--container-widget-width:calc( ( 1 - var( --container-widget-flex-grow ) ) * 100% );--padding-block-start:0rem;--padding-block-end:0rem;--padding-inline-start:0rem;--padding-inline-end:0rem;}.elementor-318 .elementor-element.elementor-element-0e0eb52{--gap:0px 0px;--border-radius:0px 0px 16px 16px;--padding-block-start:0.6rem;--padding-block-end:0.7rem;--padding-inline-start:0.7rem;--padding-inline-end:0.7rem;}.elementor-318 .elementor-element.elementor-element-a6e74aa .elementor-heading-title{font-size:16px;line-height:1.8em;}.elementor-318 .elementor-element.elementor-element-79c73da .jet-listing-dynamic-field__content{font-size:11px;}.elementor-318 .elementor-element.elementor-element-e095367{--margin-block-start:0rem;--margin-block-end:0rem;--margin-inline-start:0rem;--margin-inline-end:0rem;}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-item{font-size:11px;}.elementor-318 .elementor-element.elementor-element-4996846 .elementor-button{font-size:12px;padding:6px 11px 4px 11px;}}@media(max-width:767px){.elementor-318 .elementor-element.elementor-element-d22d862{--justify-content:center;}.elementor-318 .elementor-element.elementor-element-fa83e65{--width:100%;}.elementor-318 .elementor-element.elementor-element-acfd788 img{height:180px;}.elementor-318 .elementor-element.elementor-element-fa1c38c{--width:100%;}.elementor-318 .elementor-element.elementor-element-0e0eb52{--width:92%;--border-radius:0px 0px 16px 16px;}.elementor-318 .elementor-element.elementor-element-a6e74aa .elementor-heading-title{font-size:15px;}}@media(min-width:768px){.elementor-318 .elementor-element.elementor-element-fa83e65{--width:40%;}.elementor-318 .elementor-element.elementor-element-fa1c38c{--width:60%;}}@media(max-width:1024px) and (min-width:768px){.elementor-318 .elementor-element.elementor-element-fa83e65{--width:100%;}.elementor-318 .elementor-element.elementor-element-fa1c38c{--width:100%;}.elementor-318 .elementor-element.elementor-element-0e0eb52{--width:92%;}}\\/* Start custom CSS for container, class: .elementor-element-d22d862 *\\/.elementor-318 .elementor-element.elementor-element-d22d862:hover {<br \\/>    transform: translateY(-7px);<br \\/>    transition: 0.3s;<br \\/>}<br \\/>.elementor-318 .elementor-element.elementor-element-d22d862:not(:hover) {<br \\/>    transition: 0.3s;<br \\/>}\\/* End custom CSS *\\/<br \\/>\\/* Start Custom Fonts CSS *\\/@font-face {<br \\/>\\tfont-family: \'YekanBakhFaNum\';<br \\/>\\tfont-style: normal;<br \\/>\\tfont-weight: 400;<br \\/>\\tfont-display: auto;<br \\/>\\tsrc: url(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Light.woff2\') format(\'woff2\'),<br \\/>\\t\\turl(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Light.woff\') format(\'woff\');<br \\/>}<br \\/>@font-face {<br \\/>\\tfont-family: \'YekanBakhFaNum\';<br \\/>\\tfont-style: normal;<br \\/>\\tfont-weight: 500;<br \\/>\\tfont-display: auto;<br \\/>\\tsrc: url(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Regular.woff2\') format(\'woff2\'),<br \\/>\\t\\turl(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Regular.woff\') format(\'woff\');<br \\/>}<br \\/>@font-face {<br \\/>\\tfont-family: \'YekanBakhFaNum\';<br \\/>\\tfont-style: normal;<br \\/>\\tfont-weight: 600;<br \\/>\\tfont-display: auto;<br \\/>\\tsrc: url(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Bold.woff2\') format(\'woff2\'),<br \\/>\\t\\turl(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Bold.woff\') format(\'woff\');<br \\/>}<br \\/>@font-face {<br \\/>\\tfont-family: \'YekanBakhFaNum\';<br \\/>\\tfont-style: normal;<br \\/>\\tfont-weight: 700;<br \\/>\\tfont-display: auto;<br \\/>\\tsrc: url(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-ExtraBold.woff2\') format(\'woff2\'),<br \\/>\\t\\turl(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-ExtraBold.woff\') format(\'woff\');<br \\/>}<br \\/>@font-face {<br \\/>\\tfont-family: \'YekanBakhFaNum\';<br \\/>\\tfont-style: normal;<br \\/>\\tfont-weight: 800;<br \\/>\\tfont-display: auto;<br \\/>\\tsrc: url(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Black.woff2\') format(\'woff2\'),<br \\/>\\t\\turl(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Black.woff\') format(\'woff\');<br \\/>}<br \\/>@font-face {<br \\/>\\tfont-family: \'YekanBakhFaNum\';<br \\/>\\tfont-style: normal;<br \\/>\\tfont-weight: 900;<br \\/>\\tfont-display: auto;<br \\/>\\tsrc: url(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-ExtraBlack.woff2\') format(\'woff2\'),<br \\/>\\t\\turl(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-ExtraBlack.woff\') format(\'woff\');<br \\/>}<br \\/>\\/* End Custom Fonts CSS *\\/<\\/style><\\/p><p>\\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e\\u060c \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a. \\u0686\\u0627\\u067e\\u06af\\u0631\\u0647\\u0627 \\u0648 \\u0645\\u062a\\u0648\\u0646 \\u0628\\u0644\\u06a9\\u0647 \\u0631\\u0648\\u0632\\u0646\\u0627\\u0645\\u0647 \\u0648 \\u0645\\u062c\\u0644\\u0647\\u2026<\\/p><ul><li>17 \\u0645\\u0647\\u0631 , 1402<\\/li><\\/ul><p><a role=\\\"button\\\"><br \\/>\\u0627\\u062f\\u0627\\u0645\\u0647 \\u0645\\u0637\\u0644\\u0628<br \\/><\\/a><\\/p><p><style>.elementor-318 .elementor-element.elementor-element-d22d862{--display:flex;--flex-direction:row;--container-widget-width:initial;--container-widget-height:100%;--container-widget-flex-grow:1;--container-widget-align-self:stretch;--gap:0px 0px;--background-transition:0.3s;--margin-block-start:0rem;--margin-block-end:0rem;--margin-inline-start:0rem;--margin-inline-end:0rem;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-318 .elementor-element.elementor-element-fa83e65{--display:flex;--justify-content:center;--background-transition:0.3s;--border-radius:20px 20px 20px 20px;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-318 .elementor-element.elementor-element-fa83e65:not(.elementor-motion-effects-element-type-background), .elementor-318 .elementor-element.elementor-element-fa83e65 > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-position:center center;background-repeat:no-repeat;background-size:cover;}.elementor-318 .elementor-element.elementor-element-fa83e65, .elementor-318 .elementor-element.elementor-element-fa83e65::before{--border-transition:0.3s;}.elementor-318 .elementor-element.elementor-element-acfd788 img{width:100%;height:220px;object-fit:cover;object-position:center center;border-radius:20px 20px 20px 20px;}.elementor-318 .elementor-element.elementor-element-fa1c38c{--display:flex;--justify-content:center;--gap:0px 0px;--background-transition:0.3s;--padding-block-start:0rem;--padding-block-end:0rem;--padding-inline-start:0rem;--padding-inline-end:0rem;}.elementor-318 .elementor-element.elementor-element-0e0eb52{--display:flex;--justify-content:center;--gap:10px 10px;--background-transition:0.3s;--border-radius:16px 0px 0px 16px;box-shadow:0px 0px 10px 4px rgba(0, 0, 0, 0.07);--margin-block-start:0rem;--margin-block-end:0rem;--margin-inline-start:0rem;--margin-inline-end:0rem;--padding-block-start:1rem;--padding-block-end:1rem;--padding-inline-start:1rem;--padding-inline-end:1rem;}.elementor-318 .elementor-element.elementor-element-0e0eb52:not(.elementor-motion-effects-element-type-background), .elementor-318 .elementor-element.elementor-element-0e0eb52 > .elementor-motion-effects-container > .elementor-motion-effects-layer{background-color:#FAFAFA;}.elementor-318 .elementor-element.elementor-element-0e0eb52, .elementor-318 .elementor-element.elementor-element-0e0eb52::before{--border-transition:0.3s;}.elementor-318 .elementor-element.elementor-element-a6e74aa .elementor-heading-title{color:var( --e-global-color-secondary );font-family:\\\"YekanBakhFaNum\\\", Sans-serif;font-size:17px;font-weight:700;line-height:0em;}.elementor-318 .elementor-element.elementor-element-a6e74aa > .elementor-widget-container{margin:0rem 0rem 0rem 0rem;padding:0px 0px 0px 0px;}.elementor-318 .elementor-element.elementor-element-79c73da .jet-listing-dynamic-field__content{color:var( --e-global-color-text );font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:13px;font-weight:400;line-height:1.6rem;text-align:right;}.elementor-318 .elementor-element.elementor-element-79c73da .jet-listing-dynamic-field .jet-listing-dynamic-field__inline-wrap{width:auto;}.elementor-318 .elementor-element.elementor-element-79c73da .jet-listing-dynamic-field .jet-listing-dynamic-field__content{width:auto;}.elementor-318 .elementor-element.elementor-element-79c73da .jet-listing-dynamic-field{justify-content:flex-start;}.elementor-318 .elementor-element.elementor-element-e095367{--display:flex;--flex-direction:row;--container-widget-width:calc( ( 1 - var( --container-widget-flex-grow ) ) * 100% );--container-widget-height:100%;--container-widget-flex-grow:1;--container-widget-align-self:stretch;--justify-content:space-between;--align-items:center;--background-transition:0.3s;--margin-block-start:0.7rem;--margin-block-end:0rem;--margin-inline-start:0rem;--margin-inline-end:0rem;--padding-block-start:0px;--padding-block-end:0px;--padding-inline-start:0px;--padding-inline-end:0px;}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-icon i{color:var( --e-global-color-text );font-size:12px;}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-icon svg{fill:var( --e-global-color-text );--e-icon-list-icon-size:12px;}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-icon{width:12px;}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-text, .elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-text a{color:var( --e-global-color-text );}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-item{font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:12px;font-weight:600;}.elementor-318 .elementor-element.elementor-element-4996846 .elementor-button{font-family:\\\"iranyekanwebregular_FaNum\\\", Sans-serif;font-size:13px;font-weight:600;fill:#FFFFFF;color:#FFFFFF;background-color:var( --e-global-color-primary );border-style:solid;border-width:1px 1px 1px 1px;border-radius:12px 12px 12px 12px;padding:9px 11px 5px 11px;}.elementor-318 .elementor-element.elementor-element-4996846 .elementor-button:hover, .elementor-318 .elementor-element.elementor-element-4996846 .elementor-button:focus{color:var( --e-global-color-primary );background-color:var( --e-global-color-accent );border-color:var( --e-global-color-primary );}.elementor-318 .elementor-element.elementor-element-4996846 .elementor-button:hover svg, .elementor-318 .elementor-element.elementor-element-4996846 .elementor-button:focus svg{fill:var( --e-global-color-primary );}.jet-listing-item.single-jet-engine.elementor-page-318 > .elementor{width:626px;margin-left:auto;margin-right:auto;}@media(max-width:1024px){.elementor-318 .elementor-element.elementor-element-d22d862{--justify-content:center;--align-items:center;--container-widget-width:calc( ( 1 - var( --container-widget-flex-grow ) ) * 100% );--gap:0px 0px;--flex-wrap:wrap;}.elementor-318 .elementor-element.elementor-element-fa1c38c{--align-items:center;--container-widget-width:calc( ( 1 - var( --container-widget-flex-grow ) ) * 100% );--padding-block-start:0rem;--padding-block-end:0rem;--padding-inline-start:0rem;--padding-inline-end:0rem;}.elementor-318 .elementor-element.elementor-element-0e0eb52{--gap:0px 0px;--border-radius:0px 0px 16px 16px;--padding-block-start:0.6rem;--padding-block-end:0.7rem;--padding-inline-start:0.7rem;--padding-inline-end:0.7rem;}.elementor-318 .elementor-element.elementor-element-a6e74aa .elementor-heading-title{font-size:16px;line-height:1.8em;}.elementor-318 .elementor-element.elementor-element-79c73da .jet-listing-dynamic-field__content{font-size:11px;}.elementor-318 .elementor-element.elementor-element-e095367{--margin-block-start:0rem;--margin-block-end:0rem;--margin-inline-start:0rem;--margin-inline-end:0rem;}.elementor-318 .elementor-element.elementor-element-9ed5ca0 .elementor-icon-list-item{font-size:11px;}.elementor-318 .elementor-element.elementor-element-4996846 .elementor-button{font-size:12px;padding:6px 11px 4px 11px;}}@media(max-width:767px){.elementor-318 .elementor-element.elementor-element-d22d862{--justify-content:center;}.elementor-318 .elementor-element.elementor-element-fa83e65{--width:100%;}.elementor-318 .elementor-element.elementor-element-acfd788 img{height:180px;}.elementor-318 .elementor-element.elementor-element-fa1c38c{--width:100%;}.elementor-318 .elementor-element.elementor-element-0e0eb52{--width:92%;--border-radius:0px 0px 16px 16px;}.elementor-318 .elementor-element.elementor-element-a6e74aa .elementor-heading-title{font-size:15px;}}@media(min-width:768px){.elementor-318 .elementor-element.elementor-element-fa83e65{--width:40%;}.elementor-318 .elementor-element.elementor-element-fa1c38c{--width:60%;}}@media(max-width:1024px) and (min-width:768px){.elementor-318 .elementor-element.elementor-element-fa83e65{--width:100%;}.elementor-318 .elementor-element.elementor-element-fa1c38c{--width:100%;}.elementor-318 .elementor-element.elementor-element-0e0eb52{--width:92%;}}\\/* Start custom CSS for container, class: .elementor-element-d22d862 *\\/.elementor-318 .elementor-element.elementor-element-d22d862:hover {<br \\/>    transform: translateY(-7px);<br \\/>    transition: 0.3s;<br \\/>}<br \\/>.elementor-318 .elementor-element.elementor-element-d22d862:not(:hover) {<br \\/>    transition: 0.3s;<br \\/>}\\/* End custom CSS *\\/<br \\/>\\/* Start Custom Fonts CSS *\\/@font-face {<br \\/>\\tfont-family: \'YekanBakhFaNum\';<br \\/>\\tfont-style: normal;<br \\/>\\tfont-weight: 400;<br \\/>\\tfont-display: auto;<br \\/>\\tsrc: url(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Light.woff2\') format(\'woff2\'),<br \\/>\\t\\turl(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Light.woff\') format(\'woff\');<br \\/>}<br \\/>@font-face {<br \\/>\\tfont-family: \'YekanBakhFaNum\';<br \\/>\\tfont-style: normal;<br \\/>\\tfont-weight: 500;<br \\/>\\tfont-display: auto;<br \\/>\\tsrc: url(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Regular.woff2\') format(\'woff2\'),<br \\/>\\t\\turl(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Regular.woff\') format(\'woff\');<br \\/>}<br \\/>@font-face {<br \\/>\\tfont-family: \'YekanBakhFaNum\';<br \\/>\\tfont-style: normal;<br \\/>\\tfont-weight: 600;<br \\/>\\tfont-display: auto;<br \\/>\\tsrc: url(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Bold.woff2\') format(\'woff2\'),<br \\/>\\t\\turl(\'http:\\/\\/tabancrm.ir\\/wp-content\\/uploads\\/2023\\/10\\/YekanBakhFaNum-Bold.woff\') format(\'woff\');<br \\/>}<br \\/>@font-